/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidApplicationLogger;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidEventListener;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.AndroidPreferences;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SnapshotArray;
import java.lang.reflect.Method;

public class AndroidApplication
extends Activity
implements AndroidApplicationBase {
    private final Array<AndroidEventListener> androidEventListeners;
    protected ApplicationLogger applicationLogger;
    protected AndroidAudio audio;
    protected AndroidClipboard clipboard;
    protected final Array<Runnable> executedRunnables;
    protected AndroidFiles files;
    protected boolean firstResume = true;
    protected AndroidGraphics graphics;
    public Handler handler;
    protected boolean hideStatusBar = false;
    protected AndroidInput input;
    private boolean isWaitingForAudio = false;
    protected final SnapshotArray<LifecycleListener> lifecycleListeners;
    protected ApplicationListener listener;
    protected int logLevel = 2;
    protected AndroidNet net;
    protected final Array<Runnable> runnables = new Array();
    protected boolean useImmersiveMode = false;
    private int wasFocusChanged = -1;

    static {
        GdxNativesLoader.load();
    }

    public AndroidApplication() {
        this.executedRunnables = new Array();
        this.lifecycleListeners = new SnapshotArray(LifecycleListener.class);
        this.androidEventListeners = new Array();
    }

    private void init(ApplicationListener object, AndroidApplicationConfiguration androidApplicationConfiguration, boolean bl) {
        if (this.getVersion() >= 9) {
            this.setApplicationLogger(new AndroidApplicationLogger());
            ResolutionStrategy resolutionStrategy = androidApplicationConfiguration.resolutionStrategy == null ? new FillResolutionStrategy() : androidApplicationConfiguration.resolutionStrategy;
            this.graphics = new AndroidGraphics(this, androidApplicationConfiguration, resolutionStrategy);
            this.input = AndroidInputFactory.newAndroidInput(this, (Context)this, this.graphics.view, androidApplicationConfiguration);
            this.audio = new AndroidAudio((Context)this, androidApplicationConfiguration);
            this.getFilesDir();
            this.files = new AndroidFiles(this.getAssets(), this.getFilesDir().getAbsolutePath());
            this.net = new AndroidNet(this, androidApplicationConfiguration);
            this.listener = object;
            this.handler = new Handler();
            this.useImmersiveMode = androidApplicationConfiguration.useImmersiveMode;
            this.hideStatusBar = androidApplicationConfiguration.hideStatusBar;
            this.clipboard = new AndroidClipboard((Context)this);
            this.addLifecycleListener(new LifecycleListener(){

                @Override
                public void dispose() {
                    AndroidApplication.this.audio.dispose();
                }

                @Override
                public void pause() {
                    AndroidApplication.this.audio.pause();
                }

                @Override
                public void resume() {
                }
            });
            Gdx.app = this;
            Gdx.input = this.getInput();
            Gdx.audio = this.getAudio();
            Gdx.files = this.getFiles();
            Gdx.graphics = this.getGraphics();
            Gdx.net = this.getNet();
            if (!bl) {
                try {
                    this.requestWindowFeature(1);
                }
                catch (Exception exception) {
                    this.log("AndroidApplication", "Content already displayed, cannot request FEATURE_NO_TITLE", exception);
                }
                this.getWindow().setFlags(1024, 1024);
                this.getWindow().clearFlags(2048);
                this.setContentView(this.graphics.getView(), (ViewGroup.LayoutParams)this.createLayoutParams());
            }
            this.createWakeLock(androidApplicationConfiguration.useWakelock);
            this.hideStatusBar(this.hideStatusBar);
            this.useImmersiveMode(this.useImmersiveMode);
            if (this.useImmersiveMode && this.getVersion() >= 19) {
                try {
                    object = Class.forName("com.badlogic.gdx.backends.android.AndroidVisibilityListener");
                    androidApplicationConfiguration = ((Class)object).newInstance();
                    ((Class)object).getDeclaredMethod("createListener", AndroidApplicationBase.class).invoke((Object)androidApplicationConfiguration, this);
                }
                catch (Exception exception) {
                    this.log("AndroidApplication", "Failed to create AndroidVisibilityListener", exception);
                }
            }
            if (this.getResources().getConfiguration().keyboard != 1) {
                ((AndroidInput)this.getInput()).keyboardAvailable = true;
            }
            return;
        }
        throw new GdxRuntimeException("LibGDX requires Android API Level 9 or later.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAndroidEventListener(AndroidEventListener androidEventListener) {
        Array<AndroidEventListener> array = this.androidEventListeners;
        synchronized (array) {
            this.androidEventListeners.add(androidEventListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        SnapshotArray<LifecycleListener> snapshotArray = this.lifecycleListeners;
        synchronized (snapshotArray) {
            this.lifecycleListeners.add(lifecycleListener);
            return;
        }
    }

    protected FrameLayout.LayoutParams createLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        return layoutParams;
    }

    protected void createWakeLock(boolean bl) {
        if (bl) {
            this.getWindow().addFlags(128);
        }
    }

    @Override
    public void debug(String string2, String string3) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(string2, string3);
        }
    }

    @Override
    public void debug(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(string2, string3, throwable);
        }
    }

    @Override
    public void error(String string2, String string3) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(string2, string3);
        }
    }

    @Override
    public void error(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(string2, string3, throwable);
        }
    }

    @Override
    public void exit() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                AndroidApplication.this.finish();
            }
        });
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    @Override
    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    @Override
    public Window getApplicationWindow() {
        return this.getWindow();
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public Array<Runnable> getExecutedRunnables() {
        return this.executedRunnables;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public AndroidInput getInput() {
        return this.input;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public SnapshotArray<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public Preferences getPreferences(String string2) {
        return new AndroidPreferences(this.getSharedPreferences(string2, 0));
    }

    @Override
    public Array<Runnable> getRunnables() {
        return this.runnables;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Android;
    }

    @Override
    public int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    protected void hideStatusBar(boolean bl) {
        if (bl && this.getVersion() >= 11) {
            View view = this.getWindow().getDecorView();
            try {
                Method method = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
                if (this.getVersion() <= 13) {
                    method.invoke((Object)view, 0);
                }
                method.invoke((Object)view, 1);
            }
            catch (Exception exception) {
                this.log("AndroidApplication", "Can't hide status bar", exception);
            }
        }
    }

    public void initialize(ApplicationListener applicationListener) {
        this.initialize(applicationListener, new AndroidApplicationConfiguration());
    }

    public void initialize(ApplicationListener applicationListener, AndroidApplicationConfiguration androidApplicationConfiguration) {
        this.init(applicationListener, androidApplicationConfiguration, false);
    }

    public View initializeForView(ApplicationListener applicationListener) {
        return this.initializeForView(applicationListener, new AndroidApplicationConfiguration());
    }

    public View initializeForView(ApplicationListener applicationListener, AndroidApplicationConfiguration androidApplicationConfiguration) {
        this.init(applicationListener, androidApplicationConfiguration, true);
        return this.graphics.getView();
    }

    @Override
    public void log(String string2, String string3) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(string2, string3);
        }
    }

    @Override
    public void log(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(string2, string3, throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Array<AndroidEventListener> array = this.androidEventListeners;
        synchronized (array) {
            for (int i = 0; i < this.androidEventListeners.size; ++i) {
                this.androidEventListeners.get(i).onActivityResult(n, n2, intent);
            }
            return;
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        int n = configuration.hardKeyboardHidden;
        boolean bl = true;
        if (n != 1) {
            bl = false;
        }
        this.input.keyboardAvailable = bl;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onPause() {
        boolean bl = this.graphics.isContinuousRendering();
        boolean bl2 = AndroidGraphics.enforceContinuousRendering;
        AndroidGraphics.enforceContinuousRendering = true;
        this.graphics.setContinuousRendering(true);
        this.graphics.pause();
        this.input.onPause();
        if (this.isFinishing()) {
            this.graphics.clearManagedCaches();
            this.graphics.destroy();
        }
        AndroidGraphics.enforceContinuousRendering = bl2;
        this.graphics.setContinuousRendering(bl);
        this.graphics.onPauseGLSurfaceView();
        super.onPause();
    }

    protected void onResume() {
        Gdx.app = this;
        Gdx.input = this.getInput();
        Gdx.audio = this.getAudio();
        Gdx.files = this.getFiles();
        Gdx.graphics = this.getGraphics();
        Gdx.net = this.getNet();
        this.input.onResume();
        AndroidGraphics androidGraphics = this.graphics;
        if (androidGraphics != null) {
            androidGraphics.onResumeGLSurfaceView();
        }
        if (!this.firstResume) {
            this.graphics.resume();
        } else {
            this.firstResume = false;
        }
        this.isWaitingForAudio = true;
        int n = this.wasFocusChanged;
        if (n == 1 || n == -1) {
            this.audio.resume();
            this.isWaitingForAudio = false;
        }
        super.onResume();
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.useImmersiveMode(this.useImmersiveMode);
        this.hideStatusBar(this.hideStatusBar);
        if (bl) {
            this.wasFocusChanged = 1;
            if (this.isWaitingForAudio) {
                this.audio.resume();
                this.isWaitingForAudio = false;
            }
        } else {
            this.wasFocusChanged = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            Gdx.graphics.requestRendering();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAndroidEventListener(AndroidEventListener androidEventListener) {
        Array<AndroidEventListener> array = this.androidEventListeners;
        synchronized (array) {
            this.androidEventListeners.removeValue(androidEventListener, true);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        SnapshotArray<LifecycleListener> snapshotArray = this.lifecycleListeners;
        synchronized (snapshotArray) {
            this.lifecycleListeners.removeValue(lifecycleListener, true);
            return;
        }
    }

    @Override
    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Override
    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    @Override
    @TargetApi(value=19)
    public void useImmersiveMode(boolean bl) {
        if (bl && this.getVersion() >= 19) {
            View view = this.getWindow().getDecorView();
            try {
                View.class.getMethod("setSystemUiVisibility", Integer.TYPE).invoke((Object)view, 5894);
            }
            catch (Exception exception) {
                this.log("AndroidApplication", "Can't set immersive mode", exception);
            }
        }
    }
}

