/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.Viewport;

public class ScalingViewport
extends Viewport {
    private Scaling scaling;

    public ScalingViewport(Scaling scaling, float f, float f2) {
        this(scaling, f, f2, new OrthographicCamera());
    }

    public ScalingViewport(Scaling scaling, float f, float f2, Camera camera) {
        this.scaling = scaling;
        this.setWorldSize(f, f2);
        this.setCamera(camera);
    }

    public Scaling getScaling() {
        return this.scaling;
    }

    public void setScaling(Scaling scaling) {
        this.scaling = scaling;
    }

    @Override
    public void update(int n, int n2, boolean bl) {
        Vector2 vector2 = this.scaling.apply(this.getWorldWidth(), this.getWorldHeight(), n, n2);
        int n3 = Math.round(vector2.x);
        int n4 = Math.round(vector2.y);
        this.setScreenBounds((n - n3) / 2, (n2 - n4) / 2, n3, n4);
        this.apply(bl);
    }
}

