/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;

public final class Constructor {
    private final java.lang.reflect.Constructor constructor;

    Constructor(java.lang.reflect.Constructor constructor) {
        this.constructor = constructor;
    }

    public Class getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    public Class[] getParameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public boolean isAccessible() {
        return this.constructor.isAccessible();
    }

    public Object newInstance(Object ... object) throws ReflectionException {
        try {
            object = this.constructor.newInstance((Object[])object);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Exception occurred in constructor for class: ");
            ((StringBuilder)object).append(this.getDeclaringClass().getName());
            throw new ReflectionException(((StringBuilder)object).toString(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not instantiate instance of class: ");
            stringBuilder.append(this.getDeclaringClass().getName());
            throw new ReflectionException(stringBuilder.toString(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not instantiate instance of class: ");
            ((StringBuilder)object).append(this.getDeclaringClass().getName());
            throw new ReflectionException(((StringBuilder)object).toString(), instantiationException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal argument(s) supplied to constructor for class: ");
            stringBuilder.append(this.getDeclaringClass().getName());
            throw new ReflectionException(stringBuilder.toString(), illegalArgumentException);
        }
    }

    public void setAccessible(boolean bl) {
        this.constructor.setAccessible(bl);
    }
}

