/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression;

import com.badlogic.gdx.utils.compression.lzma.Decoder;
import com.badlogic.gdx.utils.compression.lzma.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Lzma {
    public static void compress(InputStream object, OutputStream outputStream) throws IOException {
        CommandLine commandLine = new CommandLine();
        boolean bl = commandLine.Eos;
        Encoder encoder = new Encoder();
        if (encoder.SetAlgorithm(commandLine.Algorithm)) {
            if (encoder.SetDictionarySize(commandLine.DictionarySize)) {
                if (encoder.SetNumFastBytes(commandLine.Fb)) {
                    if (encoder.SetMatchFinder(commandLine.MatchFinder)) {
                        if (encoder.SetLcLpPb(commandLine.Lc, commandLine.Lp, commandLine.Pb)) {
                            long l;
                            encoder.SetEndMarkerMode(bl);
                            encoder.WriteCoderProperties(outputStream);
                            long l2 = -1L;
                            if (bl) {
                                l = l2;
                            } else {
                                l = ((InputStream)object).available();
                                if (l == 0L) {
                                    l = l2;
                                }
                            }
                            for (int i = 0; i < 8; ++i) {
                                outputStream.write((int)(l >>> i * 8) & 0xFF);
                            }
                            encoder.Code((InputStream)object, outputStream, -1L, -1L, null);
                            return;
                        }
                        throw new RuntimeException("Incorrect -lc or -lp or -pb value");
                    }
                    throw new RuntimeException("Incorrect -mf value");
                }
                throw new RuntimeException("Incorrect -fb value");
            }
            throw new RuntimeException("Incorrect dictionary size");
        }
        object = new RuntimeException("Incorrect compression mode");
        throw object;
    }

    public static void decompress(InputStream object, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[5];
        if (((InputStream)object).read(byArray, 0, 5) == 5) {
            Decoder decoder = new Decoder();
            if (decoder.SetDecoderProperties(byArray)) {
                long l = 0L;
                for (int i = 0; i < 8; ++i) {
                    int n = ((InputStream)object).read();
                    if (n >= 0) {
                        l |= (long)n << i * 8;
                        continue;
                    }
                    throw new RuntimeException("Can't read stream size");
                }
                if (decoder.Code((InputStream)object, outputStream, l)) {
                    return;
                }
                throw new RuntimeException("Error in data stream");
            }
            throw new RuntimeException("Incorrect stream properties");
        }
        object = new RuntimeException("input .lzma file is too short");
        throw object;
    }

    static class CommandLine {
        public static final int kBenchmak = 2;
        public static final int kDecode = 1;
        public static final int kEncode = 0;
        public int Algorithm = 2;
        public int Command = -1;
        public int DictionarySize = 0x800000;
        public boolean DictionarySizeIsDefined = false;
        public boolean Eos = false;
        public int Fb = 128;
        public boolean FbIsDefined = false;
        public String InFile;
        public int Lc = 3;
        public int Lp = 0;
        public int MatchFinder = 1;
        public int NumBenchmarkPasses = 10;
        public String OutFile;
        public int Pb = 2;

        CommandLine() {
        }
    }
}

