/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class XmlReader {
    private static final byte[] _xml_actions = XmlReader.init__xml_actions_0();
    private static final short[] _xml_index_offsets;
    private static final byte[] _xml_indicies;
    private static final byte[] _xml_key_offsets;
    private static final byte[] _xml_range_lengths;
    private static final byte[] _xml_single_lengths;
    private static final byte[] _xml_trans_actions;
    private static final char[] _xml_trans_keys;
    private static final byte[] _xml_trans_targs;
    static final int xml_en_elementBody = 15;
    static final int xml_en_main = 1;
    static final int xml_error = 0;
    static final int xml_first_final = 34;
    static final int xml_start = 1;
    private Element current;
    private final Array<Element> elements = new Array(8);
    private Element root;
    private final StringBuilder textBuffer = new StringBuilder(64);

    static {
        _xml_key_offsets = XmlReader.init__xml_key_offsets_0();
        _xml_trans_keys = XmlReader.init__xml_trans_keys_0();
        _xml_single_lengths = XmlReader.init__xml_single_lengths_0();
        _xml_range_lengths = XmlReader.init__xml_range_lengths_0();
        _xml_index_offsets = XmlReader.init__xml_index_offsets_0();
        _xml_indicies = XmlReader.init__xml_indicies_0();
        _xml_trans_targs = XmlReader.init__xml_trans_targs_0();
        _xml_trans_actions = XmlReader.init__xml_trans_actions_0();
    }

    private static byte[] init__xml_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 2, 0, 6, 2, 1, 4, 2, 2, 4};
    }

    private static short[] init__xml_index_offsets_0() {
        return new short[]{0, 0, 4, 9, 14, 20, 26, 30, 35, 37, 39, 44, 48, 52, 54, 56, 60, 62, 67, 72, 78, 84, 88, 93, 95, 97, 102, 106, 110, 112, 116, 118, 120, 122, 124, 127};
    }

    private static byte[] init__xml_indicies_0() {
        return new byte[]{0, 2, 0, 1, 2, 1, 1, 2, 3, 5, 6, 7, 5, 4, 9, 10, 1, 11, 9, 8, 13, 1, 14, 1, 13, 12, 15, 16, 15, 1, 16, 17, 18, 16, 1, 20, 19, 22, 21, 9, 10, 11, 9, 1, 23, 24, 23, 1, 25, 11, 25, 1, 20, 26, 22, 27, 29, 30, 29, 28, 32, 31, 30, 34, 1, 30, 33, 36, 37, 38, 36, 35, 40, 41, 1, 42, 40, 39, 44, 1, 45, 1, 44, 43, 46, 47, 46, 1, 47, 48, 49, 47, 1, 51, 50, 53, 52, 40, 41, 42, 40, 1, 54, 55, 54, 1, 56, 42, 56, 1, 57, 1, 57, 34, 57, 1, 1, 58, 59, 58, 51, 60, 53, 61, 62, 62, 1, 1, 0};
    }

    private static byte[] init__xml_key_offsets_0() {
        return new byte[]{0, 0, 4, 9, 14, 20, 26, 30, 35, 36, 37, 42, 46, 50, 51, 52, 56, 57, 62, 67, 73, 79, 83, 88, 89, 90, 95, 99, 103, 104, 108, 109, 110, 111, 112, 115};
    }

    private static byte[] init__xml_range_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0};
    }

    private static byte[] init__xml_single_lengths_0() {
        return new byte[]{0, 2, 3, 3, 4, 4, 2, 3, 1, 1, 3, 2, 2, 1, 1, 2, 1, 3, 3, 4, 4, 2, 3, 1, 1, 3, 2, 2, 1, 2, 1, 1, 1, 1, 1, 0};
    }

    private static byte[] init__xml_trans_actions_0() {
        return new byte[]{0, 0, 0, 1, 0, 3, 3, 20, 1, 0, 0, 9, 0, 11, 11, 0, 0, 0, 0, 1, 17, 0, 13, 5, 23, 0, 1, 0, 1, 0, 0, 0, 15, 1, 0, 0, 3, 3, 20, 1, 0, 0, 9, 0, 11, 11, 0, 0, 0, 0, 1, 17, 0, 13, 5, 23, 0, 0, 0, 7, 1, 0, 0};
    }

    private static char[] init__xml_trans_keys_0() {
        return new char[]{' ', '<', '\t', '\r', ' ', '/', '>', '\t', '\r', ' ', '/', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '=', '\t', '\r', ' ', '\"', '\'', '\t', '\r', '\"', '\"', ' ', '/', '>', '\t', '\r', ' ', '>', '\t', '\r', ' ', '>', '\t', '\r', '\'', '\'', ' ', '<', '\t', '\r', '<', ' ', '/', '>', '\t', '\r', ' ', '/', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '=', '\t', '\r', ' ', '\"', '\'', '\t', '\r', '\"', '\"', ' ', '/', '>', '\t', '\r', ' ', '>', '\t', '\r', ' ', '>', '\t', '\r', '<', ' ', '/', '\t', '\r', '>', '>', '\'', '\'', ' ', '\t', '\r', '\u0000'};
    }

    private static byte[] init__xml_trans_targs_0() {
        return new byte[]{1, 0, 2, 3, 3, 4, 11, 34, 5, 4, 11, 34, 5, 6, 7, 6, 7, 8, 13, 9, 10, 9, 10, 12, 34, 12, 14, 14, 16, 15, 17, 16, 17, 18, 30, 18, 19, 26, 28, 20, 19, 26, 28, 20, 21, 22, 21, 22, 23, 32, 24, 25, 24, 25, 27, 28, 27, 29, 31, 35, 33, 33, 34};
    }

    protected void attribute(String string2, String string3) {
        this.current.setAttribute(string2, string3);
    }

    protected void close() {
        this.root = this.elements.pop();
        Element element = this.elements.size > 0 ? this.elements.peek() : null;
        this.current = element;
    }

    protected String entity(String string2) {
        if (string2.equals("lt")) {
            return "<";
        }
        if (string2.equals("gt")) {
            return ">";
        }
        if (string2.equals("amp")) {
            return "&";
        }
        if (string2.equals("apos")) {
            return "'";
        }
        if (string2.equals("quot")) {
            return "\"";
        }
        if (string2.startsWith("#x")) {
            return Character.toString((char)Integer.parseInt(string2.substring(2), 16));
        }
        return null;
    }

    protected void open(String object) {
        object = new Element((String)object, this.current);
        Element element = this.current;
        if (element != null) {
            element.addChild((Element)object);
        }
        this.elements.add((Element)object);
        this.current = object;
    }

    public Element parse(FileHandle fileHandle) {
        try {
            Element element = this.parse(fileHandle.reader("UTF-8"));
            return element;
        }
        catch (Exception exception) {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("Error parsing file: ");
            stringBuilder.append(fileHandle);
            throw new SerializationException(stringBuilder.toString(), exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element parse(InputStream inputStream) {
        Throwable throwable2222222;
        block4: {
            Object object = new InputStreamReader(inputStream, "UTF-8");
            object = this.parse((Reader)object);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (IOException iOException) {}
                {
                    SerializationException serializationException = new SerializationException(iOException);
                    throw serializationException;
                }
            }
            StreamUtils.closeQuietly(inputStream);
            return object;
        }
        StreamUtils.closeQuietly(inputStream);
        throw throwable2222222;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element parse(Reader reader) {
        Object object;
        Object object2;
        try {
            object2 = new char[1024];
            int n = 0;
            while (true) {
                int n2;
                if ((n2 = reader.read((char[])object2, n, ((char[])object2).length - n)) == -1) {
                    object2 = this.parse((char[])object2, 0, n);
                    break;
                }
                if (n2 == 0) {
                    object = new char[((char[])object2).length * 2];
                    System.arraycopy(object2, 0, object, 0, ((char[])object2).length);
                    object2 = object;
                    continue;
                }
                n += n2;
            }
        }
        catch (Throwable throwable) {
        }
        catch (IOException iOException) {
            object = new SerializationException(iOException);
            throw object;
        }
        StreamUtils.closeQuietly(reader);
        return object2;
        StreamUtils.closeQuietly(reader);
        throw throwable;
    }

    public Element parse(String object) {
        object = ((String)object).toCharArray();
        return this.parse((char[])object, 0, ((Object)object).length);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Element parse(char[] var1_1, int var2_2, int var3_3) {
        var4_4 = var2_2;
        var5_5 /* !! */  = 0;
        var6_6 /* !! */  = 1;
        var7_7 = null;
        var2_2 = 0;
        block10: while (true) {
            var8_8 = 1;
            var9_9 /* !! */  = 2;
            var10_10 = 0;
            block11: while (true) {
                block53: {
                    block52: {
                        block51: {
                            block47: {
                                block50: {
                                    block49: {
                                        if (var5_5 /* !! */  == 0) break block49;
                                        if (var5_5 /* !! */  == var8_8) break block50;
                                        if (var5_5 /* !! */  != var9_9 /* !! */ ) break block10;
                                        var11_11 = var10_10;
                                        var12_12 = var2_2;
                                        var13_13 = var7_7;
                                        break block51;
                                    }
                                    if (var4_4 == var3_3) {
                                        var5_5 /* !! */  = 4;
                                        continue;
                                    }
                                    if (var6_6 /* !! */  == 0) break block52;
                                }
                                var5_5 /* !! */  = XmlReader._xml_key_offsets[var6_6 /* !! */ ];
                                var14_14 /* !! */  = XmlReader._xml_index_offsets[var6_6 /* !! */ ];
                                var15_15 = XmlReader._xml_single_lengths[var6_6 /* !! */ ];
                                if (var15_15 > 0) {
                                    var16_16 = var5_5 /* !! */  + var15_15;
                                    var11_11 = var5_5 /* !! */ ;
                                    var12_12 = var16_16 - 1;
                                    while (true) {
                                        if (var12_12 < var11_11) {
                                            var5_5 /* !! */  = var14_14 /* !! */  + var15_15;
                                            var12_12 = var16_16;
                                            break block46;
                                        }
                                        var18_18 = var1_1[var4_4];
                                        var13_13 = XmlReader._xml_trans_keys;
                                        var17_17 = var11_11 + (var12_12 - var11_11 >> 1);
                                        if (var18_18 < var13_13[var17_17]) {
                                            var12_12 = var17_17 - 1;
                                            continue;
                                        }
                                        if (var1_1[var4_4] <= var13_13[var17_17]) break;
                                        var11_11 = var17_17 + 1;
                                    }
                                    var6_6 /* !! */  = var14_14 /* !! */  + (var17_17 - var5_5 /* !! */ );
                                } else {
                                    block46: {
                                        var12_12 = var5_5 /* !! */ ;
                                        var5_5 /* !! */  = var14_14 /* !! */ ;
                                    }
                                    var11_11 = XmlReader._xml_range_lengths[var6_6 /* !! */ ];
                                    var6_6 /* !! */  = var5_5 /* !! */ ;
                                    if (var11_11 > 0) {
                                        var9_9 /* !! */  = var12_12 + (var11_11 << 1) - var9_9 /* !! */ ;
                                        var6_6 /* !! */  = var12_12;
                                        while (true) {
                                            if (var9_9 /* !! */  < var6_6 /* !! */ ) {
                                                var6_6 /* !! */  = var11_11;
lbl58:
                                                // 2 sources

                                                while (true) {
                                                    var6_6 /* !! */  = var5_5 /* !! */  + var6_6 /* !! */ ;
                                                    break block47;
                                                    break;
                                                }
                                            }
                                            var14_14 /* !! */  = (int)var1_1[var4_4];
                                            var13_13 = XmlReader._xml_trans_keys;
                                            var16_16 = (var9_9 /* !! */  - var6_6 /* !! */  >> var8_8 & -2) + var6_6 /* !! */ ;
                                            if (var14_14 /* !! */  < var13_13[var16_16]) {
                                                var9_9 /* !! */  = var16_16 - 2;
                                                continue;
                                            }
                                            if (var1_1[var4_4] <= var13_13[var16_16 + 1]) break;
                                            var6_6 /* !! */  = var16_16 + 2;
                                        }
                                        var6_6 /* !! */  = var16_16 - var12_12 >> 1;
                                        ** continue;
                                    }
                                }
                            }
                            var5_5 /* !! */  = XmlReader._xml_indicies[var6_6 /* !! */ ];
                            var14_14 /* !! */  = XmlReader._xml_trans_targs[var5_5 /* !! */ ];
                            var19_19 /* !! */  = XmlReader._xml_trans_actions;
                            var6_6 /* !! */  = var14_14 /* !! */ ;
                            var13_13 = var7_7;
                            var12_12 = var2_2;
                            var11_11 = var10_10;
                            if (var19_19 /* !! */ [var5_5 /* !! */ ] == 0) break block51;
                            var6_6 /* !! */  = var19_19 /* !! */ [var5_5 /* !! */ ];
                            var13_13 = XmlReader._xml_actions;
                            var8_8 = var6_6 /* !! */  + 1;
                            var9_9 /* !! */  = (int)var13_13[var6_6 /* !! */ ];
                            while (true) {
                                block48: {
                                    var6_6 /* !! */  = var14_14 /* !! */ ;
                                    var13_13 = var7_7;
                                    var12_12 = var2_2;
                                    var11_11 = var10_10;
                                    if (var9_9 /* !! */  <= 0) break;
                                    switch (XmlReader._xml_actions[var8_8]) {
                                        default: {
                                            break block48;
                                        }
                                        case 7: {
                                            for (var12_12 = var4_4; var12_12 != var2_2 && ((var6_6 /* !! */  = (int)var1_1[var12_12 - 1]) == 9 || var6_6 /* !! */  == 10 || var6_6 /* !! */  == 13 || var6_6 /* !! */  == 32); --var12_12) {
                                            }
                                            var6_6 /* !! */  = var2_2;
                                            var11_11 = 0;
                                            var5_5 /* !! */  = var2_2;
                                            var2_2 = var6_6 /* !! */ ;
                                            var6_6 /* !! */  = var11_11;
                                            block17: while (var5_5 /* !! */  != var12_12) {
                                                var11_11 = var5_5 /* !! */  + 1;
                                                if (var1_1[var5_5 /* !! */ ] != 38) {
                                                    var5_5 /* !! */  = var11_11;
                                                    continue;
                                                }
                                                var5_5 /* !! */  = var11_11;
                                                while (var5_5 /* !! */  != var12_12) {
                                                    var16_16 = var5_5 /* !! */  + 1;
                                                    if (var1_1[var5_5 /* !! */ ] != 59) {
                                                        var5_5 /* !! */  = var16_16;
                                                        continue;
                                                    }
                                                    this.textBuffer.append((char[])var1_1, var2_2, var11_11 - var2_2 - 1);
                                                    var13_13 = new String((char[])var1_1, var11_11, var16_16 - var11_11 - 1);
                                                    var19_19 /* !! */  = (byte[])this.entity((String)var13_13);
                                                    var20_20 = this.textBuffer;
                                                    if (var19_19 /* !! */  != null) {
                                                        var13_13 = var19_19 /* !! */ ;
                                                    }
                                                    var20_20.append((String)var13_13);
                                                    var5_5 /* !! */  = var2_2 = var16_16;
                                                    var6_6 /* !! */  = 1;
                                                    continue block17;
                                                }
                                            }
                                            if (var6_6 /* !! */  != 0) {
                                                if (var2_2 < var12_12) {
                                                    this.textBuffer.append((char[])var1_1, var2_2, var12_12 - var2_2);
                                                }
                                                this.text(this.textBuffer.toString());
                                                this.textBuffer.setLength(0);
                                            } else {
                                                this.text(new String((char[])var1_1, var2_2, var12_12 - var2_2));
                                            }
                                            var13_13 = var7_7;
                                            var6_6 /* !! */  = var2_2;
                                            ** GOTO lbl145
                                        }
                                        case 6: {
                                            this.attribute((String)var7_7, new String((char[])var1_1, var2_2, var4_4 - var2_2));
                                            var13_13 = var7_7;
                                            var6_6 /* !! */  = var2_2;
                                            ** GOTO lbl145
                                        }
                                        case 5: {
                                            var13_13 = new String((char[])var1_1, var2_2, var4_4 - var2_2);
                                            var6_6 /* !! */  = var2_2;
lbl145:
                                            // 4 sources

                                            while (true) {
                                                var7_7 = var13_13;
                                                var2_2 = var6_6 /* !! */ ;
                                                break block48;
                                                break;
                                            }
                                        }
                                        case 4: {
                                            var13_13 = var7_7;
                                            var6_6 /* !! */  = var2_2;
                                            if (var10_10 == 0) ** continue;
                                            var12_12 = var2_2;
                                            ** GOTO lbl158
                                        }
                                        case 3: {
                                            this.close();
                                            var12_12 = var2_2;
lbl158:
                                            // 5 sources

                                            while (true) {
                                                var9_9 /* !! */  = 2;
                                                var8_8 = 1;
                                                var5_5 /* !! */  = 2;
                                                var6_6 /* !! */  = 15;
                                                var2_2 = var12_12;
                                                continue block11;
                                                break;
                                            }
                                        }
                                        case 2: {
                                            this.close();
                                            var5_5 /* !! */  = 2;
                                            var6_6 /* !! */  = 15;
                                            continue block10;
                                        }
                                        case 1: {
                                            var5_5 /* !! */  = (int)var1_1[var2_2];
                                            if (var5_5 /* !! */  == 63 || var5_5 /* !! */  == 33) ** GOTO lbl176
                                            this.open(new String((char[])var1_1, var2_2, var4_4 - var2_2));
                                            var10_10 = 1;
                                            break block48;
lbl176:
                                            // 1 sources

                                            var8_8 = var2_2 + 1;
                                            if (var1_1[var8_8] != 91 || var1_1[var2_2 + 2] != 67 || var1_1[var2_2 + 3] != 68 || var1_1[var2_2 + 4] != 65 || var1_1[var2_2 + 5] != 84 || var1_1[var2_2 + 6] != 65 || var1_1[var2_2 + 7] != 91) ** GOTO lbl187
                                            var12_12 = var2_2 + 8;
                                            var2_2 = var12_12 + 2;
                                            while (true) {
                                                if (var1_1[var2_2 - 2] != 93 || var1_1[var2_2 - 1] != 93 || var1_1[var2_2] != 62) ** GOTO lbl185
                                                this.text(new String((char[])var1_1, var12_12, var2_2 - var12_12 - 2));
                                                var4_4 = var2_2;
                                                ** GOTO lbl158
lbl185:
                                                // 1 sources

                                                ++var2_2;
                                            }
lbl187:
                                            // 1 sources

                                            var6_6 /* !! */  = var4_4;
                                            if (var5_5 /* !! */  != 33) ** GOTO lbl201
                                            var6_6 /* !! */  = var4_4;
                                            if (var1_1[var8_8] != 45) ** GOTO lbl201
                                            var6_6 /* !! */  = var4_4;
                                            if (var1_1[var2_2 + 2] != 45) ** GOTO lbl201
                                            var4_4 = var2_2 + 3;
                                            while (true) {
                                                if (var1_1[var4_4] != 45 || var1_1[var4_4 + 1] != 45 || var1_1[var6_6 /* !! */  = var4_4 + 2] != 62) ** GOTO lbl199
                                                var4_4 = var6_6 /* !! */ ;
                                                var12_12 = var2_2;
                                                ** GOTO lbl158
lbl199:
                                                // 1 sources

                                                ++var4_4;
                                            }
lbl201:
                                            // 3 sources

                                            while (true) {
                                                var4_4 = ++var6_6 /* !! */ ;
                                                var12_12 = var2_2;
                                                if (var1_1[var6_6 /* !! */ ] != 62) ** break;
                                                ** continue;
                                            }
                                        }
                                        case 0: 
                                    }
                                    var2_2 = var4_4;
                                }
                                --var9_9 /* !! */ ;
                                ++var8_8;
                            }
                        }
                        if (var6_6 /* !! */  != 0) break block53;
                        var9_9 /* !! */  = 2;
                        var8_8 = 1;
                        var10_10 = var11_11;
                        var2_2 = var12_12;
                        var7_7 = var13_13;
                    }
                    var5_5 /* !! */  = 5;
                    continue;
                }
                var4_4 = var2_2 = var4_4 + 1;
                if (var2_2 == var3_3) break block10;
                var9_9 /* !! */  = 2;
                var8_8 = 1;
                var5_5 /* !! */  = 1;
                var4_4 = var2_2;
                var7_7 = var13_13;
                var2_2 = var12_12;
                var10_10 = var11_11;
            }
            break;
        }
        if (var4_4 < var3_3) {
            var6_6 /* !! */  = 1;
            for (var2_2 = 0; var2_2 < var4_4; ++var2_2) {
                var5_5 /* !! */  = var6_6 /* !! */ ;
                if (var1_1[var2_2] == '\n') {
                    var5_5 /* !! */  = var6_6 /* !! */  + 1;
                }
                var6_6 /* !! */  = var5_5 /* !! */ ;
            }
            var7_7 = new java.lang.StringBuilder();
            var7_7.append("Error parsing XML on line ");
            var7_7.append(var6_6 /* !! */ );
            var7_7.append(" near: ");
            var7_7.append(new String((char[])var1_1, var4_4, Math.min(32, var3_3 - var4_4)));
            throw new SerializationException(var7_7.toString());
        }
        if (this.elements.size == 0) {
            var1_1 = this.root;
            this.root = null;
            return var1_1;
        }
        var1_1 = this.elements.peek();
        this.elements.clear();
        var7_7 = new java.lang.StringBuilder();
        var7_7.append("Error parsing XML, unclosed element: ");
        var7_7.append(var1_1.getName());
        var1_1 = new SerializationException(var7_7.toString());
        throw var1_1;
    }

    protected void text(String string2) {
        String string3 = this.current.getText();
        Element element = this.current;
        CharSequence charSequence = string2;
        if (string3 != null) {
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append(string3);
            ((java.lang.StringBuilder)charSequence).append(string2);
            charSequence = ((java.lang.StringBuilder)charSequence).toString();
        }
        element.setText((String)charSequence);
    }

    public static class Element {
        private ObjectMap<String, String> attributes;
        private Array<Element> children;
        private final String name;
        private Element parent;
        private String text;

        public Element(String string2, Element element) {
            this.name = string2;
            this.parent = element;
        }

        private void getChildrenByNameRecursively(String string2, Array<Element> array) {
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < this.children.size; ++i) {
                Element element = this.children.get(i);
                if (element.name.equals(string2)) {
                    array.add(element);
                }
                element.getChildrenByNameRecursively(string2, array);
            }
        }

        public void addChild(Element element) {
            if (this.children == null) {
                this.children = new Array(8);
            }
            this.children.add(element);
        }

        public String get(String string2) {
            CharSequence charSequence = this.get(string2, null);
            if (charSequence != null) {
                return charSequence;
            }
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append("Element ");
            ((java.lang.StringBuilder)charSequence).append(this.name);
            ((java.lang.StringBuilder)charSequence).append(" doesn't have attribute or child: ");
            ((java.lang.StringBuilder)charSequence).append(string2);
            throw new GdxRuntimeException(((java.lang.StringBuilder)charSequence).toString());
        }

        public String get(String object, String string2) {
            ObjectMap<String, String> objectMap = this.attributes;
            if (objectMap != null && (objectMap = objectMap.get((String)object)) != null) {
                return objectMap;
            }
            if ((object = this.getChildByName((String)object)) == null) {
                return string2;
            }
            if ((object = ((Element)object).getText()) == null) {
                return string2;
            }
            return object;
        }

        public String getAttribute(String string2) {
            ObjectMap<String, String> objectMap = this.attributes;
            if (objectMap != null) {
                if ((objectMap = objectMap.get(string2)) != null) {
                    return objectMap;
                }
                objectMap = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)((Object)objectMap)).append("Element ");
                ((java.lang.StringBuilder)((Object)objectMap)).append(this.name);
                ((java.lang.StringBuilder)((Object)objectMap)).append(" doesn't have attribute: ");
                ((java.lang.StringBuilder)((Object)objectMap)).append(string2);
                throw new GdxRuntimeException(((java.lang.StringBuilder)((Object)objectMap)).toString());
            }
            objectMap = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)((Object)objectMap)).append("Element ");
            ((java.lang.StringBuilder)((Object)objectMap)).append(this.name);
            ((java.lang.StringBuilder)((Object)objectMap)).append(" doesn't have attribute: ");
            ((java.lang.StringBuilder)((Object)objectMap)).append(string2);
            throw new GdxRuntimeException(((java.lang.StringBuilder)((Object)objectMap)).toString());
        }

        public String getAttribute(String string2, String string3) {
            ObjectMap<String, String> objectMap = this.attributes;
            if (objectMap == null) {
                return string3;
            }
            if ((string2 = objectMap.get(string2)) == null) {
                return string3;
            }
            return string2;
        }

        public ObjectMap<String, String> getAttributes() {
            return this.attributes;
        }

        public boolean getBoolean(String string2) {
            CharSequence charSequence = this.get(string2, null);
            if (charSequence != null) {
                return Boolean.parseBoolean((String)charSequence);
            }
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append("Element ");
            ((java.lang.StringBuilder)charSequence).append(this.name);
            ((java.lang.StringBuilder)charSequence).append(" doesn't have attribute or child: ");
            ((java.lang.StringBuilder)charSequence).append(string2);
            throw new GdxRuntimeException(((java.lang.StringBuilder)charSequence).toString());
        }

        public boolean getBoolean(String string2, boolean bl) {
            if ((string2 = this.get(string2, null)) == null) {
                return bl;
            }
            return Boolean.parseBoolean(string2);
        }

        public boolean getBooleanAttribute(String string2) {
            return Boolean.parseBoolean(this.getAttribute(string2));
        }

        public boolean getBooleanAttribute(String string2, boolean bl) {
            if ((string2 = this.getAttribute(string2, null)) == null) {
                return bl;
            }
            return Boolean.parseBoolean(string2);
        }

        public Element getChild(int n) {
            Array<Element> array = this.children;
            if (array != null) {
                return array.get(n);
            }
            array = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)((Object)array)).append("Element has no children: ");
            ((java.lang.StringBuilder)((Object)array)).append(this.name);
            throw new GdxRuntimeException(((java.lang.StringBuilder)((Object)array)).toString());
        }

        public Element getChildByName(String string2) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.size; ++i) {
                Element element = this.children.get(i);
                if (!element.name.equals(string2)) continue;
                return element;
            }
            return null;
        }

        public Element getChildByNameRecursive(String string2) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.size; ++i) {
                Element element = this.children.get(i);
                if (element.name.equals(string2)) {
                    return element;
                }
                if ((element = element.getChildByNameRecursive(string2)) == null) continue;
                return element;
            }
            return null;
        }

        public int getChildCount() {
            Array<Element> array = this.children;
            if (array == null) {
                return 0;
            }
            return array.size;
        }

        public Array<Element> getChildrenByName(String string2) {
            Array<Element> array = new Array<Element>();
            if (this.children == null) {
                return array;
            }
            for (int i = 0; i < this.children.size; ++i) {
                Element element = this.children.get(i);
                if (!element.name.equals(string2)) continue;
                array.add(element);
            }
            return array;
        }

        public Array<Element> getChildrenByNameRecursively(String string2) {
            Array<Element> array = new Array<Element>();
            this.getChildrenByNameRecursively(string2, array);
            return array;
        }

        public float getFloat(String string2) {
            CharSequence charSequence = this.get(string2, null);
            if (charSequence != null) {
                return Float.parseFloat((String)charSequence);
            }
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append("Element ");
            ((java.lang.StringBuilder)charSequence).append(this.name);
            ((java.lang.StringBuilder)charSequence).append(" doesn't have attribute or child: ");
            ((java.lang.StringBuilder)charSequence).append(string2);
            throw new GdxRuntimeException(((java.lang.StringBuilder)charSequence).toString());
        }

        public float getFloat(String string2, float f) {
            if ((string2 = this.get(string2, null)) == null) {
                return f;
            }
            return Float.parseFloat(string2);
        }

        public float getFloatAttribute(String string2) {
            return Float.parseFloat(this.getAttribute(string2));
        }

        public float getFloatAttribute(String string2, float f) {
            if ((string2 = this.getAttribute(string2, null)) == null) {
                return f;
            }
            return Float.parseFloat(string2);
        }

        public int getInt(String string2) {
            CharSequence charSequence = this.get(string2, null);
            if (charSequence != null) {
                return Integer.parseInt((String)charSequence);
            }
            charSequence = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)charSequence).append("Element ");
            ((java.lang.StringBuilder)charSequence).append(this.name);
            ((java.lang.StringBuilder)charSequence).append(" doesn't have attribute or child: ");
            ((java.lang.StringBuilder)charSequence).append(string2);
            throw new GdxRuntimeException(((java.lang.StringBuilder)charSequence).toString());
        }

        public int getInt(String string2, int n) {
            if ((string2 = this.get(string2, null)) == null) {
                return n;
            }
            return Integer.parseInt(string2);
        }

        public int getIntAttribute(String string2) {
            return Integer.parseInt(this.getAttribute(string2));
        }

        public int getIntAttribute(String string2, int n) {
            if ((string2 = this.getAttribute(string2, null)) == null) {
                return n;
            }
            return Integer.parseInt(string2);
        }

        public String getName() {
            return this.name;
        }

        public Element getParent() {
            return this.parent;
        }

        public String getText() {
            return this.text;
        }

        public boolean hasAttribute(String string2) {
            ObjectMap<String, String> objectMap = this.attributes;
            if (objectMap == null) {
                return false;
            }
            return objectMap.containsKey(string2);
        }

        public boolean hasChild(String string2) {
            Array<Element> array = this.children;
            boolean bl = false;
            if (array == null) {
                return false;
            }
            if (this.getChildByName(string2) != null) {
                bl = true;
            }
            return bl;
        }

        public boolean hasChildRecursive(String string2) {
            Array<Element> array = this.children;
            boolean bl = false;
            if (array == null) {
                return false;
            }
            if (this.getChildByNameRecursive(string2) != null) {
                bl = true;
            }
            return bl;
        }

        public void remove() {
            this.parent.removeChild(this);
        }

        public void removeChild(int n) {
            Array<Element> array = this.children;
            if (array != null) {
                array.removeIndex(n);
            }
        }

        public void removeChild(Element element) {
            Array<Element> array = this.children;
            if (array != null) {
                array.removeValue(element, true);
            }
        }

        public void setAttribute(String string2, String string3) {
            if (this.attributes == null) {
                this.attributes = new ObjectMap(8);
            }
            this.attributes.put(string2, string3);
        }

        public void setText(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String string2) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(string2);
            stringBuilder.append('<');
            stringBuilder.append(this.name);
            Object object2 = this.attributes;
            if (object2 != null) {
                object2 = ((ObjectMap)object2).entries().iterator();
                while (object2.hasNext()) {
                    object = (ObjectMap.Entry)object2.next();
                    stringBuilder.append(' ');
                    stringBuilder.append((String)((ObjectMap.Entry)object).key);
                    stringBuilder.append("=\"");
                    stringBuilder.append((String)((ObjectMap.Entry)object).value);
                    stringBuilder.append('\"');
                }
            }
            if (this.children == null && ((object2 = this.text) == null || ((String)object2).length() == 0)) {
                stringBuilder.append("/>");
            } else {
                stringBuilder.append(">\n");
                object2 = new java.lang.StringBuilder();
                ((java.lang.StringBuilder)object2).append(string2);
                ((java.lang.StringBuilder)object2).append('\t');
                object2 = ((java.lang.StringBuilder)object2).toString();
                object = this.text;
                if (object != null && ((String)object).length() > 0) {
                    stringBuilder.append((String)object2);
                    stringBuilder.append(this.text);
                    stringBuilder.append('\n');
                }
                if ((object = this.children) != null) {
                    object = ((Array)object).iterator();
                    while (object.hasNext()) {
                        stringBuilder.append(((Element)object.next()).toString((String)object2));
                        stringBuilder.append('\n');
                    }
                }
                stringBuilder.append(string2);
                stringBuilder.append("</");
                stringBuilder.append(this.name);
                stringBuilder.append('>');
            }
            return stringBuilder.toString();
        }
    }
}

