/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UBJsonWriter
implements Closeable {
    private JsonObject current;
    private boolean named;
    final DataOutputStream out;
    private final Array<JsonObject> stack = new Array();

    public UBJsonWriter(OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        if (!(outputStream instanceof DataOutputStream)) {
            outputStream2 = new DataOutputStream(outputStream);
        }
        this.out = (DataOutputStream)outputStream2;
    }

    private void checkName() {
        JsonObject jsonObject = this.current;
        if (jsonObject != null && !jsonObject.array) {
            if (this.named) {
                this.named = false;
            } else {
                throw new IllegalStateException("Name must be set.");
            }
        }
    }

    public UBJsonWriter array() throws IOException {
        JsonObject jsonObject = this.current;
        if (jsonObject != null && !jsonObject.array) {
            if (this.named) {
                this.named = false;
            } else {
                throw new IllegalStateException("Name must be set.");
            }
        }
        Array<JsonObject> array = this.stack;
        this.current = jsonObject = new JsonObject(true);
        array.add(jsonObject);
        return this;
    }

    public UBJsonWriter array(String string2) throws IOException {
        this.name(string2).array();
        return this;
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public UBJsonWriter name(String object) throws IOException {
        JsonObject jsonObject = this.current;
        if (jsonObject != null && !jsonObject.array) {
            if (((Object)(object = (Object)((String)object).getBytes("UTF-8"))).length <= 127) {
                this.out.writeByte(105);
                this.out.writeByte(((Object)object).length);
            } else if (((Object)object).length <= Short.MAX_VALUE) {
                this.out.writeByte(73);
                this.out.writeShort(((Object)object).length);
            } else {
                this.out.writeByte(108);
                this.out.writeInt(((Object)object).length);
            }
            this.out.write((byte[])object);
            this.named = true;
            return this;
        }
        throw new IllegalStateException("Current item must be an object.");
    }

    public UBJsonWriter object() throws IOException {
        JsonObject jsonObject;
        Object object = this.current;
        if (object != null && !((JsonObject)object).array) {
            if (this.named) {
                this.named = false;
            } else {
                throw new IllegalStateException("Name must be set.");
            }
        }
        object = this.stack;
        this.current = jsonObject = new JsonObject(false);
        ((Array)object).add(jsonObject);
        return this;
    }

    public UBJsonWriter object(String string2) throws IOException {
        this.name(string2).object();
        return this;
    }

    public UBJsonWriter pop() throws IOException {
        return this.pop(false);
    }

    protected UBJsonWriter pop(boolean bl) throws IOException {
        if (!this.named) {
            if (bl) {
                this.stack.pop();
            } else {
                this.stack.pop().close();
            }
            JsonObject jsonObject = this.stack.size == 0 ? null : this.stack.peek();
            this.current = jsonObject;
            return this;
        }
        throw new IllegalStateException("Expected an object, array, or value since a name was set.");
    }

    public UBJsonWriter set(String string2) throws IOException {
        return this.name(string2).value();
    }

    public UBJsonWriter set(String string2, byte by) throws IOException {
        return this.name(string2).value(by);
    }

    public UBJsonWriter set(String string2, char c) throws IOException {
        return this.name(string2).value(c);
    }

    public UBJsonWriter set(String string2, double d) throws IOException {
        return this.name(string2).value(d);
    }

    public UBJsonWriter set(String string2, float f) throws IOException {
        return this.name(string2).value(f);
    }

    public UBJsonWriter set(String string2, int n) throws IOException {
        return this.name(string2).value(n);
    }

    public UBJsonWriter set(String string2, long l) throws IOException {
        return this.name(string2).value(l);
    }

    public UBJsonWriter set(String string2, String string3) throws IOException {
        return this.name(string2).value(string3);
    }

    public UBJsonWriter set(String string2, short s) throws IOException {
        return this.name(string2).value(s);
    }

    public UBJsonWriter set(String string2, boolean bl) throws IOException {
        return this.name(string2).value(bl);
    }

    public UBJsonWriter set(String string2, byte[] byArray) throws IOException {
        return this.name(string2).value(byArray);
    }

    public UBJsonWriter set(String string2, char[] cArray) throws IOException {
        return this.name(string2).value(cArray);
    }

    public UBJsonWriter set(String string2, double[] dArray) throws IOException {
        return this.name(string2).value(dArray);
    }

    public UBJsonWriter set(String string2, float[] fArray) throws IOException {
        return this.name(string2).value(fArray);
    }

    public UBJsonWriter set(String string2, int[] nArray) throws IOException {
        return this.name(string2).value(nArray);
    }

    public UBJsonWriter set(String string2, long[] lArray) throws IOException {
        return this.name(string2).value(lArray);
    }

    public UBJsonWriter set(String string2, String[] stringArray) throws IOException {
        return this.name(string2).value(stringArray);
    }

    public UBJsonWriter set(String string2, short[] sArray) throws IOException {
        return this.name(string2).value(sArray);
    }

    public UBJsonWriter set(String string2, boolean[] blArray) throws IOException {
        return this.name(string2).value(blArray);
    }

    public UBJsonWriter value() throws IOException {
        this.checkName();
        this.out.writeByte(90);
        return this;
    }

    public UBJsonWriter value(byte by) throws IOException {
        this.checkName();
        this.out.writeByte(105);
        this.out.writeByte(by);
        return this;
    }

    public UBJsonWriter value(char c) throws IOException {
        this.checkName();
        this.out.writeByte(73);
        this.out.writeChar(c);
        return this;
    }

    public UBJsonWriter value(double d) throws IOException {
        this.checkName();
        this.out.writeByte(68);
        this.out.writeDouble(d);
        return this;
    }

    public UBJsonWriter value(float f) throws IOException {
        this.checkName();
        this.out.writeByte(100);
        this.out.writeFloat(f);
        return this;
    }

    public UBJsonWriter value(int n) throws IOException {
        this.checkName();
        this.out.writeByte(108);
        this.out.writeInt(n);
        return this;
    }

    public UBJsonWriter value(long l) throws IOException {
        this.checkName();
        this.out.writeByte(76);
        this.out.writeLong(l);
        return this;
    }

    public UBJsonWriter value(JsonValue object) throws IOException {
        block21: {
            block15: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        if (!((JsonValue)object).isObject()) break block14;
                                        if (((JsonValue)object).name != null) {
                                            this.object(((JsonValue)object).name);
                                        } else {
                                            this.object();
                                        }
                                        object = ((JsonValue)object).child;
                                        while (object != null) {
                                            this.value((JsonValue)object);
                                            object = ((JsonValue)object).next;
                                        }
                                        this.pop();
                                        break block15;
                                    }
                                    if (!((JsonValue)object).isArray()) break block16;
                                    if (((JsonValue)object).name != null) {
                                        this.array(((JsonValue)object).name);
                                    } else {
                                        this.array();
                                    }
                                    object = ((JsonValue)object).child;
                                    while (object != null) {
                                        this.value((JsonValue)object);
                                        object = ((JsonValue)object).next;
                                    }
                                    this.pop();
                                    break block15;
                                }
                                if (!((JsonValue)object).isBoolean()) break block17;
                                if (((JsonValue)object).name != null) {
                                    this.name(((JsonValue)object).name);
                                }
                                this.value(((JsonValue)object).asBoolean());
                                break block15;
                            }
                            if (!((JsonValue)object).isDouble()) break block18;
                            if (((JsonValue)object).name != null) {
                                this.name(((JsonValue)object).name);
                            }
                            this.value(((JsonValue)object).asDouble());
                            break block15;
                        }
                        if (!((JsonValue)object).isLong()) break block19;
                        if (((JsonValue)object).name != null) {
                            this.name(((JsonValue)object).name);
                        }
                        this.value(((JsonValue)object).asLong());
                        break block15;
                    }
                    if (!((JsonValue)object).isString()) break block20;
                    if (((JsonValue)object).name != null) {
                        this.name(((JsonValue)object).name);
                    }
                    this.value(((JsonValue)object).asString());
                    break block15;
                }
                if (!((JsonValue)object).isNull()) break block21;
                if (((JsonValue)object).name != null) {
                    this.name(((JsonValue)object).name);
                }
                this.value();
            }
            return this;
        }
        object = new IOException("Unhandled JsonValue type");
        throw object;
    }

    public UBJsonWriter value(Object object) throws IOException {
        if (object == null) {
            return this.value();
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (object instanceof Byte) {
                return this.value(number.byteValue());
            }
            if (object instanceof Short) {
                return this.value(number.shortValue());
            }
            if (object instanceof Integer) {
                return this.value(number.intValue());
            }
            if (object instanceof Long) {
                return this.value(number.longValue());
            }
            if (object instanceof Float) {
                return this.value(number.floatValue());
            }
            if (object instanceof Double) {
                return this.value(number.doubleValue());
            }
            return this;
        }
        if (object instanceof Character) {
            return this.value(((Character)object).charValue());
        }
        if (object instanceof CharSequence) {
            return this.value(object.toString());
        }
        throw new IOException("Unknown object type.");
    }

    public UBJsonWriter value(String object) throws IOException {
        this.checkName();
        object = ((String)object).getBytes("UTF-8");
        this.out.writeByte(83);
        if (((Object)object).length <= 127) {
            this.out.writeByte(105);
            this.out.writeByte(((Object)object).length);
        } else if (((Object)object).length <= Short.MAX_VALUE) {
            this.out.writeByte(73);
            this.out.writeShort(((Object)object).length);
        } else {
            this.out.writeByte(108);
            this.out.writeInt(((Object)object).length);
        }
        this.out.write((byte[])object);
        return this;
    }

    public UBJsonWriter value(short s) throws IOException {
        this.checkName();
        this.out.writeByte(73);
        this.out.writeShort(s);
        return this;
    }

    public UBJsonWriter value(boolean bl) throws IOException {
        this.checkName();
        DataOutputStream dataOutputStream = this.out;
        int n = bl ? 84 : 70;
        dataOutputStream.writeByte(n);
        return this;
    }

    public UBJsonWriter value(byte[] byArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(105);
        this.out.writeByte(35);
        this.value(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeByte(byArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(char[] cArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(67);
        this.out.writeByte(35);
        this.value(cArray.length);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeChar(cArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(double[] dArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(68);
        this.out.writeByte(35);
        this.value(dArray.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeDouble(dArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(float[] fArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(100);
        this.out.writeByte(35);
        this.value(fArray.length);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeFloat(fArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(int[] nArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(108);
        this.out.writeByte(35);
        this.value(nArray.length);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeInt(nArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(long[] lArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(76);
        this.out.writeByte(35);
        this.value(lArray.length);
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeLong(lArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(String[] stringArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(83);
        this.out.writeByte(35);
        this.value(stringArray.length);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = stringArray[i].getBytes("UTF-8");
            if (byArray.length <= 127) {
                this.out.writeByte(105);
                this.out.writeByte(byArray.length);
            } else if (byArray.length <= Short.MAX_VALUE) {
                this.out.writeByte(73);
                this.out.writeShort(byArray.length);
            } else {
                this.out.writeByte(108);
                this.out.writeInt(byArray.length);
            }
            this.out.write(byArray);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(short[] sArray) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(73);
        this.out.writeByte(35);
        this.value(sArray.length);
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeShort(sArray[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(boolean[] blArray) throws IOException {
        this.array();
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            DataOutputStream dataOutputStream = this.out;
            int n2 = blArray[i] ? 84 : 70;
            dataOutputStream.writeByte(n2);
        }
        this.pop();
        return this;
    }

    private class JsonObject {
        final boolean array;

        JsonObject(boolean bl) throws IOException {
            this.array = bl;
            UBJsonWriter.this = ((UBJsonWriter)UBJsonWriter.this).out;
            int n = bl ? 91 : 123;
            ((DataOutputStream)UBJsonWriter.this).writeByte(n);
        }

        void close() throws IOException {
            DataOutputStream dataOutputStream = UBJsonWriter.this.out;
            int n = this.array ? 93 : 125;
            dataOutputStream.writeByte(n);
        }
    }
}

