/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.FloatCounter;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.TimeUtils;

public class PerformanceCounter {
    private static final float nano2seconds = 1.0E-9f;
    public float current = 0.0f;
    private long lastTick = 0L;
    public final FloatCounter load;
    public final String name;
    private long startTime = 0L;
    public final FloatCounter time;
    public boolean valid = false;

    public PerformanceCounter(String string2) {
        this(string2, 5);
    }

    public PerformanceCounter(String string2, int n) {
        this.name = string2;
        this.time = new FloatCounter(n);
        this.load = new FloatCounter(1);
    }

    public void reset() {
        this.time.reset();
        this.load.reset();
        this.startTime = 0L;
        this.lastTick = 0L;
        this.current = 0.0f;
        this.valid = false;
    }

    public void start() {
        this.startTime = TimeUtils.nanoTime();
        this.valid = false;
    }

    public void stop() {
        if (this.startTime > 0L) {
            this.current += (float)(TimeUtils.nanoTime() - this.startTime) * 1.0E-9f;
            this.startTime = 0L;
            this.valid = true;
        }
    }

    public void tick() {
        long l = TimeUtils.nanoTime();
        long l2 = this.lastTick;
        if (l2 > 0L) {
            this.tick((float)(l - l2) * 1.0E-9f);
        }
        this.lastTick = l;
    }

    public void tick(float f) {
        if (!this.valid) {
            Gdx.app.error("PerformanceCounter", "Invalid data, check if you called PerformanceCounter#stop()");
            return;
        }
        this.time.put(this.current);
        float f2 = f == 0.0f ? 0.0f : this.current / f;
        FloatCounter floatCounter = this.load;
        if (!(f > 1.0f)) {
            f2 = f2 * f + (1.0f - f) * floatCounter.latest;
        }
        floatCounter.put(f2);
        this.current = 0.0f;
        this.valid = false;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.name).append(": [time: ").append(this.time.value).append(", load: ").append(this.load.value).append("]");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

