/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectSet<T>
implements Iterable<T> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private int hashShift;
    private ObjectSetIterator iterator1;
    private ObjectSetIterator iterator2;
    T[] keyTable;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int n) {
        this(n, 0.8f);
    }

    public ObjectSet(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new Object[this.capacity + this.stashCapacity];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public ObjectSet(ObjectSet<? extends T> objectSet) {
        this((int)Math.floor((float)objectSet.capacity * objectSet.loadFactor), objectSet.loadFactor);
        this.stashSize = objectSet.stashSize;
        T[] TArray = objectSet.keyTable;
        System.arraycopy(TArray, 0, this.keyTable, 0, TArray.length);
        this.size = objectSet.size;
    }

    private void addResize(T t) {
        Object object = this.keyTable;
        int n = t.hashCode();
        int n2 = n & this.mask;
        T t2 = object[n2];
        if (t2 == null) {
            object[n2] = t;
            int n3 = this.size;
            this.size = n3 + 1;
            if (n3 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        T[] TArray = this.keyTable;
        int n4 = this.hash2(n);
        object = TArray[n4];
        if (object == null) {
            TArray[n4] = t;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        TArray = this.keyTable;
        T t3 = TArray[n = this.hash3(n)];
        if (t3 == null) {
            TArray[n] = t;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(t, n2, t2, n4, object, n, t3);
    }

    private void addStash(T t) {
        int n = this.stashSize;
        if (n == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.addResize(t);
            return;
        }
        int n2 = this.capacity;
        this.keyTable[n2 + n] = t;
        this.stashSize = n + 1;
        ++this.size;
    }

    private T getKeyStash(T t) {
        T[] TArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!t.equals(TArray[i])) continue;
            return TArray[i];
        }
        return null;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(T t, int n, T t2, int n2, T t3, int n3, T t4) {
        T[] TArray = this.keyTable;
        int n4 = this.mask;
        int n5 = this.pushIterations;
        int n6 = 0;
        int n7 = n2;
        int n8 = n;
        n = n6;
        while (true) {
            if ((n2 = MathUtils.random(2)) != 0) {
                if (n2 != 1) {
                    TArray[n3] = t;
                    t = t4;
                } else {
                    TArray[n7] = t;
                    t = t3;
                }
            } else {
                TArray[n8] = t;
                t = t2;
            }
            n2 = t.hashCode();
            n8 = n2 & n4;
            t2 = TArray[n8];
            if (t2 == null) {
                TArray[n8] = t;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash2(n2);
            t3 = TArray[n7];
            if (t3 == null) {
                TArray[n7] = t;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            t4 = TArray[n2 = this.hash3(n2)];
            if (t4 == null) {
                TArray[n2] = t;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n == n5) {
                this.addStash(t);
                return;
            }
            n3 = n2;
        }
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        T[] TArray = this.keyTable;
        this.keyTable = new Object[n + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                T t = TArray[n];
                if (t == null) continue;
                this.addResize(t);
            }
        }
    }

    public static <T> ObjectSet<T> with(T ... TArray) {
        ObjectSet<T> objectSet = new ObjectSet<T>();
        objectSet.addAll(TArray);
        return objectSet;
    }

    public boolean add(T object) {
        if (object != null) {
            T[] TArray = this.keyTable;
            int n = object.hashCode();
            int n2 = n & this.mask;
            T t = TArray[n2];
            if (object.equals(t)) {
                return false;
            }
            int n3 = this.hash2(n);
            T t2 = TArray[n3];
            if (object.equals(t2)) {
                return false;
            }
            int n4 = this.hash3(n);
            T t3 = TArray[n4];
            if (object.equals(t3)) {
                return false;
            }
            int n5 = this.capacity;
            int n6 = this.stashSize;
            for (n = n5; n < n6 + n5; ++n) {
                if (!object.equals(TArray[n])) continue;
                return false;
            }
            if (t == null) {
                TArray[n2] = object;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return true;
            }
            if (t2 == null) {
                TArray[n3] = object;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return true;
            }
            if (t3 == null) {
                TArray[n4] = object;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return true;
            }
            this.push(object, n2, t, n3, t2, n4, t3);
            return true;
        }
        object = new IllegalArgumentException("key cannot be null.");
        throw object;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int n, int n2) {
        if (n + n2 <= array.size) {
            this.addAll(array.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(array.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(ObjectSet<T> object) {
        this.ensureCapacity(((ObjectSet)object).size);
        object = ((ObjectSet)object).iterator();
        while (object.hasNext()) {
            this.add(object.next());
        }
    }

    public void addAll(T ... TArray) {
        this.addAll(TArray, 0, TArray.length);
    }

    public void addAll(T[] TArray, int n, int n2) {
        this.ensureCapacity(n2);
        for (int i = n; i < n2 + n; ++i) {
            this.add(TArray[i]);
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        T[] TArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            TArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public boolean contains(T t) {
        boolean bl;
        int n = t.hashCode();
        int n2 = this.mask;
        boolean bl2 = t.equals(this.keyTable[n2 & n]);
        boolean bl3 = bl = true;
        if (!bl2) {
            n2 = this.hash2(n);
            bl3 = bl;
            if (!t.equals(this.keyTable[n2])) {
                n = this.hash3(n);
                bl3 = bl;
                if (!t.equals(this.keyTable[n])) {
                    bl3 = this.getKeyStash(t) != null ? bl : false;
                }
            }
        }
        return bl3;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object TArray) {
        if (!(TArray instanceof ObjectSet)) {
            return false;
        }
        ObjectSet objectSet = (ObjectSet)TArray;
        if (objectSet.size != this.size) {
            return false;
        }
        TArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            if (TArray[i] == null || objectSet.contains(TArray[i])) continue;
            return false;
        }
        return true;
    }

    public T first() {
        Object object = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            if (object[i] == null) continue;
            return object[i];
        }
        object = new IllegalStateException("ObjectSet is empty.");
        throw object;
    }

    public T get(T t) {
        T t2;
        int n = t.hashCode();
        int n2 = this.mask;
        T t3 = t2 = this.keyTable[n2 & n];
        if (!t.equals(t2)) {
            n2 = this.hash2(n);
            t3 = t2 = this.keyTable[n2];
            if (!t.equals(t2)) {
                n = this.hash3(n);
                t3 = t2 = this.keyTable[n];
                if (!t.equals(t2)) {
                    return this.getKeyStash(t);
                }
            }
        }
        return t3;
    }

    public int hashCode() {
        int n = this.capacity;
        int n2 = this.stashSize;
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            T[] TArray = this.keyTable;
            int n4 = n3;
            if (TArray[i] != null) {
                n4 = n3 + TArray[i].hashCode();
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public ObjectSetIterator<T> iterator() {
        if (Collections.allocateIterators) {
            return new ObjectSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new ObjectSetIterator(this);
            this.iterator2 = new ObjectSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            ObjectSetIterator objectSetIterator = this.iterator1;
            objectSetIterator.valid = true;
            this.iterator2.valid = false;
            return objectSetIterator;
        }
        this.iterator2.reset();
        ObjectSetIterator objectSetIterator = this.iterator2;
        objectSetIterator.valid = true;
        this.iterator1.valid = false;
        return objectSetIterator;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public boolean remove(T t) {
        int n = t.hashCode();
        int n2 = this.mask & n;
        if (t.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            --this.size;
            return true;
        }
        n2 = this.hash2(n);
        if (t.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            --this.size;
            return true;
        }
        if (t.equals(this.keyTable[n = this.hash3(n)])) {
            this.keyTable[n] = null;
            --this.size;
            return true;
        }
        return this.removeStash(t);
    }

    boolean removeStash(T t) {
        T[] TArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!t.equals(TArray[i])) continue;
            this.removeStashIndex(i);
            --this.size;
            return true;
        }
        return false;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            T[] TArray = this.keyTable;
            TArray[n] = TArray[n2];
            TArray[n2] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append(this.toString(", "));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        T t;
        int n;
        int n2;
        T[] TArray;
        StringBuilder stringBuilder;
        block4: {
            if (this.size == 0) {
                return "";
            }
            stringBuilder = new StringBuilder(32);
            TArray = this.keyTable;
            int n3 = TArray.length;
            while (true) {
                n = n2 = n3 - 1;
                if (n3 <= 0) break block4;
                t = TArray[n2];
                if (t != null) break;
                n3 = n2;
            }
            stringBuilder.append(t);
            n = n2;
        }
        while (true) {
            n2 = n - 1;
            if (n <= 0) break;
            t = TArray[n2];
            if (t != null) {
                stringBuilder.append(string2);
                stringBuilder.append(t);
            }
            n = n2;
        }
        return stringBuilder.toString();
    }

    public static class ObjectSetIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        int currentIndex;
        public boolean hasNext;
        int nextIndex;
        final ObjectSet<K> set;
        boolean valid = true;

        public ObjectSetIterator(ObjectSet<K> objectSet) {
            this.set = objectSet;
            this.reset();
        }

        private void findNextIndex() {
            block1: {
                this.hasNext = false;
                T[] TArray = this.set.keyTable;
                int n = this.set.capacity;
                int n2 = this.set.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (TArray[this.nextIndex] == null);
                this.hasNext = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public ObjectSetIterator<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object object = this.set.keyTable;
                    int n = this.nextIndex;
                    object = object[n];
                    this.currentIndex = n;
                    this.findNextIndex();
                    return (K)object;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n >= 0) {
                if (n >= this.set.capacity) {
                    this.set.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.set.keyTable[this.currentIndex] = null;
                }
                this.currentIndex = -1;
                ObjectSet<K> objectSet = this.set;
                --objectSet.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.set.size));
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }
}

