/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    private DataInputStream din;

    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
        this.din = new DataInputStream(inputStream);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.din.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.din.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.din.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.din.readFully(byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.din.readFully(byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        int n;
        int[] nArray = new int[4];
        for (n = 3; n >= 0; --n) {
            nArray[n] = this.din.read();
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        n = nArray[2];
        return nArray[3] & 0xFF | ((n2 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n & 0xFF) << 8);
    }

    @Override
    public final String readLine() throws IOException {
        return this.din.readLine();
    }

    @Override
    public long readLong() throws IOException {
        int[] nArray = new int[8];
        for (int i = 7; i >= 0; --i) {
            nArray[i] = this.din.read();
        }
        long l = nArray[0] & 0xFF;
        long l2 = nArray[1] & 0xFF;
        long l3 = nArray[2] & 0xFF;
        long l4 = nArray[3] & 0xFF;
        long l5 = nArray[4] & 0xFF;
        long l6 = nArray[5] & 0xFF;
        long l7 = nArray[6] & 0xFF;
        return (long)(nArray[7] & 0xFF) | (l << 56 | l2 << 48 | l3 << 40 | l4 << 32 | l5 << 24 | l6 << 16 | l7 << 8);
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.din.read() & 0xFF | this.din.read() << 8);
    }

    @Override
    public String readUTF() throws IOException {
        return this.din.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.din.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.din.read() & 0xFF | (this.din.read() & 0xFF) << 8;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.din.skipBytes(n);
    }
}

