/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataOutput
extends DataOutputStream {
    public DataOutput(OutputStream outputStream) {
        super(outputStream);
    }

    private void writeString_slow(String string2, int n, int n2) throws IOException {
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c <= '\u007f') {
                this.write((byte)c);
            } else if (c > '\u07ff') {
                this.write((byte)(c >> 12 & 0xF | 0xE0));
                this.write((byte)(c >> 6 & 0x3F | 0x80));
                this.write((byte)(c & 0x3F | 0x80));
            } else {
                this.write((byte)(c >> 6 & 0x1F | 0xC0));
                this.write((byte)(c & 0x3F | 0x80));
            }
            ++n2;
        }
    }

    public int writeInt(int n, boolean bl) throws IOException {
        int n2 = n;
        if (!bl) {
            n2 = n >> 31 ^ n << 1;
        }
        if ((n = n2 >>> 7) == 0) {
            this.write((byte)n2);
            return 1;
        }
        this.write((byte)(n2 & 0x7F | 0x80));
        int n3 = n2 >>> 14;
        if (n3 == 0) {
            this.write((byte)n);
            return 2;
        }
        this.write((byte)(n | 0x80));
        n = n2 >>> 21;
        if (n == 0) {
            this.write((byte)n3);
            return 3;
        }
        this.write((byte)(n3 | 0x80));
        if ((n2 >>>= 28) == 0) {
            this.write((byte)n);
            return 4;
        }
        this.write((byte)(n | 0x80));
        this.write((byte)n2);
        return 5;
    }

    public void writeString(String string2) throws IOException {
        char c;
        int n;
        if (string2 == null) {
            this.write(0);
            return;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            this.writeByte(1);
            return;
        }
        this.writeInt(n2 + 1, true);
        for (n = 0; n < n2 && (c = string2.charAt(n)) <= '\u007f'; ++n) {
            this.write((byte)c);
        }
        if (n < n2) {
            this.writeString_slow(string2, n2, n);
        }
    }
}

