/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class Window
extends Table {
    private static final int MOVE = 32;
    private static final Vector2 tmpPosition = new Vector2();
    private static final Vector2 tmpSize = new Vector2();
    protected boolean dragging;
    boolean drawTitleTable;
    protected int edge;
    boolean isModal;
    boolean isMovable = true;
    boolean isResizable;
    boolean keepWithinStage = true;
    int resizeBorder = 8;
    private WindowStyle style;
    Label titleLabel;
    Table titleTable;

    public Window(String string2, Skin skin) {
        this(string2, skin.get(WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String string2, Skin skin, String string3) {
        this(string2, skin.get(string3, WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String string2, WindowStyle windowStyle) {
        if (string2 != null) {
            this.setTouchable(Touchable.enabled);
            this.setClip(true);
            this.titleLabel = new Label((CharSequence)string2, new Label.LabelStyle(windowStyle.titleFont, windowStyle.titleFontColor));
            this.titleLabel.setEllipsis(true);
            this.titleTable = new Table(){

                @Override
                public void draw(Batch batch, float f) {
                    if (Window.this.drawTitleTable) {
                        super.draw(batch, f);
                    }
                }
            };
            this.titleTable.add(this.titleLabel).expandX().fillX().minWidth(0.0f);
            this.addActor(this.titleTable);
            this.setStyle(windowStyle);
            this.setWidth(150.0f);
            this.setHeight(150.0f);
            this.addCaptureListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    Window.this.toFront();
                    return false;
                }
            });
            this.addListener(new InputListener(){
                float lastX;
                float lastY;
                float startX;
                float startY;

                private void updateEdge(float f, float f2) {
                    float f3 = (float)Window.this.resizeBorder / 2.0f;
                    float f4 = Window.this.getWidth();
                    float f5 = Window.this.getHeight();
                    float f6 = Window.this.getPadTop();
                    float f7 = Window.this.getPadLeft();
                    float f8 = Window.this.getPadBottom();
                    float f9 = f4 - Window.this.getPadRight();
                    Window window = Window.this;
                    window.edge = 0;
                    if (window.isResizable && f >= f7 - f3 && f <= f9 + f3 && f2 >= f8 - f3) {
                        if (f < f7 + f3) {
                            window = Window.this;
                            window.edge |= 8;
                        }
                        if (f > f9 - f3) {
                            window = Window.this;
                            window.edge |= 0x10;
                        }
                        if (f2 < f8 + f3) {
                            window = Window.this;
                            window.edge |= 4;
                        }
                        f4 = f3;
                        if (Window.this.edge != 0) {
                            f4 = f3 + 25.0f;
                        }
                        if (f < f7 + f4) {
                            window = Window.this;
                            window.edge |= 8;
                        }
                        if (f > f9 - f4) {
                            window = Window.this;
                            window.edge |= 0x10;
                        }
                        if (f2 < f8 + f4) {
                            window = Window.this;
                            window.edge |= 4;
                        }
                    }
                    if (Window.this.isMovable && Window.this.edge == 0 && f2 <= f5 && f2 >= f5 - f6 && f >= f7 && f <= f9) {
                        Window.this.edge = 32;
                    }
                }

                @Override
                public boolean keyDown(InputEvent inputEvent, int n) {
                    return Window.this.isModal;
                }

                @Override
                public boolean keyTyped(InputEvent inputEvent, char c) {
                    return Window.this.isModal;
                }

                @Override
                public boolean keyUp(InputEvent inputEvent, int n) {
                    return Window.this.isModal;
                }

                @Override
                public boolean mouseMoved(InputEvent inputEvent, float f, float f2) {
                    this.updateEdge(f, f2);
                    return Window.this.isModal;
                }

                @Override
                public boolean scrolled(InputEvent inputEvent, float f, float f2, int n) {
                    return Window.this.isModal;
                }

                @Override
                public boolean touchDown(InputEvent object, float f, float f2, int n, int n2) {
                    boolean bl;
                    block5: {
                        block4: {
                            boolean bl2 = false;
                            if (n2 == 0) {
                                this.updateEdge(f, f2);
                                object = Window.this;
                                bl = ((Window)object).edge != 0;
                                ((Window)object).dragging = bl;
                                this.startX = f;
                                this.startY = f2;
                                this.lastX = f - Window.this.getWidth();
                                this.lastY = f2 - Window.this.getHeight();
                            }
                            if (Window.this.edge != 0) break block4;
                            bl = bl2;
                            if (!Window.this.isModal) break block5;
                        }
                        bl = true;
                    }
                    return bl;
                }

                @Override
                public void touchDragged(InputEvent object, float f, float f2, int n) {
                    if (!Window.this.dragging) {
                        return;
                    }
                    float f3 = Window.this.getWidth();
                    float f4 = Window.this.getHeight();
                    float f5 = Window.this.getX();
                    float f6 = Window.this.getY();
                    float f7 = Window.this.getMinWidth();
                    Window.this.getMaxWidth();
                    float f8 = Window.this.getMinHeight();
                    Window.this.getMaxHeight();
                    object = Window.this.getStage();
                    n = Window.this.keepWithinStage && object != null && Window.this.getParent() == ((Stage)object).getRoot() ? 1 : 0;
                    float f9 = f5;
                    float f10 = f6;
                    if ((Window.this.edge & 0x20) != 0) {
                        f9 = this.startX;
                        f10 = this.startY;
                        f9 = f5 + (f - f9);
                        f10 = f6 + (f2 - f10);
                    }
                    f5 = f9;
                    f6 = f3;
                    if ((Window.this.edge & 8) != 0) {
                        f6 = f5 = f - this.startX;
                        if (f3 - f5 < f7) {
                            f6 = -(f7 - f3);
                        }
                        f5 = f6;
                        if (n != 0) {
                            f5 = f6;
                            if (f9 + f6 < 0.0f) {
                                f5 = -f9;
                            }
                        }
                        f6 = f3 - f5;
                        f5 = f9 + f5;
                    }
                    f3 = f10;
                    f9 = f4;
                    if ((Window.this.edge & 4) != 0) {
                        f9 = f3 = f2 - this.startY;
                        if (f4 - f3 < f8) {
                            f9 = -(f8 - f4);
                        }
                        f3 = f9;
                        if (n != 0) {
                            f3 = f9;
                            if (f10 + f9 < 0.0f) {
                                f3 = -f10;
                            }
                        }
                        f9 = f4 - f3;
                        f3 = f10 + f3;
                    }
                    f10 = f6;
                    if ((Window.this.edge & 0x10) != 0) {
                        f = f10 = f - this.lastX - f6;
                        if (f6 + f10 < f7) {
                            f = f7 - f6;
                        }
                        f10 = f;
                        if (n != 0) {
                            f10 = f;
                            if (f5 + f6 + f > ((Stage)object).getWidth()) {
                                f10 = ((Stage)object).getWidth() - f5 - f6;
                            }
                        }
                        f10 = f6 + f10;
                    }
                    f = f9;
                    if ((Window.this.edge & 2) != 0) {
                        f = f2 = f2 - this.lastY - f9;
                        if (f9 + f2 < f8) {
                            f = f8 - f9;
                        }
                        f2 = f;
                        if (n != 0) {
                            f2 = f;
                            if (f3 + f9 + f > ((Stage)object).getHeight()) {
                                f2 = ((Stage)object).getHeight() - f3 - f9;
                            }
                        }
                        f = f9 + f2;
                    }
                    Window.this.setBounds(Math.round(f5), Math.round(f3), Math.round(f10), Math.round(f));
                }

                @Override
                public void touchUp(InputEvent inputEvent, float f, float f2, int n, int n2) {
                    Window.this.dragging = false;
                }
            });
            return;
        }
        throw new IllegalArgumentException("title cannot be null.");
    }

    @Override
    public void draw(Batch batch, float f) {
        Stage stage = this.getStage();
        if (stage != null && stage.getKeyboardFocus() == null) {
            stage.setKeyboardFocus(this);
        }
        this.keepWithinStage();
        if (this.style.stageBackground != null) {
            this.stageToLocalCoordinates(tmpPosition.set(0.0f, 0.0f));
            this.stageToLocalCoordinates(tmpSize.set(stage.getWidth(), stage.getHeight()));
            this.drawStageBackground(batch, f, this.getX() + Window.tmpPosition.x, this.getY() + Window.tmpPosition.y, this.getX() + Window.tmpSize.x, this.getY() + Window.tmpSize.y);
        }
        super.draw(batch, f);
    }

    @Override
    protected void drawBackground(Batch batch, float f, float f2, float f3) {
        super.drawBackground(batch, f, f2, f3);
        this.titleTable.getColor().a = this.getColor().a;
        f3 = this.getPadTop();
        f2 = this.getPadLeft();
        this.titleTable.setSize(this.getWidth() - f2 - this.getPadRight(), f3);
        this.titleTable.setPosition(f2, this.getHeight() - f3);
        this.drawTitleTable = true;
        this.titleTable.draw(batch, f);
        this.drawTitleTable = false;
    }

    protected void drawStageBackground(Batch batch, float f, float f2, float f3, float f4, float f5) {
        Color color2 = this.getColor();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        this.style.stageBackground.draw(batch, f2, f3, f4, f5);
    }

    @Override
    public float getPrefWidth() {
        return Math.max(super.getPrefWidth(), this.titleTable.getPrefWidth() + this.getPadLeft() + this.getPadRight());
    }

    public WindowStyle getStyle() {
        return this.style;
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public Table getTitleTable() {
        return this.titleTable;
    }

    @Override
    public Actor hit(float f, float f2, boolean bl) {
        if (!this.isVisible()) {
            return null;
        }
        Actor actor = super.hit(f, f2, bl);
        if (actor == null && this.isModal && (!bl || this.getTouchable() == Touchable.enabled)) {
            return this;
        }
        float f3 = this.getHeight();
        if (actor != null && actor != this && f2 <= f3 && f2 >= f3 - this.getPadTop() && f >= 0.0f && f <= this.getWidth()) {
            Actor actor2 = actor;
            while (actor2.getParent() != this) {
                actor2 = actor2.getParent();
            }
            if (this.getCell(actor2) != null) {
                return this;
            }
        }
        return actor;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void keepWithinStage() {
        if (!this.keepWithinStage) {
            return;
        }
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        Camera camera = stage.getCamera();
        if (camera instanceof OrthographicCamera) {
            float f;
            float f2;
            OrthographicCamera orthographicCamera = (OrthographicCamera)camera;
            float f3 = stage.getWidth();
            float f4 = stage.getHeight();
            float f5 = this.getX(16);
            if (f5 - (f2 = camera.position.x) > (f = f3 / 2.0f) / orthographicCamera.zoom) {
                this.setPosition(camera.position.x + f / orthographicCamera.zoom, this.getY(16), 16);
            }
            if (this.getX(8) - camera.position.x < -f3 / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x - f / orthographicCamera.zoom, this.getY(8), 8);
            }
            if ((f5 = this.getY(2)) - (f2 = camera.position.y) > (f = f4 / 2.0f) / orthographicCamera.zoom) {
                this.setPosition(this.getX(2), camera.position.y + f / orthographicCamera.zoom, 2);
            }
            if (this.getY(4) - camera.position.y < -f4 / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(4), camera.position.y - f / orthographicCamera.zoom, 4);
            }
        } else if (this.getParent() == stage.getRoot()) {
            float f = stage.getWidth();
            float f6 = stage.getHeight();
            if (this.getX() < 0.0f) {
                this.setX(0.0f);
            }
            if (this.getRight() > f) {
                this.setX(f - this.getWidth());
            }
            if (this.getY() < 0.0f) {
                this.setY(0.0f);
            }
            if (this.getTop() > f6) {
                this.setY(f6 - this.getHeight());
            }
        }
    }

    public void setKeepWithinStage(boolean bl) {
        this.keepWithinStage = bl;
    }

    public void setModal(boolean bl) {
        this.isModal = bl;
    }

    public void setMovable(boolean bl) {
        this.isMovable = bl;
    }

    public void setResizable(boolean bl) {
        this.isResizable = bl;
    }

    public void setResizeBorder(int n) {
        this.resizeBorder = n;
    }

    public void setStyle(WindowStyle windowStyle) {
        if (windowStyle != null) {
            this.style = windowStyle;
            this.setBackground(windowStyle.background);
            this.titleLabel.setStyle(new Label.LabelStyle(windowStyle.titleFont, windowStyle.titleFontColor));
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public static class WindowStyle {
        public Drawable background;
        public Drawable stageBackground;
        public BitmapFont titleFont;
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);

        public WindowStyle() {
        }

        public WindowStyle(BitmapFont bitmapFont, Color color2, Drawable drawable2) {
            this.background = drawable2;
            this.titleFont = bitmapFont;
            this.titleFontColor.set(color2);
        }

        public WindowStyle(WindowStyle windowStyle) {
            this.background = windowStyle.background;
            this.titleFont = windowStyle.titleFont;
            this.titleFontColor = new Color(windowStyle.titleFontColor);
        }
    }
}

