/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class Touchpad
extends Widget {
    private final Circle deadzoneBounds;
    private float deadzoneRadius;
    private final Circle knobBounds = new Circle(0.0f, 0.0f, 0.0f);
    private final Vector2 knobPercent;
    private final Vector2 knobPosition;
    boolean resetOnTouchUp = true;
    private TouchpadStyle style;
    private final Circle touchBounds = new Circle(0.0f, 0.0f, 0.0f);
    boolean touched;

    public Touchpad(float f, Skin skin) {
        this(f, skin.get(TouchpadStyle.class));
    }

    public Touchpad(float f, Skin skin, String string2) {
        this(f, skin.get(string2, TouchpadStyle.class));
    }

    public Touchpad(float f, TouchpadStyle touchpadStyle) {
        this.deadzoneBounds = new Circle(0.0f, 0.0f, 0.0f);
        this.knobPosition = new Vector2();
        this.knobPercent = new Vector2();
        if (!(f < 0.0f)) {
            this.deadzoneRadius = f;
            this.knobPosition.set(this.getWidth() / 2.0f, this.getHeight() / 2.0f);
            this.setStyle(touchpadStyle);
            this.setSize(this.getPrefWidth(), this.getPrefHeight());
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent object, float f, float f2, int n, int n2) {
                    if (Touchpad.this.touched) {
                        return false;
                    }
                    object = Touchpad.this;
                    ((Touchpad)object).touched = true;
                    ((Touchpad)object).calculatePositionAndValue(f, f2, false);
                    return true;
                }

                @Override
                public void touchDragged(InputEvent inputEvent, float f, float f2, int n) {
                    Touchpad.this.calculatePositionAndValue(f, f2, false);
                }

                @Override
                public void touchUp(InputEvent object, float f, float f2, int n, int n2) {
                    object = Touchpad.this;
                    ((Touchpad)object).touched = false;
                    ((Touchpad)object).calculatePositionAndValue(f, f2, ((Touchpad)object).resetOnTouchUp);
                }
            });
            return;
        }
        throw new IllegalArgumentException("deadzoneRadius must be > 0");
    }

    void calculatePositionAndValue(float f, float f2, boolean bl) {
        float f3 = this.knobPosition.x;
        float f4 = this.knobPosition.y;
        float f5 = this.knobPercent.x;
        float f6 = this.knobPercent.y;
        float f7 = this.knobBounds.x;
        float f8 = this.knobBounds.y;
        this.knobPosition.set(f7, f8);
        this.knobPercent.set(0.0f, 0.0f);
        if (!bl && !this.deadzoneBounds.contains(f, f2)) {
            this.knobPercent.set((f - f7) / this.knobBounds.radius, (f2 - f8) / this.knobBounds.radius);
            f7 = this.knobPercent.len();
            if (f7 > 1.0f) {
                this.knobPercent.scl(1.0f / f7);
            }
            if (this.knobBounds.contains(f, f2)) {
                this.knobPosition.set(f, f2);
            } else {
                this.knobPosition.set(this.knobPercent).nor().scl(this.knobBounds.radius).add(this.knobBounds.x, this.knobBounds.y);
            }
        }
        if (f5 != this.knobPercent.x || f6 != this.knobPercent.y) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire(changeEvent)) {
                this.knobPercent.set(f5, f6);
                this.knobPosition.set(f3, f4);
            }
            Pools.free(changeEvent);
        }
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        Object object = this.getColor();
        batch.setColor(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * f);
        float f2 = this.getX();
        f = this.getY();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        object = this.style.background;
        if (object != null) {
            object.draw(batch, f2, f, f3, f4);
        }
        if ((object = this.style.knob) != null) {
            object.draw(batch, f2 + (this.knobPosition.x - object.getMinWidth() / 2.0f), f + (this.knobPosition.y - object.getMinHeight() / 2.0f), object.getMinWidth(), object.getMinHeight());
        }
    }

    public float getKnobPercentX() {
        return this.knobPercent.x;
    }

    public float getKnobPercentY() {
        return this.knobPercent.y;
    }

    public float getKnobX() {
        return this.knobPosition.x;
    }

    public float getKnobY() {
        return this.knobPosition.y;
    }

    @Override
    public float getPrefHeight() {
        float f = this.style.background != null ? this.style.background.getMinHeight() : 0.0f;
        return f;
    }

    @Override
    public float getPrefWidth() {
        float f = this.style.background != null ? this.style.background.getMinWidth() : 0.0f;
        return f;
    }

    public boolean getResetOnTouchUp() {
        return this.resetOnTouchUp;
    }

    public TouchpadStyle getStyle() {
        return this.style;
    }

    @Override
    public Actor hit(float f, float f2, boolean bl) {
        Touchpad touchpad = null;
        if (bl && this.getTouchable() != Touchable.enabled) {
            return null;
        }
        if (!this.isVisible()) {
            return null;
        }
        if (this.touchBounds.contains(f, f2)) {
            touchpad = this;
        }
        return touchpad;
    }

    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void layout() {
        float f = this.getWidth() / 2.0f;
        float f2 = this.getHeight() / 2.0f;
        float f3 = Math.min(f, f2);
        this.touchBounds.set(f, f2, f3);
        float f4 = f3;
        if (this.style.knob != null) {
            f4 = f3 - Math.max(this.style.knob.getMinWidth(), this.style.knob.getMinHeight()) / 2.0f;
        }
        this.knobBounds.set(f, f2, f4);
        this.deadzoneBounds.set(f, f2, this.deadzoneRadius);
        this.knobPosition.set(f, f2);
        this.knobPercent.set(0.0f, 0.0f);
    }

    public void setDeadzone(float f) {
        if (!(f < 0.0f)) {
            this.deadzoneRadius = f;
            this.invalidate();
            return;
        }
        throw new IllegalArgumentException("deadzoneRadius must be > 0");
    }

    public void setResetOnTouchUp(boolean bl) {
        this.resetOnTouchUp = bl;
    }

    public void setStyle(TouchpadStyle touchpadStyle) {
        if (touchpadStyle != null) {
            this.style = touchpadStyle;
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null");
    }

    public static class TouchpadStyle {
        public Drawable background;
        public Drawable knob;

        public TouchpadStyle() {
        }

        public TouchpadStyle(TouchpadStyle touchpadStyle) {
            this.background = touchpadStyle.background;
            this.knob = touchpadStyle.knob;
        }

        public TouchpadStyle(Drawable drawable2, Drawable drawable3) {
            this.background = drawable2;
            this.knob = drawable3;
        }
    }
}

