/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class ProgressBar
extends Widget
implements Disableable {
    private float animateDuration;
    private float animateFromValue;
    private Interpolation animateInterpolation;
    private float animateTime;
    boolean disabled;
    private float max;
    private float min;
    float position;
    private boolean round;
    private float stepSize;
    private ProgressBarStyle style;
    private float value;
    final boolean vertical;
    private Interpolation visualInterpolation;

    public ProgressBar(float f, float f2, float f3, boolean bl, ProgressBarStyle object) {
        this.animateInterpolation = Interpolation.linear;
        this.visualInterpolation = Interpolation.linear;
        this.round = true;
        if (!(f > f2)) {
            if (!(f3 <= 0.0f)) {
                this.setStyle((ProgressBarStyle)object);
                this.min = f;
                this.max = f2;
                this.stepSize = f3;
                this.vertical = bl;
                this.value = f;
                this.setSize(this.getPrefWidth(), this.getPrefHeight());
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("stepSize must be > 0: ");
            ((StringBuilder)object).append(f3);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("max must be > min. min,max: ");
        ((StringBuilder)object).append(f);
        ((StringBuilder)object).append(", ");
        ((StringBuilder)object).append(f2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public ProgressBar(float f, float f2, float f3, boolean bl, Skin skin) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("default-");
        String string2 = bl ? "vertical" : "horizontal";
        stringBuilder.append(string2);
        this(f, f2, f3, bl, skin.get(stringBuilder.toString(), ProgressBarStyle.class));
    }

    public ProgressBar(float f, float f2, float f3, boolean bl, Skin skin, String string2) {
        this(f, f2, f3, bl, skin.get(string2, ProgressBarStyle.class));
    }

    @Override
    public void act(float f) {
        super.act(f);
        float f2 = this.animateTime;
        if (f2 > 0.0f) {
            this.animateTime = f2 - f;
            Stage stage = this.getStage();
            if (stage != null && stage.getActionsRequestRendering()) {
                Gdx.graphics.requestRendering();
            }
        }
    }

    protected float clamp(float f) {
        return MathUtils.clamp(f, this.min, this.max);
    }

    @Override
    public void draw(Batch batch, float f) {
        Object object = this.style;
        boolean bl = this.disabled;
        Drawable drawable2 = this.getKnobDrawable();
        Drawable drawable3 = bl && ((ProgressBarStyle)object).disabledBackground != null ? ((ProgressBarStyle)object).disabledBackground : ((ProgressBarStyle)object).background;
        Drawable drawable4 = bl && ((ProgressBarStyle)object).disabledKnobBefore != null ? ((ProgressBarStyle)object).disabledKnobBefore : ((ProgressBarStyle)object).knobBefore;
        object = bl && ((ProgressBarStyle)object).disabledKnobAfter != null ? ((ProgressBarStyle)object).disabledKnobAfter : ((ProgressBarStyle)object).knobAfter;
        Color color2 = this.getColor();
        float f2 = this.getX();
        float f3 = this.getY();
        float f4 = this.getWidth();
        float f5 = this.getHeight();
        float f6 = drawable2 == null ? 0.0f : drawable2.getMinHeight();
        float f7 = drawable2 == null ? 0.0f : drawable2.getMinWidth();
        float f8 = this.getVisualPercent();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        if (this.vertical) {
            float f9;
            float f10;
            float f11;
            if (drawable3 != null) {
                if (this.round) {
                    drawable3.draw(batch, Math.round((f4 - drawable3.getMinWidth()) * 0.5f + f2), f3, Math.round(drawable3.getMinWidth()), f5);
                } else {
                    drawable3.draw(batch, f2 + f4 - drawable3.getMinWidth() * 0.5f, f3, drawable3.getMinWidth(), f5);
                }
                f11 = drawable3.getTopHeight();
                f10 = drawable3.getBottomHeight();
                f9 = f5 - (f11 + f10);
            } else {
                f9 = f5;
                f10 = 0.0f;
                f11 = 0.0f;
            }
            if (drawable2 == null) {
                f = drawable4 == null ? 0.0f : drawable4.getMinHeight() * 0.5f;
                this.position = (f9 -= f) * f8;
                this.position = Math.min(f9, this.position);
            } else {
                f = f6 * 0.5f;
                this.position = (f9 -= f6) * f8;
                this.position = Math.min(f9, this.position) + f10;
            }
            this.position = Math.max(Math.min(0.0f, f10), this.position);
            if (drawable4 != null) {
                if (this.round) {
                    drawable4.draw(batch, Math.round((f4 - drawable4.getMinWidth()) * 0.5f + f2), Math.round(f11 + f3), Math.round(drawable4.getMinWidth()), Math.round(this.position + f));
                } else {
                    drawable4.draw(batch, f2 + (f4 - drawable4.getMinWidth()) * 0.5f, f3 + f11, drawable4.getMinWidth(), this.position + f);
                }
            }
            if (object != null) {
                if (this.round) {
                    object.draw(batch, Math.round((f4 - object.getMinWidth()) * 0.5f + f2), Math.round(this.position + f3 + f), Math.round(object.getMinWidth()), Math.round(f5 - this.position - f));
                } else {
                    object.draw(batch, f2 + (f4 - object.getMinWidth()) * 0.5f, this.position + f3 + f, object.getMinWidth(), f5 - this.position - f);
                }
            }
            if (drawable2 != null) {
                if (this.round) {
                    drawable2.draw(batch, Math.round(f2 + (f4 - f7) * 0.5f), Math.round(f3 + this.position), Math.round(f7), Math.round(f6));
                } else {
                    drawable2.draw(batch, f2 + (f4 - f7) * 0.5f, f3 + this.position, f7, f6);
                }
            }
        } else {
            float f12;
            float f13;
            if (drawable3 != null) {
                if (this.round) {
                    drawable3.draw(batch, f2, Math.round((f5 - drawable3.getMinHeight()) * 0.5f + f3), f4, Math.round(drawable3.getMinHeight()));
                } else {
                    drawable3.draw(batch, f2, f3 + (f5 - drawable3.getMinHeight()) * 0.5f, f4, drawable3.getMinHeight());
                }
                f13 = drawable3.getLeftWidth();
                f12 = f4 - (drawable3.getRightWidth() + f13);
            } else {
                f12 = f4;
                f13 = 0.0f;
            }
            if (drawable2 == null) {
                f = drawable4 == null ? 0.0f : drawable4.getMinWidth() * 0.5f;
                this.position = (f12 -= f) * f8;
                this.position = Math.min(f12, this.position);
            } else {
                f = f7 * 0.5f;
                this.position = (f12 -= f7) * f8;
                this.position = Math.min(f12, this.position) + f13;
            }
            this.position = Math.max(Math.min(0.0f, f13), this.position);
            if (drawable4 != null) {
                if (this.round) {
                    drawable4.draw(batch, Math.round(f13 + f2), Math.round((f5 - drawable4.getMinHeight()) * 0.5f + f3), Math.round(this.position + f), Math.round(drawable4.getMinHeight()));
                } else {
                    drawable4.draw(batch, f2 + f13, f3 + (f5 - drawable4.getMinHeight()) * 0.5f, this.position + f, drawable4.getMinHeight());
                }
            }
            if (object != null) {
                if (this.round) {
                    object.draw(batch, Math.round(this.position + f2 + f), Math.round((f5 - object.getMinHeight()) * 0.5f + f3), Math.round(f4 - this.position - f), Math.round(object.getMinHeight()));
                } else {
                    object.draw(batch, this.position + f2 + f, f3 + (f5 - object.getMinHeight()) * 0.5f, f4 - this.position - f, object.getMinHeight());
                }
            }
            if (drawable2 != null) {
                if (this.round) {
                    drawable2.draw(batch, Math.round(f2 + this.position), Math.round(f3 + (f5 - f6) * 0.5f), Math.round(f7), Math.round(f6));
                } else {
                    drawable2.draw(batch, f2 + this.position, f3 + (f5 - f6) * 0.5f, f7, f6);
                }
            }
        }
    }

    protected Drawable getKnobDrawable() {
        Drawable drawable2 = this.disabled && this.style.disabledKnob != null ? this.style.disabledKnob : this.style.knob;
        return drawable2;
    }

    protected float getKnobPosition() {
        return this.position;
    }

    public float getMaxValue() {
        return this.max;
    }

    public float getMinValue() {
        return this.min;
    }

    public float getPercent() {
        float f = this.min;
        float f2 = this.max;
        if (f == f2) {
            return 0.0f;
        }
        return (this.value - f) / (f2 - f);
    }

    @Override
    public float getPrefHeight() {
        if (this.vertical) {
            return 140.0f;
        }
        Drawable drawable2 = this.getKnobDrawable();
        Drawable drawable3 = this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : this.style.background;
        float f = 0.0f;
        float f2 = drawable2 == null ? 0.0f : drawable2.getMinHeight();
        if (drawable3 != null) {
            f = drawable3.getMinHeight();
        }
        return Math.max(f2, f);
    }

    @Override
    public float getPrefWidth() {
        if (this.vertical) {
            Drawable drawable2 = this.getKnobDrawable();
            Drawable drawable3 = this.disabled && this.style.disabledBackground != null ? this.style.disabledBackground : this.style.background;
            float f = 0.0f;
            float f2 = drawable2 == null ? 0.0f : drawable2.getMinWidth();
            if (drawable3 != null) {
                f = drawable3.getMinWidth();
            }
            return Math.max(f2, f);
        }
        return 140.0f;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public ProgressBarStyle getStyle() {
        return this.style;
    }

    public float getValue() {
        return this.value;
    }

    public float getVisualPercent() {
        if (this.min == this.max) {
            return 0.0f;
        }
        Interpolation interpolation = this.visualInterpolation;
        float f = this.getVisualValue();
        float f2 = this.min;
        return interpolation.apply((f - f2) / (this.max - f2));
    }

    public float getVisualValue() {
        float f = this.animateTime;
        if (f > 0.0f) {
            return this.animateInterpolation.apply(this.animateFromValue, this.value, 1.0f - f / this.animateDuration);
        }
        return this.value;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setAnimateDuration(float f) {
        this.animateDuration = f;
    }

    public void setAnimateInterpolation(Interpolation interpolation) {
        if (interpolation != null) {
            this.animateInterpolation = interpolation;
            return;
        }
        throw new IllegalArgumentException("animateInterpolation cannot be null.");
    }

    @Override
    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public void setRange(float f, float f2) {
        if (!(f > f2)) {
            this.min = f;
            this.max = f2;
            float f3 = this.value;
            if (f3 < f) {
                this.setValue(f);
            } else if (f3 > f2) {
                this.setValue(f2);
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("min must be <= max: ");
        stringBuilder.append(f);
        stringBuilder.append(" <= ");
        stringBuilder.append(f2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    public void setStepSize(float f) {
        if (!(f <= 0.0f)) {
            this.stepSize = f;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("steps must be > 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setStyle(ProgressBarStyle progressBarStyle) {
        if (progressBarStyle != null) {
            this.style = progressBarStyle;
            this.invalidateHierarchy();
            return;
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public boolean setValue(float f) {
        float f2;
        float f3 = this.clamp((float)Math.round(f / this.stepSize) * this.stepSize);
        if (f3 == (f2 = this.value)) {
            return false;
        }
        f = this.getVisualValue();
        this.value = f3;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        boolean bl = this.fire(changeEvent);
        if (bl) {
            this.value = f2;
        } else {
            f2 = this.animateDuration;
            if (f2 > 0.0f) {
                this.animateFromValue = f;
                this.animateTime = f2;
            }
        }
        Pools.free(changeEvent);
        return bl ^ true;
    }

    public void setVisualInterpolation(Interpolation interpolation) {
        this.visualInterpolation = interpolation;
    }

    public static class ProgressBarStyle {
        public Drawable background;
        public Drawable disabledBackground;
        public Drawable disabledKnob;
        public Drawable disabledKnobAfter;
        public Drawable disabledKnobBefore;
        public Drawable knob;
        public Drawable knobAfter;
        public Drawable knobBefore;

        public ProgressBarStyle() {
        }

        public ProgressBarStyle(ProgressBarStyle progressBarStyle) {
            this.background = progressBarStyle.background;
            this.disabledBackground = progressBarStyle.disabledBackground;
            this.knob = progressBarStyle.knob;
            this.disabledKnob = progressBarStyle.disabledKnob;
            this.knobBefore = progressBarStyle.knobBefore;
            this.knobAfter = progressBarStyle.knobAfter;
            this.disabledKnobBefore = progressBarStyle.disabledKnobBefore;
            this.disabledKnobAfter = progressBarStyle.disabledKnobAfter;
        }

        public ProgressBarStyle(Drawable drawable2, Drawable drawable3) {
            this.background = drawable2;
            this.knob = drawable3;
        }
    }
}

