/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.StringBuilder;

public class Label
extends Widget {
    private static final GlyphLayout prefSizeLayout;
    private static final Color tempColor;
    private BitmapFontCache cache;
    private String ellipsis;
    private boolean fontScaleChanged = false;
    private float fontScaleX = 1.0f;
    private float fontScaleY = 1.0f;
    private int intValue;
    private int labelAlign = 8;
    private float lastPrefHeight;
    private final GlyphLayout layout = new GlyphLayout();
    private int lineAlign = 8;
    private final Vector2 prefSize = new Vector2();
    private boolean prefSizeInvalid = true;
    private LabelStyle style;
    private final StringBuilder text = new StringBuilder();
    private boolean wrap;

    static {
        tempColor = new Color();
        prefSizeLayout = new GlyphLayout();
    }

    public Label(CharSequence charSequence, LabelStyle labelStyle) {
        this.intValue = Integer.MIN_VALUE;
        if (charSequence != null) {
            this.text.append(charSequence);
        }
        this.setStyle(labelStyle);
        if (charSequence != null && charSequence.length() > 0) {
            this.setSize(this.getPrefWidth(), this.getPrefHeight());
        }
    }

    public Label(CharSequence charSequence, Skin skin) {
        this(charSequence, skin.get(LabelStyle.class));
    }

    public Label(CharSequence charSequence, Skin skin, String string2) {
        this(charSequence, skin.get(string2, LabelStyle.class));
    }

    public Label(CharSequence charSequence, Skin skin, String string2, Color color2) {
        this(charSequence, new LabelStyle(skin.getFont(string2), color2));
    }

    public Label(CharSequence charSequence, Skin skin, String string2, String string3) {
        this(charSequence, new LabelStyle(skin.getFont(string2), skin.getColor(string3)));
    }

    private void computePrefSize() {
        this.prefSizeInvalid = false;
        GlyphLayout glyphLayout = prefSizeLayout;
        if (this.wrap && this.ellipsis == null) {
            float f;
            float f2 = f = this.getWidth();
            if (this.style.background != null) {
                f2 = f - (this.style.background.getLeftWidth() + this.style.background.getRightWidth());
            }
            glyphLayout.setText(this.cache.getFont(), this.text, Color.WHITE, f2, 8, true);
        } else {
            glyphLayout.setText(this.cache.getFont(), this.text);
        }
        this.prefSize.set(glyphLayout.width, glyphLayout.height);
    }

    private void scaleAndComputePrefSize() {
        BitmapFont bitmapFont = this.cache.getFont();
        float f = bitmapFont.getScaleX();
        float f2 = bitmapFont.getScaleY();
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        this.computePrefSize();
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(f, f2);
        }
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        Color color2 = tempColor.set(this.getColor());
        color2.a *= f;
        if (this.style.background != null) {
            batch.setColor(color2.r, color2.g, color2.b, color2.a);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.style.fontColor != null) {
            color2.mul(this.style.fontColor);
        }
        this.cache.tint(color2);
        this.cache.setPosition(this.getX(), this.getY());
        this.cache.draw(batch);
    }

    protected BitmapFontCache getBitmapFontCache() {
        return this.cache;
    }

    public float getFontScaleX() {
        return this.fontScaleX;
    }

    public float getFontScaleY() {
        return this.fontScaleY;
    }

    public GlyphLayout getGlyphLayout() {
        return this.layout;
    }

    public int getLabelAlign() {
        return this.labelAlign;
    }

    public int getLineAlign() {
        return this.lineAlign;
    }

    @Override
    public float getPrefHeight() {
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float f = 1.0f;
        if (this.fontScaleChanged) {
            f = this.fontScaleY / this.style.font.getScaleY();
        }
        float f2 = this.prefSize.y - this.style.font.getDescent() * f * 2.0f;
        Drawable drawable2 = this.style.background;
        f = f2;
        if (drawable2 != null) {
            f = f2 + (drawable2.getTopHeight() + drawable2.getBottomHeight());
        }
        return f;
    }

    @Override
    public float getPrefWidth() {
        if (this.wrap) {
            return 0.0f;
        }
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float f = this.prefSize.x;
        Drawable drawable2 = this.style.background;
        float f2 = f;
        if (drawable2 != null) {
            f2 = f + (drawable2.getLeftWidth() + drawable2.getRightWidth());
        }
        return f2;
    }

    public LabelStyle getStyle() {
        return this.style;
    }

    public StringBuilder getText() {
        return this.text;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.prefSizeInvalid = true;
    }

    @Override
    public void layout() {
        Object object;
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        BitmapFont bitmapFont = this.cache.getFont();
        float f6 = bitmapFont.getScaleX();
        float f7 = bitmapFont.getScaleY();
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        if ((bl = this.wrap && this.ellipsis == null) && (f5 = this.getPrefHeight()) != this.lastPrefHeight) {
            this.lastPrefHeight = f5;
            this.invalidateHierarchy();
        }
        float f8 = this.getWidth();
        float f9 = this.getHeight();
        Object object2 = this.style.background;
        if (object2 != null) {
            f5 = object2.getLeftWidth();
            f4 = object2.getBottomHeight();
            float f10 = object2.getLeftWidth();
            f3 = object2.getRightWidth();
            f2 = object2.getBottomHeight();
            f = object2.getTopHeight();
            f8 -= f10 + f3;
            f9 -= f2 + f;
        } else {
            f5 = 0.0f;
            f4 = 0.0f;
        }
        object2 = this.layout;
        if (!bl && this.text.indexOf("\n") == -1) {
            f2 = bitmapFont.getData().capHeight;
            f = f5;
        } else {
            StringBuilder stringBuilder = this.text;
            int n2 = stringBuilder.length;
            Color color2 = Color.WHITE;
            n = this.lineAlign;
            String string2 = this.ellipsis;
            object = object2;
            ((GlyphLayout)object2).setText(bitmapFont, stringBuilder, 0, n2, color2, f8, n, bl, string2);
            f3 = ((GlyphLayout)object).width;
            f2 = ((GlyphLayout)object).height;
            n = this.labelAlign;
            f = f5;
            if ((n & 8) == 0) {
                f8 = (n & 0x10) != 0 ? (f8 -= f3) : (f8 - f3) / 2.0f;
                f = f5 + f8;
            }
            f8 = f3;
        }
        n = this.labelAlign;
        if ((n & 2) != 0) {
            f5 = this.cache.getFont().isFlipped() ? 0.0f : f9 - f2;
            f5 = f4 + f5 + this.style.font.getDescent();
        } else if ((n & 4) != 0) {
            f5 = this.cache.getFont().isFlipped() ? f9 - f2 : 0.0f;
            f5 = f4 + f5 - this.style.font.getDescent();
        } else {
            f5 = f4 + (f9 - f2) / 2.0f;
        }
        f4 = f5;
        if (!this.cache.getFont().isFlipped()) {
            f4 = f5 + f2;
        }
        object = this.text;
        ((GlyphLayout)object2).setText(bitmapFont, (CharSequence)object, 0, ((StringBuilder)object).length, Color.WHITE, f8, this.lineAlign, bl, this.ellipsis);
        this.cache.setText((GlyphLayout)object2, f, f4);
        if (this.fontScaleChanged) {
            bitmapFont.getData().setScale(f6, f7);
        }
    }

    public void setAlignment(int n) {
        this.setAlignment(n, n);
    }

    public void setAlignment(int n, int n2) {
        this.labelAlign = n;
        this.lineAlign = (n2 & 8) != 0 ? 8 : ((n2 & 0x10) != 0 ? 16 : 1);
        this.invalidate();
    }

    public void setEllipsis(String string2) {
        this.ellipsis = string2;
    }

    public void setEllipsis(boolean bl) {
        this.ellipsis = bl ? "..." : null;
    }

    public void setFontScale(float f) {
        this.setFontScale(f, f);
    }

    public void setFontScale(float f, float f2) {
        this.fontScaleChanged = true;
        this.fontScaleX = f;
        this.fontScaleY = f2;
        this.invalidateHierarchy();
    }

    public void setFontScaleX(float f) {
        this.setFontScale(f, this.fontScaleY);
    }

    public void setFontScaleY(float f) {
        this.setFontScale(this.fontScaleX, f);
    }

    public void setStyle(LabelStyle labelStyle) {
        if (labelStyle != null) {
            if (labelStyle.font != null) {
                this.style = labelStyle;
                this.cache = labelStyle.font.newFontCache();
                this.invalidateHierarchy();
                return;
            }
            throw new IllegalArgumentException("Missing LabelStyle font.");
        }
        throw new IllegalArgumentException("style cannot be null.");
    }

    public void setText(CharSequence charSequence) {
        CharSequence charSequence2 = charSequence;
        if (charSequence == null) {
            charSequence2 = "";
        }
        if (charSequence2 instanceof StringBuilder) {
            if (this.text.equals(charSequence2)) {
                return;
            }
            this.text.setLength(0);
            this.text.append((StringBuilder)charSequence2);
        } else {
            if (this.textEquals(charSequence2)) {
                return;
            }
            this.text.setLength(0);
            this.text.append(charSequence2);
        }
        this.intValue = Integer.MIN_VALUE;
        this.invalidateHierarchy();
    }

    public boolean setText(int n) {
        if (this.intValue == n) {
            return false;
        }
        this.setText(Integer.toString(n));
        this.intValue = n;
        return true;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
        this.invalidateHierarchy();
    }

    public boolean textEquals(CharSequence charSequence) {
        int n = this.text.length;
        char[] cArray = this.text.chars;
        if (n != charSequence.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        String string2 = this.getName();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getClass().getName();
        int n = string3.lastIndexOf(46);
        string2 = string3;
        if (n != -1) {
            string2 = string3.substring(n + 1);
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        string3 = string2.indexOf(36) != -1 ? "Label " : "";
        stringBuilder.append(string3);
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append((Object)this.text);
        return stringBuilder.toString();
    }

    public static class LabelStyle {
        public Drawable background;
        public BitmapFont font;
        public Color fontColor;

        public LabelStyle() {
        }

        public LabelStyle(BitmapFont bitmapFont, Color color2) {
            this.font = bitmapFont;
            this.fontColor = color2;
        }

        public LabelStyle(LabelStyle labelStyle) {
            this.font = labelStyle.font;
            Color color2 = labelStyle.fontColor;
            if (color2 != null) {
                this.fontColor = new Color(color2);
            }
            this.background = labelStyle.background;
        }
    }
}

