/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.utils.Pool;

public class Cell<T extends Actor>
implements Pool.Poolable {
    private static final Integer bottomi;
    private static final Integer centeri;
    private static Cell defaults;
    private static Files files;
    private static final Integer lefti;
    private static final Float onef;
    private static final Integer onei;
    private static final Integer righti;
    private static final Integer topi;
    private static final Float zerof;
    private static final Integer zeroi;
    Actor actor;
    float actorHeight;
    float actorWidth;
    float actorX;
    float actorY;
    Integer align;
    int cellAboveIndex = -1;
    Integer colspan;
    int column;
    float computedPadBottom;
    float computedPadLeft;
    float computedPadRight;
    float computedPadTop;
    boolean endRow;
    Integer expandX;
    Integer expandY;
    Float fillX;
    Float fillY;
    Value maxHeight;
    Value maxWidth;
    Value minHeight;
    Value minWidth;
    Value padBottom;
    Value padLeft;
    Value padRight;
    Value padTop;
    Value prefHeight;
    Value prefWidth;
    int row;
    Value spaceBottom;
    Value spaceLeft;
    Value spaceRight;
    Value spaceTop;
    private Table table;
    Boolean uniformX;
    Boolean uniformY;

    static {
        zerof = Float.valueOf(0.0f);
        onef = Float.valueOf(1.0f);
        zeroi = 0;
        centeri = onei = Integer.valueOf(1);
        topi = 2;
        bottomi = 4;
        lefti = 8;
        righti = 16;
    }

    public Cell() {
        Cell cell = Cell.defaults();
        if (cell != null) {
            this.set(cell);
        }
    }

    public static Cell defaults() {
        Object object = files;
        if (object == null || object != Gdx.files) {
            Number number;
            files = Gdx.files;
            defaults = new Cell();
            Cell.defaults.minWidth = Value.minWidth;
            Cell.defaults.minHeight = Value.minHeight;
            Cell.defaults.prefWidth = Value.prefWidth;
            Cell.defaults.prefHeight = Value.prefHeight;
            Cell.defaults.maxWidth = Value.maxWidth;
            Cell.defaults.maxHeight = Value.maxHeight;
            Cell.defaults.spaceTop = Value.zero;
            Cell.defaults.spaceLeft = Value.zero;
            Cell.defaults.spaceBottom = Value.zero;
            Cell.defaults.spaceRight = Value.zero;
            Cell.defaults.padTop = Value.zero;
            Cell.defaults.padLeft = Value.zero;
            Cell.defaults.padBottom = Value.zero;
            Cell.defaults.padRight = Value.zero;
            object = defaults;
            ((Cell)object).fillX = number = zerof;
            ((Cell)object).fillY = number;
            ((Cell)object).align = centeri;
            number = zeroi;
            ((Cell)object).expandX = number;
            ((Cell)object).expandY = number;
            ((Cell)object).colspan = onei;
            ((Cell)object).uniformX = null;
            ((Cell)object).uniformY = null;
        }
        return defaults;
    }

    public Cell<T> align(int n) {
        this.align = n;
        return this;
    }

    public Cell<T> bottom() {
        Integer n = this.align;
        this.align = n == null ? bottomi : Integer.valueOf((n | 4) & 0xFFFFFFFD);
        return this;
    }

    public Cell<T> center() {
        this.align = centeri;
        return this;
    }

    void clear() {
        this.minWidth = null;
        this.minHeight = null;
        this.prefWidth = null;
        this.prefHeight = null;
        this.maxWidth = null;
        this.maxHeight = null;
        this.spaceTop = null;
        this.spaceLeft = null;
        this.spaceBottom = null;
        this.spaceRight = null;
        this.padTop = null;
        this.padLeft = null;
        this.padBottom = null;
        this.padRight = null;
        this.fillX = null;
        this.fillY = null;
        this.align = null;
        this.expandX = null;
        this.expandY = null;
        this.colspan = null;
        this.uniformX = null;
        this.uniformY = null;
    }

    public Cell<T> clearActor() {
        this.setActor(null);
        return this;
    }

    public Cell<T> colspan(int n) {
        this.colspan = n;
        return this;
    }

    public Cell<T> expand() {
        Integer n;
        this.expandX = n = onei;
        this.expandY = n;
        return this;
    }

    public Cell<T> expand(int n, int n2) {
        this.expandX = n;
        this.expandY = n2;
        return this;
    }

    public Cell<T> expand(boolean bl, boolean bl2) {
        Integer n = bl ? onei : zeroi;
        this.expandX = n;
        n = bl2 ? onei : zeroi;
        this.expandY = n;
        return this;
    }

    public Cell<T> expandX() {
        this.expandX = onei;
        return this;
    }

    public Cell<T> expandY() {
        this.expandY = onei;
        return this;
    }

    public Cell<T> fill() {
        Float f;
        this.fillX = f = onef;
        this.fillY = f;
        return this;
    }

    public Cell<T> fill(float f, float f2) {
        this.fillX = Float.valueOf(f);
        this.fillY = Float.valueOf(f2);
        return this;
    }

    public Cell<T> fill(boolean bl) {
        Float f = bl ? onef : zerof;
        this.fillX = f;
        f = bl ? onef : zerof;
        this.fillY = f;
        return this;
    }

    public Cell<T> fill(boolean bl, boolean bl2) {
        Float f = bl ? onef : zerof;
        this.fillX = f;
        f = bl2 ? onef : zerof;
        this.fillY = f;
        return this;
    }

    public Cell<T> fillX() {
        this.fillX = onef;
        return this;
    }

    public Cell<T> fillY() {
        this.fillY = onef;
        return this;
    }

    public T getActor() {
        return (T)this.actor;
    }

    public float getActorHeight() {
        return this.actorHeight;
    }

    public float getActorWidth() {
        return this.actorWidth;
    }

    public float getActorX() {
        return this.actorX;
    }

    public float getActorY() {
        return this.actorY;
    }

    public int getAlign() {
        return this.align;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getColumn() {
        return this.column;
    }

    public float getComputedPadBottom() {
        return this.computedPadBottom;
    }

    public float getComputedPadLeft() {
        return this.computedPadLeft;
    }

    public float getComputedPadRight() {
        return this.computedPadRight;
    }

    public float getComputedPadTop() {
        return this.computedPadTop;
    }

    public int getExpandX() {
        return this.expandX;
    }

    public int getExpandY() {
        return this.expandY;
    }

    public float getFillX() {
        return this.fillX.floatValue();
    }

    public float getFillY() {
        return this.fillY.floatValue();
    }

    public float getMaxHeight() {
        return this.maxHeight.get(this.actor);
    }

    public Value getMaxHeightValue() {
        return this.maxHeight;
    }

    public float getMaxWidth() {
        return this.maxWidth.get(this.actor);
    }

    public Value getMaxWidthValue() {
        return this.maxWidth;
    }

    public float getMinHeight() {
        return this.minHeight.get(this.actor);
    }

    public Value getMinHeightValue() {
        return this.minHeight;
    }

    public float getMinWidth() {
        return this.minWidth.get(this.actor);
    }

    public Value getMinWidthValue() {
        return this.minWidth;
    }

    public float getPadBottom() {
        return this.padBottom.get(this.actor);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadLeft() {
        return this.padLeft.get(this.actor);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadRight() {
        return this.padRight.get(this.actor);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadTop() {
        return this.padTop.get(this.actor);
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadX() {
        return this.padLeft.get(this.actor) + this.padRight.get(this.actor);
    }

    public float getPadY() {
        return this.padTop.get(this.actor) + this.padBottom.get(this.actor);
    }

    public float getPrefHeight() {
        return this.prefHeight.get(this.actor);
    }

    public Value getPrefHeightValue() {
        return this.prefHeight;
    }

    public float getPrefWidth() {
        return this.prefWidth.get(this.actor);
    }

    public Value getPrefWidthValue() {
        return this.prefWidth;
    }

    public int getRow() {
        return this.row;
    }

    public float getSpaceBottom() {
        return this.spaceBottom.get(this.actor);
    }

    public Value getSpaceBottomValue() {
        return this.spaceBottom;
    }

    public float getSpaceLeft() {
        return this.spaceLeft.get(this.actor);
    }

    public Value getSpaceLeftValue() {
        return this.spaceLeft;
    }

    public float getSpaceRight() {
        return this.spaceRight.get(this.actor);
    }

    public Value getSpaceRightValue() {
        return this.spaceRight;
    }

    public float getSpaceTop() {
        return this.spaceTop.get(this.actor);
    }

    public Value getSpaceTopValue() {
        return this.spaceTop;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getUniformX() {
        return this.uniformX;
    }

    public boolean getUniformY() {
        return this.uniformY;
    }

    public Cell<T> grow() {
        Number number;
        this.expandX = number = onei;
        this.expandY = number;
        number = onef;
        this.fillX = number;
        this.fillY = number;
        return this;
    }

    public Cell<T> growX() {
        this.expandX = onei;
        this.fillX = onef;
        return this;
    }

    public Cell<T> growY() {
        this.expandY = onei;
        this.fillY = onef;
        return this;
    }

    public boolean hasActor() {
        boolean bl = this.actor != null;
        return bl;
    }

    public Cell<T> height(float f) {
        this.height(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> height(Value value) {
        if (value != null) {
            this.minHeight = value;
            this.prefHeight = value;
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("height cannot be null.");
    }

    public boolean isEndRow() {
        return this.endRow;
    }

    public Cell<T> left() {
        Integer n = this.align;
        this.align = n == null ? lefti : Integer.valueOf((n | 8) & 0xFFFFFFEF);
        return this;
    }

    public Cell<T> maxHeight(float f) {
        this.maxHeight = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> maxHeight(Value value) {
        if (value != null) {
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("maxHeight cannot be null.");
    }

    public Cell<T> maxSize(float f) {
        this.maxSize(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> maxSize(float f, float f2) {
        this.maxSize(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Cell<T> maxSize(Value value) {
        if (value != null) {
            this.maxWidth = value;
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Cell<T> maxSize(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.maxWidth = value;
                this.maxHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Cell<T> maxWidth(float f) {
        this.maxWidth = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> maxWidth(Value value) {
        if (value != null) {
            this.maxWidth = value;
            return this;
        }
        throw new IllegalArgumentException("maxWidth cannot be null.");
    }

    void merge(Cell object) {
        if (object == null) {
            return;
        }
        Object object2 = ((Cell)object).minWidth;
        if (object2 != null) {
            this.minWidth = object2;
        }
        if ((object2 = ((Cell)object).minHeight) != null) {
            this.minHeight = object2;
        }
        if ((object2 = ((Cell)object).prefWidth) != null) {
            this.prefWidth = object2;
        }
        if ((object2 = ((Cell)object).prefHeight) != null) {
            this.prefHeight = object2;
        }
        if ((object2 = ((Cell)object).maxWidth) != null) {
            this.maxWidth = object2;
        }
        if ((object2 = ((Cell)object).maxHeight) != null) {
            this.maxHeight = object2;
        }
        if ((object2 = ((Cell)object).spaceTop) != null) {
            this.spaceTop = object2;
        }
        if ((object2 = ((Cell)object).spaceLeft) != null) {
            this.spaceLeft = object2;
        }
        if ((object2 = ((Cell)object).spaceBottom) != null) {
            this.spaceBottom = object2;
        }
        if ((object2 = ((Cell)object).spaceRight) != null) {
            this.spaceRight = object2;
        }
        if ((object2 = ((Cell)object).padTop) != null) {
            this.padTop = object2;
        }
        if ((object2 = ((Cell)object).padLeft) != null) {
            this.padLeft = object2;
        }
        if ((object2 = ((Cell)object).padBottom) != null) {
            this.padBottom = object2;
        }
        if ((object2 = ((Cell)object).padRight) != null) {
            this.padRight = object2;
        }
        if ((object2 = ((Cell)object).fillX) != null) {
            this.fillX = object2;
        }
        if ((object2 = ((Cell)object).fillY) != null) {
            this.fillY = object2;
        }
        if ((object2 = ((Cell)object).align) != null) {
            this.align = object2;
        }
        if ((object2 = ((Cell)object).expandX) != null) {
            this.expandX = object2;
        }
        if ((object2 = ((Cell)object).expandY) != null) {
            this.expandY = object2;
        }
        if ((object2 = ((Cell)object).colspan) != null) {
            this.colspan = object2;
        }
        if ((object2 = ((Cell)object).uniformX) != null) {
            this.uniformX = object2;
        }
        if ((object = ((Cell)object).uniformY) != null) {
            this.uniformY = object;
        }
    }

    public Cell<T> minHeight(float f) {
        this.minHeight = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> minHeight(Value value) {
        if (value != null) {
            this.minHeight = value;
            return this;
        }
        throw new IllegalArgumentException("minHeight cannot be null.");
    }

    public Cell<T> minSize(float f) {
        this.minSize(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> minSize(float f, float f2) {
        this.minSize(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Cell<T> minSize(Value value) {
        if (value != null) {
            this.minWidth = value;
            this.minHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Cell<T> minSize(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.minWidth = value;
                this.minHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Cell<T> minWidth(float f) {
        this.minWidth = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> minWidth(Value value) {
        if (value != null) {
            this.minWidth = value;
            return this;
        }
        throw new IllegalArgumentException("minWidth cannot be null.");
    }

    public Cell<T> pad(float f) {
        this.pad(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> pad(float f, float f2, float f3, float f4) {
        this.pad(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2), Value.Fixed.valueOf(f3), Value.Fixed.valueOf(f4));
        return this;
    }

    public Cell<T> pad(Value value) {
        if (value != null) {
            this.padTop = value;
            this.padLeft = value;
            this.padBottom = value;
            this.padRight = value;
            return this;
        }
        throw new IllegalArgumentException("pad cannot be null.");
    }

    public Cell<T> pad(Value value, Value value2, Value value3, Value value4) {
        if (value != null) {
            if (value2 != null) {
                if (value3 != null) {
                    if (value4 != null) {
                        this.padTop = value;
                        this.padLeft = value2;
                        this.padBottom = value3;
                        this.padRight = value4;
                        return this;
                    }
                    throw new IllegalArgumentException("right cannot be null.");
                }
                throw new IllegalArgumentException("bottom cannot be null.");
            }
            throw new IllegalArgumentException("left cannot be null.");
        }
        throw new IllegalArgumentException("top cannot be null.");
    }

    public Cell<T> padBottom(float f) {
        this.padBottom = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> padBottom(Value value) {
        if (value != null) {
            this.padBottom = value;
            return this;
        }
        throw new IllegalArgumentException("padBottom cannot be null.");
    }

    public Cell<T> padLeft(float f) {
        this.padLeft = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> padLeft(Value value) {
        if (value != null) {
            this.padLeft = value;
            return this;
        }
        throw new IllegalArgumentException("padLeft cannot be null.");
    }

    public Cell<T> padRight(float f) {
        this.padRight = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> padRight(Value value) {
        if (value != null) {
            this.padRight = value;
            return this;
        }
        throw new IllegalArgumentException("padRight cannot be null.");
    }

    public Cell<T> padTop(float f) {
        this.padTop = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> padTop(Value value) {
        if (value != null) {
            this.padTop = value;
            return this;
        }
        throw new IllegalArgumentException("padTop cannot be null.");
    }

    public Cell<T> prefHeight(float f) {
        this.prefHeight = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> prefHeight(Value value) {
        if (value != null) {
            this.prefHeight = value;
            return this;
        }
        throw new IllegalArgumentException("prefHeight cannot be null.");
    }

    public Cell<T> prefSize(float f) {
        this.prefSize(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> prefSize(float f, float f2) {
        this.prefSize(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Cell<T> prefSize(Value value) {
        if (value != null) {
            this.prefWidth = value;
            this.prefHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Cell<T> prefSize(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.prefWidth = value;
                this.prefHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Cell<T> prefWidth(float f) {
        this.prefWidth = Value.Fixed.valueOf(f);
        return this;
    }

    public Cell<T> prefWidth(Value value) {
        if (value != null) {
            this.prefWidth = value;
            return this;
        }
        throw new IllegalArgumentException("prefWidth cannot be null.");
    }

    @Override
    public void reset() {
        this.actor = null;
        this.table = null;
        this.endRow = false;
        this.cellAboveIndex = -1;
        this.set(Cell.defaults());
    }

    public Cell<T> right() {
        Integer n = this.align;
        this.align = n == null ? righti : Integer.valueOf((n | 0x10) & 0xFFFFFFF7);
        return this;
    }

    public void row() {
        this.table.row();
    }

    void set(Cell cell) {
        this.minWidth = cell.minWidth;
        this.minHeight = cell.minHeight;
        this.prefWidth = cell.prefWidth;
        this.prefHeight = cell.prefHeight;
        this.maxWidth = cell.maxWidth;
        this.maxHeight = cell.maxHeight;
        this.spaceTop = cell.spaceTop;
        this.spaceLeft = cell.spaceLeft;
        this.spaceBottom = cell.spaceBottom;
        this.spaceRight = cell.spaceRight;
        this.padTop = cell.padTop;
        this.padLeft = cell.padLeft;
        this.padBottom = cell.padBottom;
        this.padRight = cell.padRight;
        this.fillX = cell.fillX;
        this.fillY = cell.fillY;
        this.align = cell.align;
        this.expandX = cell.expandX;
        this.expandY = cell.expandY;
        this.colspan = cell.colspan;
        this.uniformX = cell.uniformX;
        this.uniformY = cell.uniformY;
    }

    public <A extends Actor> Cell<A> setActor(A a2) {
        Actor actor = this.actor;
        if (actor != a2) {
            if (actor != null && actor.getParent() == this.table) {
                this.actor.remove();
            }
            this.actor = a2;
            if (a2 != null) {
                this.table.addActor(a2);
            }
        }
        return this;
    }

    public void setActorBounds(float f, float f2, float f3, float f4) {
        this.actorX = f;
        this.actorY = f2;
        this.actorWidth = f3;
        this.actorHeight = f4;
    }

    public void setActorHeight(float f) {
        this.actorHeight = f;
    }

    public void setActorWidth(float f) {
        this.actorWidth = f;
    }

    public void setActorX(float f) {
        this.actorX = f;
    }

    public void setActorY(float f) {
        this.actorY = f;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Cell<T> size(float f) {
        this.size(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> size(float f, float f2) {
        this.size(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Cell<T> size(Value value) {
        if (value != null) {
            this.minWidth = value;
            this.minHeight = value;
            this.prefWidth = value;
            this.prefHeight = value;
            this.maxWidth = value;
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Cell<T> size(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.minWidth = value;
                this.minHeight = value2;
                this.prefWidth = value;
                this.prefHeight = value2;
                this.maxWidth = value;
                this.maxHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Cell<T> space(float f) {
        if (!(f < 0.0f)) {
            this.space(Value.Fixed.valueOf(f));
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("space cannot be < 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Cell<T> space(float f, float f2, float f3, float f4) {
        if (!(f < 0.0f)) {
            if (!(f2 < 0.0f)) {
                if (!(f3 < 0.0f)) {
                    if (!(f4 < 0.0f)) {
                        this.space(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2), Value.Fixed.valueOf(f3), Value.Fixed.valueOf(f4));
                        return this;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("right cannot be < 0: ");
                    stringBuilder.append(f4);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("bottom cannot be < 0: ");
                stringBuilder.append(f3);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("left cannot be < 0: ");
            stringBuilder.append(f2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("top cannot be < 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Cell<T> space(Value value) {
        if (value != null) {
            this.spaceTop = value;
            this.spaceLeft = value;
            this.spaceBottom = value;
            this.spaceRight = value;
            return this;
        }
        throw new IllegalArgumentException("space cannot be null.");
    }

    public Cell<T> space(Value value, Value value2, Value value3, Value value4) {
        if (value != null) {
            if (value2 != null) {
                if (value3 != null) {
                    if (value4 != null) {
                        this.spaceTop = value;
                        this.spaceLeft = value2;
                        this.spaceBottom = value3;
                        this.spaceRight = value4;
                        return this;
                    }
                    throw new IllegalArgumentException("right cannot be null.");
                }
                throw new IllegalArgumentException("bottom cannot be null.");
            }
            throw new IllegalArgumentException("left cannot be null.");
        }
        throw new IllegalArgumentException("top cannot be null.");
    }

    public Cell<T> spaceBottom(float f) {
        if (!(f < 0.0f)) {
            this.spaceBottom = Value.Fixed.valueOf(f);
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spaceBottom cannot be < 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Cell<T> spaceBottom(Value value) {
        if (value != null) {
            this.spaceBottom = value;
            return this;
        }
        throw new IllegalArgumentException("spaceBottom cannot be null.");
    }

    public Cell<T> spaceLeft(float f) {
        if (!(f < 0.0f)) {
            this.spaceLeft = Value.Fixed.valueOf(f);
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spaceLeft cannot be < 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Cell<T> spaceLeft(Value value) {
        if (value != null) {
            this.spaceLeft = value;
            return this;
        }
        throw new IllegalArgumentException("spaceLeft cannot be null.");
    }

    public Cell<T> spaceRight(float f) {
        if (!(f < 0.0f)) {
            this.spaceRight = Value.Fixed.valueOf(f);
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spaceRight cannot be < 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Cell<T> spaceRight(Value value) {
        if (value != null) {
            this.spaceRight = value;
            return this;
        }
        throw new IllegalArgumentException("spaceRight cannot be null.");
    }

    public Cell<T> spaceTop(float f) {
        if (!(f < 0.0f)) {
            this.spaceTop = Value.Fixed.valueOf(f);
            return this;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spaceTop cannot be < 0: ");
        stringBuilder.append(f);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Cell<T> spaceTop(Value value) {
        if (value != null) {
            this.spaceTop = value;
            return this;
        }
        throw new IllegalArgumentException("spaceTop cannot be null.");
    }

    public String toString() {
        Object object = this.actor;
        object = object != null ? ((Actor)object).toString() : super.toString();
        return object;
    }

    public Cell<T> top() {
        Integer n = this.align;
        this.align = n == null ? topi : Integer.valueOf((n | 2) & 0xFFFFFFFB);
        return this;
    }

    public Cell<T> uniform() {
        this.uniformX = Boolean.TRUE;
        this.uniformY = Boolean.TRUE;
        return this;
    }

    public Cell<T> uniform(boolean bl) {
        this.uniformX = bl;
        this.uniformY = bl;
        return this;
    }

    public Cell<T> uniform(boolean bl, boolean bl2) {
        this.uniformX = bl;
        this.uniformY = bl2;
        return this;
    }

    public Cell<T> uniformX() {
        this.uniformX = Boolean.TRUE;
        return this;
    }

    public Cell<T> uniformY() {
        this.uniformY = Boolean.TRUE;
        return this;
    }

    public Cell<T> width(float f) {
        this.width(Value.Fixed.valueOf(f));
        return this;
    }

    public Cell<T> width(Value value) {
        if (value != null) {
            this.minWidth = value;
            this.prefWidth = value;
            this.maxWidth = value;
            return this;
        }
        throw new IllegalArgumentException("width cannot be null.");
    }
}

