/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.actions;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;

public class IntAction
extends TemporalAction {
    private int end;
    private int start;
    private int value;

    public IntAction() {
        this.start = 0;
        this.end = 1;
    }

    public IntAction(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    public IntAction(int n, int n2, float f) {
        super(f);
        this.start = n;
        this.end = n2;
    }

    public IntAction(int n, int n2, float f, Interpolation interpolation) {
        super(f, interpolation);
        this.start = n;
        this.end = n2;
    }

    @Override
    protected void begin() {
        this.value = this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getValue() {
        return this.value;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    protected void update(float f) {
        if (f == 0.0f) {
            this.value = this.start;
        } else if (f == 1.0f) {
            this.value = this.end;
        } else {
            int n = this.start;
            this.value = (int)((float)n + (float)(this.end - n) * f);
        }
    }
}

