/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.reflect.ClassReflection;

public class Actor {
    private final Array<Action> actions;
    private final DelayedRemovalArray<EventListener> captureListeners;
    final Color color;
    private boolean debug;
    float height;
    private final DelayedRemovalArray<EventListener> listeners = new DelayedRemovalArray(0);
    private String name;
    float originX;
    float originY;
    Group parent;
    float rotation;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    private Stage stage;
    private Touchable touchable;
    private Object userObject;
    private boolean visible = true;
    float width;
    float x;
    float y;

    public Actor() {
        this.captureListeners = new DelayedRemovalArray(0);
        this.actions = new Array(0);
        this.touchable = Touchable.enabled;
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void act(float f) {
        Array<Action> array = this.actions;
        if (array.size == 0) {
            return;
        }
        Object object = this.stage;
        if (object != null && ((Stage)object).getActionsRequestRendering()) {
            Gdx.graphics.requestRendering();
        }
        int n = 0;
        try {
            while (n < array.size) {
                object = array.get(n);
                int n2 = n;
                if (((Action)object).act(f)) {
                    n2 = n;
                    if (n < array.size) {
                        int n3 = array.get(n) == object ? n : array.indexOf((Action)object, true);
                        n2 = n;
                        if (n3 != -1) {
                            array.removeIndex(n3);
                            ((Action)object).setActor(null);
                            n2 = n - 1;
                        }
                    }
                }
                n = n2 + 1;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = this.toString();
            object = new StringBuilder();
            ((StringBuilder)object).append("Actor: ");
            ((StringBuilder)object).append(string2.substring(0, Math.min(string2.length(), 128)));
            RuntimeException runtimeException2 = new RuntimeException(((StringBuilder)object).toString(), runtimeException);
            throw runtimeException2;
        }
    }

    public void addAction(Action object) {
        ((Action)object).setActor(this);
        this.actions.add((Action)object);
        object = this.stage;
        if (object != null && ((Stage)object).getActionsRequestRendering()) {
            Gdx.graphics.requestRendering();
        }
    }

    public boolean addCaptureListener(EventListener eventListener) {
        if (eventListener != null) {
            if (!this.captureListeners.contains(eventListener, true)) {
                this.captureListeners.add(eventListener);
            }
            return true;
        }
        throw new IllegalArgumentException("listener cannot be null.");
    }

    public boolean addListener(EventListener eventListener) {
        if (eventListener != null) {
            if (!this.listeners.contains(eventListener, true)) {
                this.listeners.add(eventListener);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("listener cannot be null.");
    }

    public boolean ancestorsVisible() {
        Group group;
        Actor actor = this;
        do {
            if (!actor.isVisible()) {
                return false;
            }
            group = actor.parent;
            actor = group;
        } while (group != null);
        return true;
    }

    public void clear() {
        this.clearActions();
        this.clearListeners();
    }

    public void clearActions() {
        for (int i = this.actions.size - 1; i >= 0; --i) {
            this.actions.get(i).setActor(null);
        }
        this.actions.clear();
    }

    public void clearListeners() {
        this.listeners.clear();
        this.captureListeners.clear();
    }

    public boolean clipBegin() {
        return this.clipBegin(this.x, this.y, this.width, this.height);
    }

    public boolean clipBegin(float f, float f2, float f3, float f4) {
        if (!(f3 <= 0.0f) && !(f4 <= 0.0f)) {
            Stage stage = this.stage;
            if (stage == null) {
                return false;
            }
            Rectangle rectangle = Rectangle.tmp;
            rectangle.x = f;
            rectangle.y = f2;
            rectangle.width = f3;
            rectangle.height = f4;
            Rectangle rectangle2 = Pools.obtain(Rectangle.class);
            stage.calculateScissors(rectangle, rectangle2);
            if (ScissorStack.pushScissors(rectangle2)) {
                return true;
            }
            Pools.free(rectangle2);
        }
        return false;
    }

    public void clipEnd() {
        Pools.free(ScissorStack.popScissors());
    }

    public Actor debug() {
        this.setDebug(true);
        return this;
    }

    public void draw(Batch batch, float f) {
    }

    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.drawDebugBounds(shapeRenderer);
    }

    protected void drawDebugBounds(ShapeRenderer shapeRenderer) {
        if (!this.debug) {
            return;
        }
        shapeRenderer.set(ShapeRenderer.ShapeType.Line);
        Stage stage = this.stage;
        if (stage != null) {
            shapeRenderer.setColor(stage.getDebugColor());
        }
        shapeRenderer.rect(this.x, this.y, this.originX, this.originY, this.width, this.height, this.scaleX, this.scaleY, this.rotation);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fire(Event event) {
        void var3_5;
        if (event.getStage() == null) {
            event.setStage(this.getStage());
        }
        event.setTarget(this);
        Array array = Pools.obtain(Array.class);
        Group group = this.parent;
        while (var3_5 != null) {
            array.add(var3_5);
            Group group2 = var3_5.parent;
        }
        try {
            int n;
            boolean bl;
            int n2;
            T[] TArray = array.items;
            for (n2 = array.size - 1; n2 >= 0; --n2) {
                ((Group)TArray[n2]).notify(event, true);
                if (!event.isStopped()) continue;
                bl = event.isCancelled();
                return bl;
            }
            this.notify(event, true);
            if (event.isStopped()) {
                bl = event.isCancelled();
                return bl;
            }
            this.notify(event, false);
            if (!event.getBubbles()) {
                bl = event.isCancelled();
                return bl;
            }
            if (!event.isStopped()) {
                n = array.size;
            } else {
                bl = event.isCancelled();
                return bl;
            }
            for (n2 = 0; n2 < n; ++n2) {
                ((Group)TArray[n2]).notify(event, false);
                if (!event.isStopped()) continue;
                bl = event.isCancelled();
                return bl;
            }
            bl = event.isCancelled();
            return bl;
        }
        finally {
            array.clear();
            Pools.free(array);
        }
    }

    public <T extends Actor> T firstAscendant(Class<T> serializable) {
        if (serializable != null) {
            Group group;
            Actor actor = this;
            do {
                if (ClassReflection.isInstance(serializable, actor)) {
                    return (T)actor;
                }
                group = actor.parent;
                actor = group;
            } while (group != null);
            return null;
        }
        serializable = new IllegalArgumentException("actor cannot be null.");
        throw serializable;
    }

    public Array<Action> getActions() {
        return this.actions;
    }

    public DelayedRemovalArray<EventListener> getCaptureListeners() {
        return this.captureListeners;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public float getHeight() {
        return this.height;
    }

    public DelayedRemovalArray<EventListener> getListeners() {
        return this.listeners;
    }

    public String getName() {
        return this.name;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public Group getParent() {
        return this.parent;
    }

    public float getRight() {
        return this.x + this.width;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public Stage getStage() {
        return this.stage;
    }

    public float getTop() {
        return this.y + this.height;
    }

    public Touchable getTouchable() {
        return this.touchable;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getX(int n) {
        float f;
        float f2 = this.x;
        if ((n & 0x10) != 0) {
            f = this.width;
            return f2 + f;
        }
        f = f2;
        if ((n & 8) != 0) return f;
        f = this.width / 2.0f;
        return f2 + f;
    }

    public float getY() {
        return this.y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getY(int n) {
        float f;
        float f2 = this.y;
        if ((n & 2) != 0) {
            f = this.height;
            return f2 + f;
        }
        f = f2;
        if ((n & 4) != 0) return f;
        f = this.height / 2.0f;
        return f2 + f;
    }

    public int getZIndex() {
        Group group = this.parent;
        if (group == null) {
            return -1;
        }
        return group.children.indexOf(this, true);
    }

    public boolean hasActions() {
        boolean bl = this.actions.size > 0;
        return bl;
    }

    public boolean hasKeyboardFocus() {
        Stage stage = this.getStage();
        boolean bl = stage != null && stage.getKeyboardFocus() == this;
        return bl;
    }

    public boolean hasParent() {
        boolean bl = this.parent != null;
        return bl;
    }

    public boolean hasScrollFocus() {
        Stage stage = this.getStage();
        boolean bl = stage != null && stage.getScrollFocus() == this;
        return bl;
    }

    public Actor hit(float f, float f2, boolean bl) {
        Actor actor = null;
        if (bl && this.touchable != Touchable.enabled) {
            return null;
        }
        if (!this.isVisible()) {
            return null;
        }
        Actor actor2 = actor;
        if (f >= 0.0f) {
            actor2 = actor;
            if (f < this.width) {
                actor2 = actor;
                if (f2 >= 0.0f) {
                    actor2 = actor;
                    if (f2 < this.height) {
                        actor2 = this;
                    }
                }
            }
        }
        return actor2;
    }

    public boolean isAscendantOf(Actor object) {
        if (object != null) {
            Group group;
            do {
                if (object == this) {
                    return true;
                }
                group = ((Actor)object).parent;
                object = group;
            } while (group != null);
            return false;
        }
        object = new IllegalArgumentException("actor cannot be null.");
        throw object;
    }

    public boolean isDescendantOf(Actor object) {
        if (object != null) {
            Group group;
            Actor actor = this;
            do {
                if (actor == object) {
                    return true;
                }
                group = actor.parent;
                actor = group;
            } while (group != null);
            return false;
        }
        object = new IllegalArgumentException("actor cannot be null.");
        throw object;
    }

    public boolean isTouchFocusListener() {
        Stage stage = this.getStage();
        if (stage == null) {
            return false;
        }
        int n = stage.touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            if (((Stage.TouchFocus)stage.touchFocuses.get((int)i)).listenerActor != this) continue;
            return true;
        }
        return false;
    }

    public boolean isTouchFocusTarget() {
        Stage stage = this.getStage();
        if (stage == null) {
            return false;
        }
        int n = stage.touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            if (((Stage.TouchFocus)stage.touchFocuses.get((int)i)).target != this) continue;
            return true;
        }
        return false;
    }

    public boolean isTouchable() {
        boolean bl = this.touchable == Touchable.enabled;
        return bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Vector2 localToActorCoordinates(Actor actor, Vector2 vector2) {
        this.localToStageCoordinates(vector2);
        return actor.stageToLocalCoordinates(vector2);
    }

    public Vector2 localToAscendantCoordinates(Actor actor, Vector2 vector2) {
        Group group;
        Actor actor2 = this;
        do {
            actor2.localToParentCoordinates(vector2);
            group = actor2.parent;
            if (group == actor) break;
            actor2 = group;
        } while (group != null);
        return vector2;
    }

    public Vector2 localToParentCoordinates(Vector2 vector2) {
        float f = -this.rotation;
        float f2 = this.scaleX;
        float f3 = this.scaleY;
        float f4 = this.x;
        float f5 = this.y;
        if (f == 0.0f) {
            if (f2 == 1.0f && f3 == 1.0f) {
                vector2.x += f4;
                vector2.y += f5;
            } else {
                float f6 = this.originX;
                f = this.originY;
                vector2.x = (vector2.x - f6) * f2 + f6 + f4;
                vector2.y = (vector2.y - f) * f3 + f + f5;
            }
        } else {
            double d = f * ((float)Math.PI / 180);
            f = (float)Math.cos(d);
            float f7 = (float)Math.sin(d);
            float f8 = this.originX;
            float f9 = this.originY;
            f2 = (vector2.x - f8) * f2;
            f3 = (vector2.y - f9) * f3;
            vector2.x = f2 * f + f3 * f7 + f8 + f4;
            vector2.y = f2 * -f7 + f3 * f + f9 + f5;
        }
        return vector2;
    }

    public Vector2 localToScreenCoordinates(Vector2 vector2) {
        Stage stage = this.stage;
        if (stage == null) {
            return vector2;
        }
        return stage.stageToScreenCoordinates(this.localToAscendantCoordinates(null, vector2));
    }

    public Vector2 localToStageCoordinates(Vector2 vector2) {
        return this.localToAscendantCoordinates(null, vector2);
    }

    public void moveBy(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            this.x += f;
            this.y += f2;
            this.positionChanged();
        }
    }

    public boolean notify(Event object, boolean bl) {
        if (((Event)object).getTarget() != null) {
            Object object2;
            DelayedRemovalArray<EventListener> delayedRemovalArray = bl ? this.captureListeners : this.listeners;
            if (delayedRemovalArray.size == 0) {
                return ((Event)object).isCancelled();
            }
            ((Event)object).setListenerActor(this);
            ((Event)object).setCapture(bl);
            if (((Event)object).getStage() == null) {
                ((Event)object).setStage(this.stage);
            }
            delayedRemovalArray.begin();
            int n = delayedRemovalArray.size;
            for (int i = 0; i < n; ++i) {
                InputEvent inputEvent;
                object2 = (EventListener)delayedRemovalArray.get(i);
                if (!object2.handle((Event)object)) continue;
                ((Event)object).handle();
                if (!(object instanceof InputEvent) || (inputEvent = (InputEvent)object).getType() != InputEvent.Type.touchDown) continue;
                ((Event)object).getStage().addTouchFocus((EventListener)object2, this, inputEvent.getTarget(), inputEvent.getPointer(), inputEvent.getButton());
                continue;
            }
            try {
                delayedRemovalArray.end();
            }
            catch (RuntimeException runtimeException) {
                object2 = this.toString();
                object = new StringBuilder();
                ((StringBuilder)object).append("Actor: ");
                ((StringBuilder)object).append(((String)object2).substring(0, Math.min(((String)object2).length(), 128)));
                throw new RuntimeException(((StringBuilder)object).toString(), runtimeException);
            }
            return ((Event)object).isCancelled();
        }
        object = new IllegalArgumentException("The event target cannot be null.");
        throw object;
    }

    public Vector2 parentToLocalCoordinates(Vector2 vector2) {
        float f = this.rotation;
        float f2 = this.scaleX;
        float f3 = this.scaleY;
        float f4 = this.x;
        float f5 = this.y;
        if (f == 0.0f) {
            if (f2 == 1.0f && f3 == 1.0f) {
                vector2.x -= f4;
                vector2.y -= f5;
            } else {
                float f6 = this.originX;
                f = this.originY;
                vector2.x = (vector2.x - f4 - f6) / f2 + f6;
                vector2.y = (vector2.y - f5 - f) / f3 + f;
            }
        } else {
            double d = f * ((float)Math.PI / 180);
            float f7 = (float)Math.cos(d);
            float f8 = (float)Math.sin(d);
            float f9 = this.originX;
            f = this.originY;
            f4 = vector2.x - f4 - f9;
            f5 = vector2.y - f5 - f;
            vector2.x = (f4 * f7 + f5 * f8) / f2 + f9;
            vector2.y = (f4 * -f8 + f5 * f7) / f3 + f;
        }
        return vector2;
    }

    protected void positionChanged() {
    }

    public boolean remove() {
        Group group = this.parent;
        if (group != null) {
            return group.removeActor(this, true);
        }
        return false;
    }

    public void removeAction(Action action) {
        if (this.actions.removeValue(action, true)) {
            action.setActor(null);
        }
    }

    public boolean removeCaptureListener(EventListener eventListener) {
        if (eventListener != null) {
            return this.captureListeners.removeValue(eventListener, true);
        }
        throw new IllegalArgumentException("listener cannot be null.");
    }

    public boolean removeListener(EventListener eventListener) {
        if (eventListener != null) {
            return this.listeners.removeValue(eventListener, true);
        }
        throw new IllegalArgumentException("listener cannot be null.");
    }

    public void rotateBy(float f) {
        if (f != 0.0f) {
            this.rotation = (this.rotation + f) % 360.0f;
            this.rotationChanged();
        }
    }

    protected void rotationChanged() {
    }

    public void scaleBy(float f) {
        this.scaleX += f;
        this.scaleY += f;
    }

    public void scaleBy(float f, float f2) {
        this.scaleX += f;
        this.scaleY += f2;
    }

    public Vector2 screenToLocalCoordinates(Vector2 vector2) {
        Stage stage = this.stage;
        if (stage == null) {
            return vector2;
        }
        return this.stageToLocalCoordinates(stage.screenToStageCoordinates(vector2));
    }

    public void setBounds(float f, float f2, float f3, float f4) {
        if (this.x != f || this.y != f2) {
            this.x = f;
            this.y = f2;
            this.positionChanged();
        }
        if (this.width != f3 || this.height != f4) {
            this.width = f3;
            this.height = f4;
            this.sizeChanged();
        }
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
    }

    public void setColor(Color color2) {
        this.color.set(color2);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (bl) {
            Stage.debug = true;
        }
    }

    public void setHeight(float f) {
        if (this.height != f) {
            this.height = f;
            this.sizeChanged();
        }
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setOrigin(float f, float f2) {
        this.originX = f;
        this.originY = f2;
    }

    public void setOrigin(int n) {
        this.originX = (n & 8) != 0 ? 0.0f : ((n & 0x10) != 0 ? this.width : this.width / 2.0f);
        this.originY = (n & 4) != 0 ? 0.0f : ((n & 2) != 0 ? this.height : this.height / 2.0f);
    }

    public void setOriginX(float f) {
        this.originX = f;
    }

    public void setOriginY(float f) {
        this.originY = f;
    }

    protected void setParent(Group group) {
        this.parent = group;
    }

    public void setPosition(float f, float f2) {
        if (this.x != f || this.y != f2) {
            this.x = f;
            this.y = f2;
            this.positionChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPosition(float f, float f2, int n) {
        float f3;
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                if ((n & 0x10) == 0) break block7;
                                f3 = this.width;
                                break block8;
                            }
                            f3 = f;
                            if ((n & 8) != 0) break block9;
                            f3 = this.width / 2.0f;
                        }
                        f3 = f - f3;
                    }
                    if ((n & 2) == 0) break block10;
                    f = this.height;
                    break block11;
                }
                f = f2;
                if ((n & 4) != 0) break block12;
                f = this.height / 2.0f;
            }
            f = f2 - f;
        }
        if (this.x != f3 || this.y != f) {
            this.x = f3;
            this.y = f;
            this.positionChanged();
        }
    }

    public void setRotation(float f) {
        if (this.rotation != f) {
            this.rotation = f;
            this.rotationChanged();
        }
    }

    public void setScale(float f) {
        this.scaleX = f;
        this.scaleY = f;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public void setSize(float f, float f2) {
        if (this.width != f || this.height != f2) {
            this.width = f;
            this.height = f2;
            this.sizeChanged();
        }
    }

    protected void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setTouchable(Touchable touchable) {
        this.touchable = touchable;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setWidth(float f) {
        if (this.width != f) {
            this.width = f;
            this.sizeChanged();
        }
    }

    public void setX(float f) {
        if (this.x != f) {
            this.x = f;
            this.positionChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setX(float f, int n) {
        float f2;
        block6: {
            block5: {
                block4: {
                    if ((n & 0x10) == 0) break block4;
                    f2 = this.width;
                    break block5;
                }
                f2 = f;
                if ((n & 8) != 0) break block6;
                f2 = this.width / 2.0f;
            }
            f2 = f - f2;
        }
        if (this.x != f2) {
            this.x = f2;
            this.positionChanged();
        }
    }

    public void setY(float f) {
        if (this.y != f) {
            this.y = f;
            this.positionChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setY(float f, int n) {
        float f2;
        block6: {
            block5: {
                block4: {
                    if ((n & 2) == 0) break block4;
                    f2 = this.height;
                    break block5;
                }
                f2 = f;
                if ((n & 4) != 0) break block6;
                f2 = this.height / 2.0f;
            }
            f2 = f - f2;
        }
        if (this.y != f2) {
            this.y = f2;
            this.positionChanged();
        }
    }

    public boolean setZIndex(int n) {
        if (n >= 0) {
            Object object = this.parent;
            if (object == null) {
                return false;
            }
            object = ((Group)object).children;
            if (((Array)object).size == 1) {
                return false;
            }
            if (((Array)object).get(n = Math.min(n, ((Array)object).size - 1)) == this) {
                return false;
            }
            if (!((Array)object).removeValue(this, true)) {
                return false;
            }
            ((Array)object).insert(n, this);
            return true;
        }
        throw new IllegalArgumentException("ZIndex cannot be < 0.");
    }

    public void sizeBy(float f) {
        if (f != 0.0f) {
            this.width += f;
            this.height += f;
            this.sizeChanged();
        }
    }

    public void sizeBy(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            this.width += f;
            this.height += f2;
            this.sizeChanged();
        }
    }

    protected void sizeChanged() {
    }

    public Vector2 stageToLocalCoordinates(Vector2 vector2) {
        Group group = this.parent;
        if (group != null) {
            group.stageToLocalCoordinates(vector2);
        }
        this.parentToLocalCoordinates(vector2);
        return vector2;
    }

    public void toBack() {
        this.setZIndex(0);
    }

    public void toFront() {
        this.setZIndex(Integer.MAX_VALUE);
    }

    public String toString() {
        String string2;
        String string3 = string2 = this.name;
        if (string2 == null) {
            string2 = this.getClass().getName();
            int n = string2.lastIndexOf(46);
            string3 = string2;
            if (n != -1) {
                string3 = string2.substring(n + 1);
            }
        }
        return string3;
    }
}

