/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.net;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NetJavaImpl {
    final ObjectMap<Net.HttpRequest, HttpURLConnection> connections;
    private final ExecutorService executorService;
    final ObjectMap<Net.HttpRequest, Net.HttpResponseListener> listeners;

    public NetJavaImpl() {
        this(Integer.MAX_VALUE);
    }

    public NetJavaImpl(int n) {
        this.executorService = new ThreadPoolExecutor(0, n, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, "NetThread");
                ((Thread)runnable).setDaemon(true);
                return runnable;
            }
        });
        this.connections = new ObjectMap();
        this.listeners = new ObjectMap();
    }

    public void cancelHttpRequest(Net.HttpRequest httpRequest) {
        Net.HttpResponseListener httpResponseListener = this.getFromListeners(httpRequest);
        if (httpResponseListener != null) {
            httpResponseListener.cancelled();
            this.removeFromConnectionsAndListeners(httpRequest);
        }
    }

    Net.HttpResponseListener getFromListeners(Net.HttpRequest object) {
        synchronized (this) {
            object = this.listeners.get((Net.HttpRequest)object);
            return object;
        }
    }

    void putIntoConnectionsAndListeners(Net.HttpRequest httpRequest, Net.HttpResponseListener httpResponseListener, HttpURLConnection httpURLConnection) {
        synchronized (this) {
            this.connections.put(httpRequest, httpURLConnection);
            this.listeners.put(httpRequest, httpResponseListener);
            return;
        }
    }

    void removeFromConnectionsAndListeners(Net.HttpRequest httpRequest) {
        synchronized (this) {
            this.connections.remove(httpRequest);
            this.listeners.remove(httpRequest);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendHttpRequest(final Net.HttpRequest httpRequest, Net.HttpResponseListener httpResponseListener) {
        if (httpRequest.getUrl() == null) {
            httpResponseListener.failed(new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        try {
            Object object;
            Runnable runnable = httpRequest.getMethod();
            if (((String)((Object)runnable)).equalsIgnoreCase("GET")) {
                CharSequence charSequence = httpRequest.getContent();
                String string2 = "";
                object = string2;
                if (charSequence != null) {
                    object = string2;
                    if (!"".equals(charSequence)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("?");
                        ((StringBuilder)object).append((String)charSequence);
                        object = ((StringBuilder)object).toString();
                    }
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(httpRequest.getUrl());
                ((StringBuilder)charSequence).append((String)object);
                URL uRL = new URL(((StringBuilder)charSequence).toString());
                object = uRL;
            } else {
                object = new URL(httpRequest.getUrl());
            }
            object = (HttpURLConnection)((URL)object).openConnection();
            final boolean bl = ((String)((Object)runnable)).equalsIgnoreCase("POST") || ((String)((Object)runnable)).equalsIgnoreCase("PUT") || ((String)((Object)runnable)).equalsIgnoreCase("PATCH");
            ((URLConnection)object).setDoOutput(bl);
            ((URLConnection)object).setDoInput(true);
            ((HttpURLConnection)object).setRequestMethod((String)((Object)runnable));
            HttpURLConnection.setFollowRedirects(httpRequest.getFollowRedirects());
            this.putIntoConnectionsAndListeners(httpRequest, httpResponseListener, (HttpURLConnection)object);
            runnable = httpRequest.getHeaders().entrySet().iterator();
            while (true) {
                if (!runnable.hasNext()) {
                    ((URLConnection)object).setConnectTimeout(httpRequest.getTimeOut());
                    ((URLConnection)object).setReadTimeout(httpRequest.getTimeOut());
                    ExecutorService executorService = this.executorService;
                    runnable = new Runnable((HttpURLConnection)object, httpResponseListener){
                        final /* synthetic */ HttpURLConnection val$connection;
                        final /* synthetic */ Net.HttpResponseListener val$httpResponseListener;
                        {
                            this.val$connection = httpURLConnection;
                            this.val$httpResponseListener = httpResponseListener;
                        }

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Unable to fully structure code
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            try {
                                if (!bl) ** GOTO lbl-1000
                                var1_1 = httpRequest.getContent();
                                if (var1_1 != null) {
                                    var2_4 = new OutputStreamWriter(this.val$connection.getOutputStream(), "UTF8");
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Exception var2_6) {
                                this.val$connection.disconnect();
                                try {
                                    this.val$httpResponseListener.failed(var2_6);
                                }
                                finally {
                                    NetJavaImpl.this.removeFromConnectionsAndListeners(httpRequest);
                                }
                            }
                            try {
                                var2_4.write((String)var1_1);
                                ** GOTO lbl-1000
                            }
                            finally {
                                StreamUtils.closeQuietly((Closeable)var2_4);
                            }
lbl-1000:
                            // 1 sources

                            {
                                var1_1 = httpRequest.getContentStream();
                                if (var1_1 == null) ** GOTO lbl-1000
                                var2_4 = this.val$connection.getOutputStream();
                            }
                            try {
                                StreamUtils.copyStream((InputStream)var1_1, (OutputStream)var2_4);
                            }
                            finally {
                                StreamUtils.closeQuietly((Closeable)var2_4);
                            }
lbl-1000:
                            // 4 sources

                            {
                                this.val$connection.connect();
                                var2_4 = new HttpClientResponse(this.val$connection);
                            }
                            try {
                                var1_1 = NetJavaImpl.this.getFromListeners(httpRequest);
                                if (var1_1 != null) {
                                    var1_1.handleHttpResponse((Net.HttpResponse)var2_4);
                                }
                                NetJavaImpl.this.removeFromConnectionsAndListeners(httpRequest);
                                return;
                            }
                            finally {
                                this.val$connection.disconnect();
                            }
                        }
                    };
                    executorService.submit(runnable);
                    return;
                }
                Map.Entry entry = (Map.Entry)runnable.next();
                ((URLConnection)object).addRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception exception) {
            try {
                httpResponseListener.failed(exception);
                this.removeFromConnectionsAndListeners(httpRequest);
                return;
            }
            catch (Throwable throwable) {
                this.removeFromConnectionsAndListeners(httpRequest);
                throw throwable;
            }
        }
    }

    static class HttpClientResponse
    implements Net.HttpResponse {
        private final HttpURLConnection connection;
        private HttpStatus status;

        public HttpClientResponse(HttpURLConnection httpURLConnection) throws IOException {
            this.connection = httpURLConnection;
            try {
                HttpStatus httpStatus;
                this.status = httpStatus = new HttpStatus(httpURLConnection.getResponseCode());
            }
            catch (IOException iOException) {
                this.status = new HttpStatus(-1);
            }
        }

        private InputStream getInputStream() {
            try {
                InputStream inputStream = this.connection.getInputStream();
                return inputStream;
            }
            catch (IOException iOException) {
                return this.connection.getErrorStream();
            }
        }

        @Override
        public String getHeader(String string2) {
            return this.connection.getHeaderField(string2);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.connection.getHeaderFields();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] getResult() {
            Throwable throwable2222222;
            InputStream inputStream;
            block5: {
                inputStream = this.getInputStream();
                if (inputStream == null) {
                    return StreamUtils.EMPTY_BYTES;
                }
                byte[] byArray = StreamUtils.copyStreamToByteArray(inputStream, this.connection.getContentLength());
                {
                    byte[] byArray2;
                    catch (Throwable throwable2222222) {
                        break block5;
                    }
                    catch (IOException iOException) {}
                    {
                        byArray2 = StreamUtils.EMPTY_BYTES;
                    }
                    StreamUtils.closeQuietly(inputStream);
                    return byArray2;
                }
                StreamUtils.closeQuietly(inputStream);
                return byArray;
            }
            StreamUtils.closeQuietly(inputStream);
            throw throwable2222222;
        }

        @Override
        public InputStream getResultAsStream() {
            return this.getInputStream();
        }

        @Override
        public String getResultAsString() {
            String string2;
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                return "";
            }
            try {
                string2 = StreamUtils.copyStreamToString(inputStream, this.connection.getContentLength(), "UTF8");
            }
            catch (Throwable throwable) {
            }
            catch (IOException iOException) {
                StreamUtils.closeQuietly(inputStream);
                return "";
            }
            StreamUtils.closeQuietly(inputStream);
            return string2;
            StreamUtils.closeQuietly(inputStream);
            throw throwable;
        }

        @Override
        public HttpStatus getStatus() {
            return this.status;
        }
    }
}

