/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;

public class Polyline
implements Shape2D {
    private boolean calculateLength = true;
    private boolean calculateScaledLength = true;
    private boolean dirty = true;
    private float length;
    private float[] localVertices;
    private float originX;
    private float originY;
    private float rotation;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaledLength;
    private float[] worldVertices;
    private float x;
    private float y;

    public Polyline() {
        this.localVertices = new float[0];
    }

    public Polyline(float[] fArray) {
        if (fArray.length >= 4) {
            this.localVertices = fArray;
            return;
        }
        throw new IllegalArgumentException("polylines must contain at least 2 points.");
    }

    public void calculateLength() {
        this.calculateLength = true;
    }

    public void calculateScaledLength() {
        this.calculateScaledLength = true;
    }

    @Override
    public boolean contains(float f, float f2) {
        return false;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return false;
    }

    public void dirty() {
        this.dirty = true;
    }

    public float getLength() {
        if (!this.calculateLength) {
            return this.length;
        }
        int n = 0;
        this.calculateLength = false;
        this.length = 0.0f;
        int n2 = this.localVertices.length;
        while (n < n2 - 2) {
            float[] fArray = this.localVertices;
            int n3 = n + 2;
            float f = fArray[n3] - fArray[n];
            float f2 = fArray[n + 1] - fArray[n + 3];
            this.length += (float)Math.sqrt(f * f + f2 * f2);
            n = n3;
        }
        return this.length;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaledLength() {
        if (!this.calculateScaledLength) {
            return this.scaledLength;
        }
        int n = 0;
        this.calculateScaledLength = false;
        this.scaledLength = 0.0f;
        int n2 = this.localVertices.length;
        while (n < n2 - 2) {
            float[] fArray = this.localVertices;
            int n3 = n + 2;
            float f = fArray[n3];
            float f2 = this.scaleX;
            f2 = f * f2 - fArray[n] * f2;
            float f3 = fArray[n + 1];
            f = this.scaleY;
            f = f3 * f - fArray[n + 3] * f;
            this.scaledLength += (float)Math.sqrt(f2 * f2 + f * f);
            n = n3;
        }
        return this.scaledLength;
    }

    public float[] getTransformedVertices() {
        if (!this.dirty) {
            return this.worldVertices;
        }
        int n = 0;
        this.dirty = false;
        float[] fArray = this.localVertices;
        float[] fArray2 = this.worldVertices;
        if (fArray2 == null || fArray2.length < fArray.length) {
            this.worldVertices = new float[fArray.length];
        }
        fArray2 = this.worldVertices;
        float f = this.x;
        float f2 = this.y;
        float f3 = this.originX;
        float f4 = this.originY;
        float f5 = this.scaleX;
        float f6 = this.scaleY;
        boolean bl = f5 != 1.0f || f6 != 1.0f;
        float f7 = this.rotation;
        float f8 = MathUtils.cosDeg(f7);
        float f9 = MathUtils.sinDeg(f7);
        int n2 = fArray.length;
        while (n < n2) {
            float f10 = fArray[n] - f3;
            int n3 = n + 1;
            float f11 = fArray[n3] - f4;
            float f12 = f10;
            float f13 = f11;
            if (bl) {
                f12 = f10 * f5;
                f13 = f11 * f6;
            }
            f10 = f12;
            f11 = f13;
            if (f7 != 0.0f) {
                f11 = f12 * f9 + f13 * f8;
                f10 = f8 * f12 - f9 * f13;
            }
            fArray2[n] = f10 + f + f3;
            fArray2[n3] = f2 + f11 + f4;
            n += 2;
        }
        return fArray2;
    }

    public float[] getVertices() {
        return this.localVertices;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void rotate(float f) {
        this.rotation += f;
        this.dirty = true;
    }

    public void scale(float f) {
        this.scaleX += f;
        this.scaleY += f;
        this.dirty = true;
        this.calculateScaledLength = true;
    }

    public void setOrigin(float f, float f2) {
        this.originX = f;
        this.originY = f2;
        this.dirty = true;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.dirty = true;
    }

    public void setRotation(float f) {
        this.rotation = f;
        this.dirty = true;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
        this.dirty = true;
        this.calculateScaledLength = true;
    }

    public void setVertices(float[] fArray) {
        if (fArray.length >= 4) {
            this.localVertices = fArray;
            this.dirty = true;
            return;
        }
        throw new IllegalArgumentException("polylines must contain at least 2 points.");
    }

    public void translate(float f, float f2) {
        this.x += f;
        this.y += f2;
        this.dirty = true;
    }
}

