/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.Serializable;

public final class Affine2
implements Serializable {
    private static final long serialVersionUID = 1524569123485049187L;
    public float m00 = 1.0f;
    public float m01 = 0.0f;
    public float m02 = 0.0f;
    public float m10 = 0.0f;
    public float m11 = 1.0f;
    public float m12 = 0.0f;

    public Affine2() {
    }

    public Affine2(Affine2 affine2) {
        this.set(affine2);
    }

    public void applyTo(Vector2 vector2) {
        float f = vector2.x;
        float f2 = vector2.y;
        vector2.x = this.m00 * f + this.m01 * f2 + this.m02;
        vector2.y = this.m10 * f + this.m11 * f2 + this.m12;
    }

    public float det() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public Vector2 getTranslation(Vector2 vector2) {
        vector2.x = this.m02;
        vector2.y = this.m12;
        return vector2;
    }

    public Affine2 idt() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        return this;
    }

    public Affine2 inv() {
        float f = this.det();
        if (f != 0.0f) {
            float f2 = 1.0f / f;
            float f3 = this.m11;
            float f4 = this.m01;
            float f5 = -f4;
            float f6 = this.m12;
            float f7 = this.m02;
            float f8 = this.m10;
            float f9 = -f8;
            f = this.m00;
            this.m00 = f3 * f2;
            this.m01 = f5 * f2;
            this.m02 = (f4 * f6 - f3 * f7) * f2;
            this.m10 = f9 * f2;
            this.m11 = f * f2;
            this.m12 = f2 * (f8 * f7 - f6 * f);
            return this;
        }
        throw new GdxRuntimeException("Can't invert a singular affine matrix");
    }

    public boolean isIdt() {
        boolean bl = this.m00 == 1.0f && this.m02 == 0.0f && this.m12 == 0.0f && this.m11 == 1.0f && this.m01 == 0.0f && this.m10 == 0.0f;
        return bl;
    }

    public boolean isTranslation() {
        boolean bl = this.m00 == 1.0f && this.m11 == 1.0f && this.m01 == 0.0f && this.m10 == 0.0f;
        return bl;
    }

    public Affine2 mul(Affine2 affine2) {
        float f = this.m00;
        float f2 = affine2.m00;
        float f3 = this.m01;
        float f4 = affine2.m10;
        float f5 = affine2.m01;
        float f6 = affine2.m11;
        float f7 = affine2.m02;
        float f8 = affine2.m12;
        float f9 = this.m02;
        float f10 = this.m10;
        float f11 = this.m11;
        float f12 = this.m12;
        this.m00 = f * f2 + f3 * f4;
        this.m01 = f * f5 + f3 * f6;
        this.m02 = f * f7 + f3 * f8 + f9;
        this.m10 = f2 * f10 + f4 * f11;
        this.m11 = f5 * f10 + f6 * f11;
        this.m12 = f10 * f7 + f11 * f8 + f12;
        return this;
    }

    public Affine2 preMul(Affine2 affine2) {
        float f = affine2.m00;
        float f2 = this.m00;
        float f3 = affine2.m01;
        float f4 = this.m10;
        float f5 = this.m01;
        float f6 = this.m11;
        float f7 = this.m02;
        float f8 = this.m12;
        float f9 = affine2.m02;
        float f10 = affine2.m10;
        float f11 = affine2.m11;
        float f12 = affine2.m12;
        this.m00 = f * f2 + f3 * f4;
        this.m01 = f * f5 + f3 * f6;
        this.m02 = f * f7 + f3 * f8 + f9;
        this.m10 = f2 * f10 + f4 * f11;
        this.m11 = f5 * f10 + f6 * f11;
        this.m12 = f10 * f7 + f11 * f8 + f12;
        return this;
    }

    public Affine2 preRotate(float f) {
        if (f == 0.0f) {
            return this;
        }
        float f2 = MathUtils.cosDeg(f);
        float f3 = MathUtils.sinDeg(f);
        float f4 = this.m00;
        f = this.m10;
        float f5 = this.m01;
        float f6 = this.m11;
        float f7 = this.m02;
        float f8 = this.m12;
        this.m00 = f2 * f4 - f3 * f;
        this.m01 = f2 * f5 - f3 * f6;
        this.m02 = f2 * f7 - f3 * f8;
        this.m10 = f4 * f3 + f * f2;
        this.m11 = f5 * f3 + f6 * f2;
        this.m12 = f3 * f7 + f2 * f8;
        return this;
    }

    public Affine2 preRotateRad(float f) {
        if (f == 0.0f) {
            return this;
        }
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        float f4 = this.m00;
        float f5 = this.m10;
        float f6 = this.m01;
        float f7 = this.m11;
        f = this.m02;
        float f8 = this.m12;
        this.m00 = f2 * f4 - f3 * f5;
        this.m01 = f2 * f6 - f3 * f7;
        this.m02 = f2 * f - f3 * f8;
        this.m10 = f4 * f3 + f5 * f2;
        this.m11 = f6 * f3 + f7 * f2;
        this.m12 = f3 * f + f2 * f8;
        return this;
    }

    public Affine2 preScale(float f, float f2) {
        this.m00 *= f;
        this.m01 *= f;
        this.m02 *= f;
        this.m10 *= f2;
        this.m11 *= f2;
        this.m12 *= f2;
        return this;
    }

    public Affine2 preScale(Vector2 vector2) {
        return this.preScale(vector2.x, vector2.y);
    }

    public Affine2 preShear(float f, float f2) {
        float f3 = this.m00;
        float f4 = this.m10;
        float f5 = this.m01;
        float f6 = this.m11;
        float f7 = this.m02;
        float f8 = this.m12;
        this.m00 = f * f4 + f3;
        this.m01 = f * f6 + f5;
        this.m02 = f * f8 + f7;
        this.m10 = f4 + f3 * f2;
        this.m11 = f6 + f5 * f2;
        this.m12 = f8 + f2 * f7;
        return this;
    }

    public Affine2 preShear(Vector2 vector2) {
        return this.preShear(vector2.x, vector2.y);
    }

    public Affine2 preTranslate(float f, float f2) {
        this.m02 += f;
        this.m12 += f2;
        return this;
    }

    public Affine2 preTranslate(Vector2 vector2) {
        return this.preTranslate(vector2.x, vector2.y);
    }

    public Affine2 rotate(float f) {
        if (f == 0.0f) {
            return this;
        }
        float f2 = MathUtils.cosDeg(f);
        float f3 = MathUtils.sinDeg(f);
        float f4 = this.m00;
        float f5 = this.m01;
        float f6 = -f3;
        f = this.m10;
        float f7 = this.m11;
        this.m00 = f4 * f2 + f5 * f3;
        this.m01 = f4 * f6 + f5 * f2;
        this.m10 = f * f2 + f3 * f7;
        this.m11 = f * f6 + f7 * f2;
        return this;
    }

    public Affine2 rotateRad(float f) {
        if (f == 0.0f) {
            return this;
        }
        float f2 = MathUtils.cos(f);
        float f3 = MathUtils.sin(f);
        float f4 = this.m00;
        float f5 = this.m01;
        f = -f3;
        float f6 = this.m10;
        float f7 = this.m11;
        this.m00 = f4 * f2 + f5 * f3;
        this.m01 = f4 * f + f5 * f2;
        this.m10 = f6 * f2 + f3 * f7;
        this.m11 = f6 * f + f7 * f2;
        return this;
    }

    public Affine2 scale(float f, float f2) {
        this.m00 *= f;
        this.m01 *= f2;
        this.m10 *= f;
        this.m11 *= f2;
        return this;
    }

    public Affine2 scale(Vector2 vector2) {
        return this.scale(vector2.x, vector2.y);
    }

    public Affine2 set(Affine2 affine2) {
        this.m00 = affine2.m00;
        this.m01 = affine2.m01;
        this.m02 = affine2.m02;
        this.m10 = affine2.m10;
        this.m11 = affine2.m11;
        this.m12 = affine2.m12;
        return this;
    }

    public Affine2 set(Matrix3 object) {
        object = ((Matrix3)object).val;
        this.m00 = (float)object[0];
        this.m01 = (float)object[3];
        this.m02 = (float)object[6];
        this.m10 = (float)object[1];
        this.m11 = (float)object[4];
        this.m12 = (float)object[7];
        return this;
    }

    public Affine2 set(Matrix4 object) {
        object = ((Matrix4)object).val;
        this.m00 = (float)object[0];
        this.m01 = (float)object[4];
        this.m02 = (float)object[12];
        this.m10 = (float)object[1];
        this.m11 = (float)object[5];
        this.m12 = (float)object[13];
        return this;
    }

    public Affine2 setToProduct(Affine2 affine2, Affine2 affine22) {
        float f = affine2.m00;
        float f2 = affine22.m00;
        float f3 = affine2.m01;
        float f4 = affine22.m10;
        this.m00 = f * f2 + f3 * f4;
        f = affine2.m00;
        float f5 = affine22.m01;
        f2 = affine22.m11;
        this.m01 = f5 * f + f3 * f2;
        f5 = affine22.m02;
        float f6 = affine2.m01;
        f3 = affine22.m12;
        this.m02 = f * f5 + f6 * f3 + affine2.m02;
        f6 = affine2.m10;
        f5 = affine22.m00;
        f = affine2.m11;
        this.m10 = f6 * f5 + f4 * f;
        f4 = affine2.m10;
        this.m11 = affine22.m01 * f4 + f * f2;
        this.m12 = f4 * affine22.m02 + affine2.m11 * f3 + affine2.m12;
        return this;
    }

    public Affine2 setToRotation(float f) {
        float f2 = MathUtils.cosDeg(f);
        f = MathUtils.sinDeg(f);
        this.m00 = f2;
        this.m01 = -f;
        this.m02 = 0.0f;
        this.m10 = f;
        this.m11 = f2;
        this.m12 = 0.0f;
        return this;
    }

    public Affine2 setToRotation(float f, float f2) {
        this.m00 = f;
        this.m01 = -f2;
        this.m02 = 0.0f;
        this.m10 = f2;
        this.m11 = f;
        this.m12 = 0.0f;
        return this;
    }

    public Affine2 setToRotationRad(float f) {
        float f2 = MathUtils.cos(f);
        f = MathUtils.sin(f);
        this.m00 = f2;
        this.m01 = -f;
        this.m02 = 0.0f;
        this.m10 = f;
        this.m11 = f2;
        this.m12 = 0.0f;
        return this;
    }

    public Affine2 setToScaling(float f, float f2) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f2;
        this.m12 = 0.0f;
        return this;
    }

    public Affine2 setToScaling(Vector2 vector2) {
        return this.setToScaling(vector2.x, vector2.y);
    }

    public Affine2 setToShearing(float f, float f2) {
        this.m00 = 1.0f;
        this.m01 = f;
        this.m02 = 0.0f;
        this.m10 = f2;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        return this;
    }

    public Affine2 setToShearing(Vector2 vector2) {
        return this.setToShearing(vector2.x, vector2.y);
    }

    public Affine2 setToTranslation(float f, float f2) {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = f2;
        return this;
    }

    public Affine2 setToTranslation(Vector2 vector2) {
        return this.setToTranslation(vector2.x, vector2.y);
    }

    public Affine2 setToTrnRotRadScl(float f, float f2, float f3, float f4, float f5) {
        this.m02 = f;
        this.m12 = f2;
        if (f3 == 0.0f) {
            this.m00 = f4;
            this.m01 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = f5;
        } else {
            f = MathUtils.sin(f3);
            f2 = MathUtils.cos(f3);
            this.m00 = f2 * f4;
            this.m01 = -f * f5;
            this.m10 = f * f4;
            this.m11 = f2 * f5;
        }
        return this;
    }

    public Affine2 setToTrnRotRadScl(Vector2 vector2, float f, Vector2 vector22) {
        return this.setToTrnRotRadScl(vector2.x, vector2.y, f, vector22.x, vector22.y);
    }

    public Affine2 setToTrnRotScl(float f, float f2, float f3, float f4, float f5) {
        this.m02 = f;
        this.m12 = f2;
        if (f3 == 0.0f) {
            this.m00 = f4;
            this.m01 = 0.0f;
            this.m10 = 0.0f;
            this.m11 = f5;
        } else {
            f = MathUtils.sinDeg(f3);
            f2 = MathUtils.cosDeg(f3);
            this.m00 = f2 * f4;
            this.m01 = -f * f5;
            this.m10 = f * f4;
            this.m11 = f2 * f5;
        }
        return this;
    }

    public Affine2 setToTrnRotScl(Vector2 vector2, float f, Vector2 vector22) {
        return this.setToTrnRotScl(vector2.x, vector2.y, f, vector22.x, vector22.y);
    }

    public Affine2 setToTrnScl(float f, float f2, float f3, float f4) {
        this.m00 = f3;
        this.m01 = 0.0f;
        this.m02 = f;
        this.m10 = 0.0f;
        this.m11 = f4;
        this.m12 = f2;
        return this;
    }

    public Affine2 setToTrnScl(Vector2 vector2, Vector2 vector22) {
        return this.setToTrnScl(vector2.x, vector2.y, vector22.x, vector22.y);
    }

    public Affine2 shear(float f, float f2) {
        float f3 = this.m00;
        float f4 = this.m01;
        this.m00 = f2 * f4 + f3;
        this.m01 = f4 + f3 * f;
        f4 = this.m10;
        f3 = this.m11;
        this.m10 = f2 * f3 + f4;
        this.m11 = f3 + f * f4;
        return this;
    }

    public Affine2 shear(Vector2 vector2) {
        return this.shear(vector2.x, vector2.y);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.m00);
        stringBuilder.append("|");
        stringBuilder.append(this.m01);
        stringBuilder.append("|");
        stringBuilder.append(this.m02);
        stringBuilder.append("]\n[");
        stringBuilder.append(this.m10);
        stringBuilder.append("|");
        stringBuilder.append(this.m11);
        stringBuilder.append("|");
        stringBuilder.append(this.m12);
        stringBuilder.append("]\n[0.0|0.0|0.1]");
        return stringBuilder.toString();
    }

    public Affine2 translate(float f, float f2) {
        this.m02 += this.m00 * f + this.m01 * f2;
        this.m12 += this.m10 * f + this.m11 * f2;
        return this;
    }

    public Affine2 translate(Vector2 vector2) {
        return this.translate(vector2.x, vector2.y);
    }
}

