/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;

public class OrthogonalTiledMapRenderer
extends BatchTiledMapRenderer {
    public OrthogonalTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, float f) {
        super(tiledMap, f);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, float f, Batch batch) {
        super(tiledMap, f, batch);
    }

    public OrthogonalTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        Object object = this.batch.getColor();
        float f = Color.toFloatBits(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * tiledMapTileLayer.getOpacity());
        int n = tiledMapTileLayer.getWidth();
        int n2 = tiledMapTileLayer.getHeight();
        float f2 = tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f3 = tiledMapTileLayer.getTileHeight() * this.unitScale;
        float f4 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale;
        float f5 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale;
        int n3 = Math.max(0, (int)((this.viewBounds.x - f4) / f2));
        int n4 = Math.min(n, (int)((this.viewBounds.x + this.viewBounds.width + f2 - f4) / f2));
        n = Math.max(0, (int)((this.viewBounds.y - f5) / f3));
        n2 = Math.min(n2, (int)((this.viewBounds.y + this.viewBounds.height + f3 - f5) / f3));
        f5 = (float)n2 * f3 + f5;
        f4 = (float)n3 * f2 + f4;
        float[] fArray = this.vertices;
        while (n2 >= n) {
            float f6 = f4;
            float f7 = f4;
            for (int i = n3; i < n4; ++i) {
                Object object2 = tiledMapTileLayer.getCell(i, n2);
                if (object2 == null) {
                    f4 = f6 + f2;
                } else {
                    object = ((TiledMapTileLayer.Cell)object2).getTile();
                    if (object != null) {
                        boolean bl = ((TiledMapTileLayer.Cell)object2).getFlipHorizontally();
                        boolean bl2 = ((TiledMapTileLayer.Cell)object2).getFlipVertically();
                        int n5 = ((TiledMapTileLayer.Cell)object2).getRotation();
                        object2 = object.getTextureRegion();
                        f4 = f6 + object.getOffsetX() * this.unitScale;
                        float f8 = object.getOffsetY() * this.unitScale + f5;
                        float f9 = f4 + (float)((TextureRegion)object2).getRegionWidth() * this.unitScale;
                        float f10 = (float)((TextureRegion)object2).getRegionHeight() * this.unitScale + f8;
                        float f11 = ((TextureRegion)object2).getU();
                        float f12 = ((TextureRegion)object2).getV2();
                        float f13 = ((TextureRegion)object2).getU2();
                        float f14 = ((TextureRegion)object2).getV();
                        fArray[0] = f4;
                        fArray[1] = f8;
                        fArray[2] = f;
                        fArray[3] = f11;
                        fArray[4] = f12;
                        fArray[5] = f4;
                        fArray[6] = f10;
                        fArray[7] = f;
                        fArray[8] = f11;
                        fArray[9] = f14;
                        fArray[10] = f9;
                        fArray[11] = f10;
                        fArray[12] = f;
                        fArray[13] = f13;
                        fArray[14] = f14;
                        fArray[15] = f9;
                        fArray[16] = f8;
                        fArray[17] = f;
                        fArray[18] = f13;
                        fArray[19] = f12;
                        if (bl) {
                            f4 = fArray[3];
                            fArray[3] = fArray[13];
                            fArray[13] = f4;
                            f4 = fArray[8];
                            fArray[8] = fArray[18];
                            fArray[18] = f4;
                        }
                        if (bl2) {
                            f4 = fArray[4];
                            fArray[4] = fArray[14];
                            fArray[14] = f4;
                            f4 = fArray[9];
                            fArray[9] = fArray[19];
                            fArray[19] = f4;
                        }
                        if (n5 != 0) {
                            if (n5 != 1) {
                                if (n5 != 2) {
                                    if (n5 == 3) {
                                        f4 = fArray[4];
                                        fArray[4] = fArray[19];
                                        fArray[19] = fArray[14];
                                        fArray[14] = fArray[9];
                                        fArray[9] = f4;
                                        f4 = fArray[3];
                                        fArray[3] = fArray[18];
                                        fArray[18] = fArray[13];
                                        fArray[13] = fArray[8];
                                        fArray[8] = f4;
                                    }
                                } else {
                                    f4 = fArray[3];
                                    fArray[3] = fArray[13];
                                    fArray[13] = f4;
                                    f4 = fArray[8];
                                    fArray[8] = fArray[18];
                                    fArray[18] = f4;
                                    f4 = fArray[4];
                                    fArray[4] = fArray[14];
                                    fArray[14] = f4;
                                    f4 = fArray[9];
                                    fArray[9] = fArray[19];
                                    fArray[19] = f4;
                                }
                            } else {
                                f4 = fArray[4];
                                fArray[4] = fArray[9];
                                fArray[9] = fArray[14];
                                fArray[14] = fArray[19];
                                fArray[19] = f4;
                                f4 = fArray[3];
                                fArray[3] = fArray[8];
                                fArray[8] = fArray[13];
                                fArray[13] = fArray[18];
                                fArray[18] = f4;
                            }
                        }
                        this.batch.draw(((TextureRegion)object2).getTexture(), fArray, 0, 20);
                    }
                    f4 = f6 + f2;
                }
                f6 = f4;
            }
            f5 -= f3;
            --n2;
            f4 = f7;
        }
    }
}

