/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.renderers.BatchTiledMapRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class IsometricTiledMapRenderer
extends BatchTiledMapRenderer {
    private Vector2 bottomLeft;
    private Vector2 bottomRight;
    private Matrix4 invIsotransform;
    private Matrix4 isoTransform;
    private Vector3 screenPos = new Vector3();
    private Vector2 topLeft;
    private Vector2 topRight = new Vector2();

    public IsometricTiledMapRenderer(TiledMap tiledMap) {
        super(tiledMap);
        this.bottomLeft = new Vector2();
        this.topLeft = new Vector2();
        this.bottomRight = new Vector2();
        this.init();
    }

    public IsometricTiledMapRenderer(TiledMap tiledMap, float f) {
        super(tiledMap, f);
        this.bottomLeft = new Vector2();
        this.topLeft = new Vector2();
        this.bottomRight = new Vector2();
        this.init();
    }

    public IsometricTiledMapRenderer(TiledMap tiledMap, float f, Batch batch) {
        super(tiledMap, f, batch);
        this.bottomLeft = new Vector2();
        this.topLeft = new Vector2();
        this.bottomRight = new Vector2();
        this.init();
    }

    public IsometricTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        super(tiledMap, batch);
        this.bottomLeft = new Vector2();
        this.topLeft = new Vector2();
        this.bottomRight = new Vector2();
        this.init();
    }

    private void init() {
        this.isoTransform = new Matrix4();
        this.isoTransform.idt();
        this.isoTransform.scale((float)(Math.sqrt(2.0) / 2.0), (float)(Math.sqrt(2.0) / 4.0), 1.0f);
        this.isoTransform.rotate(0.0f, 0.0f, 1.0f, -45.0f);
        this.invIsotransform = new Matrix4(this.isoTransform);
        this.invIsotransform.inv();
    }

    private Vector3 translateScreenToIso(Vector2 vector2) {
        this.screenPos.set(vector2.x, vector2.y, 0.0f);
        this.screenPos.mul(this.invIsotransform);
        return this.screenPos;
    }

    @Override
    public void renderTileLayer(TiledMapTileLayer tiledMapTileLayer) {
        Object object = this.batch.getColor();
        float f = Color.toFloatBits(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * tiledMapTileLayer.getOpacity());
        float f2 = tiledMapTileLayer.getTileWidth() * this.unitScale;
        float f3 = tiledMapTileLayer.getTileHeight();
        float f4 = this.unitScale;
        float f5 = tiledMapTileLayer.getRenderOffsetX() * this.unitScale;
        float f6 = -tiledMapTileLayer.getRenderOffsetY() * this.unitScale;
        float f7 = f2 * 0.5f;
        f3 = f3 * f4 * 0.5f;
        this.topRight.set(this.viewBounds.x + this.viewBounds.width - f5, this.viewBounds.y - f6);
        this.bottomLeft.set(this.viewBounds.x - f5, this.viewBounds.y + this.viewBounds.height - f6);
        this.topLeft.set(this.viewBounds.x - f5, this.viewBounds.y - f6);
        this.bottomRight.set(this.viewBounds.x + this.viewBounds.width - f5, this.viewBounds.y + this.viewBounds.height - f6);
        int n = (int)(this.translateScreenToIso((Vector2)this.topLeft).y / f2);
        int n2 = (int)(this.translateScreenToIso((Vector2)this.bottomLeft).x / f2);
        int n3 = (int)(this.translateScreenToIso((Vector2)this.topRight).x / f2) + 2;
        for (int i = (int)(this.translateScreenToIso((Vector2)this.bottomRight).y / f2) + 2; i >= n - 2; --i) {
            for (int j = n2 - 2; j <= n3; ++j) {
                f4 = j;
                float f8 = i;
                Object object2 = tiledMapTileLayer.getCell(j, i);
                if (object2 == null || (object = ((TiledMapTileLayer.Cell)object2).getTile()) == null) continue;
                boolean bl = ((TiledMapTileLayer.Cell)object2).getFlipHorizontally();
                boolean bl2 = ((TiledMapTileLayer.Cell)object2).getFlipVertically();
                int n4 = ((TiledMapTileLayer.Cell)object2).getRotation();
                object2 = object.getTextureRegion();
                f2 = f4 * f7 + f8 * f7 + object.getOffsetX() * this.unitScale + f5;
                float f9 = f8 * f3 - f4 * f3 + object.getOffsetY() * this.unitScale + f6;
                float f10 = (float)((TextureRegion)object2).getRegionWidth() * this.unitScale + f2;
                float f11 = (float)((TextureRegion)object2).getRegionHeight() * this.unitScale + f9;
                float f12 = ((TextureRegion)object2).getU();
                float f13 = ((TextureRegion)object2).getV2();
                f8 = ((TextureRegion)object2).getU2();
                f4 = ((TextureRegion)object2).getV();
                this.vertices[0] = f2;
                this.vertices[1] = f9;
                this.vertices[2] = f;
                this.vertices[3] = f12;
                this.vertices[4] = f13;
                this.vertices[5] = f2;
                this.vertices[6] = f11;
                this.vertices[7] = f;
                this.vertices[8] = f12;
                this.vertices[9] = f4;
                this.vertices[10] = f10;
                this.vertices[11] = f11;
                this.vertices[12] = f;
                this.vertices[13] = f8;
                this.vertices[14] = f4;
                this.vertices[15] = f10;
                this.vertices[16] = f9;
                this.vertices[17] = f;
                this.vertices[18] = f8;
                this.vertices[19] = f13;
                if (bl) {
                    f2 = this.vertices[3];
                    this.vertices[3] = this.vertices[13];
                    this.vertices[13] = f2;
                    f2 = this.vertices[8];
                    this.vertices[8] = this.vertices[18];
                    this.vertices[18] = f2;
                }
                if (bl2) {
                    f2 = this.vertices[4];
                    this.vertices[4] = this.vertices[14];
                    this.vertices[14] = f2;
                    f2 = this.vertices[9];
                    this.vertices[9] = this.vertices[19];
                    this.vertices[19] = f2;
                }
                if (n4 != 0) {
                    if (n4 != 1) {
                        if (n4 != 2) {
                            if (n4 == 3) {
                                f2 = this.vertices[4];
                                this.vertices[4] = this.vertices[19];
                                this.vertices[19] = this.vertices[14];
                                this.vertices[14] = this.vertices[9];
                                this.vertices[9] = f2;
                                f2 = this.vertices[3];
                                this.vertices[3] = this.vertices[18];
                                this.vertices[18] = this.vertices[13];
                                this.vertices[13] = this.vertices[8];
                                this.vertices[8] = f2;
                            }
                        } else {
                            f2 = this.vertices[3];
                            this.vertices[3] = this.vertices[13];
                            this.vertices[13] = f2;
                            f2 = this.vertices[8];
                            this.vertices[8] = this.vertices[18];
                            this.vertices[18] = f2;
                            f2 = this.vertices[4];
                            this.vertices[4] = this.vertices[14];
                            this.vertices[14] = f2;
                            f2 = this.vertices[9];
                            this.vertices[9] = this.vertices[19];
                            this.vertices[19] = f2;
                        }
                    } else {
                        f2 = this.vertices[4];
                        this.vertices[4] = this.vertices[9];
                        this.vertices[9] = this.vertices[14];
                        this.vertices[14] = this.vertices[19];
                        this.vertices[19] = f2;
                        f2 = this.vertices[3];
                        this.vertices[3] = this.vertices[8];
                        this.vertices[8] = this.vertices[13];
                        this.vertices[13] = this.vertices[18];
                        this.vertices[18] = f2;
                    }
                }
                this.batch.draw(((TextureRegion)object2).getTexture(), this.vertices, 0, 20);
            }
        }
    }
}

