/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps;

import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class MapLayer {
    private String name = "";
    private MapObjects objects = new MapObjects();
    private float offsetX;
    private float offsetY;
    private float opacity = 1.0f;
    private MapLayer parent;
    private MapProperties properties = new MapProperties();
    private boolean renderOffsetDirty = true;
    private float renderOffsetX;
    private float renderOffsetY;
    private boolean visible = true;

    protected void calculateRenderOffsets() {
        MapLayer mapLayer = this.parent;
        if (mapLayer != null) {
            mapLayer.calculateRenderOffsets();
            this.renderOffsetX = this.parent.getRenderOffsetX() + this.offsetX;
            this.renderOffsetY = this.parent.getRenderOffsetY() + this.offsetY;
        } else {
            this.renderOffsetX = this.offsetX;
            this.renderOffsetY = this.offsetY;
        }
        this.renderOffsetDirty = false;
    }

    public String getName() {
        return this.name;
    }

    public MapObjects getObjects() {
        return this.objects;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public MapLayer getParent() {
        return this.parent;
    }

    public MapProperties getProperties() {
        return this.properties;
    }

    public float getRenderOffsetX() {
        if (this.renderOffsetDirty) {
            this.calculateRenderOffsets();
        }
        return this.renderOffsetX;
    }

    public float getRenderOffsetY() {
        if (this.renderOffsetDirty) {
            this.calculateRenderOffsets();
        }
        return this.renderOffsetY;
    }

    public void invalidateRenderOffset() {
        this.renderOffsetDirty = true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setOffsetX(float f) {
        this.offsetX = f;
        this.invalidateRenderOffset();
    }

    public void setOffsetY(float f) {
        this.offsetY = f;
        this.invalidateRenderOffset();
    }

    public void setOpacity(float f) {
        this.opacity = f;
    }

    public void setParent(MapLayer mapLayer) {
        if (mapLayer != this) {
            this.parent = mapLayer;
            return;
        }
        throw new GdxRuntimeException("Can't set self as the parent");
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

