/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;

public class MipMapGenerator {
    private static boolean useHWMipMap = true;

    private MipMapGenerator() {
    }

    public static void generateMipMap(int n, Pixmap pixmap, int n2, int n3) {
        if (!useHWMipMap) {
            MipMapGenerator.generateMipMapCPU(n, pixmap, n2, n3);
            return;
        }
        if (Gdx.app.getType() != Application.ApplicationType.Android && Gdx.app.getType() != Application.ApplicationType.WebGL && Gdx.app.getType() != Application.ApplicationType.iOS) {
            MipMapGenerator.generateMipMapDesktop(n, pixmap, n2, n3);
        } else {
            MipMapGenerator.generateMipMapGLES20(n, pixmap);
        }
    }

    public static void generateMipMap(Pixmap pixmap, int n, int n2) {
        MipMapGenerator.generateMipMap(3553, pixmap, n, n2);
    }

    private static void generateMipMapCPU(int n, Pixmap pixmap, int n2, int n3) {
        Gdx.gl.glTexImage2D(n, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        if (Gdx.gl20 == null && n2 != n3) {
            throw new GdxRuntimeException("texture width and height must be square when using mipmapping.");
        }
        n2 = pixmap.getWidth() / 2;
        int n4 = pixmap.getHeight() / 2;
        int n5 = 1;
        n3 = n2;
        n2 = n5;
        while (n3 > 0 && n4 > 0) {
            Pixmap pixmap2 = new Pixmap(n3, n4, pixmap.getFormat());
            pixmap2.setBlending(Pixmap.Blending.None);
            pixmap2.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, n3, n4);
            if (n2 > 1) {
                pixmap.dispose();
            }
            GL20 gL20 = Gdx.gl;
            int n6 = pixmap2.getGLInternalFormat();
            n4 = pixmap2.getWidth();
            n5 = pixmap2.getHeight();
            int n7 = pixmap2.getGLFormat();
            n3 = pixmap2.getGLType();
            ByteBuffer byteBuffer = pixmap2.getPixels();
            pixmap = pixmap2;
            gL20.glTexImage2D(n, n2, n6, n4, n5, 0, n7, n3, byteBuffer);
            n3 = pixmap.getWidth() / 2;
            n4 = pixmap.getHeight() / 2;
            ++n2;
        }
    }

    private static void generateMipMapDesktop(int n, Pixmap pixmap, int n2, int n3) {
        if (!Gdx.graphics.supportsExtension("GL_ARB_framebuffer_object") && !Gdx.graphics.supportsExtension("GL_EXT_framebuffer_object") && Gdx.gl30 == null) {
            MipMapGenerator.generateMipMapCPU(n, pixmap, n2, n3);
        } else {
            Gdx.gl.glTexImage2D(n, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            Gdx.gl20.glGenerateMipmap(n);
        }
    }

    private static void generateMipMapGLES20(int n, Pixmap pixmap) {
        Gdx.gl.glTexImage2D(n, 0, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
        Gdx.gl20.glGenerateMipmap(n);
    }

    public static void setUseHardwareMipMap(boolean bl) {
        useHWMipMap = bl;
    }
}

