/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.particles.values.MeshSpawnShapeValue;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.math.CumulativeDistribution;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;

public final class WeightMeshSpawnShapeValue
extends MeshSpawnShapeValue {
    private CumulativeDistribution<MeshSpawnShapeValue.Triangle> distribution = new CumulativeDistribution();

    public WeightMeshSpawnShapeValue() {
    }

    public WeightMeshSpawnShapeValue(WeightMeshSpawnShapeValue weightMeshSpawnShapeValue) {
        super(weightMeshSpawnShapeValue);
        this.load(weightMeshSpawnShapeValue);
    }

    public void calculateWeights() {
        int n;
        this.distribution.clear();
        Object object = this.mesh.getVertexAttributes();
        int n2 = this.mesh.getNumIndices();
        int n3 = this.mesh.getNumVertices();
        short s = (short)(((VertexAttributes)object).vertexSize / 4);
        short s2 = (short)(((VertexAttributes)object).findByUsage((int)1).offset / 4);
        object = new float[n3 * s];
        this.mesh.getVertices((float[])object);
        int n4 = 0;
        if (n2 > 0) {
            short[] sArray = new short[n2];
            this.mesh.getIndices(sArray);
            for (n = n4; n < n2; n += 3) {
                n3 = sArray[n] * s + s2;
                n4 = sArray[n + 1] * s + s2;
                int n5 = sArray[n + 2] * s + s2;
                Object object2 = object[n3];
                Object object3 = object[n3 + 1];
                Object object4 = object[n3 + 2];
                Object object5 = object[n4];
                Object object6 = object[n4 + 1];
                Object object7 = object[n4 + 2];
                Object object8 = object[n5];
                Object object9 = object[n5 + 1];
                Object object10 = object[n5 + 2];
                float f = Math.abs((float)(((object6 - object9) * object2 + (object9 - object3) * object5 + (object3 - object6) * object8) / 2.0f));
                this.distribution.add(new MeshSpawnShapeValue.Triangle((float)object2, (float)object3, (float)object4, (float)object5, (float)object6, (float)object7, (float)object8, (float)object9, (float)object10), f);
            }
        } else {
            for (n = 0; n < n3; n += s) {
                n4 = n + s2;
                int n6 = n4 + s;
                n2 = n6 + s;
                Object object11 = object[n4];
                Object object12 = object[n4 + 1];
                Object object13 = object[n4 + 2];
                Object object14 = object[n6];
                Object object15 = object[n6 + 1];
                Object object16 = object[n6 + 2];
                Object object17 = object[n2];
                Object object18 = object[n2 + 1];
                Object object19 = object[n2 + 2];
                float f = Math.abs((float)(((object15 - object18) * object11 + (object18 - object12) * object14 + (object12 - object15) * object17) / 2.0f));
                this.distribution.add(new MeshSpawnShapeValue.Triangle((float)object11, (float)object12, (float)object13, (float)object14, (float)object15, (float)object16, (float)object17, (float)object18, (float)object19), f);
            }
        }
        this.distribution.generateNormalized();
    }

    @Override
    public SpawnShapeValue copy() {
        return new WeightMeshSpawnShapeValue(this);
    }

    @Override
    public void init() {
        this.calculateWeights();
    }

    @Override
    public void spawnAux(Vector3 vector3, float f) {
        MeshSpawnShapeValue.Triangle triangle = this.distribution.value();
        f = MathUtils.random();
        float f2 = MathUtils.random();
        vector3.set(triangle.x1 + (triangle.x2 - triangle.x1) * f + (triangle.x3 - triangle.x1) * f2, triangle.y1 + (triangle.y2 - triangle.y1) * f + (triangle.y3 - triangle.y1) * f2, triangle.z1 + f * (triangle.z2 - triangle.z1) + f2 * (triangle.z3 - triangle.z1));
    }
}

