/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.ParticleEffect;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Pool;
import java.util.Iterator;

public abstract class ParticleControllerInfluencer
extends Influencer {
    ParallelArray.ObjectChannel<ParticleController> particleControllerChannel;
    public Array<ParticleController> templates;

    public ParticleControllerInfluencer() {
        this.templates = new Array(true, 1, ParticleController.class);
    }

    public ParticleControllerInfluencer(ParticleControllerInfluencer particleControllerInfluencer) {
        this((ParticleController[])particleControllerInfluencer.templates.items);
    }

    public ParticleControllerInfluencer(ParticleController ... particleControllerArray) {
        this.templates = new Array<ParticleController>(particleControllerArray);
    }

    @Override
    public void allocateChannels() {
        this.particleControllerChannel = (ParallelArray.ObjectChannel)this.controller.particles.addChannel(ParticleChannels.ParticleController);
    }

    @Override
    public void dispose() {
        if (this.controller != null) {
            for (int i = 0; i < this.controller.particles.size; ++i) {
                ParticleController particleController = ((ParticleController[])this.particleControllerChannel.data)[i];
                if (particleController == null) continue;
                particleController.dispose();
                ((ParticleController[])this.particleControllerChannel.data)[i] = null;
            }
        }
    }

    @Override
    public void end() {
        for (int i = 0; i < this.controller.particles.size; ++i) {
            ((ParticleController[])this.particleControllerChannel.data)[i].end();
        }
    }

    @Override
    public void load(AssetManager assetManager, ResourceData object) {
        Object object2;
        ResourceData.SaveData saveData = ((ResourceData)object).getSaveData();
        object = ((Array)saveData.load("indices")).iterator();
        while ((object2 = saveData.loadAsset()) != null) {
            if ((object2 = (ParticleEffect)assetManager.get(object2)) != null) {
                Array<ParticleController> array = ((ParticleEffect)object2).getControllers();
                object2 = (IntArray)object.next();
                int n = ((IntArray)object2).size;
                for (int i = 0; i < n; ++i) {
                    this.templates.add(array.get(((IntArray)object2).get(i)));
                }
                continue;
            }
            throw new RuntimeException("Template is null");
        }
    }

    @Override
    public void save(AssetManager assetManager, ResourceData object) {
        ResourceData.SaveData saveData = ((ResourceData)object).createSaveData();
        Array<ParticleEffect> array = assetManager.getAll(ParticleEffect.class, new Array());
        Array<ParticleController> array2 = new Array<ParticleController>(this.templates);
        Array<Object> array3 = new Array<Object>();
        for (int i = 0; i < array.size && array2.size > 0; ++i) {
            ParticleEffect particleEffect = array.get(i);
            Array<ParticleController> array4 = particleEffect.getControllers();
            Iterator<ParticleController> iterator = array2.iterator();
            Object object2 = null;
            while (iterator.hasNext()) {
                int n = array4.indexOf(iterator.next(), true);
                if (n <= -1) continue;
                object = object2;
                if (object2 == null) {
                    object = new IntArray();
                }
                iterator.remove();
                ((IntArray)object).add(n);
                object2 = object;
            }
            if (object2 == null) continue;
            saveData.saveAsset(assetManager.getAssetFileName(particleEffect), ParticleEffect.class);
            array3.add(object2);
        }
        saveData.save("indices", array3);
    }

    public static class Random
    extends ParticleControllerInfluencer {
        ParticleControllerPool pool = new ParticleControllerPool();

        public Random() {
        }

        public Random(Random random) {
            super(random);
        }

        public Random(ParticleController ... particleControllerArray) {
            super(particleControllerArray);
        }

        @Override
        public void activateParticles(int n, int n2) {
            for (int i = n; i < n2 + n; ++i) {
                ParticleController particleController = (ParticleController)this.pool.obtain();
                particleController.start();
                ((ParticleController[])this.particleControllerChannel.data)[i] = particleController;
            }
        }

        @Override
        public Random copy() {
            return new Random(this);
        }

        @Override
        public void dispose() {
            this.pool.clear();
            super.dispose();
        }

        @Override
        public void init() {
            this.pool.clear();
            for (int i = 0; i < this.controller.emitter.maxParticleCount; ++i) {
                ParticleControllerPool particleControllerPool = this.pool;
                particleControllerPool.free(particleControllerPool.newObject());
            }
        }

        @Override
        public void killParticles(int n, int n2) {
            for (int i = n; i < n2 + n; ++i) {
                ParticleController particleController = ((ParticleController[])this.particleControllerChannel.data)[i];
                particleController.end();
                this.pool.free(particleController);
                ((ParticleController[])this.particleControllerChannel.data)[i] = null;
            }
        }

        private class ParticleControllerPool
        extends Pool<ParticleController> {
            @Override
            public void clear() {
                int n = Random.this.pool.getFree();
                for (int i = 0; i < n; ++i) {
                    ((ParticleController)Random.this.pool.obtain()).dispose();
                }
                super.clear();
            }

            @Override
            public ParticleController newObject() {
                ParticleController particleController = ((ParticleController)Random.this.templates.random()).copy();
                particleController.init();
                return particleController;
            }
        }
    }

    public static class Single
    extends ParticleControllerInfluencer {
        public Single() {
        }

        public Single(Single single) {
            super(single);
        }

        public Single(ParticleController ... particleControllerArray) {
            super(particleControllerArray);
        }

        @Override
        public void activateParticles(int n, int n2) {
            for (int i = n; i < n2 + n; ++i) {
                ((ParticleController[])this.particleControllerChannel.data)[i].start();
            }
        }

        @Override
        public Single copy() {
            return new Single(this);
        }

        @Override
        public void init() {
            ParticleController particleController = (ParticleController)this.templates.first();
            int n = this.controller.particles.capacity;
            for (int i = 0; i < n; ++i) {
                ParticleController particleController2 = particleController.copy();
                particleController2.init();
                ((ParticleController[])this.particleControllerChannel.data)[i] = particleController2;
            }
        }

        @Override
        public void killParticles(int n, int n2) {
            for (int i = n; i < n2 + n; ++i) {
                ((ParticleController[])this.particleControllerChannel.data)[i].end();
            }
        }
    }
}

