/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.emitters;

import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class Emitter
extends ParticleControllerComponent
implements Json.Serializable {
    public int maxParticleCount = 4;
    public int minParticleCount;
    public float percent;

    public Emitter() {
    }

    public Emitter(Emitter emitter) {
        this.set(emitter);
    }

    @Override
    public void end() {
        this.controller.particles.size = 0;
    }

    public int getMaxParticleCount() {
        return this.maxParticleCount;
    }

    public int getMinParticleCount() {
        return this.minParticleCount;
    }

    @Override
    public void init() {
        this.controller.particles.size = 0;
    }

    public boolean isComplete() {
        boolean bl = this.percent >= 1.0f;
        return bl;
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.minParticleCount = json.readValue("minParticleCount", Integer.TYPE, jsonValue);
        this.maxParticleCount = json.readValue("maxParticleCount", Integer.TYPE, jsonValue);
    }

    public void set(Emitter emitter) {
        this.minParticleCount = emitter.minParticleCount;
        this.maxParticleCount = emitter.maxParticleCount;
    }

    public void setMaxParticleCount(int n) {
        this.maxParticleCount = n;
    }

    public void setMinParticleCount(int n) {
        this.minParticleCount = n;
    }

    public void setParticleCount(int n, int n2) {
        this.setMinParticleCount(n);
        this.setMaxParticleCount(n2);
    }

    @Override
    public void write(Json json) {
        json.writeValue("minParticleCount", this.minParticleCount);
        json.writeValue("maxParticleCount", this.maxParticleCount);
    }
}

