/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.particles.ParticleEffect;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.Iterator;

public final class ParticleSystem
implements RenderableProvider {
    private static ParticleSystem instance;
    private Array<ParticleBatch<?>> batches = new Array();
    private Array<ParticleEffect> effects = new Array();

    public static ParticleSystem get() {
        if (instance == null) {
            instance = new ParticleSystem();
        }
        return instance;
    }

    public void add(ParticleEffect particleEffect) {
        this.effects.add(particleEffect);
    }

    public void add(ParticleBatch<?> particleBatch) {
        this.batches.add(particleBatch);
    }

    public void begin() {
        Iterator<ParticleBatch<?>> iterator = this.batches.iterator();
        while (iterator.hasNext()) {
            iterator.next().begin();
        }
    }

    public void draw() {
        Iterator<ParticleEffect> iterator = this.effects.iterator();
        while (iterator.hasNext()) {
            iterator.next().draw();
        }
    }

    public void end() {
        Iterator<ParticleBatch<?>> iterator = this.batches.iterator();
        while (iterator.hasNext()) {
            iterator.next().end();
        }
    }

    public Array<ParticleBatch<?>> getBatches() {
        return this.batches;
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        Iterator<ParticleBatch<?>> iterator = this.batches.iterator();
        while (iterator.hasNext()) {
            iterator.next().getRenderables(array, pool);
        }
    }

    public void remove(ParticleEffect particleEffect) {
        this.effects.removeValue(particleEffect, true);
    }

    public void removeAll() {
        this.effects.clear();
    }

    public void update() {
        Iterator<ParticleEffect> iterator = this.effects.iterator();
        while (iterator.hasNext()) {
            iterator.next().update();
        }
    }

    public void update(float f) {
        Iterator<ParticleEffect> iterator = this.effects.iterator();
        while (iterator.hasNext()) {
            iterator.next().update(f);
        }
    }

    public void updateAndDraw() {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update();
            particleEffect.draw();
        }
    }

    public void updateAndDraw(float f) {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update(f);
            particleEffect.draw();
        }
    }
}

