/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loader;

import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.ModelLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.model.data.ModelAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNode;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;

public class G3dModelLoader
extends ModelLoader<ModelLoader.ModelParameters> {
    public static final short VERSION_HI = 0;
    public static final short VERSION_LO = 1;
    protected final BaseJsonReader reader;
    protected final Quaternion tempQ = new Quaternion();

    public G3dModelLoader(BaseJsonReader baseJsonReader) {
        this(baseJsonReader, null);
    }

    public G3dModelLoader(BaseJsonReader baseJsonReader, FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
        this.reader = baseJsonReader;
    }

    @Override
    public ModelData loadModelData(FileHandle fileHandle, ModelLoader.ModelParameters modelParameters) {
        return this.parseModel(fileHandle);
    }

    protected void parseAnimations(ModelData modelData, JsonValue jsonValue) {
        if ((jsonValue = jsonValue.get("animations")) == null) {
            return;
        }
        modelData.animations.ensureCapacity(jsonValue.size);
        jsonValue = jsonValue.child;
        while (jsonValue != null) {
            JsonValue jsonValue2 = jsonValue.get("bones");
            if (jsonValue2 != null) {
                ModelAnimation modelAnimation = new ModelAnimation();
                modelData.animations.add(modelAnimation);
                modelAnimation.nodeAnimations.ensureCapacity(jsonValue2.size);
                modelAnimation.id = jsonValue.getString("id");
                jsonValue2 = jsonValue2.child;
                while (jsonValue2 != null) {
                    ModelNodeKeyframe modelNodeKeyframe;
                    JsonValue jsonValue3;
                    ModelNodeAnimation modelNodeAnimation = new ModelNodeAnimation();
                    modelAnimation.nodeAnimations.add(modelNodeAnimation);
                    modelNodeAnimation.nodeId = jsonValue2.getString("boneId");
                    JsonValue jsonValue4 = jsonValue2.get("keyframes");
                    if (jsonValue4 != null && jsonValue4.isArray()) {
                        jsonValue4 = jsonValue4.child;
                        while (jsonValue4 != null) {
                            float f = jsonValue4.getFloat("keytime", 0.0f) / 1000.0f;
                            jsonValue3 = jsonValue4.get("translation");
                            if (jsonValue3 != null && jsonValue3.size == 3) {
                                if (modelNodeAnimation.translation == null) {
                                    modelNodeAnimation.translation = new Array();
                                }
                                modelNodeKeyframe = new ModelNodeKeyframe();
                                modelNodeKeyframe.keytime = f;
                                modelNodeKeyframe.value = new Vector3(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                                modelNodeAnimation.translation.add(modelNodeKeyframe);
                            }
                            if ((jsonValue3 = jsonValue4.get("rotation")) != null && jsonValue3.size == 4) {
                                if (modelNodeAnimation.rotation == null) {
                                    modelNodeAnimation.rotation = new Array();
                                }
                                modelNodeKeyframe = new ModelNodeKeyframe();
                                modelNodeKeyframe.keytime = f;
                                modelNodeKeyframe.value = new Quaternion(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2), jsonValue3.getFloat(3));
                                modelNodeAnimation.rotation.add(modelNodeKeyframe);
                            }
                            if ((jsonValue3 = jsonValue4.get("scale")) != null && jsonValue3.size == 3) {
                                if (modelNodeAnimation.scaling == null) {
                                    modelNodeAnimation.scaling = new Array();
                                }
                                modelNodeKeyframe = new ModelNodeKeyframe();
                                modelNodeKeyframe.keytime = f;
                                modelNodeKeyframe.value = new Vector3(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                                modelNodeAnimation.scaling.add(modelNodeKeyframe);
                            }
                            jsonValue4 = jsonValue4.next;
                        }
                    } else {
                        jsonValue4 = jsonValue2.get("translation");
                        if (jsonValue4 != null && jsonValue4.isArray()) {
                            modelNodeAnimation.translation = new Array();
                            modelNodeAnimation.translation.ensureCapacity(jsonValue4.size);
                            jsonValue4 = jsonValue4.child;
                            while (jsonValue4 != null) {
                                modelNodeKeyframe = new ModelNodeKeyframe();
                                modelNodeAnimation.translation.add(modelNodeKeyframe);
                                modelNodeKeyframe.keytime = jsonValue4.getFloat("keytime", 0.0f) / 1000.0f;
                                jsonValue3 = jsonValue4.get("value");
                                if (jsonValue3 != null && jsonValue3.size >= 3) {
                                    modelNodeKeyframe.value = new Vector3(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                                }
                                jsonValue4 = jsonValue4.next;
                            }
                        }
                        if ((jsonValue4 = jsonValue2.get("rotation")) != null && jsonValue4.isArray()) {
                            modelNodeAnimation.rotation = new Array();
                            modelNodeAnimation.rotation.ensureCapacity(jsonValue4.size);
                            jsonValue4 = jsonValue4.child;
                            while (jsonValue4 != null) {
                                modelNodeKeyframe = new ModelNodeKeyframe();
                                modelNodeAnimation.rotation.add(modelNodeKeyframe);
                                modelNodeKeyframe.keytime = jsonValue4.getFloat("keytime", 0.0f) / 1000.0f;
                                jsonValue3 = jsonValue4.get("value");
                                if (jsonValue3 != null && jsonValue3.size >= 4) {
                                    modelNodeKeyframe.value = new Quaternion(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2), jsonValue3.getFloat(3));
                                }
                                jsonValue4 = jsonValue4.next;
                            }
                        }
                        if ((jsonValue4 = jsonValue2.get("scaling")) != null && jsonValue4.isArray()) {
                            modelNodeAnimation.scaling = new Array();
                            modelNodeAnimation.scaling.ensureCapacity(jsonValue4.size);
                            jsonValue4 = jsonValue4.child;
                            while (jsonValue4 != null) {
                                modelNodeKeyframe = new ModelNodeKeyframe();
                                modelNodeAnimation.scaling.add(modelNodeKeyframe);
                                modelNodeKeyframe.keytime = jsonValue4.getFloat("keytime", 0.0f) / 1000.0f;
                                jsonValue3 = jsonValue4.get("value");
                                if (jsonValue3 != null && jsonValue3.size >= 3) {
                                    modelNodeKeyframe.value = new Vector3(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                                }
                                jsonValue4 = jsonValue4.next;
                            }
                        }
                    }
                    jsonValue2 = jsonValue2.next;
                }
            }
            jsonValue = jsonValue.next;
        }
    }

    protected VertexAttribute[] parseAttributes(JsonValue object) {
        Array<VertexAttribute> array = new Array<VertexAttribute>();
        object = ((JsonValue)object).child;
        int n = 0;
        int n2 = 0;
        while (object != null) {
            String string2;
            block11: {
                block4: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block3: {
                                                string2 = ((JsonValue)object).asString();
                                                if (!string2.equals("POSITION")) break block3;
                                                array.add(VertexAttribute.Position());
                                                break block4;
                                            }
                                            if (!string2.equals("NORMAL")) break block5;
                                            array.add(VertexAttribute.Normal());
                                            break block4;
                                        }
                                        if (!string2.equals("COLOR")) break block6;
                                        array.add(VertexAttribute.ColorUnpacked());
                                        break block4;
                                    }
                                    if (!string2.equals("COLORPACKED")) break block7;
                                    array.add(VertexAttribute.ColorPacked());
                                    break block4;
                                }
                                if (!string2.equals("TANGENT")) break block8;
                                array.add(VertexAttribute.Tangent());
                                break block4;
                            }
                            if (!string2.equals("BINORMAL")) break block9;
                            array.add(VertexAttribute.Binormal());
                            break block4;
                        }
                        if (!string2.startsWith("TEXCOORD")) break block10;
                        array.add(VertexAttribute.TexCoords(n));
                        ++n;
                        break block4;
                    }
                    if (!string2.startsWith("BLENDWEIGHT")) break block11;
                    array.add(VertexAttribute.BoneWeight(n2));
                    ++n2;
                }
                object = ((JsonValue)object).next;
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unknown vertex attribute '");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("', should be one of position, normal, uv, tangent or binormal");
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        return array.toArray(VertexAttribute.class);
    }

    protected Color parseColor(JsonValue jsonValue) {
        if (jsonValue.size >= 3) {
            return new Color(jsonValue.getFloat(0), jsonValue.getFloat(1), jsonValue.getFloat(2), 1.0f);
        }
        throw new GdxRuntimeException("Expected Color values <> than three.");
    }

    protected void parseMaterials(ModelData modelData, JsonValue jsonValue, String string2) {
        if ((jsonValue = jsonValue.get("materials")) != null) {
            modelData.materials.ensureCapacity(jsonValue.size);
            jsonValue = jsonValue.child;
            while (jsonValue != null) {
                ModelMaterial modelMaterial = new ModelMaterial();
                Object object = jsonValue.getString("id", null);
                if (object != null) {
                    modelMaterial.id = object;
                    object = jsonValue.get("diffuse");
                    if (object != null) {
                        modelMaterial.diffuse = this.parseColor((JsonValue)object);
                    }
                    if ((object = jsonValue.get("ambient")) != null) {
                        modelMaterial.ambient = this.parseColor((JsonValue)object);
                    }
                    if ((object = jsonValue.get("emissive")) != null) {
                        modelMaterial.emissive = this.parseColor((JsonValue)object);
                    }
                    if ((object = jsonValue.get("specular")) != null) {
                        modelMaterial.specular = this.parseColor((JsonValue)object);
                    }
                    if ((object = jsonValue.get("reflection")) != null) {
                        modelMaterial.reflection = this.parseColor((JsonValue)object);
                    }
                    modelMaterial.shininess = jsonValue.getFloat("shininess", 0.0f);
                    modelMaterial.opacity = jsonValue.getFloat("opacity", 1.0f);
                    object = jsonValue.get("textures");
                    if (object != null) {
                        object = ((JsonValue)object).child;
                        while (object != null) {
                            ModelTexture modelTexture = new ModelTexture();
                            String string3 = ((JsonValue)object).getString("id", null);
                            if (string3 != null) {
                                modelTexture.id = string3;
                                String string4 = ((JsonValue)object).getString("filename", null);
                                if (string4 != null) {
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append(string2);
                                    int n = string2.length();
                                    string3 = "/";
                                    if (n == 0 || string2.endsWith("/")) {
                                        string3 = "";
                                    }
                                    stringBuilder.append(string3);
                                    stringBuilder.append(string4);
                                    modelTexture.fileName = stringBuilder.toString();
                                    modelTexture.uvTranslation = this.readVector2(((JsonValue)object).get("uvTranslation"), 0.0f, 0.0f);
                                    modelTexture.uvScaling = this.readVector2(((JsonValue)object).get("uvScaling"), 1.0f, 1.0f);
                                    string3 = ((JsonValue)object).getString("type", null);
                                    if (string3 != null) {
                                        modelTexture.usage = this.parseTextureUsage(string3);
                                        if (modelMaterial.textures == null) {
                                            modelMaterial.textures = new Array();
                                        }
                                        modelMaterial.textures.add(modelTexture);
                                        object = ((JsonValue)object).next;
                                        continue;
                                    }
                                    throw new GdxRuntimeException("Texture needs type.");
                                }
                                throw new GdxRuntimeException("Texture needs filename.");
                            }
                            throw new GdxRuntimeException("Texture has no id.");
                        }
                    }
                    modelData.materials.add(modelMaterial);
                    jsonValue = jsonValue.next;
                    continue;
                }
                throw new GdxRuntimeException("Material needs an id.");
            }
        }
    }

    protected void parseMeshes(ModelData object, JsonValue jsonValue) {
        if ((jsonValue = jsonValue.get("meshes")) != null) {
            ((ModelData)object).meshes.ensureCapacity(jsonValue.size);
            jsonValue = jsonValue.child;
            while (jsonValue != null) {
                ModelMesh modelMesh = new ModelMesh();
                modelMesh.id = jsonValue.getString("id", "");
                modelMesh.attributes = this.parseAttributes(jsonValue.require("attributes"));
                modelMesh.vertices = jsonValue.require("vertices").asFloatArray();
                JsonValue jsonValue2 = jsonValue.require("parts");
                Array<ModelMeshPart> array = new Array<ModelMeshPart>();
                jsonValue2 = jsonValue2.child;
                while (jsonValue2 != null) {
                    ModelMeshPart modelMeshPart = new ModelMeshPart();
                    String string2 = jsonValue2.getString("id", null);
                    if (string2 != null) {
                        Object object2 = array.iterator();
                        while (object2.hasNext()) {
                            if (!((ModelMeshPart)object2.next()).id.equals(string2)) continue;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Mesh part with id '");
                            ((StringBuilder)object).append(string2);
                            ((StringBuilder)object).append("' already in defined");
                            throw new GdxRuntimeException(((StringBuilder)object).toString());
                        }
                        modelMeshPart.id = string2;
                        object2 = jsonValue2.getString("type", null);
                        if (object2 != null) {
                            modelMeshPart.primitiveType = this.parseType((String)object2);
                            modelMeshPart.indices = jsonValue2.require("indices").asShortArray();
                            array.add(modelMeshPart);
                            jsonValue2 = jsonValue2.next;
                            continue;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("No primitive type given for mesh part '");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("'");
                        throw new GdxRuntimeException(((StringBuilder)object).toString());
                    }
                    throw new GdxRuntimeException("Not id given for mesh part");
                }
                modelMesh.parts = array.toArray(ModelMeshPart.class);
                ((ModelData)object).meshes.add(modelMesh);
                jsonValue = jsonValue.next;
            }
        }
    }

    public ModelData parseModel(FileHandle fileHandle) {
        JsonValue jsonValue = this.reader.parse(fileHandle);
        ModelData modelData = new ModelData();
        JsonValue jsonValue2 = jsonValue.require("version");
        modelData.version[0] = jsonValue2.getShort(0);
        modelData.version[1] = jsonValue2.getShort(1);
        if (modelData.version[0] == 0 && modelData.version[1] == 1) {
            modelData.id = jsonValue.getString("id", "");
            this.parseMeshes(modelData, jsonValue);
            this.parseMaterials(modelData, jsonValue, fileHandle.parent().path());
            this.parseNodes(modelData, jsonValue);
            this.parseAnimations(modelData, jsonValue);
            return modelData;
        }
        throw new GdxRuntimeException("Model version not supported");
    }

    protected Array<ModelNode> parseNodes(ModelData modelData, JsonValue jsonValue) {
        if ((jsonValue = jsonValue.get("nodes")) != null) {
            modelData.nodes.ensureCapacity(jsonValue.size);
            jsonValue = jsonValue.child;
            while (jsonValue != null) {
                modelData.nodes.add(this.parseNodesRecursively(jsonValue));
                jsonValue = jsonValue.next;
            }
        }
        return modelData.nodes;
    }

    protected ModelNode parseNodesRecursively(JsonValue object) {
        ModelNode modelNode = new ModelNode();
        String string2 = ((JsonValue)object).getString("id", null);
        if (string2 != null) {
            int n;
            modelNode.id = string2;
            Object object2 = "translation";
            Object object3 = ((JsonValue)object).get("translation");
            if (object3 != null && ((JsonValue)object3).size != 3) {
                throw new GdxRuntimeException("Node translation incomplete");
            }
            object3 = object3 == null ? null : new Vector3(((JsonValue)object3).getFloat(0), ((JsonValue)object3).getFloat(1), ((JsonValue)object3).getFloat(2));
            modelNode.translation = object3;
            String string3 = "rotation";
            object3 = ((JsonValue)object).get("rotation");
            if (object3 != null && ((JsonValue)object3).size != 4) {
                throw new GdxRuntimeException("Node rotation incomplete");
            }
            object3 = object3 == null ? null : new Quaternion(((JsonValue)object3).getFloat(0), ((JsonValue)object3).getFloat(1), ((JsonValue)object3).getFloat(2), ((JsonValue)object3).getFloat(3));
            modelNode.rotation = object3;
            object3 = ((JsonValue)object).get("scale");
            if (object3 != null && ((JsonValue)object3).size != 3) {
                throw new GdxRuntimeException("Node scale incomplete");
            }
            object3 = object3 == null ? null : new Vector3(((JsonValue)object3).getFloat(0), ((JsonValue)object3).getFloat(1), ((JsonValue)object3).getFloat(2));
            modelNode.scale = object3;
            object3 = ((JsonValue)object).getString("mesh", null);
            if (object3 != null) {
                modelNode.meshId = object3;
            }
            if ((object3 = ((JsonValue)object).get("parts")) != null) {
                modelNode.parts = new ModelNodePart[((JsonValue)object3).size];
                JsonValue jsonValue = ((JsonValue)object3).child;
                n = 0;
                object3 = object2;
                while (jsonValue != null) {
                    ModelNodePart modelNodePart = new ModelNodePart();
                    object2 = jsonValue.getString("meshpartid", null);
                    Object object4 = jsonValue.getString("materialid", null);
                    if (object2 != null && object4 != null) {
                        block15: {
                            modelNodePart.materialId = object4;
                            modelNodePart.meshPartId = object2;
                            JsonValue jsonValue2 = jsonValue.get("bones");
                            object4 = object3;
                            object2 = string3;
                            if (jsonValue2 != null) {
                                modelNodePart.bones = new ArrayMap(true, jsonValue2.size, String.class, Matrix4.class);
                                jsonValue2 = jsonValue2.child;
                                while (true) {
                                    object4 = object3;
                                    object2 = string3;
                                    if (jsonValue2 == null) break block15;
                                    object4 = jsonValue2.getString("node", null);
                                    if (object4 == null) break;
                                    object2 = new Matrix4();
                                    JsonValue jsonValue3 = jsonValue2.get((String)object3);
                                    if (jsonValue3 != null && jsonValue3.size >= 3) {
                                        ((Matrix4)object2).translate(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                                    }
                                    if ((jsonValue3 = jsonValue2.get(string3)) != null && jsonValue3.size >= 4) {
                                        ((Matrix4)object2).rotate(this.tempQ.set(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2), jsonValue3.getFloat(3)));
                                    }
                                    if ((jsonValue3 = jsonValue2.get("scale")) != null && jsonValue3.size >= 3) {
                                        ((Matrix4)object2).scale(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                                    }
                                    modelNodePart.bones.put((String)object4, (Matrix4)object2);
                                    jsonValue2 = jsonValue2.next;
                                }
                                throw new GdxRuntimeException("Bone node ID missing");
                            }
                        }
                        modelNode.parts[n] = modelNodePart;
                        jsonValue = jsonValue.next;
                        ++n;
                        object3 = object4;
                        string3 = object2;
                        continue;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Node ");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(" part is missing meshPartId or materialId");
                    throw new GdxRuntimeException(((StringBuilder)object).toString());
                }
            }
            n = 0;
            if ((object = ((JsonValue)object).get("children")) != null) {
                modelNode.children = new ModelNode[((JsonValue)object).size];
                object = ((JsonValue)object).child;
                while (object != null) {
                    modelNode.children[n] = this.parseNodesRecursively((JsonValue)object);
                    object = ((JsonValue)object).next;
                    ++n;
                }
            }
            return modelNode;
        }
        object = new GdxRuntimeException("Node id missing.");
        throw object;
    }

    protected int parseTextureUsage(String string2) {
        if (string2.equalsIgnoreCase("AMBIENT")) {
            return 4;
        }
        if (string2.equalsIgnoreCase("BUMP")) {
            return 8;
        }
        if (string2.equalsIgnoreCase("DIFFUSE")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("EMISSIVE")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("NONE")) {
            return 1;
        }
        if (string2.equalsIgnoreCase("NORMAL")) {
            return 7;
        }
        if (string2.equalsIgnoreCase("REFLECTION")) {
            return 10;
        }
        if (string2.equalsIgnoreCase("SHININESS")) {
            return 6;
        }
        if (string2.equalsIgnoreCase("SPECULAR")) {
            return 5;
        }
        if (string2.equalsIgnoreCase("TRANSPARENCY")) {
            return 9;
        }
        return 0;
    }

    protected int parseType(String string2) {
        if (string2.equals("TRIANGLES")) {
            return 4;
        }
        if (string2.equals("LINES")) {
            return 1;
        }
        if (string2.equals("POINTS")) {
            return 0;
        }
        if (string2.equals("TRIANGLE_STRIP")) {
            return 5;
        }
        if (string2.equals("LINE_STRIP")) {
            return 3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unknown primitive type '");
        stringBuilder.append(string2);
        stringBuilder.append("', should be one of triangle, trianglestrip, line, linestrip, lineloop or point");
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    protected Vector2 readVector2(JsonValue jsonValue, float f, float f2) {
        if (jsonValue == null) {
            return new Vector2(f, f2);
        }
        if (jsonValue.size == 2) {
            return new Vector2(jsonValue.getFloat(0), jsonValue.getFloat(1));
        }
        throw new GdxRuntimeException("Expected Vector2 values <> than two.");
    }
}

