/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;

public class DepthTestAttribute
extends Attribute {
    public static final String Alias = "depthStencil";
    protected static long Mask = Type = DepthTestAttribute.register("depthStencil");
    public static final long Type;
    public int depthFunc;
    public boolean depthMask;
    public float depthRangeFar;
    public float depthRangeNear;

    public DepthTestAttribute() {
        this(515);
    }

    public DepthTestAttribute(int n) {
        this(n, true);
    }

    public DepthTestAttribute(int n, float f, float f2) {
        this(n, f, f2, true);
    }

    public DepthTestAttribute(int n, float f, float f2, boolean bl) {
        this(Type, n, f, f2, bl);
    }

    public DepthTestAttribute(int n, boolean bl) {
        this(n, 0.0f, 1.0f, bl);
    }

    public DepthTestAttribute(long l, int n, float f, float f2, boolean bl) {
        super(l);
        if (DepthTestAttribute.is(l)) {
            this.depthFunc = n;
            this.depthRangeNear = f;
            this.depthRangeFar = f2;
            this.depthMask = bl;
            return;
        }
        throw new GdxRuntimeException("Invalid type specified");
    }

    public DepthTestAttribute(DepthTestAttribute depthTestAttribute) {
        this(depthTestAttribute.type, depthTestAttribute.depthFunc, depthTestAttribute.depthRangeNear, depthTestAttribute.depthRangeFar, depthTestAttribute.depthMask);
    }

    public DepthTestAttribute(boolean bl) {
        this(515, bl);
    }

    public static final boolean is(long l) {
        boolean bl = (l & Mask) != 0L;
        return bl;
    }

    @Override
    public int compareTo(Attribute attribute) {
        if (this.type != attribute.type) {
            return (int)(this.type - attribute.type);
        }
        attribute = (DepthTestAttribute)attribute;
        int n = this.depthFunc;
        int n2 = ((DepthTestAttribute)attribute).depthFunc;
        if (n != n2) {
            return n - n2;
        }
        boolean bl = this.depthMask;
        boolean bl2 = ((DepthTestAttribute)attribute).depthMask;
        n = -1;
        if (bl != bl2) {
            if (!bl) {
                n = 1;
            }
            return n;
        }
        if (!MathUtils.isEqual(this.depthRangeNear, ((DepthTestAttribute)attribute).depthRangeNear)) {
            if (!(this.depthRangeNear < ((DepthTestAttribute)attribute).depthRangeNear)) {
                n = 1;
            }
            return n;
        }
        if (!MathUtils.isEqual(this.depthRangeFar, ((DepthTestAttribute)attribute).depthRangeFar)) {
            if (!(this.depthRangeFar < ((DepthTestAttribute)attribute).depthRangeFar)) {
                n = 1;
            }
            return n;
        }
        return 0;
    }

    @Override
    public Attribute copy() {
        return new DepthTestAttribute(this);
    }

    @Override
    public int hashCode() {
        return (((super.hashCode() * 971 + this.depthFunc) * 971 + NumberUtils.floatToRawIntBits(this.depthRangeNear)) * 971 + NumberUtils.floatToRawIntBits(this.depthRangeFar)) * 971 + this.depthMask;
    }
}

