/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.utils.Array;

public class FreetypeFontLoader
extends AsynchronousAssetLoader<BitmapFont, FreeTypeFontLoaderParameter> {
    public FreetypeFontLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String charSequence, FileHandle object, FreeTypeFontLoaderParameter freeTypeFontLoaderParameter) {
        object = new Array();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(freeTypeFontLoaderParameter.fontFileName);
        ((StringBuilder)charSequence).append(".gen");
        ((Array)object).add(new AssetDescriptor<FreeTypeFontGenerator>(((StringBuilder)charSequence).toString(), FreeTypeFontGenerator.class));
        return object;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string2, FileHandle fileHandle, FreeTypeFontLoaderParameter freeTypeFontLoaderParameter) {
        if (freeTypeFontLoaderParameter != null) {
            return;
        }
        throw new RuntimeException("FreetypeFontParameter must be set in AssetManager#load to point at a TTF file!");
    }

    @Override
    public BitmapFont loadSync(AssetManager assetManager, String charSequence, FileHandle fileHandle, FreeTypeFontLoaderParameter freeTypeFontLoaderParameter) {
        if (freeTypeFontLoaderParameter != null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(freeTypeFontLoaderParameter.fontFileName);
            ((StringBuilder)charSequence).append(".gen");
            return assetManager.get(((StringBuilder)charSequence).toString(), FreeTypeFontGenerator.class).generateFont(freeTypeFontLoaderParameter.fontParameters);
        }
        throw new RuntimeException("FreetypeFontParameter must be set in AssetManager#load to point at a TTF file!");
    }

    public static class FreeTypeFontLoaderParameter
    extends AssetLoaderParameters<BitmapFont> {
        public String fontFileName;
        public FreeTypeFontGenerator.FreeTypeFontParameter fontParameters = new FreeTypeFontGenerator.FreeTypeFontParameter();
    }
}

