/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class FreeType {
    public static int FT_ENCODING_ADOBE_CUSTOM = 0;
    public static int FT_ENCODING_ADOBE_EXPERT = 0;
    public static int FT_ENCODING_ADOBE_LATIN_1 = 0;
    public static int FT_ENCODING_ADOBE_STANDARD = 0;
    public static int FT_ENCODING_APPLE_ROMAN = 0;
    public static int FT_ENCODING_BIG5 = 0;
    public static int FT_ENCODING_GB2312 = 0;
    public static int FT_ENCODING_JOHAB = 0;
    public static int FT_ENCODING_MS_SYMBOL = 0;
    public static int FT_ENCODING_NONE = 0;
    public static int FT_ENCODING_OLD_LATIN_2 = 0;
    public static int FT_ENCODING_SJIS = 0;
    public static int FT_ENCODING_UNICODE = 0;
    public static int FT_ENCODING_WANSUNG = 0;
    public static int FT_FACE_FLAG_CID_KEYED = 0;
    public static int FT_FACE_FLAG_EXTERNAL_STREAM = 0;
    public static int FT_FACE_FLAG_FAST_GLYPHS = 0;
    public static int FT_FACE_FLAG_FIXED_SIZES = 0;
    public static int FT_FACE_FLAG_FIXED_WIDTH = 0;
    public static int FT_FACE_FLAG_GLYPH_NAMES = 0;
    public static int FT_FACE_FLAG_HINTER = 0;
    public static int FT_FACE_FLAG_HORIZONTAL = 0;
    public static int FT_FACE_FLAG_KERNING = 0;
    public static int FT_FACE_FLAG_MULTIPLE_MASTERS = 0;
    public static int FT_FACE_FLAG_SCALABLE = 0;
    public static int FT_FACE_FLAG_SFNT = 0;
    public static int FT_FACE_FLAG_TRICKY = 0;
    public static int FT_FACE_FLAG_VERTICAL = 0;
    public static int FT_KERNING_DEFAULT = 0;
    public static int FT_KERNING_UNFITTED = 0;
    public static int FT_KERNING_UNSCALED = 0;
    public static int FT_LOAD_CROP_BITMAP = 0;
    public static int FT_LOAD_DEFAULT = 0;
    public static int FT_LOAD_FORCE_AUTOHINT = 0;
    public static int FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH = 0;
    public static int FT_LOAD_IGNORE_TRANSFORM = 0;
    public static int FT_LOAD_LINEAR_DESIGN = 0;
    public static int FT_LOAD_MONOCHROME = 0;
    public static int FT_LOAD_NO_AUTOHINT = 0;
    public static int FT_LOAD_NO_BITMAP = 0;
    public static int FT_LOAD_NO_HINTING = 0;
    public static int FT_LOAD_NO_RECURSE = 0;
    public static int FT_LOAD_NO_SCALE = 0;
    public static int FT_LOAD_PEDANTIC = 0;
    public static int FT_LOAD_RENDER = 0;
    public static int FT_LOAD_TARGET_LCD = 0;
    public static int FT_LOAD_TARGET_LCD_V = 0;
    public static int FT_LOAD_TARGET_LIGHT = 0;
    public static int FT_LOAD_TARGET_MONO = 0;
    public static int FT_LOAD_TARGET_NORMAL = 0;
    public static int FT_LOAD_VERTICAL_LAYOUT = 0;
    public static int FT_PIXEL_MODE_GRAY = 2;
    public static int FT_PIXEL_MODE_GRAY2 = 3;
    public static int FT_PIXEL_MODE_GRAY4 = 4;
    public static int FT_PIXEL_MODE_LCD = 5;
    public static int FT_PIXEL_MODE_LCD_V = 6;
    public static int FT_PIXEL_MODE_MONO = 1;
    public static int FT_PIXEL_MODE_NONE;
    public static int FT_RENDER_MODE_LCD;
    public static int FT_RENDER_MODE_LCD_V;
    public static int FT_RENDER_MODE_LIGHT;
    public static int FT_RENDER_MODE_MAX;
    public static int FT_RENDER_MODE_MONO;
    public static int FT_RENDER_MODE_NORMAL;
    public static int FT_STROKER_LINECAP_BUTT;
    public static int FT_STROKER_LINECAP_ROUND;
    public static int FT_STROKER_LINECAP_SQUARE;
    public static int FT_STROKER_LINEJOIN_BEVEL;
    public static int FT_STROKER_LINEJOIN_MITER;
    public static int FT_STROKER_LINEJOIN_MITER_FIXED;
    public static int FT_STROKER_LINEJOIN_MITER_VARIABLE;
    public static int FT_STROKER_LINEJOIN_ROUND;
    public static int FT_STYLE_FLAG_BOLD;
    public static int FT_STYLE_FLAG_ITALIC;

    static {
        FT_ENCODING_MS_SYMBOL = FreeType.encode('s', 'y', 'm', 'b');
        FT_ENCODING_UNICODE = FreeType.encode('u', 'n', 'i', 'c');
        FT_ENCODING_SJIS = FreeType.encode('s', 'j', 'i', 's');
        FT_ENCODING_GB2312 = FreeType.encode('g', 'b', ' ', ' ');
        FT_ENCODING_BIG5 = FreeType.encode('b', 'i', 'g', '5');
        FT_ENCODING_WANSUNG = FreeType.encode('w', 'a', 'n', 's');
        FT_ENCODING_JOHAB = FreeType.encode('j', 'o', 'h', 'a');
        FT_ENCODING_ADOBE_STANDARD = FreeType.encode('A', 'D', 'O', 'B');
        FT_ENCODING_ADOBE_EXPERT = FreeType.encode('A', 'D', 'B', 'E');
        FT_ENCODING_ADOBE_CUSTOM = FreeType.encode('A', 'D', 'B', 'C');
        FT_ENCODING_ADOBE_LATIN_1 = FreeType.encode('l', 'a', 't', '1');
        FT_ENCODING_OLD_LATIN_2 = FreeType.encode('l', 'a', 't', '2');
        FT_ENCODING_APPLE_ROMAN = FreeType.encode('a', 'r', 'm', 'n');
        FT_FACE_FLAG_SCALABLE = 1;
        FT_FACE_FLAG_FIXED_SIZES = 2;
        FT_FACE_FLAG_FIXED_WIDTH = 4;
        FT_FACE_FLAG_SFNT = 8;
        FT_FACE_FLAG_HORIZONTAL = 16;
        FT_FACE_FLAG_VERTICAL = 32;
        FT_FACE_FLAG_KERNING = 64;
        FT_FACE_FLAG_FAST_GLYPHS = 128;
        FT_FACE_FLAG_MULTIPLE_MASTERS = 256;
        FT_FACE_FLAG_GLYPH_NAMES = 512;
        FT_FACE_FLAG_EXTERNAL_STREAM = 1024;
        FT_FACE_FLAG_HINTER = 2048;
        FT_FACE_FLAG_CID_KEYED = 4096;
        FT_FACE_FLAG_TRICKY = 8192;
        FT_STYLE_FLAG_ITALIC = 1;
        FT_STYLE_FLAG_BOLD = 2;
        FT_LOAD_DEFAULT = 0;
        FT_LOAD_NO_SCALE = 1;
        FT_LOAD_NO_HINTING = 2;
        FT_LOAD_RENDER = 4;
        FT_LOAD_NO_BITMAP = 8;
        FT_LOAD_VERTICAL_LAYOUT = 16;
        FT_LOAD_FORCE_AUTOHINT = 32;
        FT_LOAD_CROP_BITMAP = 64;
        FT_LOAD_PEDANTIC = 128;
        FT_LOAD_IGNORE_GLOBAL_ADVANCE_WIDTH = 512;
        FT_LOAD_NO_RECURSE = 1024;
        FT_LOAD_IGNORE_TRANSFORM = 2048;
        FT_LOAD_MONOCHROME = 4096;
        FT_LOAD_LINEAR_DESIGN = 8192;
        FT_LOAD_NO_AUTOHINT = 32768;
        FT_LOAD_TARGET_NORMAL = 0;
        FT_LOAD_TARGET_LIGHT = 65536;
        FT_LOAD_TARGET_MONO = 131072;
        FT_LOAD_TARGET_LCD = 196608;
        FT_LOAD_TARGET_LCD_V = 262144;
        FT_RENDER_MODE_NORMAL = 0;
        FT_RENDER_MODE_LIGHT = 1;
        FT_RENDER_MODE_MONO = 2;
        FT_RENDER_MODE_LCD = 3;
        FT_RENDER_MODE_LCD_V = 4;
        FT_RENDER_MODE_MAX = 5;
        FT_KERNING_DEFAULT = 0;
        FT_KERNING_UNFITTED = 1;
        FT_KERNING_UNSCALED = 2;
        FT_STROKER_LINECAP_BUTT = 0;
        FT_STROKER_LINECAP_ROUND = 1;
        FT_STROKER_LINECAP_SQUARE = 2;
        FT_STROKER_LINEJOIN_ROUND = 0;
        FT_STROKER_LINEJOIN_BEVEL = 1;
        FT_STROKER_LINEJOIN_MITER = FT_STROKER_LINEJOIN_MITER_VARIABLE = 2;
        FT_STROKER_LINEJOIN_MITER_FIXED = 3;
    }

    private static int encode(char c, char c2, char c3, char c4) {
        return c << 24 | c2 << 16 | c3 << 8 | c4;
    }

    static native int getLastErrorCode();

    public static Library initFreeType() {
        new SharedLibraryLoader().load("gdx-freetype");
        long l = FreeType.initFreeTypeJni();
        if (l != 0L) {
            return new Library(l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Couldn't initialize FreeType library, FreeType error code: ");
        stringBuilder.append(FreeType.getLastErrorCode());
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    private static native long initFreeTypeJni();

    public static int toInt(int n) {
        return (n + 63 & 0xFFFFFFC0) >> 6;
    }

    public static class Bitmap
    extends Pointer {
        Bitmap(long l) {
            super(l);
        }

        private static native ByteBuffer getBuffer(long var0);

        private static native int getNumGray(long var0);

        private static native int getPitch(long var0);

        private static native int getPixelMode(long var0);

        private static native int getRows(long var0);

        private static native int getWidth(long var0);

        public ByteBuffer getBuffer() {
            if (this.getRows() == 0) {
                return BufferUtils.newByteBuffer(1);
            }
            return Bitmap.getBuffer(this.address);
        }

        public int getNumGray() {
            return Bitmap.getNumGray(this.address);
        }

        public int getPitch() {
            return Bitmap.getPitch(this.address);
        }

        public int getPixelMode() {
            return Bitmap.getPixelMode(this.address);
        }

        public Pixmap getPixmap(Pixmap.Format format, Color object, float f) {
            Object object2;
            int n = this.getWidth();
            int n2 = this.getRows();
            ByteBuffer byteBuffer = this.getBuffer();
            int n3 = this.getPixelMode();
            int n4 = Math.abs(this.getPitch());
            if (object == Color.WHITE && n3 == FT_PIXEL_MODE_GRAY && n4 == n && f == 1.0f) {
                object = new Pixmap(n, n2, Pixmap.Format.Alpha);
                BufferUtils.copy(byteBuffer, ((Pixmap)object).getPixels(), ((Pixmap)object).getPixels().capacity());
            } else {
                object2 = new Pixmap(n, n2, Pixmap.Format.RGBA8888);
                int n5 = Color.rgba8888((Color)object);
                byte[] byArray = new byte[n4];
                object = new int[n];
                IntBuffer intBuffer = ((Pixmap)object2).getPixels().asIntBuffer();
                if (n3 == FT_PIXEL_MODE_MONO) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        byteBuffer.get(byArray);
                        int n6 = 0;
                        for (n4 = 0; n4 < n; n4 += 8) {
                            byte by = byArray[n6];
                            int n7 = Math.min(8, n - n4);
                            for (int i = 0; i < n7; ++i) {
                                object[n4 + i] = (by & 1 << 7 - i) != 0 ? (Object)n5 : (Object)false;
                            }
                            ++n6;
                        }
                        intBuffer.put((int[])object);
                    }
                } else {
                    int n8 = n5 & 0xFFFFFF00;
                    int n9 = n5 & 0xFF;
                    n4 = n2;
                    int n10 = n;
                    for (n3 = 0; n3 < n4; ++n3) {
                        byteBuffer.get(byArray);
                        for (n = 0; n < n10; ++n) {
                            n2 = byArray[n] & 0xFF;
                            object[n] = n2 == 0 ? (Object)n8 : (n2 == 255 ? (Object)(n8 | n9) : (Object)((int)((float)n9 * (float)Math.pow((float)n2 / 255.0f, f)) | n8));
                        }
                        intBuffer.put((int[])object);
                    }
                }
                object = object2;
            }
            object2 = object;
            if (format != ((Pixmap)object).getFormat()) {
                object2 = new Pixmap(((Pixmap)object).getWidth(), ((Pixmap)object).getHeight(), format);
                ((Pixmap)object2).setBlending(Pixmap.Blending.None);
                ((Pixmap)object2).drawPixmap((Pixmap)object, 0, 0);
                ((Pixmap)object2).setBlending(Pixmap.Blending.SourceOver);
                ((Pixmap)object).dispose();
            }
            return object2;
        }

        public int getRows() {
            return Bitmap.getRows(this.address);
        }

        public int getWidth() {
            return Bitmap.getWidth(this.address);
        }
    }

    public static class Face
    extends Pointer
    implements Disposable {
        Library library;

        public Face(long l, Library library) {
            super(l);
            this.library = library;
        }

        private static native void doneFace(long var0);

        private static native int getAscender(long var0);

        private static native int getCharIndex(long var0, int var2);

        private static native int getDescender(long var0);

        private static native int getFaceFlags(long var0);

        private static native long getGlyph(long var0);

        private static native int getHeight(long var0);

        private static native int getKerning(long var0, int var2, int var3, int var4);

        private static native int getMaxAdvanceHeight(long var0);

        private static native int getMaxAdvanceWidth(long var0);

        private static native int getNumGlyphs(long var0);

        private static native long getSize(long var0);

        private static native int getStyleFlags(long var0);

        private static native int getUnderlinePosition(long var0);

        private static native int getUnderlineThickness(long var0);

        private static native boolean hasKerning(long var0);

        private static native boolean loadChar(long var0, int var2, int var3);

        private static native boolean loadGlyph(long var0, int var2, int var3);

        private static native boolean selectSize(long var0, int var2);

        private static native boolean setCharSize(long var0, int var2, int var3, int var4, int var5);

        private static native boolean setPixelSizes(long var0, int var2, int var3);

        @Override
        public void dispose() {
            Face.doneFace(this.address);
            ByteBuffer byteBuffer = this.library.fontData.get(this.address);
            if (byteBuffer != null) {
                this.library.fontData.remove(this.address);
                if (BufferUtils.isUnsafeByteBuffer(byteBuffer)) {
                    BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
                }
            }
        }

        public int getAscender() {
            return Face.getAscender(this.address);
        }

        public int getCharIndex(int n) {
            return Face.getCharIndex(this.address, n);
        }

        public int getDescender() {
            return Face.getDescender(this.address);
        }

        public int getFaceFlags() {
            return Face.getFaceFlags(this.address);
        }

        public GlyphSlot getGlyph() {
            return new GlyphSlot(Face.getGlyph(this.address));
        }

        public int getHeight() {
            return Face.getHeight(this.address);
        }

        public int getKerning(int n, int n2, int n3) {
            return Face.getKerning(this.address, n, n2, n3);
        }

        public int getMaxAdvanceHeight() {
            return Face.getMaxAdvanceHeight(this.address);
        }

        public int getMaxAdvanceWidth() {
            return Face.getMaxAdvanceWidth(this.address);
        }

        public int getNumGlyphs() {
            return Face.getNumGlyphs(this.address);
        }

        public Size getSize() {
            return new Size(Face.getSize(this.address));
        }

        public int getStyleFlags() {
            return Face.getStyleFlags(this.address);
        }

        public int getUnderlinePosition() {
            return Face.getUnderlinePosition(this.address);
        }

        public int getUnderlineThickness() {
            return Face.getUnderlineThickness(this.address);
        }

        public boolean hasKerning() {
            return Face.hasKerning(this.address);
        }

        public boolean loadChar(int n, int n2) {
            return Face.loadChar(this.address, n, n2);
        }

        public boolean loadGlyph(int n, int n2) {
            return Face.loadGlyph(this.address, n, n2);
        }

        public boolean selectSize(int n) {
            return Face.selectSize(this.address, n);
        }

        public boolean setCharSize(int n, int n2, int n3, int n4) {
            return Face.setCharSize(this.address, n, n2, n3, n4);
        }

        public boolean setPixelSizes(int n, int n2) {
            return Face.setPixelSizes(this.address, n, n2);
        }
    }

    public static class Glyph
    extends Pointer
    implements Disposable {
        private boolean rendered;

        Glyph(long l) {
            super(l);
        }

        private static native void done(long var0);

        private static native long getBitmap(long var0);

        private static native int getLeft(long var0);

        private static native int getTop(long var0);

        private static native long strokeBorder(long var0, long var2, boolean var4);

        private static native long toBitmap(long var0, int var2);

        @Override
        public void dispose() {
            Glyph.done(this.address);
        }

        public Bitmap getBitmap() {
            if (this.rendered) {
                return new Bitmap(Glyph.getBitmap(this.address));
            }
            throw new GdxRuntimeException("Glyph is not yet rendered");
        }

        public int getLeft() {
            if (this.rendered) {
                return Glyph.getLeft(this.address);
            }
            throw new GdxRuntimeException("Glyph is not yet rendered");
        }

        public int getTop() {
            if (this.rendered) {
                return Glyph.getTop(this.address);
            }
            throw new GdxRuntimeException("Glyph is not yet rendered");
        }

        public void strokeBorder(Stroker stroker, boolean bl) {
            this.address = Glyph.strokeBorder(this.address, stroker.address, bl);
        }

        public void toBitmap(int n) {
            long l = Glyph.toBitmap(this.address, n);
            if (l != 0L) {
                this.address = l;
                this.rendered = true;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't render glyph, FreeType error code: ");
            stringBuilder.append(FreeType.getLastErrorCode());
            throw new GdxRuntimeException(stringBuilder.toString());
        }
    }

    public static class GlyphMetrics
    extends Pointer {
        GlyphMetrics(long l) {
            super(l);
        }

        private static native int getHeight(long var0);

        private static native int getHoriAdvance(long var0);

        private static native int getHoriBearingX(long var0);

        private static native int getHoriBearingY(long var0);

        private static native int getVertAdvance(long var0);

        private static native int getVertBearingX(long var0);

        private static native int getVertBearingY(long var0);

        private static native int getWidth(long var0);

        public int getHeight() {
            return GlyphMetrics.getHeight(this.address);
        }

        public int getHoriAdvance() {
            return GlyphMetrics.getHoriAdvance(this.address);
        }

        public int getHoriBearingX() {
            return GlyphMetrics.getHoriBearingX(this.address);
        }

        public int getHoriBearingY() {
            return GlyphMetrics.getHoriBearingY(this.address);
        }

        public int getVertAdvance() {
            return GlyphMetrics.getVertAdvance(this.address);
        }

        public int getVertBearingX() {
            return GlyphMetrics.getVertBearingX(this.address);
        }

        public int getVertBearingY() {
            return GlyphMetrics.getVertBearingY(this.address);
        }

        public int getWidth() {
            return GlyphMetrics.getWidth(this.address);
        }
    }

    public static class GlyphSlot
    extends Pointer {
        GlyphSlot(long l) {
            super(l);
        }

        private static native int getAdvanceX(long var0);

        private static native int getAdvanceY(long var0);

        private static native long getBitmap(long var0);

        private static native int getBitmapLeft(long var0);

        private static native int getBitmapTop(long var0);

        private static native int getFormat(long var0);

        private static native long getGlyph(long var0);

        private static native int getLinearHoriAdvance(long var0);

        private static native int getLinearVertAdvance(long var0);

        private static native long getMetrics(long var0);

        private static native boolean renderGlyph(long var0, int var2);

        public int getAdvanceX() {
            return GlyphSlot.getAdvanceX(this.address);
        }

        public int getAdvanceY() {
            return GlyphSlot.getAdvanceY(this.address);
        }

        public Bitmap getBitmap() {
            return new Bitmap(GlyphSlot.getBitmap(this.address));
        }

        public int getBitmapLeft() {
            return GlyphSlot.getBitmapLeft(this.address);
        }

        public int getBitmapTop() {
            return GlyphSlot.getBitmapTop(this.address);
        }

        public int getFormat() {
            return GlyphSlot.getFormat(this.address);
        }

        public Glyph getGlyph() {
            long l = GlyphSlot.getGlyph(this.address);
            if (l != 0L) {
                return new Glyph(l);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't get glyph, FreeType error code: ");
            stringBuilder.append(FreeType.getLastErrorCode());
            throw new GdxRuntimeException(stringBuilder.toString());
        }

        public int getLinearHoriAdvance() {
            return GlyphSlot.getLinearHoriAdvance(this.address);
        }

        public int getLinearVertAdvance() {
            return GlyphSlot.getLinearVertAdvance(this.address);
        }

        public GlyphMetrics getMetrics() {
            return new GlyphMetrics(GlyphSlot.getMetrics(this.address));
        }

        public boolean renderGlyph(int n) {
            return GlyphSlot.renderGlyph(this.address, n);
        }
    }

    public static class Library
    extends Pointer
    implements Disposable {
        LongMap<ByteBuffer> fontData = new LongMap();

        Library(long l) {
            super(l);
        }

        private static native void doneFreeType(long var0);

        private static native long newMemoryFace(long var0, ByteBuffer var2, int var3, int var4);

        private static native long strokerNew(long var0);

        public Stroker createStroker() {
            long l = Library.strokerNew(this.address);
            if (l != 0L) {
                return new Stroker(l);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't create FreeType stroker, FreeType error code: ");
            stringBuilder.append(FreeType.getLastErrorCode());
            throw new GdxRuntimeException(stringBuilder.toString());
        }

        @Override
        public void dispose() {
            Library.doneFreeType(this.address);
            for (ByteBuffer byteBuffer : this.fontData.values()) {
                if (!BufferUtils.isUnsafeByteBuffer(byteBuffer)) continue;
                BufferUtils.disposeUnsafeByteBuffer(byteBuffer);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Face newFace(FileHandle object, int n) {
            Throwable throwable2222222;
            Object object2;
            block10: {
                block9: {
                    try {
                        object2 = ((FileHandle)object).map();
                    }
                    catch (GdxRuntimeException gdxRuntimeException) {
                        object2 = null;
                    }
                    if (object2 != null) {
                        object = object2;
                        return this.newMemoryFace((ByteBuffer)object, n);
                    }
                    object2 = ((FileHandle)object).read();
                    int n2 = (int)((FileHandle)object).length();
                    if (n2 == 0) {
                        byte[] byArray = StreamUtils.copyStreamToByteArray((InputStream)object2, 16384);
                        object = BufferUtils.newUnsafeByteBuffer(byArray.length);
                        BufferUtils.copy(byArray, 0, (Buffer)object, byArray.length);
                        break block9;
                    } else {
                        object = BufferUtils.newUnsafeByteBuffer(n2);
                        StreamUtils.copyStream((InputStream)object2, (ByteBuffer)object);
                    }
                    {
                        catch (Throwable throwable2222222) {
                            break block10;
                        }
                        catch (IOException iOException) {}
                        {
                            object = new GdxRuntimeException(iOException);
                            throw object;
                        }
                    }
                }
                StreamUtils.closeQuietly((Closeable)object2);
                return this.newMemoryFace((ByteBuffer)object, n);
            }
            StreamUtils.closeQuietly((Closeable)object2);
            throw throwable2222222;
        }

        public Face newMemoryFace(ByteBuffer comparable, int n) {
            long l = Library.newMemoryFace(this.address, (ByteBuffer)comparable, ((Buffer)((Object)comparable)).remaining(), n);
            if (l == 0L) {
                if (BufferUtils.isUnsafeByteBuffer((ByteBuffer)comparable)) {
                    BufferUtils.disposeUnsafeByteBuffer((ByteBuffer)comparable);
                }
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append("Couldn't load font, FreeType error code: ");
                ((StringBuilder)comparable).append(FreeType.getLastErrorCode());
                throw new GdxRuntimeException(((StringBuilder)comparable).toString());
            }
            this.fontData.put(l, (ByteBuffer)comparable);
            return new Face(l, this);
        }

        public Face newMemoryFace(byte[] byArray, int n, int n2) {
            ByteBuffer byteBuffer = BufferUtils.newUnsafeByteBuffer(byArray.length);
            BufferUtils.copy(byArray, 0, (Buffer)byteBuffer, byArray.length);
            return this.newMemoryFace(byteBuffer, n2);
        }
    }

    private static class Pointer {
        long address;

        Pointer(long l) {
            this.address = l;
        }
    }

    public static class Size
    extends Pointer {
        Size(long l) {
            super(l);
        }

        private static native long getMetrics(long var0);

        public SizeMetrics getMetrics() {
            return new SizeMetrics(Size.getMetrics(this.address));
        }
    }

    public static class SizeMetrics
    extends Pointer {
        SizeMetrics(long l) {
            super(l);
        }

        private static native int getAscender(long var0);

        private static native int getDescender(long var0);

        private static native int getHeight(long var0);

        private static native int getMaxAdvance(long var0);

        private static native int getXppem(long var0);

        private static native int getXscale(long var0);

        private static native int getYppem(long var0);

        private static native int getYscale(long var0);

        public int getAscender() {
            return SizeMetrics.getAscender(this.address);
        }

        public int getDescender() {
            return SizeMetrics.getDescender(this.address);
        }

        public int getHeight() {
            return SizeMetrics.getHeight(this.address);
        }

        public int getMaxAdvance() {
            return SizeMetrics.getMaxAdvance(this.address);
        }

        public int getXScale() {
            return SizeMetrics.getXscale(this.address);
        }

        public int getXppem() {
            return SizeMetrics.getXppem(this.address);
        }

        public int getYppem() {
            return SizeMetrics.getYppem(this.address);
        }

        public int getYscale() {
            return SizeMetrics.getYscale(this.address);
        }
    }

    public static class Stroker
    extends Pointer
    implements Disposable {
        Stroker(long l) {
            super(l);
        }

        private static native void done(long var0);

        private static native void set(long var0, int var2, int var3, int var4, int var5);

        @Override
        public void dispose() {
            Stroker.done(this.address);
        }

        public void set(int n, int n2, int n3, int n4) {
            Stroker.set(this.address, n, n2, n3, n4);
        }
    }
}

