/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;

public class PolygonSprite {
    private Rectangle bounds = new Rectangle();
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private boolean dirty;
    private float height;
    private float originX;
    private float originY;
    PolygonRegion region;
    private float rotation;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float[] vertices;
    private float width;
    private float x;
    private float y;

    public PolygonSprite(PolygonRegion polygonRegion) {
        this.setRegion(polygonRegion);
        this.setSize(polygonRegion.region.regionWidth, polygonRegion.region.regionHeight);
        this.setOrigin(this.width / 2.0f, this.height / 2.0f);
    }

    public PolygonSprite(PolygonSprite polygonSprite) {
        this.set(polygonSprite);
    }

    public void draw(PolygonSpriteBatch polygonSpriteBatch) {
        PolygonRegion polygonRegion = this.region;
        polygonSpriteBatch.draw(polygonRegion.region.texture, this.getVertices(), 0, this.vertices.length, polygonRegion.triangles, 0, polygonRegion.triangles.length);
    }

    public void draw(PolygonSpriteBatch polygonSpriteBatch, float f) {
        Color color2 = this.getColor();
        float f2 = color2.a;
        color2.a *= f;
        this.setColor(color2);
        this.draw(polygonSpriteBatch);
        color2.a = f2;
        this.setColor(color2);
    }

    public Rectangle getBoundingRectangle() {
        Object object = this.getVertices();
        float f = object[0];
        float f2 = object[1];
        float f3 = object[0];
        float f4 = object[1];
        for (int i = 5; i < ((float[])object).length; i += 5) {
            float f5 = object[i];
            float f6 = object[i + 1];
            float f7 = f;
            if (f > f5) {
                f7 = f5;
            }
            f = f3;
            if (f3 < f5) {
                f = f5;
            }
            f5 = f2;
            if (f2 > f6) {
                f5 = f6;
            }
            f2 = f4;
            if (f4 < f6) {
                f2 = f6;
            }
            f3 = f;
            f = f7;
            f4 = f2;
            f2 = f5;
        }
        object = this.bounds;
        object.x = f;
        object.y = f2;
        object.width = f3 - f;
        object.height = f4 - f2;
        return object;
    }

    public Color getColor() {
        return this.color;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public Color getPackedColor() {
        Color.abgr8888ToColor(this.color, this.vertices[2]);
        return this.color;
    }

    public PolygonRegion getRegion() {
        return this.region;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float[] getVertices() {
        if (!this.dirty) {
            return this.vertices;
        }
        int n = 0;
        this.dirty = false;
        float f = this.originX;
        float f2 = this.originY;
        float f3 = this.scaleX;
        float f4 = this.scaleY;
        PolygonRegion polygonRegion = this.region;
        float[] fArray = this.vertices;
        float[] fArray2 = polygonRegion.vertices;
        float f5 = this.x;
        float f6 = this.y;
        float f7 = this.width / (float)polygonRegion.region.getRegionWidth();
        float f8 = this.height / (float)polygonRegion.region.getRegionHeight();
        float f9 = MathUtils.cosDeg(this.rotation);
        float f10 = MathUtils.sinDeg(this.rotation);
        int n2 = fArray2.length;
        int n3 = 0;
        while (n < n2) {
            float f11 = (fArray2[n] * f7 - f) * f3;
            float f12 = (fArray2[n + 1] * f8 - f2) * f4;
            fArray[n3] = f9 * f11 - f10 * f12 + (f5 + f);
            fArray[n3 + 1] = f11 * f10 + f12 * f9 + (f6 + f2);
            n += 2;
            n3 += 5;
        }
        return fArray;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void rotate(float f) {
        this.rotation += f;
        this.dirty = true;
    }

    public void scale(float f) {
        this.scaleX += f;
        this.scaleY += f;
        this.dirty = true;
    }

    public void set(PolygonSprite polygonSprite) {
        if (polygonSprite != null) {
            this.setRegion(polygonSprite.region);
            this.x = polygonSprite.x;
            this.y = polygonSprite.y;
            this.width = polygonSprite.width;
            this.height = polygonSprite.height;
            this.originX = polygonSprite.originX;
            this.originY = polygonSprite.originY;
            this.rotation = polygonSprite.rotation;
            this.scaleX = polygonSprite.scaleX;
            this.scaleY = polygonSprite.scaleY;
            this.color.set(polygonSprite.color);
            return;
        }
        throw new IllegalArgumentException("sprite cannot be null.");
    }

    public void setBounds(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
        this.dirty = true;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        f = this.color.toFloatBits();
        float[] fArray = this.vertices;
        for (int i = 2; i < fArray.length; i += 5) {
            fArray[i] = f;
        }
    }

    public void setColor(Color object) {
        this.color.set((Color)object);
        float f = ((Color)object).toFloatBits();
        object = this.vertices;
        for (int i = 2; i < ((Object)object).length; i += 5) {
            object[i] = f;
        }
    }

    public void setOrigin(float f, float f2) {
        this.originX = f;
        this.originY = f2;
        this.dirty = true;
    }

    public void setPosition(float f, float f2) {
        this.translate(f - this.x, f2 - this.y);
    }

    public void setRegion(PolygonRegion object) {
        this.region = object;
        float[] fArray = ((PolygonRegion)object).vertices;
        object = ((PolygonRegion)object).textureCoords;
        int n = fArray.length / 2 * 5;
        fArray = this.vertices;
        if (fArray == null || fArray.length != n) {
            this.vertices = new float[n];
        }
        float f = this.color.toFloatBits();
        fArray = this.vertices;
        int n2 = 0;
        for (int i = 2; i < n; i += 5) {
            fArray[i] = f;
            fArray[i + 1] = (float)object[n2];
            fArray[i + 2] = (float)object[n2 + 1];
            n2 += 2;
        }
        this.dirty = true;
    }

    public void setRotation(float f) {
        this.rotation = f;
        this.dirty = true;
    }

    public void setScale(float f) {
        this.scaleX = f;
        this.scaleY = f;
        this.dirty = true;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
        this.dirty = true;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.dirty = true;
    }

    public void setX(float f) {
        this.translateX(f - this.x);
    }

    public void setY(float f) {
        this.translateY(f - this.y);
    }

    public void translate(float f, float f2) {
        this.x += f;
        this.y += f2;
        if (this.dirty) {
            return;
        }
        float[] fArray = this.vertices;
        for (int i = 0; i < fArray.length; i += 5) {
            fArray[i] = fArray[i] + f;
            int n = i + 1;
            fArray[n] = fArray[n] + f2;
        }
    }

    public void translateX(float f) {
        this.x += f;
        if (this.dirty) {
            return;
        }
        float[] fArray = this.vertices;
        for (int i = 0; i < fArray.length; i += 5) {
            fArray[i] = fArray[i] + f;
        }
    }

    public void translateY(float f) {
        this.y += f;
        if (this.dirty) {
            return;
        }
        float[] fArray = this.vertices;
        for (int i = 1; i < fArray.length; i += 5) {
            fArray[i] = fArray[i] + f;
        }
    }
}

