/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class ParticleEmitter {
    private static final int UPDATE_ANGLE = 2;
    private static final int UPDATE_GRAVITY = 32;
    private static final int UPDATE_ROTATION = 4;
    private static final int UPDATE_SCALE = 1;
    private static final int UPDATE_SPRITE = 128;
    private static final int UPDATE_TINT = 64;
    private static final int UPDATE_VELOCITY = 8;
    private static final int UPDATE_WIND = 16;
    private float accumulator;
    private boolean[] active;
    private int activeCount;
    private boolean additive = true;
    private boolean aligned;
    private boolean allowCompletion;
    private ScaledNumericValue angleValue;
    private boolean attached;
    private boolean behind;
    private BoundingBox bounds;
    boolean cleansUpBlendFunction = true;
    private boolean continuous;
    private float delay;
    private float delayTimer;
    private RangedNumericValue delayValue = new RangedNumericValue();
    public float duration = 1.0f;
    public float durationTimer;
    private RangedNumericValue durationValue;
    private int emission;
    private int emissionDelta;
    private int emissionDiff;
    private ScaledNumericValue emissionValue;
    private boolean firstUpdate;
    private boolean flipX;
    private boolean flipY;
    private ScaledNumericValue gravityValue;
    private Array<String> imagePaths;
    private int life;
    private int lifeDiff;
    private int lifeOffset;
    private int lifeOffsetDiff;
    private IndependentScaledNumericValue lifeOffsetValue = new IndependentScaledNumericValue();
    private IndependentScaledNumericValue lifeValue;
    private int maxParticleCount = 4;
    private int minParticleCount;
    private RangedNumericValue[] motionValues;
    private String name;
    private Particle[] particles;
    private boolean premultipliedAlpha = false;
    private ScaledNumericValue rotationValue;
    private float spawnHeight;
    private float spawnHeightDiff;
    private ScaledNumericValue spawnHeightValue;
    private SpawnShapeValue spawnShapeValue;
    private float spawnWidth;
    private float spawnWidthDiff;
    private ScaledNumericValue spawnWidthValue;
    private SpriteMode spriteMode;
    private Array<Sprite> sprites;
    private GradientColorValue tintValue;
    private ScaledNumericValue transparencyValue;
    private int updateFlags;
    private ScaledNumericValue velocityValue;
    private ScaledNumericValue windValue;
    private float x;
    private RangedNumericValue xOffsetValue;
    private ScaledNumericValue xScaleValue;
    private RangedNumericValue[] xSizeValues;
    private float y;
    private RangedNumericValue yOffsetValue;
    private ScaledNumericValue yScaleValue;
    private RangedNumericValue[] ySizeValues;

    public ParticleEmitter() {
        this.durationValue = new RangedNumericValue();
        this.lifeValue = new IndependentScaledNumericValue();
        this.emissionValue = new ScaledNumericValue();
        this.xScaleValue = new ScaledNumericValue();
        this.yScaleValue = new ScaledNumericValue();
        this.rotationValue = new ScaledNumericValue();
        this.velocityValue = new ScaledNumericValue();
        this.angleValue = new ScaledNumericValue();
        this.windValue = new ScaledNumericValue();
        this.gravityValue = new ScaledNumericValue();
        this.transparencyValue = new ScaledNumericValue();
        this.tintValue = new GradientColorValue();
        this.xOffsetValue = new ScaledNumericValue();
        this.yOffsetValue = new ScaledNumericValue();
        this.spawnWidthValue = new ScaledNumericValue();
        this.spawnHeightValue = new ScaledNumericValue();
        this.spawnShapeValue = new SpawnShapeValue();
        this.spriteMode = SpriteMode.single;
        this.initialize();
    }

    public ParticleEmitter(ParticleEmitter particleEmitter) {
        this.durationValue = new RangedNumericValue();
        this.lifeValue = new IndependentScaledNumericValue();
        this.emissionValue = new ScaledNumericValue();
        this.xScaleValue = new ScaledNumericValue();
        this.yScaleValue = new ScaledNumericValue();
        this.rotationValue = new ScaledNumericValue();
        this.velocityValue = new ScaledNumericValue();
        this.angleValue = new ScaledNumericValue();
        this.windValue = new ScaledNumericValue();
        this.gravityValue = new ScaledNumericValue();
        this.transparencyValue = new ScaledNumericValue();
        this.tintValue = new GradientColorValue();
        this.xOffsetValue = new ScaledNumericValue();
        this.yOffsetValue = new ScaledNumericValue();
        this.spawnWidthValue = new ScaledNumericValue();
        this.spawnHeightValue = new ScaledNumericValue();
        this.spawnShapeValue = new SpawnShapeValue();
        this.spriteMode = SpriteMode.single;
        this.sprites = new Array<Sprite>(particleEmitter.sprites);
        this.name = particleEmitter.name;
        this.imagePaths = new Array<String>(particleEmitter.imagePaths);
        this.setMaxParticleCount(particleEmitter.maxParticleCount);
        this.minParticleCount = particleEmitter.minParticleCount;
        this.delayValue.load(particleEmitter.delayValue);
        this.durationValue.load(particleEmitter.durationValue);
        this.emissionValue.load(particleEmitter.emissionValue);
        this.lifeValue.load(particleEmitter.lifeValue);
        this.lifeOffsetValue.load(particleEmitter.lifeOffsetValue);
        this.xScaleValue.load(particleEmitter.xScaleValue);
        this.yScaleValue.load(particleEmitter.yScaleValue);
        this.rotationValue.load(particleEmitter.rotationValue);
        this.velocityValue.load(particleEmitter.velocityValue);
        this.angleValue.load(particleEmitter.angleValue);
        this.windValue.load(particleEmitter.windValue);
        this.gravityValue.load(particleEmitter.gravityValue);
        this.transparencyValue.load(particleEmitter.transparencyValue);
        this.tintValue.load(particleEmitter.tintValue);
        this.xOffsetValue.load(particleEmitter.xOffsetValue);
        this.yOffsetValue.load(particleEmitter.yOffsetValue);
        this.spawnWidthValue.load(particleEmitter.spawnWidthValue);
        this.spawnHeightValue.load(particleEmitter.spawnHeightValue);
        this.spawnShapeValue.load(particleEmitter.spawnShapeValue);
        this.attached = particleEmitter.attached;
        this.continuous = particleEmitter.continuous;
        this.aligned = particleEmitter.aligned;
        this.behind = particleEmitter.behind;
        this.additive = particleEmitter.additive;
        this.premultipliedAlpha = particleEmitter.premultipliedAlpha;
        this.cleansUpBlendFunction = particleEmitter.cleansUpBlendFunction;
        this.spriteMode = particleEmitter.spriteMode;
        this.setPosition(particleEmitter.getX(), particleEmitter.getY());
    }

    public ParticleEmitter(BufferedReader bufferedReader) throws IOException {
        this.durationValue = new RangedNumericValue();
        this.lifeValue = new IndependentScaledNumericValue();
        this.emissionValue = new ScaledNumericValue();
        this.xScaleValue = new ScaledNumericValue();
        this.yScaleValue = new ScaledNumericValue();
        this.rotationValue = new ScaledNumericValue();
        this.velocityValue = new ScaledNumericValue();
        this.angleValue = new ScaledNumericValue();
        this.windValue = new ScaledNumericValue();
        this.gravityValue = new ScaledNumericValue();
        this.transparencyValue = new ScaledNumericValue();
        this.tintValue = new GradientColorValue();
        this.xOffsetValue = new ScaledNumericValue();
        this.yOffsetValue = new ScaledNumericValue();
        this.spawnWidthValue = new ScaledNumericValue();
        this.spawnHeightValue = new ScaledNumericValue();
        this.spawnShapeValue = new SpawnShapeValue();
        this.spriteMode = SpriteMode.single;
        this.initialize();
        this.load(bufferedReader);
    }

    private void activateParticle(int n) {
        float f;
        float f2;
        float f3;
        int n2 = 1.$SwitchMap$com$badlogic$gdx$graphics$g2d$ParticleEmitter$SpriteMode[this.spriteMode.ordinal()];
        Object object = n2 != 1 && n2 != 2 ? (n2 != 3 ? null : this.sprites.random()) : this.sprites.first();
        Object[] objectArray = this.particles;
        Particle particle = objectArray[n];
        if (particle == null) {
            objectArray[n] = particle = this.newParticle((Sprite)object);
            particle.flip(this.flipX, this.flipY);
        } else {
            particle.set((Sprite)object);
        }
        float f4 = this.durationTimer / this.duration;
        n2 = this.updateFlags;
        if (this.lifeValue.independent) {
            this.generateLifeValues();
        }
        if (this.lifeOffsetValue.independent) {
            this.generateLifeOffsetValues();
        }
        particle.life = n = this.life + (int)((float)this.lifeDiff * this.lifeValue.getScale(f4));
        particle.currentLife = n;
        if (this.velocityValue.active) {
            particle.velocity = this.velocityValue.newLowValue();
            particle.velocityDiff = this.velocityValue.newHighValue();
            if (!this.velocityValue.isRelative()) {
                particle.velocityDiff -= particle.velocity;
            }
        }
        particle.angle = this.angleValue.newLowValue();
        particle.angleDiff = this.angleValue.newHighValue();
        if (!this.angleValue.isRelative()) {
            particle.angleDiff -= particle.angle;
        }
        if ((n = n2 & 2) == 0) {
            particle.angle = f3 = particle.angle + particle.angleDiff * this.angleValue.getScale(0.0f);
            particle.angleCos = MathUtils.cosDeg(f3);
            particle.angleSin = MathUtils.sinDeg(f3);
        } else {
            f3 = 0.0f;
        }
        float f5 = object.getWidth();
        float f6 = object.getHeight();
        particle.xScale = this.xScaleValue.newLowValue() / f5;
        particle.xScaleDiff = this.xScaleValue.newHighValue() / f5;
        if (!this.xScaleValue.isRelative()) {
            particle.xScaleDiff -= particle.xScale;
        }
        if (this.yScaleValue.active) {
            particle.yScale = this.yScaleValue.newLowValue() / f6;
            particle.yScaleDiff = this.yScaleValue.newHighValue() / f6;
            if (!this.yScaleValue.isRelative()) {
                particle.yScaleDiff -= particle.yScale;
            }
            particle.setScale(particle.xScale + particle.xScaleDiff * this.xScaleValue.getScale(0.0f), particle.yScale + particle.yScaleDiff * this.yScaleValue.getScale(0.0f));
        } else {
            particle.setScale(particle.xScale + particle.xScaleDiff * this.xScaleValue.getScale(0.0f));
        }
        if (this.rotationValue.active) {
            particle.rotation = this.rotationValue.newLowValue();
            particle.rotationDiff = this.rotationValue.newHighValue();
            if (!this.rotationValue.isRelative()) {
                particle.rotationDiff -= particle.rotation;
            }
            f = f2 = particle.rotation + particle.rotationDiff * this.rotationValue.getScale(0.0f);
            if (this.aligned) {
                f = f2 + f3;
            }
            particle.setRotation(f);
        }
        if (this.windValue.active) {
            particle.wind = this.windValue.newLowValue();
            particle.windDiff = this.windValue.newHighValue();
            if (!this.windValue.isRelative()) {
                particle.windDiff -= particle.wind;
            }
        }
        if (this.gravityValue.active) {
            particle.gravity = this.gravityValue.newLowValue();
            particle.gravityDiff = this.gravityValue.newHighValue();
            if (!this.gravityValue.isRelative()) {
                particle.gravityDiff -= particle.gravity;
            }
        }
        object = objectArray = (Object[])particle.tint;
        if (objectArray == null) {
            object = new float[3];
            particle.tint = (float[])object;
        }
        objectArray = this.tintValue.getColor(0.0f);
        object[0] = objectArray[0];
        object[1] = objectArray[1];
        object[2] = objectArray[2];
        particle.transparency = this.transparencyValue.newLowValue();
        particle.transparencyDiff = this.transparencyValue.newHighValue() - particle.transparency;
        float f7 = f3 = this.x;
        if (this.xOffsetValue.active) {
            f7 = f3 + this.xOffsetValue.newLowValue();
        }
        f2 = f3 = this.y;
        if (this.yOffsetValue.active) {
            f2 = f3 + this.yOffsetValue.newLowValue();
        }
        if ((n2 = 1.$SwitchMap$com$badlogic$gdx$graphics$g2d$ParticleEmitter$SpawnShape[this.spawnShapeValue.shape.ordinal()]) != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    f = f7;
                    f3 = f2;
                } else {
                    float f8 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f4);
                    float f9 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f4);
                    if (f8 != 0.0f) {
                        f3 = MathUtils.random() * f8;
                        f = f7 + f3;
                        f3 = f2 + f3 * (f9 / f8);
                    } else {
                        f3 = f2 + f9 * MathUtils.random();
                        f = f7;
                    }
                }
            } else {
                float f10 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f4);
                f = this.spawnHeight;
                f3 = this.spawnHeightDiff;
                float f11 = this.spawnHeightValue.getScale(f4);
                float f12 = f10 / 2.0f;
                f11 = (f + f3 * f11) / 2.0f;
                f = f7;
                f3 = f2;
                if (f12 != 0.0f) {
                    if (f11 == 0.0f) {
                        f = f7;
                        f3 = f2;
                    } else {
                        f3 = f12 / f11;
                        if (this.spawnShapeValue.edges) {
                            n2 = 1.$SwitchMap$com$badlogic$gdx$graphics$g2d$ParticleEmitter$SpawnEllipseSide[this.spawnShapeValue.side.ordinal()];
                            f10 = n2 != 1 ? (n2 != 2 ? MathUtils.random(360.0f) : MathUtils.random(179.0f)) : -MathUtils.random(179.0f);
                            float f13 = MathUtils.cosDeg(f10);
                            f11 = MathUtils.sinDeg(f10);
                            f2 += f12 * f11 / f3;
                            f = f7 += f13 * f12;
                            f3 = f2;
                            if (n == 0) {
                                particle.angle = f10;
                                particle.angleCos = f13;
                                particle.angleSin = f11;
                                f = f7;
                                f3 = f2;
                            }
                        } else {
                            while (!((f = MathUtils.random(f10) - f12) * f + (f11 = MathUtils.random(f10) - f12) * f11 <= f12 * f12)) {
                            }
                            f = f7 + f;
                            f3 = f2 + f11 / f3;
                        }
                    }
                }
            }
        } else {
            f = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f4);
            f3 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f4);
            f = f7 + (MathUtils.random(f) - f / 2.0f);
            f3 = f2 + (MathUtils.random(f3) - f3 / 2.0f);
        }
        particle.setBounds(f - f5 / 2.0f, f3 - f6 / 2.0f, f5, f6);
        n2 = (int)((float)this.lifeOffset + (float)this.lifeOffsetDiff * this.lifeOffsetValue.getScale(f4));
        if (n2 > 0) {
            n = n2;
            if (n2 >= particle.currentLife) {
                n = particle.currentLife - 1;
            }
            this.updateParticle(particle, (float)n / 1000.0f, n);
        }
    }

    private void generateLifeOffsetValues() {
        int n = this.lifeOffsetValue.active ? (int)this.lifeOffsetValue.newLowValue() : 0;
        this.lifeOffset = n;
        this.lifeOffsetDiff = (int)this.lifeOffsetValue.newHighValue();
        if (!this.lifeOffsetValue.isRelative()) {
            this.lifeOffsetDiff -= this.lifeOffset;
        }
    }

    private void generateLifeValues() {
        this.life = (int)this.lifeValue.newLowValue();
        this.lifeDiff = (int)this.lifeValue.newHighValue();
        if (!this.lifeValue.isRelative()) {
            this.lifeDiff -= this.life;
        }
    }

    private void initialize() {
        this.sprites = new Array();
        this.imagePaths = new Array();
        this.durationValue.setAlwaysActive(true);
        this.emissionValue.setAlwaysActive(true);
        this.lifeValue.setAlwaysActive(true);
        this.xScaleValue.setAlwaysActive(true);
        this.transparencyValue.setAlwaysActive(true);
        this.spawnShapeValue.setAlwaysActive(true);
        this.spawnWidthValue.setAlwaysActive(true);
        this.spawnHeightValue.setAlwaysActive(true);
    }

    static boolean readBoolean(BufferedReader bufferedReader, String string2) throws IOException {
        return Boolean.parseBoolean(ParticleEmitter.readString(bufferedReader, string2));
    }

    static boolean readBoolean(String string2) throws IOException {
        return Boolean.parseBoolean(ParticleEmitter.readString(string2));
    }

    static float readFloat(BufferedReader bufferedReader, String string2) throws IOException {
        return Float.parseFloat(ParticleEmitter.readString(bufferedReader, string2));
    }

    static int readInt(BufferedReader bufferedReader, String string2) throws IOException {
        return Integer.parseInt(ParticleEmitter.readString(bufferedReader, string2));
    }

    static String readString(BufferedReader object, String string2) throws IOException {
        if ((object = ((BufferedReader)object).readLine()) != null) {
            return ParticleEmitter.readString((String)object);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Missing value: ");
        ((StringBuilder)object).append(string2);
        throw new IOException(((StringBuilder)object).toString());
    }

    static String readString(String string2) throws IOException {
        return string2.substring(string2.indexOf(":") + 1).trim();
    }

    private void restart() {
        float f = this.delayValue.active ? this.delayValue.newLowValue() : 0.0f;
        this.delay = f;
        this.delayTimer = 0.0f;
        this.durationTimer -= this.duration;
        this.duration = this.durationValue.newLowValue();
        this.emission = (int)this.emissionValue.newLowValue();
        this.emissionDiff = (int)this.emissionValue.newHighValue();
        if (!this.emissionValue.isRelative()) {
            this.emissionDiff -= this.emission;
        }
        if (!this.lifeValue.independent) {
            this.generateLifeValues();
        }
        if (!this.lifeOffsetValue.independent) {
            this.generateLifeOffsetValues();
        }
        this.spawnWidth = this.spawnWidthValue.newLowValue();
        this.spawnWidthDiff = this.spawnWidthValue.newHighValue();
        if (!this.spawnWidthValue.isRelative()) {
            this.spawnWidthDiff -= this.spawnWidth;
        }
        this.spawnHeight = this.spawnHeightValue.newLowValue();
        this.spawnHeightDiff = this.spawnHeightValue.newHighValue();
        if (!this.spawnHeightValue.isRelative()) {
            this.spawnHeightDiff -= this.spawnHeight;
        }
        this.updateFlags = 0;
        if (this.angleValue.active && this.angleValue.timeline.length > 1) {
            this.updateFlags |= 2;
        }
        if (this.velocityValue.active) {
            this.updateFlags |= 8;
        }
        if (this.xScaleValue.timeline.length > 1) {
            this.updateFlags |= 1;
        }
        if (this.yScaleValue.active && this.yScaleValue.timeline.length > 1) {
            this.updateFlags |= 1;
        }
        if (this.rotationValue.active && this.rotationValue.timeline.length > 1) {
            this.updateFlags |= 4;
        }
        if (this.windValue.active) {
            this.updateFlags |= 0x10;
        }
        if (this.gravityValue.active) {
            this.updateFlags |= 0x20;
        }
        if (this.tintValue.timeline.length > 1) {
            this.updateFlags |= 0x40;
        }
        if (this.spriteMode == SpriteMode.animated) {
            this.updateFlags |= 0x80;
        }
    }

    private boolean updateParticle(Particle particle, float f, int n) {
        float f2;
        float f3;
        float f4;
        block22: {
            block18: {
                float f5;
                float f6;
                block20: {
                    float f7;
                    block21: {
                        block19: {
                            float f8;
                            if ((n = particle.currentLife - n) <= 0) {
                                return false;
                            }
                            particle.currentLife = n;
                            f4 = (float)particle.currentLife / (float)particle.life;
                            f3 = 1.0f;
                            f2 = 1.0f - f4;
                            n = this.updateFlags;
                            if ((n & 1) != 0) {
                                if (this.yScaleValue.active) {
                                    particle.setScale(particle.xScale + particle.xScaleDiff * this.xScaleValue.getScale(f2), particle.yScale + particle.yScaleDiff * this.yScaleValue.getScale(f2));
                                } else {
                                    particle.setScale(particle.xScale + particle.xScaleDiff * this.xScaleValue.getScale(f2));
                                }
                            }
                            if ((n & 8) == 0) break block18;
                            f4 = (particle.velocity + particle.velocityDiff * this.velocityValue.getScale(f2)) * f;
                            if ((n & 2) == 0) break block19;
                            float f9 = particle.angle + particle.angleDiff * this.angleValue.getScale(f2);
                            f6 = MathUtils.cosDeg(f9) * f4;
                            f4 = f8 = f4 * MathUtils.sinDeg(f9);
                            f5 = f6;
                            if ((n & 4) != 0) {
                                f4 = f5 = particle.rotation + particle.rotationDiff * this.rotationValue.getScale(f2);
                                if (this.aligned) {
                                    f4 = f5 + f9;
                                }
                                particle.setRotation(f4);
                                f4 = f8;
                                f5 = f6;
                            }
                            break block20;
                        }
                        f6 = f4 * particle.angleCos;
                        f7 = f4 * particle.angleSin;
                        if (this.aligned) break block21;
                        f4 = f7;
                        f5 = f6;
                        if ((n & 4) == 0) break block20;
                    }
                    f4 = f5 = particle.rotation + particle.rotationDiff * this.rotationValue.getScale(f2);
                    if (this.aligned) {
                        f4 = f5 + particle.angle;
                    }
                    particle.setRotation(f4);
                    f5 = f6;
                    f4 = f7;
                }
                f6 = f5;
                if ((n & 0x10) != 0) {
                    f6 = f5 + (particle.wind + particle.windDiff * this.windValue.getScale(f2)) * f;
                }
                f5 = f4;
                if ((n & 0x20) != 0) {
                    f5 = f4 + (particle.gravity + particle.gravityDiff * this.gravityValue.getScale(f2)) * f;
                }
                particle.translate(f6, f5);
                break block22;
            }
            if ((n & 4) != 0) {
                particle.setRotation(particle.rotation + particle.rotationDiff * this.rotationValue.getScale(f2));
            }
        }
        Object object = (n & 0x40) != 0 ? this.tintValue.getColor(f2) : particle.tint;
        if (this.premultipliedAlpha) {
            f = f3;
            if (this.additive) {
                f = 0.0f;
            }
            f4 = particle.transparency + particle.transparencyDiff * this.transparencyValue.getScale(f2);
            particle.setColor(object[0] * f4, object[1] * f4, object[2] * f4, f4 * f);
        } else {
            particle.setColor(object[0], object[1], object[2], particle.transparency + particle.transparencyDiff * this.transparencyValue.getScale(f2));
        }
        if ((n & 0x80) != 0 && particle.frame != (n = Math.min((int)(f2 * (float)this.sprites.size), this.sprites.size - 1))) {
            object = this.sprites.get(n);
            f4 = particle.getWidth();
            f = particle.getHeight();
            particle.setRegion((TextureRegion)object);
            particle.setSize(object.getWidth(), object.getHeight());
            particle.setOrigin(object.getOriginX(), object.getOriginY());
            particle.translate((f4 - object.getWidth()) / 2.0f, (f - object.getHeight()) / 2.0f);
            particle.frame = n;
        }
        return true;
    }

    public void addParticle() {
        int n = this.activeCount;
        if (n == this.maxParticleCount) {
            return;
        }
        boolean[] blArray = this.active;
        int n2 = blArray.length;
        for (int i = 0; i < n2; ++i) {
            if (blArray[i]) continue;
            this.activateParticle(i);
            blArray[i] = true;
            this.activeCount = n + 1;
            break;
        }
    }

    public void addParticles(int n) {
        int n2 = Math.min(n, this.maxParticleCount - this.activeCount);
        if (n2 == 0) {
            return;
        }
        boolean[] blArray = this.active;
        int n3 = blArray.length;
        int n4 = 0;
        n = 0;
        block0: while (n4 < n2) {
            while (n < n3) {
                if (!blArray[n]) {
                    this.activateParticle(n);
                    blArray[n] = true;
                    ++n4;
                    ++n;
                    continue block0;
                }
                ++n;
            }
            break block0;
        }
        this.activeCount += n2;
    }

    public void allowCompletion() {
        this.allowCompletion = true;
        this.durationTimer = this.duration;
    }

    public boolean cleansUpBlendFunction() {
        return this.cleansUpBlendFunction;
    }

    public void draw(Batch batch) {
        if (this.premultipliedAlpha) {
            batch.setBlendFunction(1, 771);
        } else if (this.additive) {
            batch.setBlendFunction(770, 1);
        } else {
            batch.setBlendFunction(770, 771);
        }
        Particle[] particleArray = this.particles;
        boolean[] blArray = this.active;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            particleArray[i].draw(batch);
        }
        if (this.cleansUpBlendFunction && (this.additive || this.premultipliedAlpha)) {
            batch.setBlendFunction(770, 771);
        }
    }

    public void draw(Batch batch, float f) {
        block19: {
            int n;
            int n2;
            int n3;
            block18: {
                block17: {
                    this.accumulator += f * 1000.0f;
                    float f2 = this.accumulator;
                    if (f2 < 1.0f) {
                        this.draw(batch);
                        return;
                    }
                    n3 = (int)f2;
                    float f3 = n3;
                    this.accumulator = f2 - f3;
                    if (this.premultipliedAlpha) {
                        batch.setBlendFunction(1, 771);
                    } else if (this.additive) {
                        batch.setBlendFunction(770, 1);
                    } else {
                        batch.setBlendFunction(770, 771);
                    }
                    Particle[] particleArray = this.particles;
                    boolean[] blArray = this.active;
                    n2 = this.activeCount;
                    int n4 = blArray.length;
                    for (int i = 0; i < n4; ++i) {
                        n = n2;
                        if (blArray[i]) {
                            Particle particle = particleArray[i];
                            if (this.updateParticle(particle, f, n3)) {
                                particle.draw(batch);
                                n = n2;
                            } else {
                                blArray[i] = false;
                                n = n2 - 1;
                            }
                        }
                        n2 = n;
                    }
                    this.activeCount = n2;
                    if (this.cleansUpBlendFunction && (this.additive || this.premultipliedAlpha)) {
                        batch.setBlendFunction(770, 771);
                    }
                    if ((f = this.delayTimer) < this.delay) {
                        this.delayTimer = f + f3;
                        return;
                    }
                    if (this.firstUpdate) {
                        this.firstUpdate = false;
                        this.addParticle();
                    }
                    if (!((f = this.durationTimer) < this.duration)) break block17;
                    this.durationTimer = f + f3;
                    break block18;
                }
                if (!this.continuous || this.allowCompletion) break block19;
                this.restart();
            }
            this.emissionDelta += n3;
            f = (float)this.emission + (float)this.emissionDiff * this.emissionValue.getScale(this.durationTimer / this.duration);
            if (f > 0.0f && (float)(n = this.emissionDelta) >= (f = 1000.0f / f)) {
                n = Math.min((int)((float)n / f), this.maxParticleCount - n2);
                this.emissionDelta = (int)((float)this.emissionDelta - (float)n * f);
                this.emissionDelta = (int)((float)this.emissionDelta % f);
                this.addParticles(n);
            }
            if (n2 < (n = this.minParticleCount)) {
                this.addParticles(n - n2);
            }
        }
    }

    public void flipY() {
        RangedNumericValue rangedNumericValue = this.angleValue;
        ((ScaledNumericValue)rangedNumericValue).setHigh(-((ScaledNumericValue)rangedNumericValue).getHighMin(), -this.angleValue.getHighMax());
        rangedNumericValue = this.angleValue;
        rangedNumericValue.setLow(-rangedNumericValue.getLowMin(), -this.angleValue.getLowMax());
        rangedNumericValue = this.gravityValue;
        ((ScaledNumericValue)rangedNumericValue).setHigh(-((ScaledNumericValue)rangedNumericValue).getHighMin(), -this.gravityValue.getHighMax());
        rangedNumericValue = this.gravityValue;
        rangedNumericValue.setLow(-rangedNumericValue.getLowMin(), -this.gravityValue.getLowMax());
        rangedNumericValue = this.windValue;
        ((ScaledNumericValue)rangedNumericValue).setHigh(-((ScaledNumericValue)rangedNumericValue).getHighMin(), -this.windValue.getHighMax());
        rangedNumericValue = this.windValue;
        rangedNumericValue.setLow(-rangedNumericValue.getLowMin(), -this.windValue.getLowMax());
        rangedNumericValue = this.rotationValue;
        ((ScaledNumericValue)rangedNumericValue).setHigh(-((ScaledNumericValue)rangedNumericValue).getHighMin(), -this.rotationValue.getHighMax());
        rangedNumericValue = this.rotationValue;
        rangedNumericValue.setLow(-rangedNumericValue.getLowMin(), -this.rotationValue.getLowMax());
        rangedNumericValue = this.yOffsetValue;
        rangedNumericValue.setLow(-rangedNumericValue.getLowMin(), -this.yOffsetValue.getLowMax());
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public ScaledNumericValue getAngle() {
        return this.angleValue;
    }

    public BoundingBox getBoundingBox() {
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        Particle[] particleArray = this.particles;
        boolean[] blArray = this.active;
        BoundingBox boundingBox = this.bounds;
        boundingBox.inf();
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            Rectangle rectangle = particleArray[i].getBoundingRectangle();
            boundingBox.ext(rectangle.x, rectangle.y, 0.0f);
            boundingBox.ext(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f);
        }
        return boundingBox;
    }

    public RangedNumericValue getDelay() {
        return this.delayValue;
    }

    public RangedNumericValue getDuration() {
        return this.durationValue;
    }

    public ScaledNumericValue getEmission() {
        return this.emissionValue;
    }

    public ScaledNumericValue getGravity() {
        return this.gravityValue;
    }

    public Array<String> getImagePaths() {
        return this.imagePaths;
    }

    public ScaledNumericValue getLife() {
        return this.lifeValue;
    }

    public ScaledNumericValue getLifeOffset() {
        return this.lifeOffsetValue;
    }

    public int getMaxParticleCount() {
        return this.maxParticleCount;
    }

    public int getMinParticleCount() {
        return this.minParticleCount;
    }

    protected RangedNumericValue[] getMotionValues() {
        if (this.motionValues == null) {
            RangedNumericValue[] rangedNumericValueArray = this.motionValues = new RangedNumericValue[3];
            rangedNumericValueArray[0] = this.velocityValue;
            rangedNumericValueArray[1] = this.windValue;
            rangedNumericValueArray[2] = this.gravityValue;
        }
        return this.motionValues;
    }

    public String getName() {
        return this.name;
    }

    protected Particle[] getParticles() {
        return this.particles;
    }

    public float getPercentComplete() {
        if (this.delayTimer < this.delay) {
            return 0.0f;
        }
        return Math.min(1.0f, this.durationTimer / this.duration);
    }

    public ScaledNumericValue getRotation() {
        return this.rotationValue;
    }

    public ScaledNumericValue getSpawnHeight() {
        return this.spawnHeightValue;
    }

    public SpawnShapeValue getSpawnShape() {
        return this.spawnShapeValue;
    }

    public ScaledNumericValue getSpawnWidth() {
        return this.spawnWidthValue;
    }

    public SpriteMode getSpriteMode() {
        return this.spriteMode;
    }

    public Array<Sprite> getSprites() {
        return this.sprites;
    }

    public GradientColorValue getTint() {
        return this.tintValue;
    }

    public ScaledNumericValue getTransparency() {
        return this.transparencyValue;
    }

    public ScaledNumericValue getVelocity() {
        return this.velocityValue;
    }

    public ScaledNumericValue getWind() {
        return this.windValue;
    }

    public float getX() {
        return this.x;
    }

    public RangedNumericValue getXOffsetValue() {
        return this.xOffsetValue;
    }

    public ScaledNumericValue getXScale() {
        return this.xScaleValue;
    }

    protected RangedNumericValue[] getXSizeValues() {
        if (this.xSizeValues == null) {
            RangedNumericValue[] rangedNumericValueArray = this.xSizeValues = new RangedNumericValue[3];
            rangedNumericValueArray[0] = this.xScaleValue;
            rangedNumericValueArray[1] = this.spawnWidthValue;
            rangedNumericValueArray[2] = this.xOffsetValue;
        }
        return this.xSizeValues;
    }

    public float getY() {
        return this.y;
    }

    public RangedNumericValue getYOffsetValue() {
        return this.yOffsetValue;
    }

    public ScaledNumericValue getYScale() {
        return this.yScaleValue;
    }

    protected RangedNumericValue[] getYSizeValues() {
        if (this.ySizeValues == null) {
            RangedNumericValue[] rangedNumericValueArray = this.ySizeValues = new RangedNumericValue[3];
            rangedNumericValueArray[0] = this.yScaleValue;
            rangedNumericValueArray[1] = this.spawnHeightValue;
            rangedNumericValueArray[2] = this.yOffsetValue;
        }
        return this.ySizeValues;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean isBehind() {
        return this.behind;
    }

    public boolean isComplete() {
        boolean bl = this.continuous;
        boolean bl2 = false;
        if (bl && !this.allowCompletion) {
            return false;
        }
        if (this.delayTimer < this.delay) {
            return false;
        }
        bl = bl2;
        if (this.durationTimer >= this.duration) {
            bl = bl2;
            if (this.activeCount == 0) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public boolean isPremultipliedAlpha() {
        return this.premultipliedAlpha;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(BufferedReader object) throws IOException {
        try {
            this.name = ParticleEmitter.readString((BufferedReader)object, "name");
            ((BufferedReader)object).readLine();
            this.delayValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.durationValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.setMinParticleCount(ParticleEmitter.readInt((BufferedReader)object, "minParticleCount"));
            this.setMaxParticleCount(ParticleEmitter.readInt((BufferedReader)object, "maxParticleCount"));
            ((BufferedReader)object).readLine();
            this.emissionValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.lifeValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.lifeOffsetValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.xOffsetValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.yOffsetValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.spawnShapeValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.spawnWidthValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.spawnHeightValue.load((BufferedReader)object);
            if (((BufferedReader)object).readLine().trim().equals("- Scale -")) {
                this.xScaleValue.load((BufferedReader)object);
                this.yScaleValue.setActive(false);
            } else {
                this.xScaleValue.load((BufferedReader)object);
                ((BufferedReader)object).readLine();
                this.yScaleValue.load((BufferedReader)object);
            }
            ((BufferedReader)object).readLine();
            this.velocityValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.angleValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.rotationValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.windValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.gravityValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.tintValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.transparencyValue.load((BufferedReader)object);
            ((BufferedReader)object).readLine();
            this.attached = ParticleEmitter.readBoolean((BufferedReader)object, "attached");
            this.continuous = ParticleEmitter.readBoolean((BufferedReader)object, "continuous");
            this.aligned = ParticleEmitter.readBoolean((BufferedReader)object, "aligned");
            this.additive = ParticleEmitter.readBoolean((BufferedReader)object, "additive");
            this.behind = ParticleEmitter.readBoolean((BufferedReader)object, "behind");
            String string2 = ((BufferedReader)object).readLine();
            Array<String> array = string2;
            if (string2.startsWith("premultipliedAlpha")) {
                this.premultipliedAlpha = ParticleEmitter.readBoolean(string2);
                array = ((BufferedReader)object).readLine();
            }
            if (((String)((Object)array)).startsWith("spriteMode")) {
                this.spriteMode = SpriteMode.valueOf(ParticleEmitter.readString((String)((Object)array)));
                ((BufferedReader)object).readLine();
            }
            array = new Array<String>();
            while ((string2 = ((BufferedReader)object).readLine()) != null && !string2.isEmpty()) {
                array.add(string2);
            }
            this.setImagePaths(array);
            return;
        }
        catch (RuntimeException runtimeException) {
            if (this.name == null) {
                throw runtimeException;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Error parsing emitter: ");
            ((StringBuilder)object).append(this.name);
            object = new RuntimeException(((StringBuilder)object).toString(), runtimeException);
            throw object;
        }
    }

    public void matchMotion(ParticleEmitter rangedNumericValueArray) {
        RangedNumericValue[] rangedNumericValueArray2 = this.getMotionValues();
        rangedNumericValueArray = rangedNumericValueArray.getMotionValues();
        for (int i = 0; i < rangedNumericValueArray2.length; ++i) {
            rangedNumericValueArray2[i].set(rangedNumericValueArray[i]);
        }
    }

    public void matchSize(ParticleEmitter particleEmitter) {
        this.matchXSize(particleEmitter);
        this.matchYSize(particleEmitter);
    }

    public void matchXSize(ParticleEmitter rangedNumericValueArray) {
        RangedNumericValue[] rangedNumericValueArray2 = this.getXSizeValues();
        rangedNumericValueArray = rangedNumericValueArray.getXSizeValues();
        for (int i = 0; i < rangedNumericValueArray2.length; ++i) {
            rangedNumericValueArray2[i].set(rangedNumericValueArray[i]);
        }
    }

    public void matchYSize(ParticleEmitter rangedNumericValueArray) {
        RangedNumericValue[] rangedNumericValueArray2 = this.getYSizeValues();
        rangedNumericValueArray = rangedNumericValueArray.getYSizeValues();
        for (int i = 0; i < rangedNumericValueArray2.length; ++i) {
            rangedNumericValueArray2[i].set(rangedNumericValueArray[i]);
        }
    }

    protected Particle newParticle(Sprite sprite) {
        return new Particle(sprite);
    }

    public void reset() {
        this.emissionDelta = 0;
        this.durationTimer = this.duration;
        boolean[] blArray = this.active;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
        }
        this.activeCount = 0;
        this.start();
    }

    public void save(Writer writer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        writer.write("- Delay -\n");
        this.delayValue.save(writer);
        writer.write("- Duration - \n");
        this.durationValue.save(writer);
        writer.write("- Count - \n");
        stringBuilder = new StringBuilder();
        stringBuilder.append("min: ");
        stringBuilder.append(this.minParticleCount);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("max: ");
        stringBuilder.append(this.maxParticleCount);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        writer.write("- Emission - \n");
        this.emissionValue.save(writer);
        writer.write("- Life - \n");
        this.lifeValue.save(writer);
        writer.write("- Life Offset - \n");
        this.lifeOffsetValue.save(writer);
        writer.write("- X Offset - \n");
        this.xOffsetValue.save(writer);
        writer.write("- Y Offset - \n");
        this.yOffsetValue.save(writer);
        writer.write("- Spawn Shape - \n");
        this.spawnShapeValue.save(writer);
        writer.write("- Spawn Width - \n");
        this.spawnWidthValue.save(writer);
        writer.write("- Spawn Height - \n");
        this.spawnHeightValue.save(writer);
        writer.write("- X Scale - \n");
        this.xScaleValue.save(writer);
        writer.write("- Y Scale - \n");
        this.yScaleValue.save(writer);
        writer.write("- Velocity - \n");
        this.velocityValue.save(writer);
        writer.write("- Angle - \n");
        this.angleValue.save(writer);
        writer.write("- Rotation - \n");
        this.rotationValue.save(writer);
        writer.write("- Wind - \n");
        this.windValue.save(writer);
        writer.write("- Gravity - \n");
        this.gravityValue.save(writer);
        writer.write("- Tint - \n");
        this.tintValue.save(writer);
        writer.write("- Transparency - \n");
        this.transparencyValue.save(writer);
        writer.write("- Options - \n");
        stringBuilder = new StringBuilder();
        stringBuilder.append("attached: ");
        stringBuilder.append(this.attached);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("continuous: ");
        stringBuilder.append(this.continuous);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("aligned: ");
        stringBuilder.append(this.aligned);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("additive: ");
        stringBuilder.append(this.additive);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("behind: ");
        stringBuilder.append(this.behind);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("premultipliedAlpha: ");
        stringBuilder.append(this.premultipliedAlpha);
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("spriteMode: ");
        stringBuilder.append(this.spriteMode.toString());
        stringBuilder.append("\n");
        writer.write(stringBuilder.toString());
        writer.write("- Image Paths -\n");
        for (String string2 : this.imagePaths) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
        }
        writer.write("\n");
    }

    public void scaleMotion(float f) {
        if (f == 1.0f) {
            return;
        }
        RangedNumericValue[] rangedNumericValueArray = this.getMotionValues();
        int n = rangedNumericValueArray.length;
        for (int i = 0; i < n; ++i) {
            rangedNumericValueArray[i].scale(f);
        }
    }

    public void scaleSize(float f) {
        if (f == 1.0f) {
            return;
        }
        this.scaleSize(f, f);
    }

    public void scaleSize(float f, float f2) {
        int n;
        if (f == 1.0f && f2 == 1.0f) {
            return;
        }
        RangedNumericValue[] rangedNumericValueArray = this.getXSizeValues();
        int n2 = rangedNumericValueArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            rangedNumericValueArray[n].scale(f);
        }
        rangedNumericValueArray = this.getYSizeValues();
        n2 = rangedNumericValueArray.length;
        for (n = n3; n < n2; ++n) {
            rangedNumericValueArray[n].scale(f2);
        }
    }

    public void setAdditive(boolean bl) {
        this.additive = bl;
    }

    public void setAligned(boolean bl) {
        this.aligned = bl;
    }

    public void setAttached(boolean bl) {
        this.attached = bl;
    }

    public void setBehind(boolean bl) {
        this.behind = bl;
    }

    public void setCleansUpBlendFunction(boolean bl) {
        this.cleansUpBlendFunction = bl;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public void setFlip(boolean bl, boolean bl2) {
        this.flipX = bl;
        this.flipY = bl2;
        Object object = this.particles;
        if (object == null) {
            return;
        }
        int n = ((Particle[])object).length;
        for (int i = 0; i < n; ++i) {
            object = this.particles[i];
            if (object == null) continue;
            ((Sprite)object).flip(bl, bl2);
        }
    }

    public void setImagePaths(Array<String> array) {
        this.imagePaths = array;
    }

    public void setMaxParticleCount(int n) {
        this.maxParticleCount = n;
        this.active = new boolean[n];
        this.activeCount = 0;
        this.particles = new Particle[n];
    }

    public void setMinParticleCount(int n) {
        this.minParticleCount = n;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public void setPosition(float f, float f2) {
        if (this.attached) {
            float f3 = this.x;
            float f4 = this.y;
            boolean[] blArray = this.active;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                if (!blArray[i]) continue;
                this.particles[i].translate(f - f3, f2 - f4);
            }
        }
        this.x = f;
        this.y = f2;
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.premultipliedAlpha = bl;
    }

    public void setSpriteMode(SpriteMode spriteMode) {
        this.spriteMode = spriteMode;
    }

    public void setSprites(Array<Sprite> array) {
        this.sprites = array;
        if (array.size == 0) {
            return;
        }
        for (Particle particle : this.particles) {
            if (particle == null) break;
            Sprite sprite = null;
            int n = 1.$SwitchMap$com$badlogic$gdx$graphics$g2d$ParticleEmitter$SpriteMode[this.spriteMode.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        sprite = array.random();
                    }
                } else {
                    particle.frame = Math.min((int)((1.0f - (float)particle.currentLife / (float)particle.life) * (float)array.size), array.size - 1);
                    sprite = array.get(particle.frame);
                }
            } else {
                sprite = array.first();
            }
            particle.setRegion(sprite);
            particle.setOrigin(sprite.getOriginX(), sprite.getOriginY());
        }
    }

    public void start() {
        this.firstUpdate = true;
        this.allowCompletion = false;
        this.restart();
    }

    /*
     * Unable to fully structure code
     */
    public void update(float var1_1) {
        block11: {
            block12: {
                block10: {
                    this.accumulator += var1_1 * 1000.0f;
                    var2_2 = this.accumulator;
                    if (var2_2 < 1.0f) {
                        return;
                    }
                    var3_3 = (int)var2_2;
                    var4_4 = var3_3;
                    this.accumulator = var2_2 - var4_4;
                    var2_2 = this.delayTimer;
                    if (!(var2_2 < this.delay)) break block10;
                    this.delayTimer = var2_2 + var4_4;
                    break block11;
                }
                if (this.firstUpdate) {
                    this.firstUpdate = false;
                    this.addParticle();
                }
                if (!((var2_2 = this.durationTimer) < this.duration)) break block12;
                this.durationTimer = var2_2 + var4_4;
                ** GOTO lbl22
            }
            if (this.continuous && !this.allowCompletion) {
                this.restart();
lbl22:
                // 2 sources

                var5_5 = 0;
            } else {
                var5_5 = 1;
            }
            if (var5_5 == 0) {
                this.emissionDelta += var3_3;
                var4_4 = (float)this.emission + (float)this.emissionDiff * this.emissionValue.getScale(this.durationTimer / this.duration);
                if (var4_4 > 0.0f && (float)(var5_5 = this.emissionDelta) >= (var4_4 = 1000.0f / var4_4)) {
                    var5_5 = Math.min((int)((float)var5_5 / var4_4), this.maxParticleCount - this.activeCount);
                    this.emissionDelta = (int)((float)this.emissionDelta - (float)var5_5 * var4_4);
                    this.emissionDelta = (int)((float)this.emissionDelta % var4_4);
                    this.addParticles(var5_5);
                }
                if ((var6_6 = this.activeCount) < (var5_5 = this.minParticleCount)) {
                    this.addParticles(var5_5 - var6_6);
                }
            }
        }
        var7_7 = this.active;
        var5_5 = this.activeCount;
        var8_8 = this.particles;
        var9_9 = var7_7.length;
        for (var6_6 = 0; var6_6 < var9_9; ++var6_6) {
            var10_10 = var5_5;
            if (var7_7[var6_6]) {
                var10_10 = var5_5;
                if (!this.updateParticle(var8_8[var6_6], var1_1, var3_3)) {
                    var7_7[var6_6] = false;
                    var10_10 = var5_5 - 1;
                }
            }
            var5_5 = var10_10;
        }
        this.activeCount = var5_5;
    }

    public static class GradientColorValue
    extends ParticleValue {
        private static float[] temp = new float[4];
        private float[] colors = new float[]{1.0f, 1.0f, 1.0f};
        float[] timeline = new float[]{0.0f};

        public GradientColorValue() {
            this.alwaysActive = true;
        }

        public float[] getColor(float f) {
            int n;
            int n2;
            float[] fArray;
            block3: {
                fArray = this.timeline;
                int n3 = fArray.length;
                n2 = 1;
                n = 0;
                while (n2 < n3) {
                    if (!(fArray[n2] > f)) {
                        n = n2++;
                        continue;
                    }
                    break block3;
                }
                n2 = -1;
            }
            float f2 = fArray[n];
            float[] fArray2 = this.colors;
            float f3 = fArray2[n *= 3];
            float f4 = fArray2[n + 1];
            float f5 = fArray2[n + 2];
            if (n2 == -1) {
                fArray2 = temp;
                fArray2[0] = f3;
                fArray2[1] = f4;
                fArray2[2] = f5;
                return fArray2;
            }
            f = (f - f2) / (fArray[n2] - f2);
            fArray = temp;
            fArray[0] = f3 + (fArray2[n2 *= 3] - f3) * f;
            fArray[1] = f4 + (fArray2[n2 + 1] - f4) * f;
            fArray[2] = f5 + (fArray2[n2 + 2] - f5) * f;
            return fArray;
        }

        public float[] getColors() {
            return this.colors;
        }

        public float[] getTimeline() {
            return this.timeline;
        }

        public void load(GradientColorValue object) {
            super.load((ParticleValue)object);
            this.colors = new float[((GradientColorValue)object).colors.length];
            float[] fArray = ((GradientColorValue)object).colors;
            float[] fArray2 = this.colors;
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            this.timeline = new float[((GradientColorValue)object).timeline.length];
            object = ((GradientColorValue)object).timeline;
            fArray2 = this.timeline;
            System.arraycopy(object, 0, fArray2, 0, fArray2.length);
        }

        @Override
        public void load(BufferedReader bufferedReader) throws IOException {
            StringBuilder stringBuilder;
            float[] fArray;
            int n;
            super.load(bufferedReader);
            if (!this.active) {
                return;
            }
            this.colors = new float[ParticleEmitter.readInt(bufferedReader, "colorsCount")];
            int n2 = 0;
            for (n = 0; n < (fArray = this.colors).length; ++n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("colors");
                stringBuilder.append(n);
                fArray[n] = ParticleEmitter.readFloat(bufferedReader, stringBuilder.toString());
            }
            this.timeline = new float[ParticleEmitter.readInt(bufferedReader, "timelineCount")];
            for (n = n2; n < (fArray = this.timeline).length; ++n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("timeline");
                stringBuilder.append(n);
                fArray[n] = ParticleEmitter.readFloat(bufferedReader, stringBuilder.toString());
            }
        }

        @Override
        public void save(Writer writer) throws IOException {
            int n;
            super.save(writer);
            if (!this.active) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("colorsCount: ");
            stringBuilder.append(this.colors.length);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            int n2 = 0;
            for (n = 0; n < this.colors.length; ++n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("colors");
                stringBuilder.append(n);
                stringBuilder.append(": ");
                stringBuilder.append(this.colors[n]);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("timelineCount: ");
            stringBuilder.append(this.timeline.length);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            for (n = n2; n < this.timeline.length; ++n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("timeline");
                stringBuilder.append(n);
                stringBuilder.append(": ");
                stringBuilder.append(this.timeline[n]);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
            }
        }

        public void setColors(float[] fArray) {
            this.colors = fArray;
        }

        public void setTimeline(float[] fArray) {
            this.timeline = fArray;
        }
    }

    public static class IndependentScaledNumericValue
    extends ScaledNumericValue {
        boolean independent;

        public boolean isIndependent() {
            return this.independent;
        }

        public void load(IndependentScaledNumericValue independentScaledNumericValue) {
            super.load(independentScaledNumericValue);
            this.independent = independentScaledNumericValue.independent;
        }

        @Override
        public void load(BufferedReader bufferedReader) throws IOException {
            block4: {
                block7: {
                    block6: {
                        block5: {
                            String string2;
                            super.load(bufferedReader);
                            if (bufferedReader.markSupported()) {
                                bufferedReader.mark(100);
                            }
                            if ((string2 = bufferedReader.readLine()) == null) break block4;
                            if (!string2.contains("independent")) break block5;
                            this.independent = Boolean.parseBoolean(ParticleEmitter.readString(string2));
                            break block6;
                        }
                        if (!bufferedReader.markSupported()) break block7;
                        bufferedReader.reset();
                    }
                    return;
                }
                Gdx.app.error("ParticleEmitter", "The loaded particle effect descriptor file uses an old invalid format. Please download the latest version of the Particle Editor tool and recreate the file by loading and saving it again.");
                throw new IOException("The loaded particle effect descriptor file uses an old invalid format. Please download the latest version of the Particle Editor tool and recreate the file by loading and saving it again.");
            }
            throw new IOException("Missing value: independent");
        }

        @Override
        public void save(Writer writer) throws IOException {
            super.save(writer);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("independent: ");
            stringBuilder.append(this.independent);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
        }

        public void set(IndependentScaledNumericValue independentScaledNumericValue) {
            super.set(independentScaledNumericValue);
            this.independent = independentScaledNumericValue.independent;
        }

        @Override
        public void set(RangedNumericValue rangedNumericValue) {
            if (rangedNumericValue instanceof IndependentScaledNumericValue) {
                this.set((IndependentScaledNumericValue)rangedNumericValue);
            } else {
                super.set(rangedNumericValue);
            }
        }

        @Override
        public void set(ScaledNumericValue scaledNumericValue) {
            if (scaledNumericValue instanceof IndependentScaledNumericValue) {
                this.set((IndependentScaledNumericValue)scaledNumericValue);
            } else {
                super.set(scaledNumericValue);
            }
        }

        public void setIndependent(boolean bl) {
            this.independent = bl;
        }
    }

    public static class NumericValue
    extends ParticleValue {
        private float value;

        public float getValue() {
            return this.value;
        }

        public void load(NumericValue numericValue) {
            super.load(numericValue);
            this.value = numericValue.value;
        }

        @Override
        public void load(BufferedReader bufferedReader) throws IOException {
            super.load(bufferedReader);
            if (!this.active) {
                return;
            }
            this.value = ParticleEmitter.readFloat(bufferedReader, "value");
        }

        @Override
        public void save(Writer writer) throws IOException {
            super.save(writer);
            if (!this.active) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("value: ");
            stringBuilder.append(this.value);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
        }

        public void setValue(float f) {
            this.value = f;
        }
    }

    public static class Particle
    extends Sprite {
        protected float angle;
        protected float angleCos;
        protected float angleDiff;
        protected float angleSin;
        protected int currentLife;
        protected int frame;
        protected float gravity;
        protected float gravityDiff;
        protected int life;
        protected float rotation;
        protected float rotationDiff;
        protected float[] tint;
        protected float transparency;
        protected float transparencyDiff;
        protected float velocity;
        protected float velocityDiff;
        protected float wind;
        protected float windDiff;
        protected float xScale;
        protected float xScaleDiff;
        protected float yScale;
        protected float yScaleDiff;

        public Particle(Sprite sprite) {
            super(sprite);
        }
    }

    public static class ParticleValue {
        boolean active;
        boolean alwaysActive;

        public boolean isActive() {
            boolean bl = this.alwaysActive || this.active;
            return bl;
        }

        public boolean isAlwaysActive() {
            return this.alwaysActive;
        }

        public void load(ParticleValue particleValue) {
            this.active = particleValue.active;
            this.alwaysActive = particleValue.alwaysActive;
        }

        public void load(BufferedReader bufferedReader) throws IOException {
            this.active = !this.alwaysActive ? ParticleEmitter.readBoolean(bufferedReader, "active") : true;
        }

        public void save(Writer writer) throws IOException {
            if (!this.alwaysActive) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("active: ");
                stringBuilder.append(this.active);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
            } else {
                this.active = true;
            }
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public void setAlwaysActive(boolean bl) {
            this.alwaysActive = bl;
        }
    }

    public static class RangedNumericValue
    extends ParticleValue {
        private float lowMax;
        private float lowMin;

        public float getLowMax() {
            return this.lowMax;
        }

        public float getLowMin() {
            return this.lowMin;
        }

        public void load(RangedNumericValue rangedNumericValue) {
            super.load(rangedNumericValue);
            this.lowMax = rangedNumericValue.lowMax;
            this.lowMin = rangedNumericValue.lowMin;
        }

        @Override
        public void load(BufferedReader bufferedReader) throws IOException {
            super.load(bufferedReader);
            if (!this.active) {
                return;
            }
            this.lowMin = ParticleEmitter.readFloat(bufferedReader, "lowMin");
            this.lowMax = ParticleEmitter.readFloat(bufferedReader, "lowMax");
        }

        public float newLowValue() {
            float f = this.lowMin;
            return f + (this.lowMax - f) * MathUtils.random();
        }

        @Override
        public void save(Writer writer) throws IOException {
            super.save(writer);
            if (!this.active) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("lowMin: ");
            stringBuilder.append(this.lowMin);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("lowMax: ");
            stringBuilder.append(this.lowMax);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
        }

        public void scale(float f) {
            this.lowMin *= f;
            this.lowMax *= f;
        }

        public void set(RangedNumericValue rangedNumericValue) {
            this.lowMin = rangedNumericValue.lowMin;
            this.lowMax = rangedNumericValue.lowMax;
        }

        public void setLow(float f) {
            this.lowMin = f;
            this.lowMax = f;
        }

        public void setLow(float f, float f2) {
            this.lowMin = f;
            this.lowMax = f2;
        }

        public void setLowMax(float f) {
            this.lowMax = f;
        }

        public void setLowMin(float f) {
            this.lowMin = f;
        }
    }

    public static class ScaledNumericValue
    extends RangedNumericValue {
        private float highMax;
        private float highMin;
        private boolean relative;
        private float[] scaling = new float[]{1.0f};
        float[] timeline = new float[]{0.0f};

        public float getHighMax() {
            return this.highMax;
        }

        public float getHighMin() {
            return this.highMin;
        }

        public float getScale(float f) {
            int n;
            int n2;
            float[] fArray;
            block3: {
                fArray = this.timeline;
                n2 = fArray.length;
                for (n = 1; n < n2; ++n) {
                    if (!(fArray[n] > f)) {
                        continue;
                    }
                    break block3;
                }
                n = -1;
            }
            if (n == -1) {
                return this.scaling[n2 - 1];
            }
            float[] fArray2 = this.scaling;
            n2 = n - 1;
            float f2 = fArray2[n2];
            float f3 = fArray[n2];
            return f2 + (fArray2[n] - f2) * ((f - f3) / (fArray[n] - f3));
        }

        public float[] getScaling() {
            return this.scaling;
        }

        public float[] getTimeline() {
            return this.timeline;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void load(ScaledNumericValue scaledNumericValue) {
            super.load(scaledNumericValue);
            this.highMax = scaledNumericValue.highMax;
            this.highMin = scaledNumericValue.highMin;
            this.scaling = new float[scaledNumericValue.scaling.length];
            float[] fArray = scaledNumericValue.scaling;
            float[] fArray2 = this.scaling;
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            this.timeline = new float[scaledNumericValue.timeline.length];
            fArray = scaledNumericValue.timeline;
            fArray2 = this.timeline;
            System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            this.relative = scaledNumericValue.relative;
        }

        @Override
        public void load(BufferedReader bufferedReader) throws IOException {
            Object object;
            Object object2;
            int n;
            super.load(bufferedReader);
            if (!this.active) {
                return;
            }
            this.highMin = ParticleEmitter.readFloat(bufferedReader, "highMin");
            this.highMax = ParticleEmitter.readFloat(bufferedReader, "highMax");
            this.relative = ParticleEmitter.readBoolean(bufferedReader, "relative");
            this.scaling = new float[ParticleEmitter.readInt(bufferedReader, "scalingCount")];
            int n2 = 0;
            for (n = 0; n < ((float[])(object2 = this.scaling)).length; ++n) {
                object = new StringBuilder();
                ((StringBuilder)object).append("scaling");
                ((StringBuilder)object).append(n);
                object2[n] = ParticleEmitter.readFloat(bufferedReader, ((StringBuilder)object).toString());
            }
            this.timeline = new float[ParticleEmitter.readInt(bufferedReader, "timelineCount")];
            for (n = n2; n < ((Object)(object = (Object)this.timeline)).length; ++n) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("timeline");
                ((StringBuilder)object2).append(n);
                object[n] = ParticleEmitter.readFloat(bufferedReader, ((StringBuilder)object2).toString());
            }
        }

        public float newHighValue() {
            float f = this.highMin;
            return f + (this.highMax - f) * MathUtils.random();
        }

        @Override
        public void save(Writer writer) throws IOException {
            int n;
            super.save(writer);
            if (!this.active) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("highMin: ");
            stringBuilder.append(this.highMin);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("highMax: ");
            stringBuilder.append(this.highMax);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("relative: ");
            stringBuilder.append(this.relative);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("scalingCount: ");
            stringBuilder.append(this.scaling.length);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            int n2 = 0;
            for (n = 0; n < this.scaling.length; ++n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("scaling");
                stringBuilder.append(n);
                stringBuilder.append(": ");
                stringBuilder.append(this.scaling[n]);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("timelineCount: ");
            stringBuilder.append(this.timeline.length);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            for (n = n2; n < this.timeline.length; ++n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("timeline");
                stringBuilder.append(n);
                stringBuilder.append(": ");
                stringBuilder.append(this.timeline[n]);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
            }
        }

        @Override
        public void scale(float f) {
            super.scale(f);
            this.highMin *= f;
            this.highMax *= f;
        }

        @Override
        public void set(RangedNumericValue rangedNumericValue) {
            if (rangedNumericValue instanceof ScaledNumericValue) {
                this.set((ScaledNumericValue)rangedNumericValue);
            } else {
                super.set(rangedNumericValue);
            }
        }

        public void set(ScaledNumericValue scaledNumericValue) {
            super.set(scaledNumericValue);
            this.highMin = scaledNumericValue.highMin;
            this.highMax = scaledNumericValue.highMax;
            float[] fArray = this.scaling;
            int n = fArray.length;
            float[] fArray2 = scaledNumericValue.scaling;
            if (n != fArray2.length) {
                this.scaling = Arrays.copyOf(fArray2, fArray2.length);
            } else {
                System.arraycopy(fArray2, 0, fArray, 0, fArray.length);
            }
            fArray2 = this.timeline;
            n = fArray2.length;
            fArray = scaledNumericValue.timeline;
            if (n != fArray.length) {
                this.timeline = Arrays.copyOf(fArray, fArray.length);
            } else {
                System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
            }
            this.relative = scaledNumericValue.relative;
        }

        public void setHigh(float f) {
            this.highMin = f;
            this.highMax = f;
        }

        public void setHigh(float f, float f2) {
            this.highMin = f;
            this.highMax = f2;
        }

        public void setHighMax(float f) {
            this.highMax = f;
        }

        public void setHighMin(float f) {
            this.highMin = f;
        }

        public void setRelative(boolean bl) {
            this.relative = bl;
        }

        public void setScaling(float[] fArray) {
            this.scaling = fArray;
        }

        public void setTimeline(float[] fArray) {
            this.timeline = fArray;
        }
    }

    public static enum SpawnEllipseSide {
        both,
        top,
        bottom;

    }

    public static enum SpawnShape {
        point,
        line,
        square,
        ellipse;

    }

    public static class SpawnShapeValue
    extends ParticleValue {
        boolean edges;
        SpawnShape shape = SpawnShape.point;
        SpawnEllipseSide side = SpawnEllipseSide.both;

        public SpawnShape getShape() {
            return this.shape;
        }

        public SpawnEllipseSide getSide() {
            return this.side;
        }

        public boolean isEdges() {
            return this.edges;
        }

        public void load(SpawnShapeValue spawnShapeValue) {
            super.load(spawnShapeValue);
            this.shape = spawnShapeValue.shape;
            this.edges = spawnShapeValue.edges;
            this.side = spawnShapeValue.side;
        }

        @Override
        public void load(BufferedReader bufferedReader) throws IOException {
            super.load(bufferedReader);
            if (!this.active) {
                return;
            }
            this.shape = SpawnShape.valueOf(ParticleEmitter.readString(bufferedReader, "shape"));
            if (this.shape == SpawnShape.ellipse) {
                this.edges = ParticleEmitter.readBoolean(bufferedReader, "edges");
                this.side = SpawnEllipseSide.valueOf(ParticleEmitter.readString(bufferedReader, "side"));
            }
        }

        @Override
        public void save(Writer writer) throws IOException {
            super.save(writer);
            if (!this.active) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("shape: ");
            stringBuilder.append((Object)this.shape);
            stringBuilder.append("\n");
            writer.write(stringBuilder.toString());
            if (this.shape == SpawnShape.ellipse) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("edges: ");
                stringBuilder.append(this.edges);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                stringBuilder.append("side: ");
                stringBuilder.append((Object)this.side);
                stringBuilder.append("\n");
                writer.write(stringBuilder.toString());
            }
        }

        public void setEdges(boolean bl) {
            this.edges = bl;
        }

        public void setShape(SpawnShape spawnShape) {
            this.shape = spawnShape;
        }

        public void setSide(SpawnEllipseSide spawnEllipseSide) {
            this.side = spawnEllipseSide;
        }
    }

    public static enum SpriteMode {
        single,
        random,
        animated;

    }
}

