/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class NinePatch {
    public static final int BOTTOM_CENTER = 7;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_RIGHT = 8;
    public static final int MIDDLE_CENTER = 4;
    public static final int MIDDLE_LEFT = 3;
    public static final int MIDDLE_RIGHT = 5;
    public static final int TOP_CENTER = 1;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 2;
    private static final Color tmpDrawColor = new Color();
    private int bottomCenter = -1;
    private float bottomHeight;
    private int bottomLeft = -1;
    private int bottomRight = -1;
    private final Color color;
    private int idx;
    private float leftWidth;
    private int middleCenter = -1;
    private float middleHeight;
    private int middleLeft = -1;
    private int middleRight = -1;
    private float middleWidth;
    private float padBottom = -1.0f;
    private float padLeft = -1.0f;
    private float padRight = -1.0f;
    private float padTop = -1.0f;
    private float rightWidth;
    private Texture texture;
    private int topCenter = -1;
    private float topHeight;
    private int topLeft = -1;
    private int topRight = -1;
    private float[] vertices = new float[180];

    public NinePatch(Texture texture) {
        this(new TextureRegion(texture));
    }

    public NinePatch(Texture texture, int n, int n2, int n3, int n4) {
        this(new TextureRegion(texture), n, n2, n3, n4);
    }

    public NinePatch(Texture texture, Color color2) {
        this(texture);
        this.setColor(color2);
    }

    public NinePatch(NinePatch ninePatch) {
        this(ninePatch, ninePatch.color);
    }

    public NinePatch(NinePatch ninePatch, Color color2) {
        this.color = new Color(Color.WHITE);
        this.texture = ninePatch.texture;
        this.bottomLeft = ninePatch.bottomLeft;
        this.bottomCenter = ninePatch.bottomCenter;
        this.bottomRight = ninePatch.bottomRight;
        this.middleLeft = ninePatch.middleLeft;
        this.middleCenter = ninePatch.middleCenter;
        this.middleRight = ninePatch.middleRight;
        this.topLeft = ninePatch.topLeft;
        this.topCenter = ninePatch.topCenter;
        this.topRight = ninePatch.topRight;
        this.leftWidth = ninePatch.leftWidth;
        this.rightWidth = ninePatch.rightWidth;
        this.middleWidth = ninePatch.middleWidth;
        this.middleHeight = ninePatch.middleHeight;
        this.topHeight = ninePatch.topHeight;
        this.bottomHeight = ninePatch.bottomHeight;
        this.padLeft = ninePatch.padLeft;
        this.padTop = ninePatch.padTop;
        this.padBottom = ninePatch.padBottom;
        this.padRight = ninePatch.padRight;
        this.vertices = new float[ninePatch.vertices.length];
        float[] fArray = ninePatch.vertices;
        System.arraycopy(fArray, 0, this.vertices, 0, fArray.length);
        this.idx = ninePatch.idx;
        this.color.set(color2);
    }

    public NinePatch(TextureRegion textureRegion) {
        this.color = new Color(Color.WHITE);
        this.load(new TextureRegion[]{null, null, null, null, textureRegion, null, null, null, null});
    }

    public NinePatch(TextureRegion textureRegion, int n, int n2, int n3, int n4) {
        this.color = new Color(Color.WHITE);
        if (textureRegion != null) {
            int n5 = textureRegion.getRegionWidth() - n - n2;
            int n6 = textureRegion.getRegionHeight() - n3 - n4;
            TextureRegion[] textureRegionArray = new TextureRegion[9];
            if (n3 > 0) {
                if (n > 0) {
                    textureRegionArray[0] = new TextureRegion(textureRegion, 0, 0, n, n3);
                }
                if (n5 > 0) {
                    textureRegionArray[1] = new TextureRegion(textureRegion, n, 0, n5, n3);
                }
                if (n2 > 0) {
                    textureRegionArray[2] = new TextureRegion(textureRegion, n + n5, 0, n2, n3);
                }
            }
            if (n6 > 0) {
                if (n > 0) {
                    textureRegionArray[3] = new TextureRegion(textureRegion, 0, n3, n, n6);
                }
                if (n5 > 0) {
                    textureRegionArray[4] = new TextureRegion(textureRegion, n, n3, n5, n6);
                }
                if (n2 > 0) {
                    textureRegionArray[5] = new TextureRegion(textureRegion, n + n5, n3, n2, n6);
                }
            }
            if (n4 > 0) {
                if (n > 0) {
                    textureRegionArray[6] = new TextureRegion(textureRegion, 0, n3 + n6, n, n4);
                }
                if (n5 > 0) {
                    textureRegionArray[7] = new TextureRegion(textureRegion, n, n3 + n6, n5, n4);
                }
                if (n2 > 0) {
                    textureRegionArray[8] = new TextureRegion(textureRegion, n + n5, n3 + n6, n2, n4);
                }
            }
            if (n == 0 && n5 == 0) {
                textureRegionArray[1] = textureRegionArray[2];
                textureRegionArray[4] = textureRegionArray[5];
                textureRegionArray[7] = textureRegionArray[8];
                textureRegionArray[2] = null;
                textureRegionArray[5] = null;
                textureRegionArray[8] = null;
            }
            if (n3 == 0 && n6 == 0) {
                textureRegionArray[3] = textureRegionArray[6];
                textureRegionArray[4] = textureRegionArray[7];
                textureRegionArray[5] = textureRegionArray[8];
                textureRegionArray[6] = null;
                textureRegionArray[7] = null;
                textureRegionArray[8] = null;
            }
            this.load(textureRegionArray);
            return;
        }
        throw new IllegalArgumentException("region cannot be null.");
    }

    public NinePatch(TextureRegion textureRegion, Color color2) {
        this(textureRegion);
        this.setColor(color2);
    }

    public NinePatch(TextureRegion ... textureRegionArray) {
        this.color = new Color(Color.WHITE);
        if (textureRegionArray != null && textureRegionArray.length == 9) {
            this.load(textureRegionArray);
            float f = this.getLeftWidth();
            if (textureRegionArray[0] != null && (float)textureRegionArray[0].getRegionWidth() != f || textureRegionArray[3] != null && (float)textureRegionArray[3].getRegionWidth() != f || textureRegionArray[6] != null && (float)textureRegionArray[6].getRegionWidth() != f) {
                throw new GdxRuntimeException("Left side patches must have the same width");
            }
            f = this.getRightWidth();
            if (textureRegionArray[2] != null && (float)textureRegionArray[2].getRegionWidth() != f || textureRegionArray[5] != null && (float)textureRegionArray[5].getRegionWidth() != f || textureRegionArray[8] != null && (float)textureRegionArray[8].getRegionWidth() != f) {
                throw new GdxRuntimeException("Right side patches must have the same width");
            }
            f = this.getBottomHeight();
            if (textureRegionArray[6] != null && (float)textureRegionArray[6].getRegionHeight() != f || textureRegionArray[7] != null && (float)textureRegionArray[7].getRegionHeight() != f || textureRegionArray[8] != null && (float)textureRegionArray[8].getRegionHeight() != f) {
                throw new GdxRuntimeException("Bottom side patches must have the same height");
            }
            f = this.getTopHeight();
            if (textureRegionArray[0] != null && (float)textureRegionArray[0].getRegionHeight() != f || textureRegionArray[1] != null && (float)textureRegionArray[1].getRegionHeight() != f || textureRegionArray[2] != null && (float)textureRegionArray[2].getRegionHeight() != f) {
                throw new GdxRuntimeException("Top side patches must have the same height");
            }
            return;
        }
        throw new IllegalArgumentException("NinePatch needs nine TextureRegions");
    }

    private int add(TextureRegion object, float f, boolean bl, boolean bl2) {
        block7: {
            float f2;
            float f3;
            float f4;
            float f5;
            block9: {
                float f6;
                float f7;
                float f8;
                float f9;
                block8: {
                    block6: {
                        Texture texture;
                        block5: {
                            texture = this.texture;
                            if (texture != null) break block5;
                            this.texture = ((TextureRegion)object).getTexture();
                            break block6;
                        }
                        if (texture != ((TextureRegion)object).getTexture()) break block7;
                    }
                    f9 = ((TextureRegion)object).u;
                    f8 = ((TextureRegion)object).v2;
                    f7 = ((TextureRegion)object).u2;
                    f6 = ((TextureRegion)object).v;
                    if (this.texture.getMagFilter() == Texture.TextureFilter.Linear) break block8;
                    f5 = f9;
                    f4 = f8;
                    f3 = f7;
                    f2 = f6;
                    if (this.texture.getMinFilter() != Texture.TextureFilter.Linear) break block9;
                }
                float f10 = f9;
                float f11 = f7;
                if (bl) {
                    f11 = 0.5f / (float)this.texture.getWidth();
                    f10 = f9 + f11;
                    f11 = f7 - f11;
                }
                f5 = f10;
                f4 = f8;
                f3 = f11;
                f2 = f6;
                if (bl2) {
                    f7 = 0.5f / (float)this.texture.getHeight();
                    f4 = f8 - f7;
                    f2 = f6 + f7;
                    f3 = f11;
                    f5 = f10;
                }
            }
            object = this.vertices;
            int n = this.idx;
            object[n + 2] = f;
            object[n + 3] = f5;
            object[n + 4] = f4;
            object[n + 7] = f;
            object[n + 8] = f5;
            object[n + 9] = f2;
            object[n + 12] = f;
            object[n + 13] = f3;
            object[n + 14] = f2;
            object[n + 17] = f;
            object[n + 18] = f3;
            object[n + 19] = f4;
            this.idx = n + 20;
            return this.idx - 20;
        }
        throw new IllegalArgumentException("All regions must be from the same texture.");
    }

    private void load(TextureRegion[] objectArray) {
        int n;
        float f = Color.WHITE_FLOAT_BITS;
        if (objectArray[6] != null) {
            this.bottomLeft = this.add(objectArray[6], f, false, false);
            this.leftWidth = objectArray[6].getRegionWidth();
            this.bottomHeight = objectArray[6].getRegionHeight();
        }
        if (objectArray[7] != null) {
            this.bottomCenter = this.add(objectArray[7], f, true, false);
            this.middleWidth = Math.max(this.middleWidth, (float)objectArray[7].getRegionWidth());
            this.bottomHeight = Math.max(this.bottomHeight, (float)objectArray[7].getRegionHeight());
        }
        if (objectArray[8] != null) {
            this.bottomRight = this.add(objectArray[8], f, false, false);
            this.rightWidth = Math.max(this.rightWidth, (float)objectArray[8].getRegionWidth());
            this.bottomHeight = Math.max(this.bottomHeight, (float)objectArray[8].getRegionHeight());
        }
        if (objectArray[3] != null) {
            this.middleLeft = this.add(objectArray[3], f, false, true);
            this.leftWidth = Math.max(this.leftWidth, (float)objectArray[3].getRegionWidth());
            this.middleHeight = Math.max(this.middleHeight, (float)objectArray[3].getRegionHeight());
        }
        if (objectArray[4] != null) {
            this.middleCenter = this.add(objectArray[4], f, true, true);
            this.middleWidth = Math.max(this.middleWidth, (float)objectArray[4].getRegionWidth());
            this.middleHeight = Math.max(this.middleHeight, (float)objectArray[4].getRegionHeight());
        }
        if (objectArray[5] != null) {
            this.middleRight = this.add(objectArray[5], f, false, true);
            this.rightWidth = Math.max(this.rightWidth, (float)objectArray[5].getRegionWidth());
            this.middleHeight = Math.max(this.middleHeight, (float)objectArray[5].getRegionHeight());
        }
        if (objectArray[0] != null) {
            this.topLeft = this.add(objectArray[0], f, false, false);
            this.leftWidth = Math.max(this.leftWidth, (float)objectArray[0].getRegionWidth());
            this.topHeight = Math.max(this.topHeight, (float)objectArray[0].getRegionHeight());
        }
        if (objectArray[1] != null) {
            this.topCenter = this.add(objectArray[1], f, true, false);
            this.middleWidth = Math.max(this.middleWidth, (float)objectArray[1].getRegionWidth());
            this.topHeight = Math.max(this.topHeight, (float)objectArray[1].getRegionHeight());
        }
        if (objectArray[2] != null) {
            this.topRight = this.add(objectArray[2], f, false, false);
            this.rightWidth = Math.max(this.rightWidth, (float)objectArray[2].getRegionWidth());
            this.topHeight = Math.max(this.topHeight, (float)objectArray[2].getRegionHeight());
        }
        if ((n = this.idx) < (objectArray = (Object[])this.vertices).length) {
            float[] fArray = new float[n];
            System.arraycopy(objectArray, 0, fArray, 0, n);
            this.vertices = fArray;
        }
    }

    private void prepareVertices(Batch batch, float f, float f2, float f3, float f4) {
        float f5 = f + this.leftWidth;
        float f6 = f + f3;
        float f7 = f6 - this.rightWidth;
        f3 = f2 + this.bottomHeight;
        float f8 = f2 + f4;
        float f9 = f8 - this.topHeight;
        f4 = tmpDrawColor.set(this.color).mul(batch.getColor()).toFloatBits();
        int n = this.bottomLeft;
        if (n != -1) {
            this.set(n, f, f2, f5 - f, f3 - f2, f4);
        }
        if ((n = this.bottomCenter) != -1) {
            this.set(n, f5, f2, f7 - f5, f3 - f2, f4);
        }
        if ((n = this.bottomRight) != -1) {
            this.set(n, f7, f2, f6 - f7, f3 - f2, f4);
        }
        if ((n = this.middleLeft) != -1) {
            this.set(n, f, f3, f5 - f, f9 - f3, f4);
        }
        if ((n = this.middleCenter) != -1) {
            this.set(n, f5, f3, f7 - f5, f9 - f3, f4);
        }
        if ((n = this.middleRight) != -1) {
            this.set(n, f7, f3, f6 - f7, f9 - f3, f4);
        }
        if ((n = this.topLeft) != -1) {
            this.set(n, f, f9, f5 - f, f8 - f9, f4);
        }
        if ((n = this.topCenter) != -1) {
            this.set(n, f5, f9, f7 - f5, f8 - f9, f4);
        }
        if ((n = this.topRight) != -1) {
            this.set(n, f7, f9, f6 - f7, f8 - f9, f4);
        }
    }

    private void set(int n, float f, float f2, float f3, float f4, float f5) {
        f3 += f;
        f4 += f2;
        float[] fArray = this.vertices;
        fArray[n] = f;
        fArray[n + 1] = f2;
        fArray[n + 2] = f5;
        fArray[n + 5] = f;
        fArray[n + 6] = f4;
        fArray[n + 7] = f5;
        fArray[n + 10] = f3;
        fArray[n + 11] = f4;
        fArray[n + 12] = f5;
        fArray[n + 15] = f3;
        fArray[n + 16] = f2;
        fArray[n + 17] = f5;
    }

    public void draw(Batch batch, float f, float f2, float f3, float f4) {
        this.prepareVertices(batch, f, f2, f3, f4);
        batch.draw(this.texture, this.vertices, 0, this.idx);
    }

    public void draw(Batch batch, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.prepareVertices(batch, f, f2, f5, f6);
        f += f3;
        f5 = f2 + f4;
        int n = this.idx;
        float[] fArray = this.vertices;
        if (f9 != 0.0f) {
            for (int i = 0; i < n; i += 5) {
                f4 = (fArray[i] - f) * f7;
                int n2 = i + 1;
                f6 = (fArray[n2] - f5) * f8;
                f2 = MathUtils.cosDeg(f9);
                f3 = MathUtils.sinDeg(f9);
                fArray[i] = f2 * f4 - f3 * f6 + f;
                fArray[n2] = f3 * f4 + f2 * f6 + f5;
            }
        } else if (f7 != 1.0f || f8 != 1.0f) {
            for (int i = 0; i < n; i += 5) {
                fArray[i] = (fArray[i] - f) * f7 + f;
                int n3 = i + 1;
                fArray[n3] = (fArray[n3] - f5) * f8 + f5;
            }
        }
        batch.draw(this.texture, fArray, 0, n);
    }

    public float getBottomHeight() {
        return this.bottomHeight;
    }

    public Color getColor() {
        return this.color;
    }

    public float getLeftWidth() {
        return this.leftWidth;
    }

    public float getMiddleHeight() {
        return this.middleHeight;
    }

    public float getMiddleWidth() {
        return this.middleWidth;
    }

    public float getPadBottom() {
        float f;
        float f2 = f = this.padBottom;
        if (f == -1.0f) {
            f2 = this.getBottomHeight();
        }
        return f2;
    }

    public float getPadLeft() {
        float f;
        float f2 = f = this.padLeft;
        if (f == -1.0f) {
            f2 = this.getLeftWidth();
        }
        return f2;
    }

    public float getPadRight() {
        float f;
        float f2 = f = this.padRight;
        if (f == -1.0f) {
            f2 = this.getRightWidth();
        }
        return f2;
    }

    public float getPadTop() {
        float f;
        float f2 = f = this.padTop;
        if (f == -1.0f) {
            f2 = this.getTopHeight();
        }
        return f2;
    }

    public float getRightWidth() {
        return this.rightWidth;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public float getTopHeight() {
        return this.topHeight;
    }

    public float getTotalHeight() {
        return this.topHeight + this.middleHeight + this.bottomHeight;
    }

    public float getTotalWidth() {
        return this.leftWidth + this.middleWidth + this.rightWidth;
    }

    public void scale(float f, float f2) {
        this.leftWidth *= f;
        this.rightWidth *= f;
        this.topHeight *= f2;
        this.bottomHeight *= f2;
        this.middleWidth *= f;
        this.middleHeight *= f2;
        float f3 = this.padLeft;
        if (f3 != -1.0f) {
            this.padLeft = f3 * f;
        }
        if ((f3 = this.padRight) != -1.0f) {
            this.padRight = f3 * f;
        }
        if ((f = this.padTop) != -1.0f) {
            this.padTop = f * f2;
        }
        if ((f = this.padBottom) != -1.0f) {
            this.padBottom = f * f2;
        }
    }

    public void setBottomHeight(float f) {
        this.bottomHeight = f;
    }

    public void setColor(Color color2) {
        this.color.set(color2);
    }

    public void setLeftWidth(float f) {
        this.leftWidth = f;
    }

    public void setMiddleHeight(float f) {
        this.middleHeight = f;
    }

    public void setMiddleWidth(float f) {
        this.middleWidth = f;
    }

    public void setPadBottom(float f) {
        this.padBottom = f;
    }

    public void setPadLeft(float f) {
        this.padLeft = f;
    }

    public void setPadRight(float f) {
        this.padRight = f;
    }

    public void setPadTop(float f) {
        this.padTop = f;
    }

    public void setPadding(float f, float f2, float f3, float f4) {
        this.padLeft = f;
        this.padRight = f2;
        this.padTop = f3;
        this.padBottom = f4;
    }

    public void setRightWidth(float f) {
        this.rightWidth = f;
    }

    public void setTopHeight(float f) {
        this.topHeight = f;
    }
}

