/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class BitmapFont
implements Disposable {
    private static final int LOG2_PAGE_SIZE = 9;
    private static final int PAGES = 128;
    private static final int PAGE_SIZE = 512;
    private final BitmapFontCache cache;
    final BitmapFontData data;
    private boolean flipped;
    boolean integer;
    private boolean ownsTexture;
    Array<TextureRegion> regions;

    public BitmapFont() {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.png"), false, true);
    }

    public BitmapFont(FileHandle fileHandle) {
        this(fileHandle, false);
    }

    public BitmapFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl) {
        this(fileHandle, fileHandle2, bl, true);
    }

    public BitmapFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl, boolean bl2) {
        this(new BitmapFontData(fileHandle, bl), new TextureRegion(new Texture(fileHandle2, false)), bl2);
        this.ownsTexture = true;
    }

    public BitmapFont(FileHandle fileHandle, TextureRegion textureRegion) {
        this(fileHandle, textureRegion, false);
    }

    public BitmapFont(FileHandle fileHandle, TextureRegion textureRegion, boolean bl) {
        this(new BitmapFontData(fileHandle, bl), textureRegion, true);
    }

    public BitmapFont(FileHandle fileHandle, boolean bl) {
        this(new BitmapFontData(fileHandle, bl), (TextureRegion)null, true);
    }

    public BitmapFont(BitmapFontData bitmapFontData, TextureRegion array, boolean bl) {
        array = array != null ? Array.with(array) : null;
        this(bitmapFontData, array, bl);
    }

    public BitmapFont(BitmapFontData object, Array<TextureRegion> object2, boolean bl) {
        block5: {
            block4: {
                block3: {
                    this.flipped = ((BitmapFontData)object).flipped;
                    this.data = object;
                    this.integer = bl;
                    if (object2 == null || ((Array)object2).size == 0) break block3;
                    this.regions = object2;
                    this.ownsTexture = false;
                    break block4;
                }
                if (((BitmapFontData)object).imagePaths == null) break block5;
                int n = ((BitmapFontData)object).imagePaths.length;
                this.regions = new Array(n);
                for (int i = 0; i < n; ++i) {
                    object2 = ((BitmapFontData)object).fontFile == null ? Gdx.files.internal(((BitmapFontData)object).imagePaths[i]) : Gdx.files.getFileHandle(((BitmapFontData)object).imagePaths[i], ((BitmapFontData)object).fontFile.type());
                    this.regions.add(new TextureRegion(new Texture((FileHandle)object2, false)));
                }
                this.ownsTexture = true;
            }
            this.cache = this.newFontCache();
            this.load((BitmapFontData)object);
            return;
        }
        object = new IllegalArgumentException("If no regions are specified, the font data must have an images path.");
        throw object;
    }

    public BitmapFont(boolean bl) {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/arial-15.png"), bl, true);
    }

    static int indexOf(CharSequence charSequence, char c, int n) {
        int n2 = charSequence.length();
        while (n < n2) {
            if (charSequence.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return n2;
    }

    @Override
    public void dispose() {
        if (this.ownsTexture) {
            for (int i = 0; i < this.regions.size; ++i) {
                this.regions.get(i).getTexture().dispose();
            }
        }
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f, float f2) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f, f2);
        this.cache.draw(batch);
        return object;
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f, float f2, float f3, int n, boolean bl) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f, f2, f3, n, bl);
        this.cache.draw(batch);
        return object;
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f, float f2, int n, int n2, float f3, int n3, boolean bl) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f, f2, n, n2, f3, n3, bl);
        this.cache.draw(batch);
        return object;
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f, float f2, int n, int n2, float f3, int n3, boolean bl, String string2) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f, f2, n, n2, f3, n3, bl, string2);
        this.cache.draw(batch);
        return object;
    }

    public void draw(Batch batch, GlyphLayout glyphLayout, float f, float f2) {
        this.cache.clear();
        this.cache.addText(glyphLayout, f, f2);
        this.cache.draw(batch);
    }

    public float getAscent() {
        return this.data.ascent;
    }

    public BitmapFontCache getCache() {
        return this.cache;
    }

    public float getCapHeight() {
        return this.data.capHeight;
    }

    public Color getColor() {
        return this.cache.getColor();
    }

    public BitmapFontData getData() {
        return this.data;
    }

    public float getDescent() {
        return this.data.descent;
    }

    public float getLineHeight() {
        return this.data.lineHeight;
    }

    public TextureRegion getRegion() {
        return this.regions.first();
    }

    public TextureRegion getRegion(int n) {
        return this.regions.get(n);
    }

    public Array<TextureRegion> getRegions() {
        return this.regions;
    }

    public float getScaleX() {
        return this.data.scaleX;
    }

    public float getScaleY() {
        return this.data.scaleY;
    }

    public float getSpaceXadvance() {
        return this.data.spaceXadvance;
    }

    public float getXHeight() {
        return this.data.xHeight;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    protected void load(BitmapFontData bitmapFontData) {
        for (Glyph[] glyphArray : bitmapFontData.glyphs) {
            if (glyphArray == null) continue;
            int n = glyphArray.length;
            for (int i = 0; i < n; ++i) {
                Glyph glyph = glyphArray[i];
                if (glyph == null) continue;
                bitmapFontData.setGlyphRegion(glyph, this.regions.get(glyph.page));
            }
        }
        if (bitmapFontData.missingGlyph != null) {
            bitmapFontData.setGlyphRegion(bitmapFontData.missingGlyph, this.regions.get(bitmapFontData.missingGlyph.page));
        }
    }

    public BitmapFontCache newFontCache() {
        return new BitmapFontCache(this, this.integer);
    }

    public boolean ownsTexture() {
        return this.ownsTexture;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.cache.getColor().set(f, f2, f3, f4);
    }

    public void setColor(Color color2) {
        this.cache.getColor().set(color2);
    }

    public void setFixedWidthGlyphs(CharSequence charSequence) {
        int n;
        Glyph glyph;
        int n2;
        BitmapFontData bitmapFontData = this.data;
        int n3 = charSequence.length();
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            glyph = bitmapFontData.getGlyph(charSequence.charAt(n2));
            n = n5;
            if (glyph != null) {
                n = n5;
                if (glyph.xadvance > n5) {
                    n = glyph.xadvance;
                }
            }
            n5 = n;
        }
        n2 = charSequence.length();
        for (n = n4; n < n2; ++n) {
            glyph = bitmapFontData.getGlyph(charSequence.charAt(n));
            if (glyph == null) continue;
            glyph.xoffset += Math.round((n5 - glyph.xadvance) / 2);
            glyph.xadvance = n5;
            glyph.kerning = null;
            glyph.fixedWidth = true;
        }
    }

    public void setOwnsTexture(boolean bl) {
        this.ownsTexture = bl;
    }

    public void setUseIntegerPositions(boolean bl) {
        this.integer = bl;
        this.cache.setUseIntegerPositions(bl);
    }

    public String toString() {
        String string2 = this.data.name != null ? this.data.name : super.toString();
        return string2;
    }

    public boolean usesIntegerPositions() {
        return this.integer;
    }

    public static class BitmapFontData {
        public float ascent;
        public float blankLineScale = 1.0f;
        public char[] breakChars;
        public char[] capChars;
        public float capHeight = 1.0f;
        public float cursorX;
        public float descent;
        public float down;
        public boolean flipped;
        public FileHandle fontFile;
        public final Glyph[][] glyphs = new Glyph[128][];
        public String[] imagePaths;
        public float lineHeight;
        public boolean markupEnabled;
        public Glyph missingGlyph;
        public String name;
        public float padBottom;
        public float padLeft;
        public float padRight;
        public float padTop;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public float spaceXadvance;
        public char[] xChars = new char[]{'x', 'e', 'a', 'o', 'n', 's', 'r', 'c', 'u', 'm', 'v', 'w', 'z'};
        public float xHeight = 1.0f;

        public BitmapFontData() {
            this.capChars = new char[]{'M', 'N', 'B', 'D', 'C', 'E', 'F', 'K', 'A', 'G', 'H', 'I', 'J', 'L', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        }

        public BitmapFontData(FileHandle fileHandle, boolean bl) {
            this.capChars = new char[]{'M', 'N', 'B', 'D', 'C', 'E', 'F', 'K', 'A', 'G', 'H', 'I', 'J', 'L', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
            this.fontFile = fileHandle;
            this.flipped = bl;
            this.load(fileHandle, bl);
        }

        public Glyph getFirstGlyph() {
            Object object;
            for (Glyph[] glyphArray : this.glyphs) {
                if (glyphArray == null) continue;
                int n = glyphArray.length;
                for (int i = 0; i < n; ++i) {
                    object = glyphArray[i];
                    if (object == null || ((Glyph)object).height == 0 || ((Glyph)object).width == 0) continue;
                    return object;
                }
            }
            object = new GdxRuntimeException("No glyphs found.");
            throw object;
        }

        public FileHandle getFontFile() {
            return this.fontFile;
        }

        public Glyph getGlyph(char c) {
            Glyph[] glyphArray = this.glyphs[c / 512];
            if (glyphArray != null) {
                return glyphArray[c & 0x1FF];
            }
            return null;
        }

        public void getGlyphs(GlyphLayout.GlyphRun object, CharSequence charSequence, int n, int n2, Glyph object2) {
            float f;
            boolean bl = this.markupEnabled;
            float f2 = this.scaleX;
            Glyph glyph = this.missingGlyph;
            Array<Glyph> array = ((GlyphLayout.GlyphRun)object).glyphs;
            FloatArray floatArray = ((GlyphLayout.GlyphRun)object).xAdvances;
            int n3 = n2 - n;
            array.ensureCapacity(n3);
            floatArray.ensureCapacity(n3 + 1);
            while (n < n2) {
                char c;
                block12: {
                    block13: {
                        block11: {
                            n3 = n + 1;
                            c = charSequence.charAt(n);
                            if (c == '\r') break block11;
                            Glyph glyph2 = this.getGlyph(c);
                            object = glyph2;
                            if (glyph2 != null) break block12;
                            if (glyph != null) break block13;
                        }
                        n = n3;
                        continue;
                    }
                    object = glyph;
                }
                array.add((Glyph)object);
                if (object2 == null) {
                    f = ((Glyph)object).fixedWidth ? 0.0f : (float)(-((Glyph)object).xoffset) * f2 - this.padLeft;
                    floatArray.add(f);
                } else {
                    floatArray.add((float)(((Glyph)object2).xadvance + ((Glyph)object2).getKerning(c)) * f2);
                }
                n = n3;
                if (bl) {
                    n = n3;
                    if (c == '[') {
                        n = n3;
                        if (n3 < n2) {
                            n = n3;
                            if (charSequence.charAt(n3) == '[') {
                                n = n3 + 1;
                            }
                        }
                    }
                }
                object2 = object;
            }
            if (object2 != null) {
                f = ((Glyph)object2).fixedWidth ? (float)((Glyph)object2).xadvance * f2 : (float)(((Glyph)object2).width + ((Glyph)object2).xoffset) * f2 - this.padRight;
                floatArray.add(f);
            }
        }

        public String getImagePath(int n) {
            return this.imagePaths[n];
        }

        public String[] getImagePaths() {
            return this.imagePaths;
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        public int getWrapIndex(Array<Glyph> array, int n) {
            int n2 = n - 1;
            char c = (char)array.get((int)n2).id;
            if (this.isWhitespace(c)) {
                return n2;
            }
            n = n2;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || this.isBreakChar(c)) {
                    n = n2 - 1;
                }
                if (n <= 0) {
                    return 0;
                }
                c = (char)array.get((int)n).id;
                if (this.isBreakChar(c)) {
                    return n + 1;
                }
                n2 = n;
            } while (!this.isWhitespace(c));
            return n + 1;
        }

        public boolean hasGlyph(char c) {
            Glyph glyph = this.missingGlyph;
            boolean bl = true;
            if (glyph != null) {
                return true;
            }
            if (this.getGlyph(c) == null) {
                bl = false;
            }
            return bl;
        }

        public boolean isBreakChar(char c) {
            char[] cArray = this.breakChars;
            if (cArray == null) {
                return false;
            }
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                if (c != cArray[i]) continue;
                return true;
            }
            return false;
        }

        public boolean isWhitespace(char c) {
            return c == '\t' || c == '\n' || c == '\r' || c == ' ';
        }

        /*
         * Unable to fully structure code
         */
        public void load(FileHandle var1_1, boolean var2_5) {
            block236: {
                block235: {
                    block208: {
                        block209: {
                            block210: {
                                block211: {
                                    block212: {
                                        block213: {
                                            block214: {
                                                if (this.imagePaths != null) break block236;
                                                this.name = var1_1.nameWithoutExtension();
                                                var4_8 = var3_6 = new BufferedReader(new InputStreamReader(var1_1.read()), 512);
                                                var5_9 = var3_6;
                                                var6_11 = var3_6.readLine();
                                                if (var6_11 == null) break block208;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var6_11 = var6_11.substring(var6_11.indexOf("padding=") + 8);
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var6_11 = var6_11.substring(0, var6_11.indexOf(32)).split(",", 4);
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                if (((String[])var6_11).length != 4) break block209;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                this.padTop = Integer.parseInt(var6_11[0]);
                                                var7_15 = 1;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                this.padRight = Integer.parseInt(var6_11[1]);
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                this.padBottom = Integer.parseInt(var6_11[2]);
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                this.padLeft = Integer.parseInt(var6_11[3]);
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var8_16 = this.padTop + this.padBottom;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var6_11 = var3_6.readLine();
                                                if (var6_11 == null) break block210;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var6_11 = var6_11.split(" ", 9);
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                if (((Object)var6_11).length < 3) break block211;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                if (!var6_11[1].startsWith("lineHeight=")) break block212;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                this.lineHeight = Integer.parseInt(var6_11[1].substring(11));
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                if (!var6_11[2].startsWith("base=")) break block213;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var9_17 = Integer.parseInt(var6_11[2].substring(5));
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                ** try [egrp 16[TRYBLOCK] [33, 32 : 345->353)] { 
lbl73:
                                                // 1 sources

                                                if (((Object)var6_11).length < 6 || var6_11[5] == null) break block214;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var10_18 = var6_11[5].startsWith("pages=");
                                                if (!var10_18) break block214;
                                                var4_8 = var3_6;
                                                var5_9 = var3_6;
                                                var11_19 = Math.max(1, Integer.parseInt(var6_11[5].substring(6)));
                                                ** GOTO lbl87
                                            }
lbl85:
                                            // 2 sources

                                            while (true) {
                                                block234: {
                                                    block233: {
                                                        block232: {
                                                            block231: {
                                                                block230: {
                                                                    block229: {
                                                                        var11_19 = 1;
lbl87:
                                                                        // 2 sources

                                                                        var4_8 = var3_6;
                                                                        var5_9 = var3_6;
                                                                        this.imagePaths = new String[var11_19];
                                                                        for (var12_20 = 0; var12_20 < var11_19; ++var12_20) {
                                                                            block215: {
                                                                                block217: {
                                                                                    block216: {
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var13_21 = var3_6.readLine();
                                                                                        if (var13_21 == null) break block215;
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var6_11 = Pattern.compile(".*id=(\\d+)").matcher((CharSequence)var13_21);
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        if (!var6_11.find()) break block216;
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var6_11 = var6_11.group(1);
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        if (Integer.parseInt((String)var6_11) == var12_20) break block216;
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var14_23 = new StringBuilder();
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var14_23.append("Page IDs must be indices starting at 0: ");
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var14_23.append((String)var6_11);
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        var13_21 = new GdxRuntimeException(var14_23.toString());
                                                                                        var4_8 = var3_6;
                                                                                        var5_9 = var3_6;
                                                                                        try {
                                                                                            throw var13_21;
                                                                                        }
                                                                                        catch (NumberFormatException var13_22) {
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            var14_23 = new StringBuilder();
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            var14_23.append("Invalid page id: ");
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            var14_23.append((String)var6_11);
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            var15_25 = new GdxRuntimeException(var14_23.toString(), var13_22);
                                                                                            var4_8 = var3_6;
                                                                                            var5_9 = var3_6;
                                                                                            throw var15_25;
                                                                                        }
                                                                                    }
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    var6_11 = Pattern.compile(".*file=\"?([^\"]+)\"?").matcher((CharSequence)var13_21);
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    if (!var6_11.find()) break block217;
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    var6_11 = var6_11.group(1);
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    this.imagePaths[var12_20] = var1_1.parent().child((String)var6_11).path().replaceAll("\\\\", "/");
                                                                                    continue;
                                                                                }
                                                                                var4_8 = var3_6;
                                                                                var5_9 = var3_6;
                                                                                var4_8 = var3_6;
                                                                                var5_9 = var3_6;
                                                                                var6_11 = new GdxRuntimeException("Missing: file");
                                                                                var4_8 = var3_6;
                                                                                var5_9 = var3_6;
                                                                                throw var6_11;
                                                                            }
                                                                            var4_8 = var3_6;
                                                                            var5_9 = var3_6;
                                                                            var4_8 = var3_6;
                                                                            var5_9 = var3_6;
                                                                            var6_11 = new GdxRuntimeException("Missing additional page definitions.");
                                                                            var4_8 = var3_6;
                                                                            var5_9 = var3_6;
                                                                            throw var6_11;
                                                                        }
                                                                        var16_27 = 0.0f;
                                                                        var4_8 = var3_6;
                                                                        var5_9 = var3_6;
                                                                        this.descent = 0.0f;
                                                                        block192: while (true) {
                                                                            block219: {
                                                                                block218: {
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    var13_21 = var3_6.readLine();
                                                                                    if (var13_21 == null) break block218;
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    if (var13_21.startsWith("kernings ")) break block218;
                                                                                    var4_8 = var3_6;
                                                                                    var5_9 = var3_6;
                                                                                    if (!var13_21.startsWith("metrics ")) break block219;
                                                                                }
                                                                                var4_8 = var3_6;
                                                                                var5_9 = var3_6;
                                                                                this.descent += this.padBottom;
                                                                                while (true) {
                                                                                    block228: {
                                                                                        block221: {
                                                                                            block227: {
                                                                                                block226: {
                                                                                                    block224: {
                                                                                                        block225: {
                                                                                                            block223: {
                                                                                                                block222: {
                                                                                                                    block220: {
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var13_21 = var3_6.readLine();
                                                                                                                        if (var13_21 == null) break block220;
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        if (var13_21.startsWith("kerning ")) break block221;
                                                                                                                    }
                                                                                                                    if (var13_21 != null) {
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        if (!var13_21.startsWith("metrics ")) break block222;
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11 = new StringTokenizer((String)var13_21, " =");
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var16_27 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var17_28 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var18_29 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var19_30 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var20_31 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var21_32 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var6_11.nextToken();
                                                                                                                        var4_8 = var3_6;
                                                                                                                        var5_9 = var3_6;
                                                                                                                        var22_33 = Float.parseFloat(var6_11.nextToken());
                                                                                                                        var11_19 = var7_15;
                                                                                                                        break block223;
                                                                                                                    }
                                                                                                                }
                                                                                                                var11_19 = 0;
                                                                                                                var22_33 = 0.0f;
                                                                                                                var17_28 = 0.0f;
                                                                                                                var18_29 = 0.0f;
                                                                                                                var19_30 = 0.0f;
                                                                                                                var20_31 = 0.0f;
                                                                                                                var21_32 = 0.0f;
                                                                                                            }
                                                                                                            var4_8 = var3_6;
                                                                                                            var5_9 = var3_6;
                                                                                                            var13_21 = this.getGlyph(' ');
                                                                                                            var6_11 = var13_21;
                                                                                                            if (var13_21 != null) break block224;
                                                                                                            var4_8 = var3_6;
                                                                                                            var5_9 = var3_6;
                                                                                                            var4_8 = var3_6;
                                                                                                            var5_9 = var3_6;
                                                                                                            var13_21 = new Glyph();
                                                                                                            var4_8 = var3_6;
                                                                                                            var5_9 = var3_6;
                                                                                                            var13_21.id = 32;
                                                                                                            var4_8 = var3_6;
                                                                                                            var5_9 = var3_6;
                                                                                                            var14_24 = this.getGlyph('l');
                                                                                                            var6_11 = var14_24;
                                                                                                            if (var14_24 != null) break block225;
                                                                                                            var4_8 = var3_6;
                                                                                                            var5_9 = var3_6;
                                                                                                            var6_11 = this.getFirstGlyph();
                                                                                                        }
                                                                                                        var4_8 = var3_6;
                                                                                                        var5_9 = var3_6;
                                                                                                        var13_21.xadvance = var6_11.xadvance;
                                                                                                        var4_8 = var3_6;
                                                                                                        var5_9 = var3_6;
                                                                                                        this.setGlyph(32, (Glyph)var13_21);
                                                                                                        var6_11 = var13_21;
                                                                                                    }
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    if (var6_11.width != 0) break block226;
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var6_11.width = (int)(this.padLeft + (float)var6_11.xadvance + this.padRight);
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var6_11.xoffset = (int)(-this.padLeft);
                                                                                                }
                                                                                                var4_8 = var3_6;
                                                                                                var5_9 = var3_6;
                                                                                                this.spaceXadvance = var6_11.xadvance;
                                                                                                var4_8 = var3_6;
                                                                                                var5_9 = var3_6;
                                                                                                var13_21 = (Glyph[][])this.xChars;
                                                                                                var4_8 = var3_6;
                                                                                                var5_9 = var3_6;
                                                                                                var7_15 = var13_21.length;
                                                                                                var5_9 = null;
                                                                                                for (var12_20 = 0; var12_20 < var7_15; ++var12_20) {
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var6_11 = this.getGlyph((char)var13_21[var12_20]);
                                                                                                    if (var6_11 != null) {
                                                                                                        var5_9 = var6_11;
                                                                                                        break;
                                                                                                    }
                                                                                                    var5_9 = var6_11;
                                                                                                    continue;
                                                                                                }
                                                                                                var6_11 = var5_9;
                                                                                                if (var5_9 == null) {
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var6_11 = this.getFirstGlyph();
                                                                                                }
                                                                                                var4_8 = var3_6;
                                                                                                var5_9 = var3_6;
                                                                                                this.xHeight = (float)var6_11.height - var8_16;
                                                                                                var4_8 = var3_6;
                                                                                                var5_9 = var3_6;
                                                                                                var13_21 = (Glyph[][])this.capChars;
                                                                                                var4_8 = var3_6;
                                                                                                var5_9 = var3_6;
                                                                                                var12_20 = var13_21.length;
                                                                                                var7_15 = 0;
                                                                                                var5_9 = null;
                                                                                                while (true) {
                                                                                                    var4_8 = var5_9;
                                                                                                    if (var7_15 >= var12_20) break;
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var6_11 = this.getGlyph((char)var13_21[var7_15]);
                                                                                                    if (var6_11 != null) {
                                                                                                        var4_8 = var6_11;
                                                                                                        break;
                                                                                                    }
                                                                                                    ++var7_15;
                                                                                                    var5_9 = var6_11;
                                                                                                    continue;
                                                                                                    break;
                                                                                                }
                                                                                                if (var4_8 == null) {
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var13_21 = this.glyphs;
                                                                                                    var4_8 = var3_6;
                                                                                                    var5_9 = var3_6;
                                                                                                    var12_20 = var13_21.length;
                                                                                                    var6_11 = var3_6;
                                                                                                    for (var7_15 = 0; var7_15 < var12_20; ++var7_15) {
                                                                                                        var14_24 = var13_21[var7_15];
                                                                                                        if (var14_24 == null) continue;
                                                                                                        var4_8 = var6_11;
                                                                                                        var5_9 = var6_11;
                                                                                                        var23_34 = var14_24.length;
                                                                                                        var4_8 = var6_11;
                                                                                                        for (var24_35 = 0; var24_35 < var23_34; ++var24_35) {
                                                                                                            var15_26 = var14_24[var24_35];
                                                                                                            if (var15_26 == null) continue;
                                                                                                            var5_9 = var4_8;
                                                                                                            var3_6 = var4_8;
                                                                                                            if (var15_26.height == 0) continue;
                                                                                                            var5_9 = var4_8;
                                                                                                            var3_6 = var4_8;
                                                                                                            if (var15_26.width == 0) continue;
                                                                                                            var5_9 = var4_8;
                                                                                                            var3_6 = var4_8;
                                                                                                            this.capHeight = Math.max(this.capHeight, (float)var15_26.height);
                                                                                                        }
                                                                                                    }
                                                                                                } else {
                                                                                                    var5_9 = var6_11 = var3_6;
                                                                                                    var3_6 = var6_11;
                                                                                                    this.capHeight = var4_8.height;
                                                                                                }
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.capHeight -= var8_16;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.ascent = var9_17 - this.capHeight;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.down = -this.lineHeight;
                                                                                                if (!var2_5) break block227;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.ascent = -this.ascent;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.down = -this.down;
                                                                                            }
                                                                                            if (var11_19 != 0) {
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.ascent = var16_27;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.descent = var17_28;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.down = var18_29;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.capHeight = var19_30;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.lineHeight = var20_31;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.spaceXadvance = var21_32;
                                                                                                var5_9 = var6_11;
                                                                                                var3_6 = var6_11;
                                                                                                this.xHeight = var22_33;
                                                                                            }
                                                                                            StreamUtils.closeQuietly((Closeable)var6_11);
                                                                                            return;
                                                                                        }
                                                                                        var5_9 = var6_11 = var3_6;
                                                                                        var3_6 = var6_11;
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var4_8 = new StringTokenizer((String)var13_21, " =");
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var4_8.nextToken();
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var4_8.nextToken();
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var12_20 = Integer.parseInt(var4_8.nextToken());
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var4_8.nextToken();
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var11_19 = Integer.parseInt(var4_8.nextToken());
                                                                                        if (var12_20 < 0 || var12_20 > 65535 || var11_19 < 0 || var11_19 > 65535) break block228;
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var13_21 = this.getGlyph((char)var12_20);
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var4_8.nextToken();
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var12_20 = Integer.parseInt(var4_8.nextToken());
                                                                                        if (var13_21 == null) break block228;
                                                                                        var5_9 = var6_11;
                                                                                        var3_6 = var6_11;
                                                                                        var13_21.setKerning(var11_19, var12_20);
                                                                                    }
                                                                                    var3_6 = var6_11;
                                                                                }
                                                                            }
                                                                            var5_9 = var6_11 = var3_6;
                                                                            var3_6 = var6_11;
                                                                            if (var13_21.startsWith("char ")) break;
lbl587:
                                                                            // 5 sources

                                                                            while (true) {
                                                                                var3_6 = var6_11;
                                                                                continue block192;
                                                                                break;
                                                                            }
                                                                            break;
                                                                        }
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var4_8 = new Glyph();
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var14_24 = new StringTokenizer((String)var13_21, " =");
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var14_24.nextToken();
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var14_24.nextToken();
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        var11_19 = Integer.parseInt(var14_24.nextToken());
                                                                        if (var11_19 > 0) break block229;
                                                                        var5_9 = var6_11;
                                                                        var3_6 = var6_11;
                                                                        this.missingGlyph = var4_8;
                                                                        break block230;
                                                                    }
                                                                    if (var11_19 > 65535) ** GOTO lbl587
                                                                    var5_9 = var6_11;
                                                                    var3_6 = var6_11;
                                                                    this.setGlyph(var11_19, (Glyph)var4_8);
                                                                }
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.id = var11_19;
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var14_24.nextToken();
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.srcX = Integer.parseInt(var14_24.nextToken());
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var14_24.nextToken();
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.srcY = Integer.parseInt(var14_24.nextToken());
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var14_24.nextToken();
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.width = Integer.parseInt(var14_24.nextToken());
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var14_24.nextToken();
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.height = Integer.parseInt(var14_24.nextToken());
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var14_24.nextToken();
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.xoffset = Integer.parseInt(var14_24.nextToken());
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var14_24.nextToken();
                                                                if (!var2_5) break block231;
                                                                var5_9 = var6_11;
                                                                var3_6 = var6_11;
                                                                var4_8.yoffset = Integer.parseInt(var14_24.nextToken());
                                                                break block232;
                                                            }
                                                            var5_9 = var6_11;
                                                            var3_6 = var6_11;
                                                            var4_8.yoffset = -(var4_8.height + Integer.parseInt(var14_24.nextToken()));
                                                        }
                                                        var5_9 = var6_11;
                                                        var3_6 = var6_11;
                                                        var14_24.nextToken();
                                                        var5_9 = var6_11;
                                                        var3_6 = var6_11;
                                                        var4_8.xadvance = Integer.parseInt(var14_24.nextToken());
                                                        var5_9 = var6_11;
                                                        var3_6 = var6_11;
                                                        if (!var14_24.hasMoreTokens()) break block233;
                                                        var5_9 = var6_11;
                                                        var3_6 = var6_11;
                                                        var14_24.nextToken();
                                                    }
                                                    var5_9 = var6_11;
                                                    var3_6 = var6_11;
                                                    var10_18 = var14_24.hasMoreTokens();
                                                    if (!var10_18) break block234;
                                                    var5_9 = var6_11;
                                                    var3_6 = var6_11;
                                                    var4_8.page = Integer.parseInt(var14_24.nextToken());
                                                }
lbl724:
                                                // 2 sources

                                                while (true) {
                                                    var5_9 = var6_11;
                                                    var3_6 = var6_11;
                                                    if (var4_8.width <= 0) ** GOTO lbl587
                                                    var5_9 = var6_11;
                                                    var3_6 = var6_11;
                                                    if (var4_8.height <= 0) ** GOTO lbl587
                                                    var5_9 = var6_11;
                                                    var3_6 = var6_11;
                                                    this.descent = Math.min((float)var4_8.yoffset + var9_17, this.descent);
                                                    ** continue;
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        var5_9 = var6_11 = var3_6;
                                        var3_6 = var6_11;
                                        var5_9 = var6_11;
                                        var3_6 = var6_11;
                                        var4_8 = new GdxRuntimeException("Missing: base");
                                        var5_9 = var6_11;
                                        var3_6 = var6_11;
                                        throw var4_8;
                                    }
                                    var5_9 = var6_11 = var3_6;
                                    var3_6 = var6_11;
                                    var5_9 = var6_11;
                                    var3_6 = var6_11;
                                    var4_8 = new GdxRuntimeException("Missing: lineHeight");
                                    var5_9 = var6_11;
                                    var3_6 = var6_11;
                                    throw var4_8;
                                }
                                var5_9 = var6_11 = var3_6;
                                var3_6 = var6_11;
                                var5_9 = var6_11;
                                var3_6 = var6_11;
                                var4_8 = new GdxRuntimeException("Invalid common header.");
                                var5_9 = var6_11;
                                var3_6 = var6_11;
                                throw var4_8;
                            }
                            var5_9 = var6_11 = var3_6;
                            var3_6 = var6_11;
                            var5_9 = var6_11;
                            var3_6 = var6_11;
                            var4_8 = new GdxRuntimeException("Missing common header.");
                            var5_9 = var6_11;
                            var3_6 = var6_11;
                            throw var4_8;
                        }
                        var5_9 = var6_11 = var3_6;
                        var3_6 = var6_11;
                        var5_9 = var6_11;
                        var3_6 = var6_11;
                        var4_8 = new GdxRuntimeException("Invalid padding.");
                        var5_9 = var6_11;
                        var3_6 = var6_11;
                        throw var4_8;
                    }
                    var5_9 = var6_11 = var3_6;
                    var3_6 = var6_11;
                    var5_9 = var6_11;
                    var3_6 = var6_11;
                    var4_8 = new GdxRuntimeException("File is empty.");
                    var5_9 = var6_11;
                    var3_6 = var6_11;
                    try {
                        throw var4_8;
                    }
                    catch (Exception var6_12) {}
lbl-1000:
                    // 89 sources

                    {
                        catch (Throwable var1_2) {
                            var3_6 = var4_8;
                            break block235;
                        }
lbl808:
                        // 89 sources

                        catch (Exception var6_13) {
                            // empty catch block
                        }
                    }
lbl810:
                    // 2 sources

                    while (true) {
                        var3_6 = var5_9;
                        var3_6 = var5_9;
                        var3_6 = var5_9;
                        try {
                            var13_21 = new StringBuilder();
                            var3_6 = var5_9;
                        }
                        catch (Throwable var1_4) {}
                        var13_21.append("Error loading font file: ");
                        var3_6 = var5_9;
                        var13_21.append(var1_1);
                        var3_6 = var5_9;
                        var4_8 = new GdxRuntimeException(var13_21.toString(), (Throwable)var6_14);
                        var3_6 = var5_9;
                        throw var4_8;
                        break;
                    }
                    finally {
                        ** continue;
                    }
                }
                StreamUtils.closeQuietly((Closeable)var3_6);
                throw var1_3;
            }
            var1_1 = new IllegalStateException("Already loaded.");
            throw var1_1;
            catch (NumberFormatException var5_10) {
                ** continue;
            }
            catch (NumberFormatException var3_7) {
                ** continue;
            }
        }

        public void scale(float f) {
            this.setScale(this.scaleX + f, this.scaleY + f);
        }

        public void setGlyph(int n, Glyph glyph) {
            Glyph[] glyphArray;
            Glyph[][] glyphArray2 = this.glyphs;
            int n2 = n / 512;
            Glyph[] glyphArray3 = glyphArray = glyphArray2[n2];
            if (glyphArray == null) {
                glyphArray3 = new Glyph[512];
                glyphArray2[n2] = glyphArray3;
            }
            glyphArray3[n & 0x1FF] = glyph;
        }

        public void setGlyphRegion(Glyph glyph, TextureRegion textureRegion) {
            float f;
            float f2;
            Texture texture = textureRegion.getTexture();
            float f3 = 1.0f / (float)texture.getWidth();
            float f4 = 1.0f / (float)texture.getHeight();
            float f5 = textureRegion.u;
            float f6 = textureRegion.v;
            float f7 = textureRegion.getRegionWidth();
            float f8 = textureRegion.getRegionHeight();
            if (textureRegion instanceof TextureAtlas.AtlasRegion) {
                textureRegion = (TextureAtlas.AtlasRegion)textureRegion;
                f2 = ((TextureAtlas.AtlasRegion)textureRegion).offsetX;
                f = (float)(((TextureAtlas.AtlasRegion)textureRegion).originalHeight - ((TextureAtlas.AtlasRegion)textureRegion).packedHeight) - ((TextureAtlas.AtlasRegion)textureRegion).offsetY;
            } else {
                f = 0.0f;
                f2 = 0.0f;
            }
            float f9 = glyph.srcX;
            float f10 = glyph.srcX + glyph.width;
            float f11 = glyph.srcY;
            float f12 = glyph.srcY + glyph.height;
            if (f2 > 0.0f) {
                float f13;
                f9 = f13 = f9 - f2;
                if (f13 < 0.0f) {
                    glyph.width = (int)((float)glyph.width + f13);
                    glyph.xoffset = (int)((float)glyph.xoffset - f13);
                    f9 = 0.0f;
                }
                if ((f2 = f10 - f2) > f7) {
                    glyph.width = (int)((float)glyph.width - (f2 - f7));
                    f2 = f7;
                    f7 = f9;
                } else {
                    f7 = f9;
                }
            } else {
                f2 = f10;
                f7 = f9;
            }
            if (f > 0.0f) {
                f9 = f11 - f;
                if (f9 < 0.0f) {
                    glyph.height = (int)((float)glyph.height + f9);
                    if (glyph.height < 0) {
                        glyph.height = 0;
                    }
                    f9 = 0.0f;
                }
                f11 = f12 - f;
                f12 = f9;
                f = f11;
                if (f11 > f8) {
                    f = f11 - f8;
                    glyph.height = (int)((float)glyph.height - f);
                    glyph.yoffset = (int)((float)glyph.yoffset + f);
                    f = f8;
                    f12 = f9;
                }
            } else {
                f = f12;
                f12 = f11;
            }
            glyph.u = f7 * f3 + f5;
            glyph.u2 = f5 + f2 * f3;
            if (this.flipped) {
                glyph.v = f12 * f4 + f6;
                glyph.v2 = f6 + f * f4;
            } else {
                glyph.v2 = f12 * f4 + f6;
                glyph.v = f6 + f * f4;
            }
        }

        public void setLineHeight(float f) {
            this.lineHeight = f * this.scaleY;
            f = this.flipped ? this.lineHeight : -this.lineHeight;
            this.down = f;
        }

        public void setScale(float f) {
            this.setScale(f, f);
        }

        public void setScale(float f, float f2) {
            if (f != 0.0f) {
                if (f2 != 0.0f) {
                    float f3 = f / this.scaleX;
                    float f4 = f2 / this.scaleY;
                    this.lineHeight *= f4;
                    this.spaceXadvance *= f3;
                    this.xHeight *= f4;
                    this.capHeight *= f4;
                    this.ascent *= f4;
                    this.descent *= f4;
                    this.down *= f4;
                    this.padLeft *= f3;
                    this.padRight *= f3;
                    this.padTop *= f4;
                    this.padBottom *= f4;
                    this.scaleX = f;
                    this.scaleY = f2;
                    return;
                }
                throw new IllegalArgumentException("scaleY cannot be 0.");
            }
            throw new IllegalArgumentException("scaleX cannot be 0.");
        }

        public String toString() {
            String string2 = this.name;
            if (string2 == null) {
                string2 = super.toString();
            }
            return string2;
        }
    }

    public static class Glyph {
        public boolean fixedWidth;
        public int height;
        public int id;
        public byte[][] kerning;
        public int page = 0;
        public int srcX;
        public int srcY;
        public float u;
        public float u2;
        public float v;
        public float v2;
        public int width;
        public int xadvance;
        public int xoffset;
        public int yoffset;

        public int getKerning(char c) {
            Object object = this.kerning;
            if (object != null && (object = (Object)object[c >>> 9]) != null) {
                return (int)object[c & 0x1FF];
            }
            return 0;
        }

        public void setKerning(int n, int n2) {
            byte[] byArray;
            if (this.kerning == null) {
                this.kerning = new byte[128][];
            }
            byte[][] byArray2 = this.kerning;
            int n3 = n >>> 9;
            byte[] byArray3 = byArray = byArray2[n3];
            if (byArray == null) {
                byArray3 = new byte[512];
                byArray2[n3] = byArray3;
            }
            byArray3[n & 0x1FF] = (byte)n2;
        }

        public String toString() {
            return Character.toString((char)this.id);
        }
    }
}

