/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Gdx2DPixmap;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Pixmap
implements Disposable {
    private Blending blending = Blending.SourceOver;
    int color = 0;
    private boolean disposed;
    private Filter filter = Filter.BiLinear;
    final Gdx2DPixmap pixmap;

    public Pixmap(int n, int n2, Format format) {
        this.pixmap = new Gdx2DPixmap(n, n2, Format.toGdx2DPixmapFormat(format));
        this.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fill();
    }

    public Pixmap(FileHandle fileHandle) {
        try {
            Gdx2DPixmap gdx2DPixmap;
            byte[] byArray = fileHandle.readBytes();
            this.pixmap = gdx2DPixmap = new Gdx2DPixmap(byArray, 0, byArray.length, 0);
            return;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't load file: ");
            stringBuilder.append(fileHandle);
            throw new GdxRuntimeException(stringBuilder.toString(), exception);
        }
    }

    public Pixmap(Gdx2DPixmap gdx2DPixmap) {
        this.pixmap = gdx2DPixmap;
    }

    public Pixmap(byte[] byArray, int n, int n2) {
        try {
            Gdx2DPixmap gdx2DPixmap;
            this.pixmap = gdx2DPixmap = new Gdx2DPixmap(byArray, n, n2, 0);
            return;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load pixmap from image data", iOException);
        }
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.pixmap.dispose();
            this.disposed = true;
            return;
        }
        throw new GdxRuntimeException("Pixmap already disposed!");
    }

    public void drawCircle(int n, int n2, int n3) {
        this.pixmap.drawCircle(n, n2, n3, this.color);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.pixmap.drawLine(n, n2, n3, n4, this.color);
    }

    public void drawPixel(int n, int n2) {
        this.pixmap.setPixel(n, n2, this.color);
    }

    public void drawPixel(int n, int n2, int n3) {
        this.pixmap.setPixel(n, n2, n3);
    }

    public void drawPixmap(Pixmap pixmap, int n, int n2) {
        this.drawPixmap(pixmap, n, n2, 0, 0, pixmap.getWidth(), pixmap.getHeight());
    }

    public void drawPixmap(Pixmap pixmap, int n, int n2, int n3, int n4, int n5, int n6) {
        this.pixmap.drawPixmap(pixmap.pixmap, n3, n4, n, n2, n5, n6);
    }

    public void drawPixmap(Pixmap pixmap, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.pixmap.drawPixmap(pixmap.pixmap, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        this.pixmap.drawRect(n, n2, n3, n4, this.color);
    }

    public void fill() {
        this.pixmap.clear(this.color);
    }

    public void fillCircle(int n, int n2, int n3) {
        this.pixmap.fillCircle(n, n2, n3, this.color);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        this.pixmap.fillRect(n, n2, n3, n4, this.color);
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.pixmap.fillTriangle(n, n2, n3, n4, n5, n6, this.color);
    }

    public Blending getBlending() {
        return this.blending;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Format getFormat() {
        return Format.fromGdx2DPixmapFormat(this.pixmap.getFormat());
    }

    public int getGLFormat() {
        return this.pixmap.getGLFormat();
    }

    public int getGLInternalFormat() {
        return this.pixmap.getGLInternalFormat();
    }

    public int getGLType() {
        return this.pixmap.getGLType();
    }

    public int getHeight() {
        return this.pixmap.getHeight();
    }

    public int getPixel(int n, int n2) {
        return this.pixmap.getPixel(n, n2);
    }

    public ByteBuffer getPixels() {
        if (!this.disposed) {
            return this.pixmap.getPixels();
        }
        throw new GdxRuntimeException("Pixmap already disposed");
    }

    public int getWidth() {
        return this.pixmap.getWidth();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setBlending(Blending blending) {
        this.blending = blending;
        Gdx2DPixmap gdx2DPixmap = this.pixmap;
        int n = blending == Blending.None ? 0 : 1;
        gdx2DPixmap.setBlend(n);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color = Color.rgba8888(f, f2, f3, f4);
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setColor(Color color2) {
        this.color = Color.rgba8888(color2.r, color2.g, color2.b, color2.a);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        Gdx2DPixmap gdx2DPixmap = this.pixmap;
        int n = filter == Filter.NearestNeighbour ? 0 : 1;
        gdx2DPixmap.setScale(n);
    }

    public static enum Blending {
        None,
        SourceOver;

    }

    public static enum Filter {
        NearestNeighbour,
        BiLinear;

    }

    public static enum Format {
        Alpha,
        Intensity,
        LuminanceAlpha,
        RGB565,
        RGBA4444,
        RGB888,
        RGBA8888;


        public static Format fromGdx2DPixmapFormat(int n) {
            if (n == 1) {
                return Alpha;
            }
            if (n == 2) {
                return LuminanceAlpha;
            }
            if (n == 5) {
                return RGB565;
            }
            if (n == 6) {
                return RGBA4444;
            }
            if (n == 3) {
                return RGB888;
            }
            if (n == 4) {
                return RGBA8888;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unknown Gdx2DPixmap Format: ");
            stringBuilder.append(n);
            throw new GdxRuntimeException(stringBuilder.toString());
        }

        public static int toGdx2DPixmapFormat(Format format) {
            if (format == Alpha) {
                return 1;
            }
            if (format == Intensity) {
                return 1;
            }
            if (format == LuminanceAlpha) {
                return 2;
            }
            if (format == RGB565) {
                return 5;
            }
            if (format == RGBA4444) {
                return 6;
            }
            if (format == RGB888) {
                return 3;
            }
            if (format == RGBA8888) {
                return 4;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unknown Format: ");
            stringBuilder.append((Object)format);
            throw new GdxRuntimeException(stringBuilder.toString());
        }

        public static int toGlFormat(Format format) {
            return Gdx2DPixmap.toGlFormat(Format.toGdx2DPixmapFormat(format));
        }

        public static int toGlType(Format format) {
            return Gdx2DPixmap.toGlType(Format.toGdx2DPixmapFormat(format));
        }
    }
}

