/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.CubemapLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FacedCubemapData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Cubemap
extends GLTexture {
    private static AssetManager assetManager;
    static final Map<Application, Array<Cubemap>> managedCubemaps;
    protected CubemapData data;

    static {
        managedCubemaps = new HashMap<Application, Array<Cubemap>>();
    }

    public Cubemap(int n, int n2, int n3, Pixmap.Format format) {
        this(new PixmapTextureData(new Pixmap(n3, n2, format), null, false, true), new PixmapTextureData(new Pixmap(n3, n2, format), null, false, true), new PixmapTextureData(new Pixmap(n, n3, format), null, false, true), new PixmapTextureData(new Pixmap(n, n3, format), null, false, true), new PixmapTextureData(new Pixmap(n, n2, format), null, false, true), new PixmapTextureData(new Pixmap(n, n2, format), null, false, true));
    }

    public Cubemap(FileHandle fileHandle, FileHandle fileHandle2, FileHandle fileHandle3, FileHandle fileHandle4, FileHandle fileHandle5, FileHandle fileHandle6) {
        this(fileHandle, fileHandle2, fileHandle3, fileHandle4, fileHandle5, fileHandle6, false);
    }

    public Cubemap(FileHandle fileHandle, FileHandle fileHandle2, FileHandle fileHandle3, FileHandle fileHandle4, FileHandle fileHandle5, FileHandle fileHandle6, boolean bl) {
        this(TextureData.Factory.loadFromFile(fileHandle, bl), TextureData.Factory.loadFromFile(fileHandle2, bl), TextureData.Factory.loadFromFile(fileHandle3, bl), TextureData.Factory.loadFromFile(fileHandle4, bl), TextureData.Factory.loadFromFile(fileHandle5, bl), TextureData.Factory.loadFromFile(fileHandle6, bl));
    }

    public Cubemap(CubemapData cubemapData) {
        super(34067);
        this.data = cubemapData;
        this.load(cubemapData);
    }

    public Cubemap(Pixmap pixmap, Pixmap pixmap2, Pixmap pixmap3, Pixmap pixmap4, Pixmap pixmap5, Pixmap pixmap6) {
        this(pixmap, pixmap2, pixmap3, pixmap4, pixmap5, pixmap6, false);
    }

    public Cubemap(Pixmap object, Pixmap object2, Pixmap object3, Pixmap object4, Pixmap object5, Pixmap object6, boolean bl) {
        object = object == null ? null : new PixmapTextureData((Pixmap)object, null, bl, false);
        object2 = object2 == null ? null : new PixmapTextureData((Pixmap)object2, null, bl, false);
        object3 = object3 == null ? null : new PixmapTextureData((Pixmap)object3, null, bl, false);
        object4 = object4 == null ? null : new PixmapTextureData((Pixmap)object4, null, bl, false);
        object5 = object5 == null ? null : new PixmapTextureData((Pixmap)object5, null, bl, false);
        object6 = object6 == null ? null : new PixmapTextureData((Pixmap)object6, null, bl, false);
        this((TextureData)object, (TextureData)object2, (TextureData)object3, (TextureData)object4, (TextureData)object5, (TextureData)object6);
    }

    public Cubemap(TextureData textureData, TextureData textureData2, TextureData textureData3, TextureData textureData4, TextureData textureData5, TextureData textureData6) {
        super(34067);
        this.minFilter = Texture.TextureFilter.Nearest;
        this.magFilter = Texture.TextureFilter.Nearest;
        this.uWrap = Texture.TextureWrap.ClampToEdge;
        this.vWrap = Texture.TextureWrap.ClampToEdge;
        this.data = new FacedCubemapData(textureData, textureData2, textureData3, textureData4, textureData5, textureData6);
        this.load(this.data);
    }

    private static void addManagedCubemap(Application application, Cubemap cubemap) {
        Array<Cubemap> array;
        Array<Cubemap> array2 = array = managedCubemaps.get(application);
        if (array == null) {
            array2 = new Array();
        }
        array2.add(cubemap);
        managedCubemaps.put(application, array2);
    }

    public static void clearAllCubemaps(Application application) {
        managedCubemaps.remove(application);
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed cubemap/app: { ");
        for (Application application : managedCubemaps.keySet()) {
            stringBuilder.append(Cubemap.managedCubemaps.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedCubemaps() {
        return Cubemap.managedCubemaps.get((Object)Gdx.app).size;
    }

    public static void invalidateAllCubemaps(Application object) {
        int n;
        if ((object = managedCubemaps.get(object)) == null) {
            return;
        }
        AssetManager assetManager = Cubemap.assetManager;
        if (assetManager == null) {
            for (n = 0; n < ((Array)object).size; ++n) {
                ((Cubemap)((Array)object).get(n)).reload();
            }
        } else {
            assetManager.finishLoading();
            Array array = new Array(object);
            for (Cubemap cubemap : array) {
                String string2 = Cubemap.assetManager.getAssetFileName(cubemap);
                if (string2 == null) {
                    cubemap.reload();
                    continue;
                }
                n = Cubemap.assetManager.getReferenceCount(string2);
                Cubemap.assetManager.setReferenceCount(string2, 0);
                cubemap.glHandle = 0;
                CubemapLoader.CubemapParameter cubemapParameter = new CubemapLoader.CubemapParameter();
                cubemapParameter.cubemapData = cubemap.getCubemapData();
                cubemapParameter.minFilter = cubemap.getMinFilter();
                cubemapParameter.magFilter = cubemap.getMagFilter();
                cubemapParameter.wrapU = cubemap.getUWrap();
                cubemapParameter.wrapV = cubemap.getVWrap();
                cubemapParameter.cubemap = cubemap;
                cubemapParameter.loadedCallback = new AssetLoaderParameters.LoadedCallback(){

                    @Override
                    public void finishedLoading(AssetManager assetManager, String string2, Class clazz) {
                        assetManager.setReferenceCount(string2, n);
                    }
                };
                Cubemap.assetManager.unload(string2);
                cubemap.glHandle = Gdx.gl.glGenTexture();
                Cubemap.assetManager.load(string2, Cubemap.class, cubemapParameter);
            }
            ((Array)object).clear();
            ((Array)object).addAll(array);
        }
    }

    public static void setAssetManager(AssetManager assetManager) {
        Cubemap.assetManager = assetManager;
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedCubemaps.get(Gdx.app) != null) {
            managedCubemaps.get(Gdx.app).removeValue(this, true);
        }
    }

    public CubemapData getCubemapData() {
        return this.data;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    public void load(CubemapData cubemapData) {
        if (!cubemapData.isPrepared()) {
            cubemapData.prepare();
        }
        this.bind();
        this.unsafeSetFilter(this.minFilter, this.magFilter, true);
        this.unsafeSetWrap(this.uWrap, this.vWrap, true);
        cubemapData.consumeCubemapData();
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    @Override
    protected void reload() {
        if (this.isManaged()) {
            this.glHandle = Gdx.gl.glGenTexture();
            this.load(this.data);
            return;
        }
        throw new GdxRuntimeException("Tried to reload an unmanaged Cubemap");
    }

    public static enum CubemapSide {
        PositiveX(0, 34069, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f),
        NegativeX(1, 34070, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f),
        PositiveY(2, 34071, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f),
        NegativeY(3, 34072, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f),
        PositiveZ(4, 34073, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f),
        NegativeZ(5, 34074, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);

        public final Vector3 direction;
        public final int glEnum;
        public final int index;
        public final Vector3 up;

        private CubemapSide(int n2, int n3, float f, float f2, float f3, float f4, float f5, float f6) {
            this.index = n2;
            this.glEnum = n3;
            this.up = new Vector3(f, f2, f3);
            this.direction = new Vector3(f4, f5, f6);
        }

        public Vector3 getDirection(Vector3 vector3) {
            return vector3.set(this.direction);
        }

        public int getGLEnum() {
            return this.glEnum;
        }

        public Vector3 getUp(Vector3 vector3) {
            return vector3.set(this.up);
        }
    }
}

