/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android.surfaceview;

import android.opengl.GLSurfaceView;
import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class GdxEglConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    public static final int EGL_COVERAGE_BUFFERS_NV = 12512;
    public static final int EGL_COVERAGE_SAMPLES_NV = 12513;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final String TAG = "GdxEglConfigChooser";
    protected int mAlphaSize;
    protected int mBlueSize;
    protected final int[] mConfigAttribs;
    protected int mDepthSize;
    protected int mGreenSize;
    protected int mNumSamples;
    protected int mRedSize;
    protected int mStencilSize;
    private int[] mValue = new int[1];

    public GdxEglConfigChooser(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mRedSize = n;
        this.mGreenSize = n2;
        this.mBlueSize = n3;
        this.mAlphaSize = n4;
        this.mDepthSize = n5;
        this.mStencilSize = n6;
        this.mNumSamples = n7;
        this.mConfigAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344};
    }

    private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
        if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
            return this.mValue[0];
        }
        return n2;
    }

    private void printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
        int[] nArray;
        int[] nArray2 = nArray = new int[35];
        nArray[0] = 12320;
        nArray2[1] = 12321;
        nArray2[2] = 12322;
        nArray2[3] = 12323;
        nArray2[4] = 12324;
        nArray2[5] = 12325;
        nArray2[6] = 12326;
        nArray2[7] = 12327;
        nArray2[8] = 12328;
        nArray2[9] = 12329;
        nArray2[10] = 12330;
        nArray2[11] = 12331;
        nArray2[12] = 12332;
        nArray2[13] = 12333;
        nArray2[14] = 12334;
        nArray2[15] = 12335;
        nArray2[16] = 12336;
        nArray2[17] = 12337;
        nArray2[18] = 12338;
        nArray2[19] = 12339;
        nArray2[20] = 12340;
        nArray2[21] = 12343;
        nArray2[22] = 12342;
        nArray2[23] = 12341;
        nArray2[24] = 12345;
        nArray2[25] = 12346;
        nArray2[26] = 12347;
        nArray2[27] = 12348;
        nArray2[28] = 12349;
        nArray2[29] = 12350;
        nArray2[30] = 12351;
        nArray2[31] = 12352;
        nArray2[32] = 12354;
        nArray2[33] = 12512;
        nArray2[34] = 12513;
        int[] nArray3 = new int[1];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string2 = (new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT", "EGL_COVERAGE_BUFFERS_NV", "EGL_COVERAGE_SAMPLES_NV"})[i];
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray3)) {
                Log.w((String)TAG, (String)String.format("  %s: %d\n", string2, nArray3[0]));
                continue;
            }
            eGL10.eglGetError();
        }
    }

    private void printConfigs(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
        int n = eGLConfigArray.length;
        Log.w((String)TAG, (String)String.format("%d configurations", n));
        for (int i = 0; i < n; ++i) {
            Log.w((String)TAG, (String)String.format("Configuration %d:\n", i));
            this.printConfig(eGL10, eGLDisplay, eGLConfigArray[i]);
        }
    }

    public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
        int[] nArray = new int[1];
        eGL10.eglChooseConfig(eGLDisplay, this.mConfigAttribs, null, 0, nArray);
        int n = nArray[0];
        if (n > 0) {
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            eGL10.eglChooseConfig(eGLDisplay, this.mConfigAttribs, eGLConfigArray, n, nArray);
            return this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
        }
        throw new IllegalArgumentException("No configs match configSpec");
    }

    public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
        EGLConfig eGLConfig;
        EGLConfig eGLConfig2;
        EGLConfig eGLConfig3;
        block17: {
            EGLConfig eGLConfig4;
            EGLConfig eGLConfig5;
            int n = eGLConfigArray.length;
            eGLConfig3 = eGLConfig5 = (eGLConfig4 = null);
            for (int i = 0; i < n; ++i) {
                block21: {
                    block18: {
                        block20: {
                            block19: {
                                eGLConfig2 = eGLConfigArray[i];
                                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12325, 0);
                                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12326, 0);
                                if (n2 < this.mDepthSize || n3 < this.mStencilSize) break block18;
                                n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12324, 0);
                                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12323, 0);
                                n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12322, 0);
                                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12321, 0);
                                eGLConfig = eGLConfig4;
                                if (eGLConfig4 == null) {
                                    eGLConfig = eGLConfig4;
                                    if (n2 == 5) {
                                        eGLConfig = eGLConfig4;
                                        if (n4 == 6) {
                                            eGLConfig = eGLConfig4;
                                            if (n3 == 5) {
                                                eGLConfig = eGLConfig4;
                                                if (n5 == 0) {
                                                    eGLConfig = eGLConfig2;
                                                }
                                            }
                                        }
                                    }
                                }
                                eGLConfig4 = eGLConfig5;
                                if (eGLConfig5 == null) {
                                    eGLConfig4 = eGLConfig5;
                                    if (n2 == this.mRedSize) {
                                        eGLConfig4 = eGLConfig5;
                                        if (n4 == this.mGreenSize) {
                                            eGLConfig4 = eGLConfig5;
                                            if (n3 == this.mBlueSize) {
                                                eGLConfig4 = eGLConfig5;
                                                if (n5 == this.mAlphaSize) {
                                                    if (this.mNumSamples == 0) break block17;
                                                    eGLConfig4 = eGLConfig2;
                                                }
                                            }
                                        }
                                    }
                                }
                                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12338, 0);
                                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12337, 0);
                                if (eGLConfig3 == null && n6 == 1 && n7 >= this.mNumSamples && n2 == this.mRedSize && n4 == this.mGreenSize && n3 == this.mBlueSize && n5 == this.mAlphaSize) break block19;
                                n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12512, 0);
                                n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12513, 0);
                                eGLConfig5 = eGLConfig3;
                                if (eGLConfig3 != null) break block20;
                                eGLConfig5 = eGLConfig3;
                                if (n7 != 1) break block20;
                                eGLConfig5 = eGLConfig3;
                                if (n6 < this.mNumSamples) break block20;
                                eGLConfig5 = eGLConfig3;
                                if (n2 != this.mRedSize) break block20;
                                eGLConfig5 = eGLConfig3;
                                if (n4 != this.mGreenSize) break block20;
                                eGLConfig5 = eGLConfig3;
                                if (n3 != this.mBlueSize) break block20;
                                eGLConfig5 = eGLConfig3;
                                if (n5 != this.mAlphaSize) break block20;
                            }
                            eGLConfig5 = eGLConfig2;
                        }
                        eGLConfig2 = eGLConfig4;
                        eGLConfig4 = eGLConfig;
                        eGLConfig = eGLConfig2;
                        eGLConfig3 = eGLConfig5;
                        break block21;
                    }
                    eGLConfig = eGLConfig5;
                }
                eGLConfig5 = eGLConfig;
            }
            eGLConfig2 = eGLConfig5;
            eGLConfig = eGLConfig4;
        }
        if (eGLConfig3 != null) {
            return eGLConfig3;
        }
        if (eGLConfig2 != null) {
            return eGLConfig2;
        }
        return eGLConfig;
    }
}

