/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipResourceFile {
    static final boolean LOGV = false;
    static final String LOG_TAG = "zipro";
    static final int kCDECRC = 16;
    static final int kCDECommentLen = 32;
    static final int kCDECompLen = 20;
    static final int kCDEExtraLen = 30;
    static final int kCDELen = 46;
    static final int kCDELocalOffset = 42;
    static final int kCDEMethod = 10;
    static final int kCDEModWhen = 12;
    static final int kCDENameLen = 28;
    static final int kCDESignature = 33639248;
    static final int kCDEUncompLen = 24;
    static final int kCompressDeflated = 8;
    static final int kCompressStored = 0;
    static final int kEOCDFileOffset = 16;
    static final int kEOCDLen = 22;
    static final int kEOCDNumEntries = 8;
    static final int kEOCDSignature = 101010256;
    static final int kEOCDSize = 12;
    static final int kLFHExtraLen = 28;
    static final int kLFHLen = 30;
    static final int kLFHNameLen = 26;
    static final int kLFHSignature = 67324752;
    static final int kMaxCommentLen = 65535;
    static final int kMaxEOCDSearch = 65557;
    static final int kZipEntryAdj = 10000;
    private HashMap<String, ZipEntryRO> mHashMap = new HashMap();
    ByteBuffer mLEByteBuffer;
    public HashMap<File, ZipFile> mZipFiles = new HashMap();

    public ZipResourceFile(String string2) throws IOException {
        this.mLEByteBuffer = ByteBuffer.allocate(4);
        this.addPatchFile(string2);
    }

    private static int read4LE(RandomAccessFile randomAccessFile) throws EOFException, IOException {
        return ZipResourceFile.swapEndian(randomAccessFile.readInt());
    }

    private static int swapEndian(int n) {
        return ((n & 0xFF) << 24) + ((0xFF00 & n) << 8) + ((0xFF0000 & n) >>> 8) + (n >>> 24 & 0xFF);
    }

    private static int swapEndian(short s) {
        return (s & 0xFF00) >>> 8 | (s & 0xFF) << 8;
    }

    void addPatchFile(String object) throws IOException {
        Object object2 = object;
        File file = new File((String)object2);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        if (l >= 22L) {
            long l2 = 65557L;
            if (65557L > l) {
                l2 = l;
            }
            randomAccessFile.seek(0L);
            int n = ZipResourceFile.read4LE(randomAccessFile);
            if (n != 101010256) {
                if (n == 67324752) {
                    randomAccessFile.seek(l - l2);
                    Object object3 = ByteBuffer.allocate((int)l2);
                    Object object4 = ((ByteBuffer)object3).array();
                    randomAccessFile.readFully((byte[])object4);
                    ((ByteBuffer)object3).order(ByteOrder.LITTLE_ENDIAN);
                    for (n = ((byte[])object4).length - 22; n >= 0 && (object4[n] != 80 || ((ByteBuffer)object3).getInt(n) != 101010256); --n) {
                    }
                    if (n < 0) {
                        object4 = new StringBuilder();
                        ((StringBuilder)object4).append("Zip: EOCD not found, ");
                        ((StringBuilder)object4).append((String)object2);
                        ((StringBuilder)object4).append(" is not zip");
                        Log.d((String)LOG_TAG, (String)((StringBuilder)object4).toString());
                    }
                    int n2 = ((ByteBuffer)object3).getShort(n + 8);
                    l2 = (long)((ByteBuffer)object3).getInt(n + 12) & 0xFFFFFFFFL;
                    long l3 = (long)((ByteBuffer)object3).getInt(n + 16) & 0xFFFFFFFFL;
                    if (l3 + l2 <= l) {
                        if (n2 != 0) {
                            object4 = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, l3, l2);
                            ((ByteBuffer)object4).order(ByteOrder.LITTLE_ENDIAN);
                            object3 = new byte[65535];
                            object2 = ByteBuffer.allocate(30);
                            ((ByteBuffer)object2).order(ByteOrder.LITTLE_ENDIAN);
                            n = 0;
                            for (int i = 0; i < n2; ++i) {
                                if (((ByteBuffer)object4).getInt(n) == 33639248) {
                                    int n3 = ((ByteBuffer)object4).getShort(n + 28) & 0xFFFF;
                                    short s = ((ByteBuffer)object4).getShort(n + 30);
                                    short s2 = ((ByteBuffer)object4).getShort(n + 32);
                                    ((MappedByteBuffer)object4).position(n + 46);
                                    ((ByteBuffer)object4).get((byte[])object3, 0, n3);
                                    ((MappedByteBuffer)object4).position(0);
                                    String string2 = new String((byte[])object3, 0, n3);
                                    ZipEntryRO zipEntryRO = new ZipEntryRO((String)object, file, string2);
                                    zipEntryRO.mMethod = ((ByteBuffer)object4).getShort(n + 10) & 0xFFFF;
                                    zipEntryRO.mWhenModified = (long)((ByteBuffer)object4).getInt(n + 12) & 0xFFFFFFFFL;
                                    zipEntryRO.mCRC32 = ((ByteBuffer)object4).getLong(n + 16) & 0xFFFFFFFFL;
                                    zipEntryRO.mCompressedLength = ((ByteBuffer)object4).getLong(n + 20) & 0xFFFFFFFFL;
                                    zipEntryRO.mUncompressedLength = ((ByteBuffer)object4).getLong(n + 24) & 0xFFFFFFFFL;
                                    zipEntryRO.mLocalHdrOffset = (long)((ByteBuffer)object4).getInt(n + 42) & 0xFFFFFFFFL;
                                    ((ByteBuffer)object2).clear();
                                    zipEntryRO.setOffsetFromFile(randomAccessFile, (ByteBuffer)object2);
                                    this.mHashMap.put(string2, zipEntryRO);
                                    n += n3 + 46 + (s & 0xFFFF) + (s2 & 0xFFFF);
                                    continue;
                                }
                                object = new StringBuilder();
                                ((StringBuilder)object).append("Missed a central dir sig (at ");
                                ((StringBuilder)object).append(n);
                                ((StringBuilder)object).append(")");
                                Log.w((String)LOG_TAG, (String)((StringBuilder)object).toString());
                                throw new IOException();
                            }
                            return;
                        }
                        Log.w((String)LOG_TAG, (String)"empty archive?");
                        throw new IOException();
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("bad offsets (dir ");
                    ((StringBuilder)object).append(l3);
                    ((StringBuilder)object).append(", size ");
                    ((StringBuilder)object).append(l2);
                    ((StringBuilder)object).append(", eocd ");
                    ((StringBuilder)object).append(n);
                    ((StringBuilder)object).append(")");
                    Log.w((String)LOG_TAG, (String)((StringBuilder)object).toString());
                    throw new IOException();
                }
                Log.v((String)LOG_TAG, (String)"Not a Zip archive");
                throw new IOException();
            }
            Log.i((String)LOG_TAG, (String)"Found Zip archive, but it looks empty");
            throw new IOException();
        }
        randomAccessFile.close();
        object = new IOException();
        throw object;
    }

    public ZipEntryRO[] getAllEntries() {
        Collection<ZipEntryRO> collection = this.mHashMap.values();
        return collection.toArray(new ZipEntryRO[collection.size()]);
    }

    public AssetFileDescriptor getAssetFileDescriptor(String object) {
        if ((object = this.mHashMap.get(object)) != null) {
            return ((ZipEntryRO)object).getAssetFileDescriptor();
        }
        return null;
    }

    ZipEntryRO[] getEntriesAt(String object) {
        Vector<Object> vector = new Vector<Object>();
        Object object2 = this.mHashMap.values();
        String string2 = object;
        if (object == null) {
            string2 = "";
        }
        int n = string2.length();
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (ZipEntryRO)object.next();
            if (!((ZipEntryRO)object2).mFileName.startsWith(string2) || -1 != ((ZipEntryRO)object2).mFileName.indexOf(47, n)) continue;
            vector.add(object2);
        }
        return vector.toArray(new ZipEntryRO[vector.size()]);
    }

    public InputStream getInputStream(String object) throws IOException {
        ZipEntryRO zipEntryRO = this.mHashMap.get(object);
        if (zipEntryRO != null) {
            ZipFile zipFile;
            if (zipEntryRO.isUncompressed()) {
                return zipEntryRO.getAssetFileDescriptor().createInputStream();
            }
            ZipFile zipFile2 = zipFile = this.mZipFiles.get(zipEntryRO.getZipFile());
            if (zipFile == null) {
                zipFile2 = new ZipFile(zipEntryRO.getZipFile(), 1);
                this.mZipFiles.put(zipEntryRO.getZipFile(), zipFile2);
            }
            if ((object = zipFile2.getEntry((String)object)) != null) {
                return zipFile2.getInputStream((ZipEntry)object);
            }
        }
        return null;
    }

    public static final class ZipEntryRO {
        public long mCRC32;
        public long mCompressedLength;
        public final File mFile;
        public final String mFileName;
        public long mLocalHdrOffset;
        public int mMethod;
        public long mOffset = -1L;
        public long mUncompressedLength;
        public long mWhenModified;
        public final String mZipFileName;

        public ZipEntryRO(String string2, File file, String string3) {
            this.mFileName = string3;
            this.mZipFileName = string2;
            this.mFile = file;
        }

        public AssetFileDescriptor getAssetFileDescriptor() {
            if (this.mMethod == 0) {
                try {
                    AssetFileDescriptor assetFileDescriptor = new AssetFileDescriptor(ParcelFileDescriptor.open((File)this.mFile, (int)0x10000000), this.getOffset(), this.mUncompressedLength);
                    return assetFileDescriptor;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
            return null;
        }

        public long getOffset() {
            return this.mOffset;
        }

        public File getZipFile() {
            return this.mFile;
        }

        public String getZipFileName() {
            return this.mZipFileName;
        }

        public boolean isUncompressed() {
            boolean bl = this.mMethod == 0;
            return bl;
        }

        public void setOffsetFromFile(RandomAccessFile object, ByteBuffer byteBuffer) throws IOException {
            long l = this.mLocalHdrOffset;
            try {
                ((RandomAccessFile)object).seek(l);
                ((RandomAccessFile)object).readFully(byteBuffer.array());
                if (byteBuffer.getInt(0) != 67324752) {
                    Log.w((String)ZipResourceFile.LOG_TAG, (String)"didn't find signature at start of lfh");
                    object = new IOException();
                    throw object;
                }
                short s = byteBuffer.getShort(26);
                short s2 = byteBuffer.getShort(28);
                this.mOffset = l + 30L + (long)(s & 0xFFFF) + (long)(s2 & 0xFFFF);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }
}

