/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.os.Build;
import android.os.Bundle;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidWallpaperListener;
import com.badlogic.gdx.utils.GdxNativesLoader;

public abstract class AndroidLiveWallpaperService
extends WallpaperService {
    static boolean DEBUG = false;
    static final String TAG = "WallpaperService";
    protected volatile AndroidLiveWallpaper app = null;
    protected int engines = 0;
    protected volatile boolean isPreviewNotified = false;
    protected volatile AndroidWallpaperEngine linkedEngine = null;
    protected volatile boolean notifiedPreviewState = false;
    volatile int[] sync = new int[0];
    protected SurfaceHolder.Callback view = null;
    protected int viewFormat;
    protected int viewHeight;
    protected int viewWidth;
    protected int visibleEngines = 0;

    static {
        GdxNativesLoader.load();
        DEBUG = false;
    }

    protected void finalize() throws Throwable {
        Log.i((String)TAG, (String)"service finalized");
        super.finalize();
    }

    public AndroidLiveWallpaper getLiveWallpaper() {
        return this.app;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SurfaceHolder getSurfaceHolder() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - getSurfaceHolder()");
        }
        int[] nArray = this.sync;
        synchronized (nArray) {
            if (this.linkedEngine != null) return this.linkedEngine.getSurfaceHolder();
            return null;
        }
    }

    public WindowManager getWindowManager() {
        return (WindowManager)this.getSystemService("window");
    }

    public void initialize(ApplicationListener applicationListener) {
        this.initialize(applicationListener, new AndroidApplicationConfiguration());
    }

    public void initialize(ApplicationListener applicationListener, AndroidApplicationConfiguration androidApplicationConfiguration) {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - initialize()");
        }
        this.app.initialize(applicationListener, androidApplicationConfiguration);
        if (androidApplicationConfiguration.getTouchEventsForLiveWallpaper && Integer.parseInt(Build.VERSION.SDK) >= 7) {
            this.linkedEngine.setTouchEventsEnabled(true);
        }
    }

    public void onCreate() {
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" > AndroidLiveWallpaperService - onCreate() ");
            stringBuilder.append(((Object)((Object)this)).hashCode());
            Log.d((String)TAG, (String)stringBuilder.toString());
        }
        Log.i((String)TAG, (String)"service created");
        super.onCreate();
    }

    public void onCreateApplication() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - onCreateApplication()");
        }
    }

    public WallpaperService.Engine onCreateEngine() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - onCreateEngine()");
        }
        Log.i((String)TAG, (String)"engine created");
        return new AndroidWallpaperEngine();
    }

    public void onDeepPauseApplication() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - onDeepPauseApplication()");
        }
        if (this.app != null) {
            this.app.graphics.clearManagedCaches();
        }
    }

    public void onDestroy() {
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" > AndroidLiveWallpaperService - onDestroy() ");
            stringBuilder.append(((Object)((Object)this)).hashCode());
            Log.d((String)TAG, (String)stringBuilder.toString());
        }
        Log.i((String)TAG, (String)"service destroyed");
        super.onDestroy();
        if (this.app != null) {
            this.app.onDestroy();
            this.app = null;
            this.view = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setLinkedEngine(AndroidWallpaperEngine androidWallpaperEngine) {
        int[] nArray = this.sync;
        synchronized (nArray) {
            this.linkedEngine = androidWallpaperEngine;
            return;
        }
    }

    public class AndroidWallpaperEngine
    extends WallpaperService.Engine {
        protected int engineFormat;
        protected int engineHeight;
        protected boolean engineIsVisible;
        protected int engineWidth;
        boolean iconDropConsumed;
        boolean offsetsConsumed;
        int xIconDrop;
        float xOffset;
        float xOffsetStep;
        int xPixelOffset;
        int yIconDrop;
        float yOffset;
        float yOffsetStep;
        int yPixelOffset;

        public AndroidWallpaperEngine() {
            super((WallpaperService)AndroidLiveWallpaperService.this);
            this.engineIsVisible = false;
            this.iconDropConsumed = true;
            this.offsetsConsumed = true;
            this.xOffset = 0.0f;
            this.yOffset = 0.0f;
            this.xOffsetStep = 0.0f;
            this.yOffsetStep = 0.0f;
            this.xPixelOffset = 0;
            this.yPixelOffset = 0;
            if (DEBUG) {
                AndroidLiveWallpaperService.this = new StringBuilder();
                ((StringBuilder)AndroidLiveWallpaperService.this).append(" > AndroidWallpaperEngine() ");
                ((StringBuilder)AndroidLiveWallpaperService.this).append(((Object)((Object)this)).hashCode());
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)((StringBuilder)AndroidLiveWallpaperService.this).toString());
            }
        }

        private void notifySurfaceChanged(int n, int n2, int n3, boolean bl) {
            if (!bl && n == AndroidLiveWallpaperService.this.viewFormat && n2 == AndroidLiveWallpaperService.this.viewWidth && n3 == AndroidLiveWallpaperService.this.viewHeight) {
                if (DEBUG) {
                    Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > surface is current, skipping surfaceChanged event");
                }
            } else {
                this.engineFormat = n;
                this.engineWidth = n2;
                this.engineHeight = n3;
                if (AndroidLiveWallpaperService.this.linkedEngine == this) {
                    AndroidLiveWallpaperService androidLiveWallpaperService = AndroidLiveWallpaperService.this;
                    androidLiveWallpaperService.viewFormat = this.engineFormat;
                    androidLiveWallpaperService.viewWidth = this.engineWidth;
                    androidLiveWallpaperService.viewHeight = this.engineHeight;
                    androidLiveWallpaperService.view.surfaceChanged(this.getSurfaceHolder(), AndroidLiveWallpaperService.this.viewFormat, AndroidLiveWallpaperService.this.viewWidth, AndroidLiveWallpaperService.this.viewHeight);
                } else if (DEBUG) {
                    Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > engine is not active, skipping surfaceChanged event");
                }
            }
        }

        private void notifyVisibilityChanged(boolean bl) {
            if (this.engineIsVisible != bl) {
                this.engineIsVisible = bl;
                if (this.engineIsVisible) {
                    this.onResume();
                } else {
                    this.onPause();
                }
            } else if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > visible state is current, skipping visibilityChanged event!");
            }
        }

        protected void notifyIconDropped() {
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.app.listener instanceof AndroidWallpaperListener && !this.iconDropConsumed) {
                this.iconDropConsumed = true;
                AndroidLiveWallpaperService.this.app.postRunnable(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        boolean bl;
                        int[] nArray = AndroidLiveWallpaperService.this.sync;
                        synchronized (nArray) {
                            if (AndroidLiveWallpaperService.this.linkedEngine != AndroidWallpaperEngine.this) return;
                            bl = true;
                        }
                        if (!bl) return;
                        ((AndroidWallpaperListener)((Object)AndroidLiveWallpaperService.this.app.listener)).iconDropped(AndroidWallpaperEngine.this.xIconDrop, AndroidWallpaperEngine.this.yIconDrop);
                    }
                });
            }
        }

        protected void notifyOffsetsChanged() {
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.app.listener instanceof AndroidWallpaperListener && !this.offsetsConsumed) {
                this.offsetsConsumed = true;
                AndroidLiveWallpaperService.this.app.postRunnable(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        boolean bl;
                        int[] nArray = AndroidLiveWallpaperService.this.sync;
                        synchronized (nArray) {
                            if (AndroidLiveWallpaperService.this.linkedEngine != AndroidWallpaperEngine.this) return;
                            bl = true;
                        }
                        if (!bl) return;
                        ((AndroidWallpaperListener)((Object)AndroidLiveWallpaperService.this.app.listener)).offsetChange(AndroidWallpaperEngine.this.xOffset, AndroidWallpaperEngine.this.yOffset, AndroidWallpaperEngine.this.xOffsetStep, AndroidWallpaperEngine.this.yOffsetStep, AndroidWallpaperEngine.this.xPixelOffset, AndroidWallpaperEngine.this.yPixelOffset);
                    }
                });
            }
        }

        protected void notifyPreviewState() {
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.app.listener instanceof AndroidWallpaperListener) {
                final boolean bl = AndroidLiveWallpaperService.this.linkedEngine.isPreview();
                AndroidLiveWallpaperService.this.app.postRunnable(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        boolean bl3;
                        int[] nArray = AndroidLiveWallpaperService.this.sync;
                        synchronized (nArray) {
                            boolean bl2 = AndroidLiveWallpaperService.this.isPreviewNotified;
                            bl3 = true;
                            if (bl2) {
                                if (AndroidLiveWallpaperService.this.notifiedPreviewState == bl) return;
                            }
                            AndroidLiveWallpaperService.this.notifiedPreviewState = bl;
                            AndroidLiveWallpaperService.this.isPreviewNotified = true;
                        }
                        if (!bl3) return;
                        AndroidLiveWallpaper androidLiveWallpaper = AndroidLiveWallpaperService.this.app;
                        if (androidLiveWallpaper == null) return;
                        ((AndroidWallpaperListener)((Object)androidLiveWallpaper.listener)).previewStateChange(bl);
                    }
                });
            }
        }

        public Bundle onCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            if (DEBUG) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" > AndroidWallpaperEngine - onCommand(");
                stringBuilder.append(string2);
                stringBuilder.append(" ");
                stringBuilder.append(n);
                stringBuilder.append(" ");
                stringBuilder.append(n2);
                stringBuilder.append(" ");
                stringBuilder.append(n3);
                stringBuilder.append(" ");
                stringBuilder.append(bundle);
                stringBuilder.append(" ");
                stringBuilder.append(bl);
                stringBuilder.append("), linked: ");
                boolean bl2 = AndroidLiveWallpaperService.this.linkedEngine == this;
                stringBuilder.append(bl2);
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)stringBuilder.toString());
            }
            if (string2.equals("android.home.drop")) {
                this.iconDropConsumed = false;
                this.xIconDrop = n;
                this.yIconDrop = n2;
                this.notifyIconDropped();
            }
            return super.onCommand(string2, n, n2, n3, bundle, bl);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            if (DEBUG) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" > AndroidWallpaperEngine - onCreate() ");
                stringBuilder.append(((Object)((Object)this)).hashCode());
                stringBuilder.append(" running: ");
                stringBuilder.append(AndroidLiveWallpaperService.this.engines);
                stringBuilder.append(", linked: ");
                boolean bl = AndroidLiveWallpaperService.this.linkedEngine == this;
                stringBuilder.append(bl);
                stringBuilder.append(", thread: ");
                stringBuilder.append(Thread.currentThread().toString());
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)stringBuilder.toString());
            }
            super.onCreate(surfaceHolder);
        }

        public void onDestroy() {
            super.onDestroy();
        }

        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
            this.offsetsConsumed = false;
            this.xOffset = f;
            this.yOffset = f2;
            this.xOffsetStep = f3;
            this.yOffsetStep = f4;
            this.xPixelOffset = n;
            this.yPixelOffset = n2;
            this.notifyOffsetsChanged();
            if (!Gdx.graphics.isContinuousRendering()) {
                Gdx.graphics.requestRendering();
            }
            super.onOffsetsChanged(f, f2, f3, f4, n, n2);
        }

        public void onPause() {
            Object object = AndroidLiveWallpaperService.this;
            --((AndroidLiveWallpaperService)((Object)object)).visibleEngines;
            if (DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append(" > AndroidWallpaperEngine - onPause() ");
                ((StringBuilder)object).append(((Object)((Object)this)).hashCode());
                ((StringBuilder)object).append(", running: ");
                ((StringBuilder)object).append(AndroidLiveWallpaperService.this.engines);
                ((StringBuilder)object).append(", linked: ");
                boolean bl = AndroidLiveWallpaperService.this.linkedEngine == this;
                ((StringBuilder)object).append(bl);
                ((StringBuilder)object).append(", visible: ");
                ((StringBuilder)object).append(AndroidLiveWallpaperService.this.visibleEngines);
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)((StringBuilder)object).toString());
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine paused");
            if (AndroidLiveWallpaperService.this.visibleEngines >= AndroidLiveWallpaperService.this.engines) {
                Log.e((String)AndroidLiveWallpaperService.TAG, (String)"wallpaper lifecycle error, counted too many visible engines! repairing..");
                object = AndroidLiveWallpaperService.this;
                ((AndroidLiveWallpaperService)((Object)object)).visibleEngines = Math.max(((AndroidLiveWallpaperService)((Object)object)).engines - 1, 0);
            }
            if (AndroidLiveWallpaperService.this.linkedEngine != null && AndroidLiveWallpaperService.this.visibleEngines == 0) {
                AndroidLiveWallpaperService.this.app.onPause();
            }
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > AndroidWallpaperEngine - onPause() done!");
            }
        }

        public void onResume() {
            Object object = AndroidLiveWallpaperService.this;
            ++((AndroidLiveWallpaperService)((Object)object)).visibleEngines;
            if (DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append(" > AndroidWallpaperEngine - onResume() ");
                ((StringBuilder)object).append(((Object)((Object)this)).hashCode());
                ((StringBuilder)object).append(", running: ");
                ((StringBuilder)object).append(AndroidLiveWallpaperService.this.engines);
                ((StringBuilder)object).append(", linked: ");
                boolean bl = AndroidLiveWallpaperService.this.linkedEngine == this;
                ((StringBuilder)object).append(bl);
                ((StringBuilder)object).append(", visible: ");
                ((StringBuilder)object).append(AndroidLiveWallpaperService.this.visibleEngines);
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)((StringBuilder)object).toString());
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine resumed");
            if (AndroidLiveWallpaperService.this.linkedEngine != null) {
                if (AndroidLiveWallpaperService.this.linkedEngine != this) {
                    AndroidLiveWallpaperService.this.setLinkedEngine(this);
                    AndroidLiveWallpaperService.this.view.surfaceDestroyed(this.getSurfaceHolder());
                    this.notifySurfaceChanged(this.engineFormat, this.engineWidth, this.engineHeight, false);
                    AndroidLiveWallpaperService.this.view.surfaceCreated(this.getSurfaceHolder());
                } else {
                    this.notifySurfaceChanged(this.engineFormat, this.engineWidth, this.engineHeight, false);
                }
                if (AndroidLiveWallpaperService.this.visibleEngines == 1) {
                    AndroidLiveWallpaperService.this.app.onResume();
                }
                this.notifyPreviewState();
                this.notifyOffsetsChanged();
                if (!Gdx.graphics.isContinuousRendering()) {
                    Gdx.graphics.requestRendering();
                }
            }
        }

        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            if (DEBUG) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" > AndroidWallpaperEngine - onSurfaceChanged() isPreview: ");
                stringBuilder.append(this.isPreview());
                stringBuilder.append(", ");
                stringBuilder.append(((Object)((Object)this)).hashCode());
                stringBuilder.append(", running: ");
                stringBuilder.append(AndroidLiveWallpaperService.this.engines);
                stringBuilder.append(", linked: ");
                boolean bl = AndroidLiveWallpaperService.this.linkedEngine == this;
                stringBuilder.append(bl);
                stringBuilder.append(", sufcace valid: ");
                stringBuilder.append(this.getSurfaceHolder().getSurface().isValid());
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)stringBuilder.toString());
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine surface changed");
            super.onSurfaceChanged(surfaceHolder, n, n2, n3);
            this.notifySurfaceChanged(n, n2, n3, true);
        }

        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
            Object object = AndroidLiveWallpaperService.this;
            ++((AndroidLiveWallpaperService)((Object)object)).engines;
            AndroidLiveWallpaperService.this.setLinkedEngine(this);
            if (DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append(" > AndroidWallpaperEngine - onSurfaceCreated() ");
                ((StringBuilder)object).append(((Object)((Object)this)).hashCode());
                ((StringBuilder)object).append(", running: ");
                ((StringBuilder)object).append(AndroidLiveWallpaperService.this.engines);
                ((StringBuilder)object).append(", linked: ");
                boolean bl = AndroidLiveWallpaperService.this.linkedEngine == this;
                ((StringBuilder)object).append(bl);
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)((StringBuilder)object).toString());
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine surface created");
            super.onSurfaceCreated(surfaceHolder);
            if (AndroidLiveWallpaperService.this.engines == 1) {
                AndroidLiveWallpaperService.this.visibleEngines = 0;
            }
            if (AndroidLiveWallpaperService.this.engines == 1 && AndroidLiveWallpaperService.this.app == null) {
                object = AndroidLiveWallpaperService.this;
                ((AndroidLiveWallpaperService)((Object)object)).viewFormat = 0;
                ((AndroidLiveWallpaperService)((Object)object)).viewWidth = 0;
                ((AndroidLiveWallpaperService)((Object)object)).viewHeight = 0;
                ((AndroidLiveWallpaperService)((Object)object)).app = new AndroidLiveWallpaper((AndroidLiveWallpaperService)((Object)object));
                AndroidLiveWallpaperService.this.onCreateApplication();
                if (AndroidLiveWallpaperService.this.app.graphics == null) {
                    throw new Error("You must override 'AndroidLiveWallpaperService.onCreateApplication' method and call 'initialize' from its body.");
                }
            }
            object = AndroidLiveWallpaperService.this;
            ((AndroidLiveWallpaperService)((Object)object)).view = (SurfaceHolder.Callback)((AndroidLiveWallpaperService)((Object)object)).app.graphics.view;
            this.getSurfaceHolder().removeCallback(AndroidLiveWallpaperService.this.view);
            this.engineFormat = AndroidLiveWallpaperService.this.viewFormat;
            this.engineWidth = AndroidLiveWallpaperService.this.viewWidth;
            this.engineHeight = AndroidLiveWallpaperService.this.viewHeight;
            if (AndroidLiveWallpaperService.this.engines == 1) {
                AndroidLiveWallpaperService.this.view.surfaceCreated(surfaceHolder);
            } else {
                AndroidLiveWallpaperService.this.view.surfaceDestroyed(surfaceHolder);
                this.notifySurfaceChanged(this.engineFormat, this.engineWidth, this.engineHeight, false);
                AndroidLiveWallpaperService.this.view.surfaceCreated(surfaceHolder);
            }
            this.notifyPreviewState();
            this.notifyOffsetsChanged();
            if (!Gdx.graphics.isContinuousRendering()) {
                Gdx.graphics.requestRendering();
            }
        }

        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
            Object object = AndroidLiveWallpaperService.this;
            int n = ((AndroidLiveWallpaperService)((Object)object)).engines;
            boolean bl = true;
            ((AndroidLiveWallpaperService)((Object)object)).engines = n - 1;
            if (DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append(" > AndroidWallpaperEngine - onSurfaceDestroyed() ");
                ((StringBuilder)object).append(((Object)((Object)this)).hashCode());
                ((StringBuilder)object).append(", running: ");
                ((StringBuilder)object).append(AndroidLiveWallpaperService.this.engines);
                ((StringBuilder)object).append(" ,linked: ");
                if (AndroidLiveWallpaperService.this.linkedEngine != this) {
                    bl = false;
                }
                ((StringBuilder)object).append(bl);
                ((StringBuilder)object).append(", isVisible: ");
                ((StringBuilder)object).append(this.engineIsVisible);
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)((StringBuilder)object).toString());
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine surface destroyed");
            if (AndroidLiveWallpaperService.this.engines == 0) {
                AndroidLiveWallpaperService.this.onDeepPauseApplication();
            }
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.view != null) {
                AndroidLiveWallpaperService.this.view.surfaceDestroyed(surfaceHolder);
            }
            this.engineFormat = 0;
            this.engineWidth = 0;
            this.engineHeight = 0;
            if (AndroidLiveWallpaperService.this.engines == 0) {
                AndroidLiveWallpaperService.this.linkedEngine = null;
            }
            super.onSurfaceDestroyed(surfaceHolder);
        }

        public void onTouchEvent(MotionEvent motionEvent) {
            if (AndroidLiveWallpaperService.this.linkedEngine == this) {
                AndroidLiveWallpaperService.this.app.input.onTouch(null, motionEvent);
            }
        }

        public void onVisibilityChanged(boolean bl) {
            boolean bl2 = this.isVisible();
            if (DEBUG) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(" > AndroidWallpaperEngine - onVisibilityChanged(paramVisible: ");
                stringBuilder.append(bl);
                stringBuilder.append(" reportedVisible: ");
                stringBuilder.append(bl2);
                stringBuilder.append(") ");
                stringBuilder.append(((Object)((Object)this)).hashCode());
                stringBuilder.append(", sufcace valid: ");
                stringBuilder.append(this.getSurfaceHolder().getSurface().isValid());
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)stringBuilder.toString());
            }
            super.onVisibilityChanged(bl);
            if (!bl2 && bl) {
                if (DEBUG) {
                    Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > fake visibilityChanged event! Android WallpaperService likes do that!");
                }
                return;
            }
            this.notifyVisibilityChanged(bl);
        }
    }
}

