/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidApplicationLogger;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidGraphicsLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaperService;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.AndroidPreferences;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SnapshotArray;

public class AndroidLiveWallpaper
implements AndroidApplicationBase {
    protected ApplicationLogger applicationLogger;
    protected AndroidAudio audio;
    protected AndroidClipboard clipboard;
    protected final Array<Runnable> executedRunnables;
    protected AndroidFiles files;
    protected boolean firstResume = true;
    protected AndroidGraphicsLiveWallpaper graphics;
    protected AndroidInput input;
    protected final SnapshotArray<LifecycleListener> lifecycleListeners;
    protected ApplicationListener listener;
    protected int logLevel = 2;
    protected AndroidNet net;
    protected final Array<Runnable> runnables = new Array();
    protected AndroidLiveWallpaperService service;

    static {
        GdxNativesLoader.load();
    }

    public AndroidLiveWallpaper(AndroidLiveWallpaperService androidLiveWallpaperService) {
        this.executedRunnables = new Array();
        this.lifecycleListeners = new SnapshotArray(LifecycleListener.class);
        this.service = androidLiveWallpaperService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        SnapshotArray<LifecycleListener> snapshotArray = this.lifecycleListeners;
        synchronized (snapshotArray) {
            this.lifecycleListeners.add(lifecycleListener);
            return;
        }
    }

    @Override
    public void debug(String string2, String string3) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(string2, string3);
        }
    }

    @Override
    public void debug(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(string2, string3, throwable);
        }
    }

    @Override
    public void error(String string2, String string3) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(string2, string3);
        }
    }

    @Override
    public void error(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(string2, string3, throwable);
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    @Override
    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    @Override
    public Window getApplicationWindow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    @Override
    public Context getContext() {
        return this.service;
    }

    @Override
    public Array<Runnable> getExecutedRunnables() {
        return this.executedRunnables;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Handler getHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AndroidInput getInput() {
        return this.input;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public SnapshotArray<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public Preferences getPreferences(String string2) {
        return new AndroidPreferences(this.service.getSharedPreferences(string2, 0));
    }

    @Override
    public Array<Runnable> getRunnables() {
        return this.runnables;
    }

    public AndroidLiveWallpaperService getService() {
        return this.service;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Android;
    }

    @Override
    public int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public WindowManager getWindowManager() {
        return this.service.getWindowManager();
    }

    public void initialize(ApplicationListener applicationListener, AndroidApplicationConfiguration androidApplicationConfiguration) {
        if (this.getVersion() >= 9) {
            this.setApplicationLogger(new AndroidApplicationLogger());
            ResolutionStrategy resolutionStrategy = androidApplicationConfiguration.resolutionStrategy == null ? new FillResolutionStrategy() : androidApplicationConfiguration.resolutionStrategy;
            this.graphics = new AndroidGraphicsLiveWallpaper(this, androidApplicationConfiguration, resolutionStrategy);
            this.input = AndroidInputFactory.newAndroidInput(this, (Context)this.getService(), this.graphics.view, androidApplicationConfiguration);
            this.audio = new AndroidAudio((Context)this.getService(), androidApplicationConfiguration);
            this.getService().getFilesDir();
            this.files = new AndroidFiles(this.getService().getAssets(), this.getService().getFilesDir().getAbsolutePath());
            this.net = new AndroidNet(this, androidApplicationConfiguration);
            this.listener = applicationListener;
            this.clipboard = new AndroidClipboard((Context)this.getService());
            Gdx.app = this;
            Gdx.input = this.input;
            Gdx.audio = this.audio;
            Gdx.files = this.files;
            Gdx.graphics = this.graphics;
            Gdx.net = this.net;
            return;
        }
        throw new GdxRuntimeException("LibGDX requires Android API Level 9 or later.");
    }

    @Override
    public void log(String string2, String string3) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(string2, string3);
        }
    }

    @Override
    public void log(String string2, String string3, Throwable throwable) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(string2, string3, throwable);
        }
    }

    public void onDestroy() {
        Object object = this.graphics;
        if (object != null) {
            ((AndroidGraphicsLiveWallpaper)object).onDestroyGLSurfaceView();
        }
        if ((object = this.audio) != null) {
            ((AndroidAudio)object).dispose();
        }
    }

    public void onPause() {
        if (AndroidLiveWallpaperService.DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onPause()");
        }
        this.audio.pause();
        this.input.onPause();
        AndroidGraphicsLiveWallpaper androidGraphicsLiveWallpaper = this.graphics;
        if (androidGraphicsLiveWallpaper != null) {
            androidGraphicsLiveWallpaper.onPauseGLSurfaceView();
        }
        if (AndroidLiveWallpaperService.DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onPause() done!");
        }
    }

    public void onResume() {
        Gdx.app = this;
        Object object = this.input;
        Gdx.input = object;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
        Gdx.net = this.net;
        ((AndroidInput)object).onResume();
        object = this.graphics;
        if (object != null) {
            ((AndroidGraphics)object).onResumeGLSurfaceView();
        }
        if (!this.firstResume) {
            this.audio.resume();
            this.graphics.resume();
        } else {
            this.firstResume = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        SnapshotArray<LifecycleListener> snapshotArray = this.lifecycleListeners;
        synchronized (snapshotArray) {
            this.lifecycleListeners.removeValue(lifecycleListener, true);
            return;
        }
    }

    @Override
    public void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            new Handler(Looper.getMainLooper()).post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Override
    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    @Override
    public void startActivity(Intent intent) {
        this.service.startActivity(intent);
    }

    @Override
    public void useImmersiveMode(boolean bl) {
        throw new UnsupportedOperationException();
    }
}

