/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaperService;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20API18;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceViewAPI18;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.utils.GdxRuntimeException;
import javax.microedition.khronos.opengles.GL10;

public final class AndroidGraphicsLiveWallpaper
extends AndroidGraphics {
    public AndroidGraphicsLiveWallpaper(AndroidLiveWallpaper androidLiveWallpaper, AndroidApplicationConfiguration androidApplicationConfiguration, ResolutionStrategy resolutionStrategy) {
        super(androidLiveWallpaper, androidApplicationConfiguration, resolutionStrategy, false);
    }

    @Override
    protected View createGLSurfaceView(AndroidApplicationBase object, ResolutionStrategy resolutionStrategy) {
        if (this.checkGL20()) {
            GLSurfaceView.EGLConfigChooser eGLConfigChooser = this.getEglConfigChooser();
            if (Build.VERSION.SDK_INT <= 10 && this.config.useGLSurfaceView20API18) {
                object = new GLSurfaceView20API18(object.getContext(), resolutionStrategy){

                    public SurfaceHolder getHolder() {
                        return AndroidGraphicsLiveWallpaper.this.getSurfaceHolder();
                    }

                    public void onDestroy() {
                        this.onDetachedFromWindow();
                    }
                };
                if (eGLConfigChooser != null) {
                    ((GLSurfaceViewAPI18)((Object)object)).setEGLConfigChooser(eGLConfigChooser);
                } else {
                    ((GLSurfaceViewAPI18)((Object)object)).setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
                }
                ((GLSurfaceViewAPI18)((Object)object)).setRenderer(this);
                return object;
            }
            object = new GLSurfaceView20(object.getContext(), resolutionStrategy){

                public SurfaceHolder getHolder() {
                    return AndroidGraphicsLiveWallpaper.this.getSurfaceHolder();
                }

                public void onDestroy() {
                    this.onDetachedFromWindow();
                }
            };
            if (eGLConfigChooser != null) {
                object.setEGLConfigChooser(eGLConfigChooser);
            } else {
                object.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
            }
            object.setRenderer((GLSurfaceView.Renderer)this);
            return object;
        }
        throw new GdxRuntimeException("Libgdx requires OpenGL ES 2.0");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SurfaceHolder getSurfaceHolder() {
        int[] nArray = ((AndroidLiveWallpaper)this.app).service.sync;
        synchronized (nArray) {
            return ((AndroidLiveWallpaper)this.app).service.getSurfaceHolder();
        }
    }

    @Override
    protected void logManagedCachesStatus() {
        if (AndroidLiveWallpaperService.DEBUG) {
            super.logManagedCachesStatus();
        }
    }

    public void onDestroyGLSurfaceView() {
        if (this.view != null && (this.view instanceof GLSurfaceView || this.view instanceof GLSurfaceViewAPI18)) {
            try {
                this.view.getClass().getMethod("onDestroy", new Class[0]).invoke((Object)this.view, new Object[0]);
                if (AndroidLiveWallpaperService.DEBUG) {
                    Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onDestroy() stopped GLThread managed by GLSurfaceView");
                }
            }
            catch (Throwable throwable) {
                Log.e((String)"WallpaperService", (String)"failed to destroy GLSurfaceView's thread! GLSurfaceView.onDetachedFromWindow impl changed since API lvl 16!");
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onDrawFrame(GL10 object) {
        boolean bl;
        boolean bl2;
        long l;
        block20: {
            l = System.nanoTime();
            this.deltaTime = (float)(l - this.lastFrameTime) / 1.0E9f;
            this.lastFrameTime = l;
            if (!this.resume) {
                this.mean.addValue(this.deltaTime);
            } else {
                this.deltaTime = 0.0f;
            }
            Object object2 = this.synch;
            synchronized (object2) {
                boolean bl3 = this.running;
                bl2 = this.pause;
                bl = this.destroy;
                boolean bl4 = this.resume;
                if (this.resume) {
                    this.resume = false;
                    this.synch.notifyAll();
                }
                if (this.pause) {
                    this.pause = false;
                    this.synch.notifyAll();
                }
                if (this.destroy) {
                    this.destroy = false;
                    this.synch.notifyAll();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 6] lbl24 : MonitorExitStatement: MONITOREXIT : var4_4
                if (bl4) {
                    this.app.getApplicationListener().resume();
                    Gdx.app.log("AndroidGraphics", "resumed");
                }
                if (!bl3) break block20;
                object = this.app.getRunnables();
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            synchronized (object) {
                int n;
                this.app.getExecutedRunnables().clear();
                this.app.getExecutedRunnables().addAll(this.app.getRunnables());
                this.app.getRunnables().clear();
                for (int i = 0; i < (n = this.app.getExecutedRunnables().size); ++i) {
                    try {
                        this.app.getExecutedRunnables().get(i).run();
                        continue;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            this.app.getInput().processEvents();
            ++this.frameId;
            this.app.getApplicationListener().render();
        }
        if (bl2) {
            this.app.getApplicationListener().pause();
            Gdx.app.log("AndroidGraphics", "paused");
        }
        if (bl) {
            this.app.getApplicationListener().dispose();
            Gdx.app.log("AndroidGraphics", "destroyed");
        }
        if (l - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = l;
        }
        ++this.frames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void resume() {
        Object object = this.synch;
        synchronized (object) {
            boolean bl;
            this.running = true;
            this.resume = true;
            while (bl = this.resume) {
                try {
                    this.requestRendering();
                    this.synch.wait();
                }
                catch (InterruptedException interruptedException) {
                    Gdx.app.log("AndroidGraphics", "waiting for resume synchronization failed!");
                }
            }
            return;
        }
    }
}

