/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Logger;

public class ShaderProgramLoader
extends AsynchronousAssetLoader<ShaderProgram, ShaderProgramParameter> {
    private String fragmentFileSuffix = ".frag";
    private String vertexFileSuffix = ".vert";

    public ShaderProgramLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    public ShaderProgramLoader(FileHandleResolver fileHandleResolver, String string2, String string3) {
        super(fileHandleResolver);
        this.vertexFileSuffix = string2;
        this.fragmentFileSuffix = string3;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string2, FileHandle fileHandle, ShaderProgramParameter shaderProgramParameter) {
        return null;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string2, FileHandle fileHandle, ShaderProgramParameter shaderProgramParameter) {
    }

    @Override
    public ShaderProgram loadSync(AssetManager object, String string2, FileHandle object2, ShaderProgramParameter object3) {
        Object object4;
        Object object5;
        Object object6 = null;
        if (object3 != null) {
            object5 = ((ShaderProgramParameter)object3).vertexFile != null ? ((ShaderProgramParameter)object3).vertexFile : null;
            object4 = object5;
            if (((ShaderProgramParameter)object3).fragmentFile != null) {
                object6 = ((ShaderProgramParameter)object3).fragmentFile;
                object4 = object5;
            }
        } else {
            object4 = null;
        }
        object5 = object4;
        if (object4 == null) {
            object5 = object4;
            if (string2.endsWith(this.fragmentFileSuffix)) {
                object5 = new StringBuilder();
                ((StringBuilder)object5).append(string2.substring(0, string2.length() - this.fragmentFileSuffix.length()));
                ((StringBuilder)object5).append(this.vertexFileSuffix);
                object5 = ((StringBuilder)object5).toString();
            }
        }
        object4 = object6;
        if (object6 == null) {
            object4 = object6;
            if (string2.endsWith(this.vertexFileSuffix)) {
                object6 = new StringBuilder();
                ((StringBuilder)object6).append(string2.substring(0, string2.length() - this.vertexFileSuffix.length()));
                ((StringBuilder)object6).append(this.fragmentFileSuffix);
                object4 = ((StringBuilder)object6).toString();
            }
        }
        object6 = object5 == null ? object2 : this.resolve((String)object5);
        object5 = object4 == null ? object2 : this.resolve((String)object4);
        object2 = ((FileHandle)object6).readString();
        object6 = ((FileHandle)object6).equals(object5) ? object2 : ((FileHandle)object5).readString();
        Object object7 = object2;
        object4 = object6;
        if (object3 != null) {
            object5 = object2;
            if (((ShaderProgramParameter)object3).prependVertexCode != null) {
                object5 = new StringBuilder();
                ((StringBuilder)object5).append(((ShaderProgramParameter)object3).prependVertexCode);
                ((StringBuilder)object5).append((String)object2);
                object5 = ((StringBuilder)object5).toString();
            }
            object7 = object5;
            object4 = object6;
            if (((ShaderProgramParameter)object3).prependFragmentCode != null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(((ShaderProgramParameter)object3).prependFragmentCode);
                ((StringBuilder)object2).append((String)object6);
                object4 = ((StringBuilder)object2).toString();
                object7 = object5;
            }
        }
        object2 = new ShaderProgram((String)object7, (String)object4);
        if ((object3 == null || ((ShaderProgramParameter)object3).logOnCompileFailure) && !((ShaderProgram)object2).isCompiled()) {
            object3 = ((AssetManager)object).getLogger();
            object = new StringBuilder();
            ((StringBuilder)object).append("ShaderProgram ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" failed to compile:\n");
            ((StringBuilder)object).append(((ShaderProgram)object2).getLog());
            ((Logger)object3).error(((StringBuilder)object).toString());
        }
        return object2;
    }

    public static class ShaderProgramParameter
    extends AssetLoaderParameters<ShaderProgram> {
        public String fragmentFile;
        public boolean logOnCompileFailure = true;
        public String prependFragmentCode;
        public String prependVertexCode;
        public String vertexFile;
    }
}

