/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.net.ServerSocket;
import com.badlogic.gdx.net.ServerSocketHints;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.badlogic.gdx.utils.Pool;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Net {
    public void cancelHttpRequest(HttpRequest var1);

    public Socket newClientSocket(Protocol var1, String var2, int var3, SocketHints var4);

    public ServerSocket newServerSocket(Protocol var1, int var2, ServerSocketHints var3);

    public ServerSocket newServerSocket(Protocol var1, String var2, int var3, ServerSocketHints var4);

    public boolean openURI(String var1);

    public void sendHttpRequest(HttpRequest var1, HttpResponseListener var2);

    public static interface HttpMethods {
        public static final String DELETE = "DELETE";
        public static final String GET = "GET";
        public static final String PATCH = "PATCH";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
    }

    public static class HttpRequest
    implements Pool.Poolable {
        private String content;
        private long contentLength;
        private InputStream contentStream;
        private boolean followRedirects = true;
        private Map<String, String> headers = new HashMap<String, String>();
        private String httpMethod;
        private boolean includeCredentials = false;
        private int timeOut = 0;
        private String url;

        public HttpRequest() {
        }

        public HttpRequest(String string2) {
            this();
            this.httpMethod = string2;
        }

        public String getContent() {
            return this.content;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public InputStream getContentStream() {
            return this.contentStream;
        }

        public boolean getFollowRedirects() {
            return this.followRedirects;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public boolean getIncludeCredentials() {
            return this.includeCredentials;
        }

        public String getMethod() {
            return this.httpMethod;
        }

        public int getTimeOut() {
            return this.timeOut;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public void reset() {
            this.httpMethod = null;
            this.url = null;
            this.headers.clear();
            this.timeOut = 0;
            this.content = null;
            this.contentStream = null;
            this.contentLength = 0L;
            this.followRedirects = true;
        }

        public void setContent(InputStream inputStream, long l) {
            this.contentStream = inputStream;
            this.contentLength = l;
        }

        public void setContent(String string2) {
            this.content = string2;
        }

        public void setFollowRedirects(boolean bl) throws IllegalArgumentException {
            if (!bl && Gdx.app.getType() == Application.ApplicationType.WebGL) {
                throw new IllegalArgumentException("Following redirects can't be disabled using the GWT/WebGL backend!");
            }
            this.followRedirects = bl;
        }

        public void setHeader(String string2, String string3) {
            this.headers.put(string2, string3);
        }

        public void setIncludeCredentials(boolean bl) {
            this.includeCredentials = bl;
        }

        public void setMethod(String string2) {
            this.httpMethod = string2;
        }

        public void setTimeOut(int n) {
            this.timeOut = n;
        }

        public void setUrl(String string2) {
            this.url = string2;
        }
    }

    public static interface HttpResponse {
        public String getHeader(String var1);

        public Map<String, List<String>> getHeaders();

        public byte[] getResult();

        public InputStream getResultAsStream();

        public String getResultAsString();

        public HttpStatus getStatus();
    }

    public static interface HttpResponseListener {
        public void cancelled();

        public void failed(Throwable var1);

        public void handleHttpResponse(HttpResponse var1);
    }

    public static enum Protocol {
        TCP;

    }
}

