/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;

public interface Graphics {
    public int getBackBufferHeight();

    public int getBackBufferWidth();

    public BufferFormat getBufferFormat();

    public float getDeltaTime();

    public float getDensity();

    public DisplayMode getDisplayMode();

    public DisplayMode getDisplayMode(Monitor var1);

    public DisplayMode[] getDisplayModes();

    public DisplayMode[] getDisplayModes(Monitor var1);

    public long getFrameId();

    public int getFramesPerSecond();

    public GL20 getGL20();

    public GL30 getGL30();

    public GLVersion getGLVersion();

    public int getHeight();

    public Monitor getMonitor();

    public Monitor[] getMonitors();

    public float getPpcX();

    public float getPpcY();

    public float getPpiX();

    public float getPpiY();

    public Monitor getPrimaryMonitor();

    public float getRawDeltaTime();

    public GraphicsType getType();

    public int getWidth();

    public boolean isContinuousRendering();

    public boolean isFullscreen();

    public boolean isGL30Available();

    public Cursor newCursor(Pixmap var1, int var2, int var3);

    public void requestRendering();

    public void setContinuousRendering(boolean var1);

    public void setCursor(Cursor var1);

    public boolean setFullscreenMode(DisplayMode var1);

    public void setGL20(GL20 var1);

    public void setGL30(GL30 var1);

    public void setResizable(boolean var1);

    public void setSystemCursor(Cursor.SystemCursor var1);

    public void setTitle(String var1);

    public void setUndecorated(boolean var1);

    public void setVSync(boolean var1);

    public boolean setWindowedMode(int var1, int var2);

    public boolean supportsDisplayModeChange();

    public boolean supportsExtension(String var1);

    public static class BufferFormat {
        public final int a;
        public final int b;
        public final boolean coverageSampling;
        public final int depth;
        public final int g;
        public final int r;
        public final int samples;
        public final int stencil;

        public BufferFormat(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
            this.r = n;
            this.g = n2;
            this.b = n3;
            this.a = n4;
            this.depth = n5;
            this.stencil = n6;
            this.samples = n7;
            this.coverageSampling = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("r: ");
            stringBuilder.append(this.r);
            stringBuilder.append(", g: ");
            stringBuilder.append(this.g);
            stringBuilder.append(", b: ");
            stringBuilder.append(this.b);
            stringBuilder.append(", a: ");
            stringBuilder.append(this.a);
            stringBuilder.append(", depth: ");
            stringBuilder.append(this.depth);
            stringBuilder.append(", stencil: ");
            stringBuilder.append(this.stencil);
            stringBuilder.append(", num samples: ");
            stringBuilder.append(this.samples);
            stringBuilder.append(", coverage sampling: ");
            stringBuilder.append(this.coverageSampling);
            return stringBuilder.toString();
        }
    }

    public static class DisplayMode {
        public final int bitsPerPixel;
        public final int height;
        public final int refreshRate;
        public final int width;

        protected DisplayMode(int n, int n2, int n3, int n4) {
            this.width = n;
            this.height = n2;
            this.refreshRate = n3;
            this.bitsPerPixel = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.width);
            stringBuilder.append("x");
            stringBuilder.append(this.height);
            stringBuilder.append(", bpp: ");
            stringBuilder.append(this.bitsPerPixel);
            stringBuilder.append(", hz: ");
            stringBuilder.append(this.refreshRate);
            return stringBuilder.toString();
        }
    }

    public static enum GraphicsType {
        AndroidGL,
        LWJGL,
        WebGL,
        iOSGL,
        JGLFW,
        Mock,
        LWJGL3;

    }

    public static class Monitor {
        public final String name;
        public final int virtualX;
        public final int virtualY;

        protected Monitor(int n, int n2, String string2) {
            this.virtualX = n;
            this.virtualY = n2;
            this.name = string2;
        }
    }
}

