/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Menu;
import age.of.civilizations2.jakowski.lukasz.Menu_PeaceTreaty;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_Civs;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_Demands;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_DrawData;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_GameData;
import age.of.civilizations2.jakowski.lukasz.PeaceTreaty_ReleaseableVassals;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

class PeaceTreaty_Data {
    protected PeaceTreaty_GameData peaceTreatyGameData = new PeaceTreaty_GameData();
    protected List<PeaceTreaty_DrawData> drawProvinceOwners = new ArrayList<PeaceTreaty_DrawData>();
    protected List<Integer> provincesLeftToTake = new ArrayList<Integer>();
    protected int iProvincesLeftToTakeSize = 0;
    protected boolean scoreCountDefenders = false;
    protected int iBrushCivID = -1;
    protected int iPlayerTurnID = 0;
    protected int iLastTakenID = -1;
    protected static final float VASSALIZE_COST = 0.4f;
    protected static final float WAR_REPARATIONS_COST = 0.1f;
    private int recursionDepth = 0;
    private static final int MAX_RECURSION_DEPTH = 8500;

    protected PeaceTreaty_Data() {
    }

    protected PeaceTreaty_Data(PeaceTreaty_GameData nPeaceTreaty) {
        this.peaceTreatyGameData = nPeaceTreaty;
        this.iBrushCivID = CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID();
        this.iPlayerTurnID = CFG.PLAYER_TURNID;
        this.prepareProvinceData(false);
        this.prepareDemansVassalsData();
    }

    protected boolean isPlayerInvolved() {
        if ((CFG.PLAYER_PEACE || CFG.SPECTATOR_MODE) && CFG.sandbox_task == Menu.eINGAME_PEACE_TREATY) {
            return Menu_PeaceTreaty.WAR_ID == this.peaceTreatyGameData.iWarID;
        }
        return false;
    }

    protected PeaceTreaty_Data(int iWarID, boolean scoreCountDefenders) {
        int i;
        ArrayList<Boolean> addDefender = new ArrayList<Boolean>();
        ArrayList<Boolean> addAggressor = new ArrayList<Boolean>();
        for (i = 0; i < CFG.game.getWar(iWarID).getDefendersSize(); ++i) {
            addDefender.add(true);
        }
        for (i = 0; i < CFG.game.getWar(iWarID).getAggressorsSize(); ++i) {
            addAggressor.add(true);
        }
        this.initPeaceTreatyData(iWarID, addDefender, addAggressor, scoreCountDefenders);
    }

    protected PeaceTreaty_Data(int iWarID, List<Boolean> addDefender, List<Boolean> addAggressor, boolean scoreCountDefenders) {
        this.initPeaceTreatyData(iWarID, addDefender, addAggressor, scoreCountDefenders);
    }

    protected final void AI_UseVictoryPoints() {
        try {
            Gdx.app.log("AoC", "AI_UseVictoryPoints -> provincesLeftToTake.size: " + this.iProvincesLeftToTakeSize);
            if (this.iProvincesLeftToTakeSize > 0) {
                int i;
                int iBestCivID = -1;
                int tBestPoints = -1;
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft > tBestPoints) {
                        iBestCivID = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID;
                        tBestPoints = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft;
                        continue;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft != tBestPoints || CFG.oR.nextInt(100) >= 50) continue;
                    iBestCivID = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID;
                    tBestPoints = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft;
                }
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft > tBestPoints) {
                        iBestCivID = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID;
                        tBestPoints = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft;
                        continue;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft != tBestPoints || CFG.oR.nextInt(100) >= 50) continue;
                    iBestCivID = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID;
                    tBestPoints = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft;
                }
                Gdx.app.log("AoC", "AI_UseVictoryPoints -> iBestCivID: " + iBestCivID + (iBestCivID >= 0 ? ", " + CFG.game.getCiv(iBestCivID).getCivName() : "") + ", tBestPoints: " + tBestPoints);
                if (iBestCivID > 0 && tBestPoints > 0 && !CFG.game.getCiv(iBestCivID).getControlledByPlayer() && !this.isPlayerInvolved()) {
                    if (this.recursionDepth++ > 8500) {
                        Gdx.app.log("AoC", "AI_UseVictoryPoints: Max recursion depth reached, aborting.");
                        this.recursionDepth = 0;
                        return;
                    }
                    Gdx.app.log("AoC", "AI_UseVictoryPoints -> AI TAKE PROVINCE");
                    ++this.recursionDepth;
                    CFG.toast.setInView("Calculating Peace Treaty for " + CFG.game.getCiv(iBestCivID).getCivName() + ", " + this.recursionDepth);
                    this.AI_UseVictoryPoints_CivID(iBestCivID, tBestPoints);
                }
            }
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            // empty catch block
        }
    }

    protected final void AI_UseVictoryPoints_CivID_TakeVassal(int nCivID, int pointsLeft, boolean clearPoints) {
        try {
            int o;
            int i;
            ArrayList<Integer> canVassalizeCivs = new ArrayList<Integer>();
            boolean doneCheck = false;
            for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nCivID) continue;
                for (o = 0; o < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++o) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)o).iWillBecomeVassalOfCivID >= 0 || this.getVassalization_Cost(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)o).iCivID) > pointsLeft) continue;
                    canVassalizeCivs.add(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)o).iCivID);
                }
                doneCheck = true;
                break;
            }
            if (!doneCheck) {
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nCivID) continue;
                    for (o = 0; o < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++o) {
                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)o).iWillBecomeVassalOfCivID >= 0 || this.getVassalization_Cost(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)o).iCivID) > pointsLeft) continue;
                        canVassalizeCivs.add(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)o).iCivID);
                    }
                    doneCheck = true;
                    break;
                }
            }
            if (canVassalizeCivs.size() > 0) {
                this.takeVassalize((Integer)canVassalizeCivs.get(CFG.oR.nextInt(canVassalizeCivs.size())), nCivID, nCivID);
                this.AI_UseVictoryPoints();
                return;
            }
            if (clearPoints) {
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nCivID) continue;
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft = 0;
                    this.AI_UseVictoryPoints();
                    return;
                }
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nCivID) continue;
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft = 0;
                    this.AI_UseVictoryPoints();
                    return;
                }
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    protected final void AI_UseVictoryPoints_CivID(int nCivID, int pointsLeft) {
        block19: {
            try {
                int i;
                int provincesSize = this.iProvincesLeftToTakeSize;
                int[] toTakeArr = new int[provincesSize];
                float[] lScoresArr = new float[provincesSize];
                boolean[] lNeighArr = new boolean[provincesSize];
                int toTakeCount = 0;
                boolean canTakeNieghProvince = false;
                float maxDistance = 1.0E-4f;
                for (int i2 = 0; i2 < provincesSize; ++i2) {
                    int provinceIdx = this.provincesLeftToTake.get(i2);
                    PeaceTreaty_DrawData provinceOwner = this.drawProvinceOwners.get(provinceIdx);
                    if (pointsLeft < provinceOwner.iProvinceValue) continue;
                    float dist = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(nCivID).getCapitalProvinceID(), provinceIdx);
                    if (dist > maxDistance) {
                        maxDistance = dist;
                    }
                    if (CFG.game.getProvince(provinceIdx).getTrueOwnerOfProvince() == nCivID) {
                        lScoresArr[toTakeCount] = this.AI_UseVictoryPoints_CivID_Score(nCivID, provinceIdx, 10.0f);
                        lNeighArr[toTakeCount] = true;
                        toTakeArr[toTakeCount++] = provinceIdx;
                        canTakeNieghProvince = true;
                        continue;
                    }
                    boolean tempProvinceAdded = false;
                    int neighSize = CFG.game.getProvince(provinceIdx).getNeighboringProvincesSize();
                    for (int j = 0; j < neighSize; ++j) {
                        int neighIdx = CFG.game.getProvince(provinceIdx).getNeighboringProvinces(j);
                        if (this.drawProvinceOwners.get((int)neighIdx).iCivID != nCivID) continue;
                        if (CFG.game.getProvince(provinceIdx).getCore().getHaveACore(nCivID)) {
                            tempProvinceAdded = true;
                            lScoresArr[toTakeCount] = this.AI_UseVictoryPoints_CivID_Score(nCivID, provinceIdx, 5.0f);
                            lNeighArr[toTakeCount] = true;
                            toTakeArr[toTakeCount++] = provinceIdx;
                            canTakeNieghProvince = true;
                            break;
                        }
                        lScoresArr[toTakeCount] = this.AI_UseVictoryPoints_CivID_Score(nCivID, provinceIdx, 4.25f);
                        lNeighArr[toTakeCount] = true;
                        toTakeArr[toTakeCount++] = provinceIdx;
                        tempProvinceAdded = true;
                        canTakeNieghProvince = true;
                        break;
                    }
                    if (tempProvinceAdded) continue;
                    if (CFG.game.getProvince(provinceIdx).getCore().getHaveACore(nCivID)) {
                        lScoresArr[toTakeCount] = this.AI_UseVictoryPoints_CivID_Score(nCivID, provinceIdx, 1.75f);
                        lNeighArr[toTakeCount] = true;
                        toTakeArr[toTakeCount++] = provinceIdx;
                        canTakeNieghProvince = true;
                        continue;
                    }
                    if (CFG.game.getProvince(provinceIdx).getNeighboringSeaProvincesSize() > 0) {
                        lScoresArr[toTakeCount] = this.AI_UseVictoryPoints_CivID_Score(nCivID, provinceIdx, 0.325f);
                        lNeighArr[toTakeCount] = true;
                        toTakeArr[toTakeCount++] = provinceIdx;
                        canTakeNieghProvince = true;
                        continue;
                    }
                    lScoresArr[toTakeCount] = this.AI_UseVictoryPoints_CivID_Score(nCivID, provinceIdx, 0.025f);
                    lNeighArr[toTakeCount] = false;
                    toTakeArr[toTakeCount++] = provinceIdx;
                }
                if (toTakeCount == 0) {
                    Gdx.app.log("AoC", "AI_UseVictoryPoints -> AI TAKE PROVINCE -> lNeigh.size(): 0");
                    this.AI_UseVictoryPoints_CivID_TakeVassal(nCivID, pointsLeft, true);
                    return;
                }
                boolean hasNeigh = false;
                for (int i3 = 0; i3 < toTakeCount; ++i3) {
                    if (!lNeighArr[i3]) continue;
                    hasNeigh = true;
                    break;
                }
                if (!hasNeigh) {
                    Gdx.app.log("AoC", "AI_UseVictoryPoints -> AI TAKE PROVINCE -> canTakeNieghProvince: false");
                    this.AI_UseVictoryPoints_CivID_TakeVassal(nCivID, pointsLeft, true);
                    return;
                }
                for (int k = 0; k < toTakeCount; ++k) {
                    float dist = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(nCivID).getCapitalProvinceID(), toTakeArr[k]);
                    float distFactor = 0.8f + 0.2f * (1.0f - dist / maxDistance);
                    float lastTakenFactor = this.iLastTakenID == toTakeArr[k] ? 0.05f : 1.0f;
                    lScoresArr[k] = lScoresArr[k] * distFactor * lastTakenFactor;
                }
                int tBest = 0;
                float bestScore = lScoresArr[0];
                for (int k = 1; k < toTakeCount; ++k) {
                    if (!(lScoresArr[k] > bestScore)) continue;
                    tBest = k;
                    bestScore = lScoresArr[k];
                }
                boolean tookProvince = false;
                if (lNeighArr[tBest]) {
                    tookProvince = this.takeProvince(toTakeArr[tBest], nCivID, nCivID);
                } else if (toTakeCount == 1) {
                    tookProvince = this.takeProvince(toTakeArr[tBest], nCivID, nCivID);
                }
                if (tookProvince) break block19;
                boolean found = false;
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nCivID) continue;
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft = 0;
                    this.AI_UseVictoryPoints();
                    found = true;
                    break;
                }
                if (found) break block19;
                for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nCivID) continue;
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft = 0;
                    this.AI_UseVictoryPoints();
                    break;
                }
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
        }
    }

    protected final float AI_UseVictoryPoints_CivID_Score(int nCivID, int nProvinceID, float modifier) {
        int neigh_OwnProvinces = 0;
        int neigh_OtherCivsProvinces = 0;
        for (int i = 0; i < CFG.game.getProvince(nProvinceID).getNeighboringProvincesSize(); ++i) {
            if (CFG.game.getProvince(CFG.game.getProvince(nProvinceID).getNeighboringProvinces(i)).getSeaProvince() || CFG.game.getProvince(CFG.game.getProvince(nProvinceID).getNeighboringProvinces(i)).getWasteland() >= 0 || CFG.game.getProvince(CFG.game.getProvince(nProvinceID).getNeighboringProvinces(i)).getCivID() <= 0) continue;
            if (this.drawProvinceOwners.get((int)CFG.game.getProvince((int)nProvinceID).getNeighboringProvinces((int)i)).iCivID == nCivID) {
                ++neigh_OwnProvinces;
                continue;
            }
            ++neigh_OtherCivsProvinces;
        }
        if (CFG.game.getProvince(nProvinceID).getNeighboringSeaProvincesSize() > 0) {
            ++neigh_OwnProvinces;
        }
        neigh_OtherCivsProvinces = Math.max(1, neigh_OtherCivsProvinces);
        float numDistance = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(nCivID).getPuppetOfCivID(), nProvinceID);
        numDistance = 10.0f * (numDistance / (float)CFG.map.getMapBG().getMaxDistance() / (100.0f * (float)CFG.game.countLandProvinces_NotWasteland() / (float)CFG.game.getProvincesSize()));
        return numDistance + modifier + ((float)neigh_OwnProvinces * (modifier * 0.125f) + modifier * (float)(neigh_OwnProvinces / (neigh_OwnProvinces + neigh_OtherCivsProvinces)) + 0.125f * (float)CFG.game.getProvince(nProvinceID).getPopulationData().getPopulation() / (float)CFG.game.getGameScenarios().getScenario_StartingPopulation() + 0.05f * (float)CFG.game.getProvince(nProvinceID).getEconomy() / (float)CFG.game.getGameScenarios().getScenario_StartingEconomy() + 0.0075f * CFG.game.getProvince(nProvinceID).getDevelopmentLevel());
    }

    protected final void addProvincesLeftToTake(int nProvinceID) {
        Gdx.app.log("AoC", "addProvincesLeftToTake: nCivID: , nProvinceID: " + CFG.game.getProvince(nProvinceID).getName());
        for (int i = 0; i < this.iProvincesLeftToTakeSize; ++i) {
            if (this.provincesLeftToTake.get(i) != nProvinceID) continue;
            return;
        }
        this.provincesLeftToTake.add(nProvinceID);
        this.iProvincesLeftToTakeSize = this.provincesLeftToTake.size();
    }

    protected final void removeProvincesLeftToTake(int nProvinceID) {
        Gdx.app.log("AoC", "removeProvincesLeftToTake: nCivID: , nProvinceID: " + CFG.game.getProvince(nProvinceID).getName());
        for (int i = 0; i < this.iProvincesLeftToTakeSize; ++i) {
            if (this.provincesLeftToTake.get(i) != nProvinceID) continue;
            this.provincesLeftToTake.remove(i);
            this.iProvincesLeftToTakeSize = this.provincesLeftToTake.size();
            return;
        }
    }

    private final void initPeaceTreatyData(int iWarID, List<Boolean> addDefender, List<Boolean> addAggressor, boolean scoreCountDefenders) {
        try {
            this.peaceTreatyGameData.iWarID = iWarID;
            this.peaceTreatyGameData.WAR_TAG = CFG.game.getWar((int)iWarID).WAR_TAG;
            this.scoreCountDefenders = scoreCountDefenders;
            this.iBrushCivID = CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID();
            this.iPlayerTurnID = CFG.PLAYER_TURNID;
            if (this.isPlayerInvolved()) {
                int i;
                boolean PLAYER_IN_WAR = false;
                for (i = 0; i < CFG.game.getWar(iWarID).getDefendersSize(); ++i) {
                    if (!addDefender.get(i).booleanValue()) continue;
                    this.peaceTreatyGameData.lCivsData_Defenders.add(CFG.game.getWar(iWarID).getDefenders_ProvincesLost(i, addDefender, addAggressor));
                    this.peaceTreatyGameData.lCivsDemands_Defenders.add(new PeaceTreaty_Demands(CFG.game.getWar(iWarID).getDefenderID(i).getCivID(), 999999999));
                    if (CFG.game.getWar(iWarID).getDefenderID(i).getCivID() != CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()) continue;
                    PLAYER_IN_WAR = true;
                }
                for (i = 0; i < CFG.game.getWar(iWarID).getAggressorsSize(); ++i) {
                    if (!addAggressor.get(i).booleanValue()) continue;
                    this.peaceTreatyGameData.lCivsData_Aggressors.add(CFG.game.getWar(iWarID).getAggressors_ProvincesLost(i, addDefender, addAggressor));
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.add(new PeaceTreaty_Demands(CFG.game.getWar(iWarID).getAggressorID(i).getCivID(), 999999999));
                    if (CFG.game.getWar(iWarID).getAggressorID(i).getCivID() != CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID()) continue;
                    PLAYER_IN_WAR = true;
                }
                if (CFG.PLAYER_PEACE && !PLAYER_IN_WAR) {
                    this.prepareProvinceData(true);
                    CFG.peaceTreatyData = this;
                    this.iBrushCivID = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)0).iCivID;
                    CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                    CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                    return;
                }
            } else {
                int i;
                for (i = 0; i < CFG.game.getWar(iWarID).getDefendersSize(); ++i) {
                    if (!addDefender.get(i).booleanValue()) continue;
                    this.peaceTreatyGameData.lCivsData_Defenders.add(CFG.game.getWar(iWarID).getDefenders_ProvincesLost(i, addDefender, addAggressor));
                    this.peaceTreatyGameData.lCivsDemands_Defenders.add(new PeaceTreaty_Demands(CFG.game.getWar(iWarID).getDefenderID(i).getCivID(), CFG.game.getWar(iWarID).getWarScore_DefendersInProvinceValue_OnlyPositive(i, addDefender, addAggressor)));
                }
                for (i = 0; i < CFG.game.getWar(iWarID).getAggressorsSize(); ++i) {
                    if (!addAggressor.get(i).booleanValue()) continue;
                    this.peaceTreatyGameData.lCivsData_Aggressors.add(CFG.game.getWar(iWarID).getAggressors_ProvincesLost(i, addDefender, addAggressor));
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.add(new PeaceTreaty_Demands(CFG.game.getWar(iWarID).getAggressorID(i).getCivID(), CFG.game.getWar(iWarID).getWarScore_AggressorsInProvinceValue_OnlyPositive(i, addDefender, addAggressor)));
                }
                this.iBrushCivID = CFG.game.getPlayer(CFG.PLAYER_TURNID).getCivID();
                this.iPlayerTurnID = CFG.PLAYER_TURNID;
            }
            this.prepareProvinceData(true);
        }
        catch (IndexOutOfBoundsException ex) {
            CFG.exceptionStack(ex);
        }
    }

    protected final void prepareProvinceData(boolean buildProvincesLost) {
        int i;
        this.drawProvinceOwners.clear();
        this.drawProvinceOwners = new ArrayList<PeaceTreaty_DrawData>();
        ArrayList<Boolean> tempParticipants = new ArrayList<Boolean>();
        for (i = 0; i < CFG.game.getCivsSize(); ++i) {
            tempParticipants.add(false);
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsData_Defenders.size(); ++i) {
            tempParticipants.set(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).iCivID, true);
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsData_Aggressors.size(); ++i) {
            tempParticipants.set(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i).iCivID, true);
        }
        for (i = 0; i < CFG.game.getProvincesSize(); ++i) {
            if (((Boolean)tempParticipants.get(CFG.game.getProvince(i).getCivID())).booleanValue()) {
                this.drawProvinceOwners.add(new PeaceTreaty_DrawData(CFG.game.getProvince(i).getCivID(), CFG.game.getProvinceValue(i), false));
                continue;
            }
            this.drawProvinceOwners.add(new PeaceTreaty_DrawData(CFG.game.getProvince(i).getCivID() * -1, CFG.game.getProvinceValue(i), false));
        }
        if (this.isPlayerInvolved()) {
            int o;
            int k;
            boolean tAdd;
            int i2;
            PeaceTreaty_Demands peaceTreaty_Demands2;
            int j;
            try {
                for (i = this.peaceTreatyGameData.lCivsData_Defenders.size() - 1; i >= 0; --i) {
                    for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getNumOfProvinces(); ++j) {
                        this.drawProvinceOwners.get((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getProvinceID((int)j)).isToTake = true;
                        this.drawProvinceOwners.get((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getProvinceID((int)j)).iCivID = CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getProvinceID(j)).getTrueOwnerOfProvince();
                        peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
                        peaceTreaty_Demands2.iTotalNumOfVicotryPoints += CFG.game.getProvinceValue(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getProvinceID(j));
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                CFG.exceptionStack(ex);
            }
            try {
                for (int i3 = this.peaceTreatyGameData.lCivsData_Aggressors.size() - 1; i3 >= 0; --i3) {
                    for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i3).iCivID).getNumOfProvinces(); ++j) {
                        this.drawProvinceOwners.get((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i3).iCivID).getProvinceID((int)j)).isToTake = true;
                        this.drawProvinceOwners.get((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i3).iCivID).getProvinceID((int)j)).iCivID = CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i3).iCivID).getProvinceID(j)).getTrueOwnerOfProvince();
                        peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i3);
                        peaceTreaty_Demands2.iTotalNumOfVicotryPoints += CFG.game.getProvinceValue(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i3).iCivID).getProvinceID(j));
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                CFG.exceptionStack(ex);
            }
            for (i2 = this.drawProvinceOwners.size() - 1; i2 >= 0; --i2) {
                if (!this.drawProvinceOwners.get((int)i2).isToTake) continue;
                this.provincesLeftToTake.add(i2);
            }
            for (i2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; i2 >= 0; --i2) {
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs = new ArrayList<PeaceTreaty_ReleaseableVassals>();
                for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getNumOfProvinces(); ++j) {
                    if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).isOccupied()) continue;
                    for (int u = 0; u < CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivsSize(); ++u) {
                        if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u) == CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.get(k).addProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u), CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID).getProvinceID(j)));
                    }
                }
                for (o = this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.size() - 1; o >= 0; --o) {
                    for (int l = 0; l < CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)).getCore().getCivsSize(); ++l) {
                        if (CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.get(k).addProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l), this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i2).lProvincesLost.get(o)));
                    }
                }
            }
            for (i2 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; i2 >= 0; --i2) {
                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs = new ArrayList<PeaceTreaty_ReleaseableVassals>();
                for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getNumOfProvinces(); ++j) {
                    if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).isOccupied()) continue;
                    for (int u = 0; u < CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivsSize(); ++u) {
                        if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u) == CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.get(k).addProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)).getCore().getCivID(u), CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID).getProvinceID(j)));
                    }
                }
                for (o = this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.size() - 1; o >= 0; --o) {
                    for (int l = 0; l < CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)).getCore().getCivsSize(); ++l) {
                        if (CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.get(k).addProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)).getCore().getCivID(l), this.peaceTreatyGameData.lCivsData_Defenders.get((int)i2).lProvincesLost.get(o)));
                    }
                }
            }
            for (i2 = this.drawProvinceOwners.size() - 1; i2 >= 0; --i2) {
                if (!this.drawProvinceOwners.get((int)i2).isToTake) continue;
                this.provincesLeftToTake.add(i2);
            }
            this.iProvincesLeftToTakeSize = this.provincesLeftToTake.size();
        } else if (buildProvincesLost) {
            int o;
            int k;
            boolean tAdd;
            int i4;
            int j;
            try {
                for (i = this.peaceTreatyGameData.lCivsData_Defenders.size() - 1; i >= 0; --i) {
                    for (j = this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.size() - 1; j >= 0; --j) {
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.get((int)j).intValue()).isToTake = true;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.get((int)j).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.get(j)).getTrueOwnerOfProvince();
                        PeaceTreaty_Demands peaceTreaty_Demands = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
                        peaceTreaty_Demands.iTotalNumOfVicotryPoints += CFG.game.getProvinceValue(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.get(j));
                    }
                    for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getNumOfProvinces(); ++j) {
                        PeaceTreaty_Demands peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
                        peaceTreaty_Demands2.iTotalNumOfVicotryPoints += CFG.game.getProvinceValue(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID).getProvinceID(j));
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                CFG.exceptionStack(ex);
            }
            try {
                for (int i5 = this.peaceTreatyGameData.lCivsData_Aggressors.size() - 1; i5 >= 0; --i5) {
                    for (j = this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i5).lProvincesLost.size() - 1; j >= 0; --j) {
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i5).lProvincesLost.get((int)j).intValue()).isToTake = true;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i5).lProvincesLost.get((int)j).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i5).lProvincesLost.get(j)).getTrueOwnerOfProvince();
                        PeaceTreaty_Demands peaceTreaty_Demands3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i5);
                        peaceTreaty_Demands3.iTotalNumOfVicotryPoints += CFG.game.getProvinceValue(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i5).lProvincesLost.get(j));
                    }
                    for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i5).iCivID).getNumOfProvinces(); ++j) {
                        PeaceTreaty_Demands peaceTreaty_Demands4 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i5);
                        peaceTreaty_Demands4.iTotalNumOfVicotryPoints += CFG.game.getProvinceValue(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i5).iCivID).getProvinceID(j));
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                CFG.exceptionStack(ex);
            }
            for (i4 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; i4 >= 0; --i4) {
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs = new ArrayList<PeaceTreaty_ReleaseableVassals>();
                for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getNumOfProvinces(); ++j) {
                    if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).isOccupied()) continue;
                    for (int u = 0; u < CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivsSize(); ++u) {
                        if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u) == CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.get(k).addProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u), CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).iCivID).getProvinceID(j)));
                    }
                }
                for (o = this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.size() - 1; o >= 0; --o) {
                    for (int l = 0; l < CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)).getCore().getCivsSize(); ++l) {
                        if (CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.get(k).addProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i4).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l), this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i4).lProvincesLost.get(o)));
                    }
                }
            }
            for (i4 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; i4 >= 0; --i4) {
                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs = new ArrayList<PeaceTreaty_ReleaseableVassals>();
                for (j = 0; j < CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getNumOfProvinces(); ++j) {
                    if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).isOccupied()) continue;
                    for (int u = 0; u < CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivsSize(); ++u) {
                        if (CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u) == CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.get(k).addProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)).getCore().getCivID(u), CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).iCivID).getProvinceID(j)));
                    }
                }
                for (o = this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.size() - 1; o >= 0; --o) {
                    for (int l = 0; l < CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)).getCore().getCivsSize(); ++l) {
                        if (CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)).getCivID() || CFG.game.getCiv(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l)).getNumOfProvinces() != 0) continue;
                        tAdd = true;
                        for (k = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.size() - 1; k >= 0; --k) {
                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.get((int)k).iCivID != CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l)) continue;
                            tAdd = false;
                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.get(k).addProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o));
                            break;
                        }
                        if (!tAdd) continue;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i4).lReleasableCivs.add(new PeaceTreaty_ReleaseableVassals(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)).getCore().getCivID(l), this.peaceTreatyGameData.lCivsData_Defenders.get((int)i4).lProvincesLost.get(o)));
                    }
                }
            }
            for (i4 = this.drawProvinceOwners.size() - 1; i4 >= 0; --i4) {
                if (!this.drawProvinceOwners.get((int)i4).isToTake) continue;
                this.provincesLeftToTake.add(i4);
            }
            this.iProvincesLeftToTakeSize = this.provincesLeftToTake.size();
        } else {
            try {
                int o2;
                int k3;
                boolean removed;
                int k2;
                boolean isAdded;
                int j2;
                boolean addCiv;
                int m;
                ArrayList<Boolean> addDefender = new ArrayList<Boolean>();
                ArrayList<Boolean> addAggressor = new ArrayList<Boolean>();
                for (m = 0; m < CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefendersSize(); ++m) {
                    addCiv = false;
                    for (j2 = this.peaceTreatyGameData.lCivsData_Defenders.size() - 1; j2 >= 0; --j2) {
                        if (CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenderID(m).getCivID() != this.peaceTreatyGameData.lCivsData_Defenders.get((int)j2).iCivID) continue;
                        addCiv = true;
                        break;
                    }
                    addDefender.add(addCiv);
                }
                for (m = 0; m < CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorsSize(); ++m) {
                    addCiv = false;
                    for (j2 = this.peaceTreatyGameData.lCivsData_Aggressors.size() - 1; j2 >= 0; --j2) {
                        if (CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorID(m).getCivID() != this.peaceTreatyGameData.lCivsData_Aggressors.get((int)j2).iCivID) continue;
                        addCiv = true;
                        break;
                    }
                    addAggressor.add(addCiv);
                }
                for (m = this.peaceTreatyGameData.lCivsData_Defenders.size() - 1; m >= 0; --m) {
                    try {
                        PeaceTreaty_Civs tempLost = CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenders_ProvincesLost(CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenderID_ByCivID(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).iCivID), addDefender, addAggressor);
                        for (j2 = tempLost.lProvincesLost.size() - 1; j2 >= 0; --j2) {
                            isAdded = false;
                            for (k2 = this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.size() - 1; k2 >= 0; --k2) {
                                if (!tempLost.lProvincesLost.get(j2).equals(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(k2))) continue;
                                isAdded = true;
                                break;
                            }
                            if (!isAdded) {
                                this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.add(tempLost.lProvincesLost.get(j2));
                                this.makeDemand_Province(tempLost.lProvincesLost.get(j2), this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).iCivID, this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).iCivID, true);
                            }
                            tempLost.lProvincesLost.remove(j2);
                        }
                        continue;
                    }
                    catch (IndexOutOfBoundsException tempLost) {
                        // empty catch block
                    }
                }
                for (m = 0; m < this.peaceTreatyGameData.lCivsData_Aggressors.size(); ++m) {
                    try {
                        PeaceTreaty_Civs tempLost = CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressors_ProvincesLost(CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorID_ByCivID(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).iCivID), addDefender, addAggressor);
                        for (j2 = tempLost.lProvincesLost.size() - 1; j2 >= 0; --j2) {
                            isAdded = false;
                            for (k2 = this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.size() - 1; k2 >= 0; --k2) {
                                if (!tempLost.lProvincesLost.get(j2).equals(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(k2))) continue;
                                isAdded = true;
                                break;
                            }
                            if (!isAdded) {
                                this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.add(tempLost.lProvincesLost.get(j2));
                                this.makeDemand_Province(tempLost.lProvincesLost.get(j2), this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).iCivID, this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).iCivID, true);
                            }
                            tempLost.lProvincesLost.remove(j2);
                        }
                        continue;
                    }
                    catch (IndexOutOfBoundsException tempLost) {
                        // empty catch block
                    }
                }
                for (m = this.peaceTreatyGameData.lCivsData_Defenders.size() - 1; m >= 0; --m) {
                    if (CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsAggressor(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).iCivID) || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsDefender(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).iCivID)) {
                        for (int j3 = this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.size() - 1; j3 >= 0; --j3) {
                            if (CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)).isOccupied()) {
                                if (CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsDefender(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)).getCivID()) || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsAggressor(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)).getCivID())) {
                                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get((int)j3).intValue()).isToTake = true;
                                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get((int)j3).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)).getTrueOwnerOfProvince();
                                    continue;
                                }
                                removed = false;
                                block71: for (k3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; k3 >= 0; --k3) {
                                    for (o2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                        if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)) continue;
                                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.remove(o2);
                                        k3 = -1;
                                        removed = true;
                                        continue block71;
                                    }
                                }
                                if (!removed) {
                                    block73: for (k3 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; k3 >= 0; --k3) {
                                        for (o2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)) continue;
                                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.remove(o2);
                                            k3 = -1;
                                            removed = true;
                                            continue block73;
                                        }
                                    }
                                }
                                this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.remove(j3);
                                continue;
                            }
                            removed = false;
                            block75: for (k3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; k3 >= 0; --k3) {
                                for (o2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)) continue;
                                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.remove(o2);
                                    k3 = -1;
                                    removed = true;
                                    continue block75;
                                }
                            }
                            if (!removed) {
                                block77: for (k3 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; k3 >= 0; --k3) {
                                    for (o2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.get(j3)) continue;
                                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.remove(o2);
                                        k3 = -1;
                                        removed = true;
                                        continue block77;
                                    }
                                }
                            }
                            this.peaceTreatyGameData.lCivsData_Defenders.get((int)m).lProvincesLost.remove(j3);
                        }
                        continue;
                    }
                    this.peaceTreatyGameData.lCivsData_Defenders.remove(m);
                    this.peaceTreatyGameData.lCivsDemands_Defenders.remove(m);
                }
                for (m = this.peaceTreatyGameData.lCivsData_Aggressors.size() - 1; m >= 0; --m) {
                    if (CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsAggressor(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).iCivID) || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsDefender(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).iCivID)) {
                        for (int j3 = this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.size() - 1; j3 >= 0; --j3) {
                            if (CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)).isOccupied()) {
                                if (CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsDefender(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)).getCivID()) || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getIsAggressor(CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)).getCivID())) {
                                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get((int)j3).intValue()).isToTake = true;
                                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get((int)j3).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)).getTrueOwnerOfProvince();
                                    continue;
                                }
                                removed = false;
                                block81: for (k3 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; k3 >= 0; --k3) {
                                    for (o2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)) continue;
                                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.remove(o2);
                                        k3 = -1;
                                        removed = true;
                                        continue block81;
                                    }
                                }
                                if (!removed) {
                                    block83: for (k3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; k3 >= 0; --k3) {
                                        for (o2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)) continue;
                                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.remove(o2);
                                            k3 = -1;
                                            removed = true;
                                            continue block83;
                                        }
                                    }
                                }
                                this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.remove(j3);
                                continue;
                            }
                            removed = false;
                            block85: for (k3 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; k3 >= 0; --k3) {
                                for (o2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)) continue;
                                    this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.remove(o2);
                                    k3 = -1;
                                    removed = true;
                                    continue block85;
                                }
                            }
                            if (!removed) {
                                block87: for (k3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; k3 >= 0; --k3) {
                                    for (o2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.size() - 1; o2 >= 0; --o2) {
                                        if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(o2) != this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.get(j3)) continue;
                                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.remove(o2);
                                        k3 = -1;
                                        removed = true;
                                        continue block87;
                                    }
                                }
                            }
                            this.peaceTreatyGameData.lCivsData_Aggressors.get((int)m).lProvincesLost.remove(j3);
                        }
                        continue;
                    }
                    this.peaceTreatyGameData.lCivsData_Aggressors.remove(m);
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.remove(m);
                }
                for (m = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; m >= 0; --m) {
                    for (int j3 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)m).lDemands.size() - 1; j3 >= 0; --j3) {
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)m).lDemands.get((int)j3).intValue()).isTaken = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)m).iCivID;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)m).lDemands.get((int)j3).intValue()).iCivID = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)m).iCivID;
                    }
                }
                for (m = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; m >= 0; --m) {
                    for (int j3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)m).lDemands.size() - 1; j3 >= 0; --j3) {
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)m).lDemands.get((int)j3).intValue()).isTaken = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)m).iCivID;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)m).lDemands.get((int)j3).intValue()).iCivID = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)m).iCivID;
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                CFG.exceptionStack(ex);
            }
        }
    }

    protected final void prepareDemansVassalsData() {
        int u;
        int o;
        int k;
        int j;
        int i;
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs_TakeControl.size(); ++j) {
                for (k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs_TakeControl.get((int)j).iFromCivID != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID) continue;
                    for (o = 0; o < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.size(); ++o) {
                        if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)o).iCivID != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs_TakeControl.get((int)j).iVassalCivID) continue;
                        for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)o).lProvinces.size(); ++u) {
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)o).lProvinces.get((int)u).intValue()).iCivID = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs_TakeControl.get((int)j).iVassalCivID;
                        }
                    }
                }
            }
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs_TakeControl.size(); ++j) {
                for (k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs_TakeControl.get((int)j).iFromCivID != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID) continue;
                    for (o = 0; o < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.size(); ++o) {
                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)o).iCivID != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs_TakeControl.get((int)j).iVassalCivID) continue;
                        for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)o).lProvinces.size(); ++u) {
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)o).lProvinces.get((int)u).intValue()).iCivID = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs_TakeControl.get((int)j).iVassalCivID;
                        }
                    }
                }
            }
        }
    }

    protected final int takeReleaseVassal(int iFromCivID, int nReleaseCivID, int nCivID, int pointsUsedByCivID) {
        int o;
        int nID;
        int j;
        int i;
        block0: for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != iFromCivID) continue;
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++j) {
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iCivID != nCivID) continue;
                nID = -1;
                for (o = 0; o < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.size(); ++o) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)o).iCivID != nReleaseCivID) continue;
                    nID = o;
                    break;
                }
                if (nID < 0) {
                    i = this.peaceTreatyGameData.lCivsDemands_Defenders.size();
                    continue block0;
                }
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID == nCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID = -1;
                        PeaceTreaty_Demands peaceTreaty_Demands = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                        peaceTreaty_Demands.iVictoryPointsLeft += this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get(nID).getScoreValue();
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j).removeReleaseVassal_TakeControl(iFromCivID, nReleaseCivID);
                        for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.size(); ++k) {
                            if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isToTake) {
                                if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken > 0) {
                                    if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iCivID) {
                                        int u;
                                        for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++u) {
                                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)u).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(u).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                            }
                                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)u).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                            PeaceTreaty_Demands peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(u);
                                            peaceTreaty_Demands2.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                        }
                                        for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++u) {
                                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)u).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                                this.peaceTreatyGameData.lCivsDemands_Defenders.get(u).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                            }
                                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)u).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                            PeaceTreaty_Demands peaceTreaty_Demands3 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(u);
                                            peaceTreaty_Demands3.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                        }
                                        PeaceTreaty_Demands peaceTreaty_Demands4 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                                        peaceTreaty_Demands4.iVictoryPointsLeft -= this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                    }
                                } else {
                                    PeaceTreaty_Demands peaceTreaty_Demands5 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                                    peaceTreaty_Demands5.iVictoryPointsLeft -= this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                }
                                this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken = -1;
                                this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k)).getCivID();
                                continue;
                            }
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k)).getCivID();
                        }
                        return 0;
                    }
                    return this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID;
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iVictoryPointsLeft < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get(nID).getScoreValue()) {
                    return 0;
                }
                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID = nCivID;
                PeaceTreaty_Demands peaceTreaty_Demands6 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                peaceTreaty_Demands6.iVictoryPointsLeft -= this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get(nID).getScoreValue();
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j).addReleaseVassal_TakeControl(iFromCivID, nReleaseCivID);
                for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.size(); ++k) {
                    if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isToTake) {
                        if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken > 0) {
                            int u;
                            for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++u) {
                                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                }
                                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                PeaceTreaty_Demands peaceTreaty_Demands7 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i);
                                peaceTreaty_Demands7.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                            }
                            for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++u) {
                                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                    this.peaceTreatyGameData.lCivsDemands_Defenders.get(i).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                }
                                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                PeaceTreaty_Demands peaceTreaty_Demands8 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
                                peaceTreaty_Demands8.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                            }
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken = -1;
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k)).getTrueOwnerOfProvince();
                        }
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken = nCivID;
                    }
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = nReleaseCivID;
                }
                return nCivID;
            }
        }
        block9: for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != iFromCivID) continue;
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++j) {
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iCivID != nCivID) continue;
                nID = -1;
                for (o = 0; o < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.size(); ++o) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)o).iCivID != nReleaseCivID) continue;
                    nID = o;
                    break;
                }
                if (nID < 0) {
                    i = this.peaceTreatyGameData.lCivsDemands_Aggressors.size();
                    continue block9;
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID == nCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID = -1;
                        PeaceTreaty_Demands peaceTreaty_Demands9 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                        peaceTreaty_Demands9.iVictoryPointsLeft += this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get(nID).getScoreValue();
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(j).removeReleaseVassal_TakeControl(iFromCivID, nReleaseCivID);
                        for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.size(); ++k) {
                            if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isToTake) {
                                if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken > 0) {
                                    if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iCivID) {
                                        int u;
                                        for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++u) {
                                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)u).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                                this.peaceTreatyGameData.lCivsDemands_Defenders.get(u).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                            }
                                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)u).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                            PeaceTreaty_Demands peaceTreaty_Demands10 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(u);
                                            peaceTreaty_Demands10.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                        }
                                        for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++u) {
                                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)u).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(u).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                            }
                                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)u).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                            PeaceTreaty_Demands peaceTreaty_Demands11 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(u);
                                            peaceTreaty_Demands11.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                        }
                                        PeaceTreaty_Demands peaceTreaty_Demands12 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                                        peaceTreaty_Demands12.iVictoryPointsLeft -= this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                    }
                                } else {
                                    PeaceTreaty_Demands peaceTreaty_Demands13 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                                    peaceTreaty_Demands13.iVictoryPointsLeft -= this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                                }
                                this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken = -1;
                                this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k)).getCivID();
                                continue;
                            }
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k)).getCivID();
                        }
                        return 0;
                    }
                    return this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID;
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get(nID).getScoreValue() > this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iVictoryPointsLeft) {
                    return 0;
                }
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).iReleasesToCivID = nCivID;
                PeaceTreaty_Demands peaceTreaty_Demands14 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                peaceTreaty_Demands14.iVictoryPointsLeft -= this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get(nID).getScoreValue();
                this.peaceTreatyGameData.lCivsDemands_Defenders.get(j).addReleaseVassal_TakeControl(iFromCivID, nReleaseCivID);
                for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.size(); ++k) {
                    if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isToTake) {
                        if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken > 0) {
                            int u;
                            for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++u) {
                                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                    this.peaceTreatyGameData.lCivsDemands_Defenders.get(i).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                }
                                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                PeaceTreaty_Demands peaceTreaty_Demands15 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
                                peaceTreaty_Demands15.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                            }
                            for (u = 0; u < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++u) {
                                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID == this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID) {
                                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k));
                                }
                                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken) continue;
                                PeaceTreaty_Demands peaceTreaty_Demands16 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i);
                                peaceTreaty_Demands16.iVictoryPointsLeft += this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iProvinceValue;
                            }
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken = -1;
                            this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get(k)).getTrueOwnerOfProvince();
                        }
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).isTaken = nCivID;
                    }
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).lReleasableCivs.get((int)nID).lProvinces.get((int)k).intValue()).iCivID = nReleaseCivID;
                }
                return nCivID;
            }
        }
        return pointsUsedByCivID;
    }

    protected final int getVassalization_Cost(int nCivID) {
        int i;
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nCivID) continue;
            return (int)Math.max((float)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iTotalNumOfVicotryPoints * 0.4f, 1.0f);
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nCivID) continue;
            return (int)Math.max((float)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iTotalNumOfVicotryPoints * 0.4f, 1.0f);
        }
        return 1;
    }

    protected final int takeVassalize(int nVasslizeCivID, int nCivID, int pointsUsedByCivID) {
        int j;
        int i;
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nVasslizeCivID) continue;
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++j) {
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iCivID != nCivID) continue;
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iWillBecomeVassalOfCivID > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iWillBecomeVassalOfCivID == nCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iWillBecomeVassalOfCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                        peaceTreaty_Demands.iVictoryPointsLeft += this.getVassalization_Cost(nVasslizeCivID);
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j).removeWillVassalizeCivID(nVasslizeCivID);
                        if (CFG.menuManager.getInGame_PeaceTreaty()) {
                            if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                                CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                            }
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                        }
                        return 0;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iVictoryPointsLeft < this.getVassalization_Cost(nVasslizeCivID)) {
                        if (CFG.menuManager.getInGame_PeaceTreaty()) {
                            if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                                CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                            }
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                        }
                        return 0;
                    }
                    for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k) {
                        if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iWillBecomeVassalOfCivID) continue;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iWillBecomeVassalOfCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k);
                        peaceTreaty_Demands2.iVictoryPointsLeft += this.getVassalization_Cost(nVasslizeCivID);
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k).removeWillVassalizeCivID(nVasslizeCivID);
                        break;
                    }
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iVictoryPointsLeft < this.getVassalization_Cost(nVasslizeCivID)) {
                    if (CFG.menuManager.getInGame_PeaceTreaty()) {
                        if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                        }
                        CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                    }
                    return 0;
                }
                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iWillBecomeVassalOfCivID = nCivID;
                PeaceTreaty_Demands peaceTreaty_Demands3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                peaceTreaty_Demands3.iVictoryPointsLeft -= this.getVassalization_Cost(nVasslizeCivID);
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j).addWillVassalizeCivID(nVasslizeCivID);
                if (CFG.menuManager.getInGame_PeaceTreaty()) {
                    if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                        CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                    }
                    CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                }
                return nCivID;
            }
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nVasslizeCivID) continue;
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++j) {
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iCivID != nCivID) continue;
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iWillBecomeVassalOfCivID > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iWillBecomeVassalOfCivID == nCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iWillBecomeVassalOfCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands4 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                        peaceTreaty_Demands4.iVictoryPointsLeft += this.getVassalization_Cost(nVasslizeCivID);
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(j).removeWillVassalizeCivID(nVasslizeCivID);
                        if (CFG.menuManager.getInGame_PeaceTreaty()) {
                            if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                                CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                            }
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                        }
                        return 0;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iVictoryPointsLeft < this.getVassalization_Cost(nVasslizeCivID)) {
                        if (CFG.menuManager.getInGame_PeaceTreaty()) {
                            if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                                CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                            }
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                        }
                        return 0;
                    }
                    for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k) {
                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iWillBecomeVassalOfCivID) continue;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iWillBecomeVassalOfCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands5 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(k);
                        peaceTreaty_Demands5.iVictoryPointsLeft += this.getVassalization_Cost(nVasslizeCivID);
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(k).removeWillVassalizeCivID(nVasslizeCivID);
                        break;
                    }
                }
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iVictoryPointsLeft < this.getVassalization_Cost(nVasslizeCivID)) {
                    if (CFG.menuManager.getInGame_PeaceTreaty()) {
                        if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                        }
                        CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                    }
                    return 0;
                }
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iWillBecomeVassalOfCivID = nCivID;
                PeaceTreaty_Demands peaceTreaty_Demands6 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                peaceTreaty_Demands6.iVictoryPointsLeft -= this.getVassalization_Cost(nVasslizeCivID);
                this.peaceTreatyGameData.lCivsDemands_Defenders.get(j).addWillVassalizeCivID(nVasslizeCivID);
                if (CFG.menuManager.getInGame_PeaceTreaty()) {
                    if (!CFG.game.getCiv(nCivID).getControlledByPlayer()) {
                        CFG.menuManager.rebuildInGame_PeaceTreaty_Provinces();
                    }
                    CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                }
                return nCivID;
            }
        }
        return pointsUsedByCivID;
    }

    protected final int getWarReparation_Cost(int nCivID) {
        int i;
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nCivID) continue;
            return (int)Math.max((float)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iTotalNumOfVicotryPoints * 0.1f, 1.0f);
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nCivID) continue;
            return (int)Math.max((float)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iTotalNumOfVicotryPoints * 0.1f, 1.0f);
        }
        return 1;
    }

    protected final int takeWarReparations(int nWarRepartionsFromCivID, int nCivID, int pointsUsedByCivID) {
        int j;
        int i;
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != nWarRepartionsFromCivID) continue;
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++j) {
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iCivID != nCivID) continue;
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iPaysWarReparationsToCivID > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iPaysWarReparationsToCivID == nCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iPaysWarReparationsToCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                        peaceTreaty_Demands.iVictoryPointsLeft += this.getWarReparation_Cost(nWarRepartionsFromCivID);
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j).removeWarReparationsFromCivID(nWarRepartionsFromCivID);
                        return 0;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iVictoryPointsLeft < this.getWarReparation_Cost(nWarRepartionsFromCivID)) {
                        return 0;
                    }
                    for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k) {
                        if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iPaysWarReparationsToCivID) continue;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iPaysWarReparationsToCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k);
                        peaceTreaty_Demands2.iVictoryPointsLeft += this.getWarReparation_Cost(nWarRepartionsFromCivID);
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k).removeWarReparationsFromCivID(nWarRepartionsFromCivID);
                        break;
                    }
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)j).iVictoryPointsLeft < this.getWarReparation_Cost(nWarRepartionsFromCivID)) {
                    return 0;
                }
                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iPaysWarReparationsToCivID = nCivID;
                PeaceTreaty_Demands peaceTreaty_Demands3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j);
                peaceTreaty_Demands3.iVictoryPointsLeft -= this.getWarReparation_Cost(nWarRepartionsFromCivID);
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(j).addWarReparationsFromCivID(nWarRepartionsFromCivID);
                return nCivID;
            }
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != nWarRepartionsFromCivID) continue;
            for (j = 0; j < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++j) {
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iCivID != nCivID) continue;
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iPaysWarReparationsToCivID > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iPaysWarReparationsToCivID == nCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iPaysWarReparationsToCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands4 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                        peaceTreaty_Demands4.iVictoryPointsLeft += this.getWarReparation_Cost(nWarRepartionsFromCivID);
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(j).removeWarReparationsFromCivID(nWarRepartionsFromCivID);
                        return 0;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iVictoryPointsLeft < this.getWarReparation_Cost(nWarRepartionsFromCivID)) {
                        return 0;
                    }
                    for (int k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k) {
                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iPaysWarReparationsToCivID) continue;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iPaysWarReparationsToCivID = 0;
                        PeaceTreaty_Demands peaceTreaty_Demands5 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(k);
                        peaceTreaty_Demands5.iVictoryPointsLeft += this.getWarReparation_Cost(nWarRepartionsFromCivID);
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(k).removeWarReparationsFromCivID(nWarRepartionsFromCivID);
                        break;
                    }
                }
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)j).iVictoryPointsLeft < this.getWarReparation_Cost(nWarRepartionsFromCivID)) {
                    return 0;
                }
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iPaysWarReparationsToCivID = nCivID;
                PeaceTreaty_Demands peaceTreaty_Demands6 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(j);
                peaceTreaty_Demands6.iVictoryPointsLeft -= this.getWarReparation_Cost(nWarRepartionsFromCivID);
                this.peaceTreatyGameData.lCivsDemands_Defenders.get(j).addWarReparationsFromCivID(nWarRepartionsFromCivID);
                return nCivID;
            }
        }
        return pointsUsedByCivID;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final boolean takeProvince(int nProvinceID, int nCivID, int pointsUsedByCivID) {
        if (nProvinceID < 0) return false;
        if (CFG.game.getProvince(nProvinceID).getSeaProvince()) return false;
        if (!this.drawProvinceOwners.get((int)nProvinceID).isToTake) return false;
        this.iLastTakenID = nProvinceID;
        if (this.drawProvinceOwners.get((int)nProvinceID).isTaken > 0) {
            int i;
            if (this.drawProvinceOwners.get((int)nProvinceID).iCivID == nCivID) {
                int i2;
                for (i2 = 0; i2 < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i2) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID == this.drawProvinceOwners.get((int)nProvinceID).iCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(i2).removeDemandOnProvince(nProvinceID);
                        this.addProvincesLeftToTake(nProvinceID);
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i2).iCivID != this.drawProvinceOwners.get((int)nProvinceID).isTaken) continue;
                    PeaceTreaty_Demands peaceTreaty_Demands = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i2);
                    peaceTreaty_Demands.iVictoryPointsLeft += this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue;
                    if (!CFG.menuManager.getInGame_PeaceTreaty()) continue;
                    CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                }
                i2 = 0;
                while (true) {
                    if (i2 >= this.peaceTreatyGameData.lCivsDemands_Aggressors.size()) {
                        this.drawProvinceOwners.get((int)nProvinceID).isTaken = -1;
                        this.drawProvinceOwners.get((int)nProvinceID).iCivID = CFG.game.getProvince(nProvinceID).getTrueOwnerOfProvince();
                        return false;
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID == this.drawProvinceOwners.get((int)nProvinceID).iCivID) {
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i2).removeDemandOnProvince(nProvinceID);
                        this.addProvincesLeftToTake(nProvinceID);
                    }
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i2).iCivID == this.drawProvinceOwners.get((int)nProvinceID).isTaken) {
                        PeaceTreaty_Demands peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i2);
                        peaceTreaty_Demands2.iVictoryPointsLeft += this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue;
                        if (CFG.menuManager.getInGame_PeaceTreaty()) {
                            CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
                        }
                    }
                    ++i2;
                }
            }
            for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); peaceTreaty_Demands3.iVictoryPointsLeft += this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue, ++i) {
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID == this.drawProvinceOwners.get((int)nProvinceID).iCivID) {
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get(i).removeDemandOnProvince(nProvinceID);
                    this.addProvincesLeftToTake(nProvinceID);
                }
                PeaceTreaty_Demands peaceTreaty_Demands3 = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
            }
            for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID == this.drawProvinceOwners.get((int)nProvinceID).iCivID) {
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i).removeDemandOnProvince(nProvinceID);
                    this.addProvincesLeftToTake(nProvinceID);
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != this.drawProvinceOwners.get((int)nProvinceID).isTaken) continue;
                PeaceTreaty_Demands peaceTreaty_Demands4 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i);
                peaceTreaty_Demands4.iVictoryPointsLeft += this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue;
            }
            this.drawProvinceOwners.get((int)nProvinceID).isTaken = -1;
            if (this.makeDemand_Province(nProvinceID, nCivID, pointsUsedByCivID)) {
                this.removeProvincesLeftToTake(nProvinceID);
                CFG.game.setActiveProvinceID(-1);
                this.AI_UseVictoryPoints();
                return true;
            }
            CFG.game.setActiveProvinceID(-1);
            this.AI_UseVictoryPoints();
            return false;
        }
        if (this.makeDemand_Province(nProvinceID, nCivID, pointsUsedByCivID)) {
            this.removeProvincesLeftToTake(nProvinceID);
            CFG.game.setActiveProvinceID(-1);
            this.AI_UseVictoryPoints();
            return true;
        }
        CFG.game.setActiveProvinceID(-1);
        this.AI_UseVictoryPoints();
        return false;
    }

    protected final boolean makeDemand_Province(int nProvinceID, int nCivID, int pointsUsedByCivID) {
        return this.makeDemand_Province(nProvinceID, nCivID, pointsUsedByCivID, false);
    }

    protected final boolean makeDemand_Province(int nProvinceID, int nCivID, int pointsUsedByCivID, boolean free_ToTrueOwner) {
        int i;
        Gdx.app.log("AoC", "makeDemand_Province: nCivID: " + CFG.game.getCiv(nCivID).getCivName() + ", nProvinceID: " + CFG.game.getProvince(nProvinceID).getName());
        if (nCivID != pointsUsedByCivID && CFG.game.getProvince(nProvinceID).getTrueOwnerOfProvince() == nCivID) {
            pointsUsedByCivID = nCivID;
        }
        if (!free_ToTrueOwner) {
            for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
                if (this.drawProvinceOwners.get((int)nProvinceID).isTaken > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != pointsUsedByCivID) continue;
                    if (this.drawProvinceOwners.get((int)nProvinceID).isTaken == pointsUsedByCivID) break;
                    if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft >= this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue) continue;
                    return false;
                }
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != pointsUsedByCivID || this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iVictoryPointsLeft >= this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue) continue;
                return false;
            }
            for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
                if (this.drawProvinceOwners.get((int)nProvinceID).isTaken > 0) {
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != pointsUsedByCivID) continue;
                    if (this.drawProvinceOwners.get((int)nProvinceID).isTaken == pointsUsedByCivID) break;
                    if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft >= this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue) continue;
                    return false;
                }
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != pointsUsedByCivID || this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iVictoryPointsLeft >= this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue) continue;
                return false;
            }
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID == nCivID) {
                this.peaceTreatyGameData.lCivsDemands_Defenders.get(i).addDemandOnProvince(nProvinceID);
            }
            if (this.drawProvinceOwners.get((int)nProvinceID).isTaken > 0) {
                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != this.drawProvinceOwners.get((int)nProvinceID).iCivID) continue;
                this.peaceTreatyGameData.lCivsDemands_Defenders.get(i).removeDemandOnProvince(nProvinceID);
                continue;
            }
            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)i).iCivID != pointsUsedByCivID) continue;
            PeaceTreaty_Demands peaceTreaty_Demands = this.peaceTreatyGameData.lCivsDemands_Defenders.get(i);
            peaceTreaty_Demands.iVictoryPointsLeft -= this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue;
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++i) {
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID == nCivID) {
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i).addDemandOnProvince(nProvinceID);
            }
            if (this.drawProvinceOwners.get((int)nProvinceID).isTaken > 0) {
                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != this.drawProvinceOwners.get((int)nProvinceID).iCivID) continue;
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i).removeDemandOnProvince(nProvinceID);
                continue;
            }
            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)i).iCivID != pointsUsedByCivID) continue;
            PeaceTreaty_Demands peaceTreaty_Demands2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get(i);
            peaceTreaty_Demands2.iVictoryPointsLeft -= this.drawProvinceOwners.get((int)nProvinceID).iProvinceValue;
        }
        this.drawProvinceOwners.get((int)nProvinceID).isTaken = pointsUsedByCivID;
        this.drawProvinceOwners.get((int)nProvinceID).iCivID = nCivID;
        if (CFG.menuManager.getInGame_PeaceTreaty()) {
            CFG.menuManager.rebuildInGame_PeaceTreaty_Scores();
        }
        return true;
    }

    protected final boolean purifyTreaty(int iFromCivID) {
        ArrayList<Integer> provinces;
        int j;
        boolean bContinue;
        int i;
        String sOwners;
        FileHandle file;
        Enumeration<String> keyVals;
        String foundID;
        int foundVassal;
        int l2;
        float denominator;
        float numerator;
        float sTotal;
        float mediatedMapSize;
        float numDistance;
        int numOfConnections_Neutral;
        int numOfConnections_Enemies;
        int numOfConnections_PT;
        int numOfConnections_Own;
        int l;
        int k;
        boolean updateData = false;
        for (k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k) {
            if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getControlledByPlayer()) continue;
            for (l = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.size() - 1; l >= 0; --l) {
                numOfConnections_Own = 0;
                numOfConnections_PT = 0;
                numOfConnections_Enemies = 0;
                numOfConnections_Neutral = 0;
                for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvincesSize(); ++m) {
                    if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getTrueOwnerOfProvince() == this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID) {
                        ++numOfConnections_Own;
                        continue;
                    }
                    if (this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).getNeighboringProvinces((int)m)).iCivID == this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID) {
                        ++numOfConnections_PT;
                        continue;
                    }
                    if (CFG.game.getCivsAtWar(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID, Math.abs(this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).getNeighboringProvinces((int)m)).iCivID))) {
                        ++numOfConnections_Enemies;
                        continue;
                    }
                    if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getWasteland() >= 0 || CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getSeaProvince()) continue;
                    ++numOfConnections_Neutral;
                }
                numDistance = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getCapitalProvinceID(), this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l));
                mediatedMapSize = (float)CFG.map.getMapBG().getMaxDistance() / (100.0f * (float)CFG.game.countLandProvinces_NotWasteland() / (float)CFG.game.getProvincesSize());
                sTotal = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvincesSize();
                if (sTotal > 0.0f) {
                    float nNotOwned = numOfConnections_Neutral + numOfConnections_Enemies;
                    float oOwned = numOfConnections_PT + numOfConnections_Own;
                    numerator = sTotal - nNotOwned + oOwned + (float)(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringSeaProvincesSize() * 3);
                    denominator = sTotal - nNotOwned * 1.65f;
                } else {
                    numerator = numDistance < 150.0f ? 1.0f : 0.0f;
                    denominator = 1.0f;
                }
                if (numerator / denominator <= 0.45f) {
                    if (Math.abs(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).iCivID) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getTrueOwnerOfProvince()) {
                        int optimal = -1;
                        for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvincesSize(); ++m) {
                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID == CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID() || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID()) < 0 && CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenderID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID()) < 0) continue;
                            optimal = CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID();
                            break;
                        }
                        if (optimal > -1) {
                            int i2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l);
                            this.drawProvinceOwners.get((int)i2).iCivID = optimal;
                            this.drawProvinceOwners.get((int)i2).isTaken = optimal;
                            this.drawProvinceOwners.get((int)i2).isToTake = false;
                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.remove(l);
                            for (l2 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; l2 >= 0; --l2) {
                                if (optimal != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).iCivID) continue;
                                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).lDemands.add(i2);
                            }
                            for (l2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; l2 >= 0; --l2) {
                                if (optimal != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).iCivID) continue;
                                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).lDemands.add(i2);
                            }
                            updateData = true;
                            Gdx.app.log("AoC2.5", "Corrected Peace Treaty loneprovince");
                            continue;
                        }
                    }
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).isTaken = -1;
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).iCivID = CFG.game.getProvince(k).getCivID() * -1;
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get(k).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l));
                    updateData = true;
                    continue;
                }
                if (!CFG.AI_VASSALS || !(numerator / denominator <= 0.5f) && !(10.0f * (numDistance / mediatedMapSize) > 30.0f) || CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).saveProvinceData.oProvinceCore.getHaveACore(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).iCivID)) continue;
                int civID = k;
                if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getIsPupet() && (CFG.SPECTATOR_MODE || !CFG.game.getCiv(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getPuppetOfCivID()).getControlledByPlayer())) {
                    for (int k2 = 0; k2 < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k2) {
                        if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k2).iCivID != CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getPuppetOfCivID()) continue;
                        civID = k2;
                        break;
                    }
                }
                Gdx.app.log("AoC2.5", "AI Peace Vassalization");
                float found = -1.0f;
                foundVassal = -1;
                try {
                    for (int i3 = 0; i3 < CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getPuppetOfCivID()).civGameData.iVassalsSize; ++i3) {
                        int iVassal = CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID).getPuppetOfCivID()).civGameData.lVassals.get((int)i3).iCivID;
                        float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(iVassal).getCivID(), this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)) / mediatedMapSize);
                        if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                        found = dist;
                        foundVassal = iVassal;
                    }
                }
                catch (IndexOutOfBoundsException i3) {
                    // empty catch block
                }
                foundID = "";
                keyVals = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableVassals_PT.keys();
                while (keyVals.hasMoreElements()) {
                    String key = keyVals.nextElement();
                    for (Integer provinceID : this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableVassals_PT.get(key)) {
                        float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(provinceID, this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l)) / mediatedMapSize);
                        if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                        found = dist;
                        foundID = key;
                    }
                }
                if (found > -1.0f) {
                    Gdx.app.log("AoC2.5", "AI Peace Vassal Annex");
                    if (foundID.length() > 0) {
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableVassals_PT.get(foundID).add(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l));
                        continue;
                    }
                    if (foundVassal <= 0) continue;
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get((int)l).intValue()).iCivID = foundVassal;
                    continue;
                }
                Gdx.app.log("AoC2.5", "AI Peace Vassal Create");
                ArrayList<String> lCivsTags = new ArrayList<String>();
                try {
                    file = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path() + "suggested_owners/" + this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l));
                    sOwners = file.readString();
                    String[] sRes = sOwners.split(";");
                    for (i = 0; i < sRes.length; i += 2) {
                        bContinue = false;
                        for (j = 0; j < CFG.game.getCivsSize(); ++j) {
                            if (!CFG.game.getCiv(j).getCivTag().equals(sRes[i])) continue;
                            bContinue = true;
                            break;
                        }
                        if (bContinue) continue;
                        lCivsTags.add(sRes[i]);
                    }
                    sRes = null;
                    sOwners = null;
                    file = null;
                }
                catch (GdxRuntimeException file2) {
                    // empty catch block
                }
                try {
                    if (lCivsTags.size() < 1) {
                        file = Gdx.files.internal("game/civilizations/Age_of_Civilizations");
                        sOwners = file.readString();
                        String[] sRes = sOwners.split(";");
                        for (i = 0; i < sRes.length; ++i) {
                            bContinue = false;
                            for (j = 0; j < CFG.game.getCivsSize(); ++j) {
                                if (!CFG.game.getCiv(j).getCivTag().equals(sRes[i])) continue;
                                bContinue = true;
                                break;
                            }
                            if (bContinue) continue;
                            lCivsTags.add(sRes[i]);
                        }
                        sRes = null;
                        sOwners = null;
                        file = null;
                    }
                }
                catch (GdxRuntimeException e) {
                    CFG.exceptionStack(e);
                }
                provinces = new ArrayList();
                provinces.add(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lDemands.get(l));
                if (lCivsTags.size() > 0) {
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get(k).addReleasableVassal_PT((String)lCivsTags.get((int)(Math.random() * (double)lCivsTags.size())), provinces);
                    continue;
                }
                this.peaceTreatyGameData.lCivsDemands_Defenders.get(k).addReleasableVassal_PT("ran", provinces);
            }
        }
        for (k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k) {
            if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getControlledByPlayer()) continue;
            for (l = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.size() - 1; l >= 0; --l) {
                numOfConnections_Own = 0;
                numOfConnections_PT = 0;
                numOfConnections_Enemies = 0;
                numOfConnections_Neutral = 0;
                for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvincesSize(); ++m) {
                    if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getTrueOwnerOfProvince() == this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID) {
                        ++numOfConnections_Own;
                        continue;
                    }
                    if (this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).getNeighboringProvinces((int)m)).iCivID == this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID) {
                        ++numOfConnections_PT;
                        continue;
                    }
                    if (CFG.game.getCivsAtWar(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID, Math.abs(this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).getNeighboringProvinces((int)m)).iCivID))) {
                        ++numOfConnections_Enemies;
                        continue;
                    }
                    if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getWasteland() >= 0 || CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getSeaProvince()) continue;
                    ++numOfConnections_Neutral;
                }
                numDistance = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getCapitalProvinceID(), this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l));
                mediatedMapSize = (float)CFG.map.getMapBG().getMaxDistance() / (100.0f * (float)CFG.game.countLandProvinces_NotWasteland() / (float)CFG.game.getProvincesSize());
                sTotal = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvincesSize();
                if (sTotal > 0.0f) {
                    float nNotOwned = numOfConnections_Neutral + numOfConnections_Enemies;
                    float oOwned = numOfConnections_PT + numOfConnections_Own;
                    numerator = sTotal - nNotOwned + oOwned + (float)(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringSeaProvincesSize() * 3);
                    denominator = sTotal - nNotOwned * 1.65f;
                } else {
                    numerator = numDistance < 150.0f ? 1.0f : 0.0f;
                    denominator = 1.0f;
                }
                if (numerator / denominator <= 0.45f) {
                    if (Math.abs(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).iCivID) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getTrueOwnerOfProvince()) {
                        int optimal = -1;
                        for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvincesSize(); ++m) {
                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID == CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID() || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID()) < 0 && CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenderID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID()) < 0) continue;
                            optimal = CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)).getNeighboringProvinces(m)).getCivID();
                            break;
                        }
                        if (optimal > -1) {
                            int i4 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l);
                            this.drawProvinceOwners.get((int)i4).iCivID = optimal;
                            this.drawProvinceOwners.get((int)i4).isTaken = optimal;
                            this.drawProvinceOwners.get((int)i4).isToTake = false;
                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.remove(l);
                            for (l2 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; l2 >= 0; --l2) {
                                if (optimal != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).iCivID) continue;
                                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).lDemands.add(i4);
                                break;
                            }
                            for (l2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; l2 >= 0; --l2) {
                                if (optimal != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).iCivID) continue;
                                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).lDemands.add(i4);
                                break;
                            }
                            Gdx.app.log("AoC2.5", "Corrected Peace Treaty loneprovince");
                            updateData = true;
                            continue;
                        }
                    }
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).isTaken = -1;
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).iCivID = CFG.game.getProvince(k).getCivID() * -1;
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l));
                    updateData = true;
                    continue;
                }
                if (!CFG.AI_VASSALS || !(numerator / denominator <= 0.5f) && !(10.0f * (numDistance / mediatedMapSize) > 30.0f) || CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).saveProvinceData.oProvinceCore.getHaveACore(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).iCivID)) continue;
                int civID = k;
                if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getIsPupet() && (CFG.SPECTATOR_MODE || !CFG.game.getCiv(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getPuppetOfCivID()).getControlledByPlayer())) {
                    for (int k2 = 0; k2 < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k2) {
                        if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k2).iCivID != CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getPuppetOfCivID()) continue;
                        civID = k2;
                        break;
                    }
                }
                Gdx.app.log("AoC2.5", "AI Peace Vassalization");
                float found = -1.0f;
                foundVassal = -1;
                try {
                    for (int i5 = 0; i5 < CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getPuppetOfCivID()).civGameData.iVassalsSize; ++i5) {
                        int iVassal = CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID).getPuppetOfCivID()).civGameData.lVassals.get((int)i5).iCivID;
                        float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(iVassal).getCapitalProvinceID(), this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)) / mediatedMapSize);
                        if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                        found = dist;
                        foundVassal = iVassal;
                    }
                }
                catch (IndexOutOfBoundsException i5) {
                    // empty catch block
                }
                foundID = "";
                keyVals = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableVassals_PT.keys();
                while (keyVals.hasMoreElements()) {
                    String key = keyVals.nextElement();
                    for (Integer provinceID : this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableVassals_PT.get(key)) {
                        float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(provinceID, this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l)) / mediatedMapSize);
                        if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                        found = dist;
                        foundID = key;
                    }
                }
                if (found > -1.0f) {
                    Gdx.app.log("AoC2.5", "AI Peace Vassal Annex");
                    if (foundID.length() > 0) {
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableVassals_PT.get(foundID).add(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l));
                        continue;
                    }
                    if (foundVassal <= 0) continue;
                    this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get((int)l).intValue()).iCivID = foundVassal;
                    continue;
                }
                Gdx.app.log("AoC2.5", "AI Peace Vassal Create");
                ArrayList<String> lCivsTags = new ArrayList<String>();
                try {
                    file = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path() + "suggested_owners/" + this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l));
                    sOwners = file.readString();
                    String[] sRes = sOwners.split(";");
                    for (i = 0; i < sRes.length; i += 2) {
                        bContinue = false;
                        for (j = 0; j < CFG.game.getCivsSize(); ++j) {
                            if (!CFG.game.getCiv(j).getCivTag().equals(sRes[i])) continue;
                            bContinue = true;
                            break;
                        }
                        if (bContinue) continue;
                        lCivsTags.add(sRes[i]);
                    }
                    sRes = null;
                    sOwners = null;
                    file = null;
                }
                catch (GdxRuntimeException file3) {
                    // empty catch block
                }
                try {
                    if (lCivsTags.size() < 1) {
                        file = Gdx.files.internal("game/civilizations/Age_of_Civilizations");
                        sOwners = file.readString();
                        String[] sRes = sOwners.split(";");
                        for (i = 0; i < sRes.length; ++i) {
                            bContinue = false;
                            for (j = 0; j < CFG.game.getCivsSize(); ++j) {
                                if (!CFG.game.getCiv(j).getCivTag().equals(sRes[i])) continue;
                                bContinue = true;
                                break;
                            }
                            if (bContinue) continue;
                            lCivsTags.add(sRes[i]);
                        }
                        sRes = null;
                        sOwners = null;
                        file = null;
                    }
                }
                catch (GdxRuntimeException e) {
                    CFG.exceptionStack(e);
                }
                provinces = new ArrayList<Integer>();
                provinces.add(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lDemands.get(l));
                if (lCivsTags.size() > 0) {
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k).addReleasableVassal_PT((String)lCivsTags.get((int)(Math.random() * (double)lCivsTags.size())), provinces);
                    continue;
                }
                this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k).addReleasableVassal_PT("ran", provinces);
            }
        }
        return updateData;
    }

    protected final void preparePeaceTreatyToSend(int iFromCivID) {
        int k2;
        int l;
        int k;
        int j;
        int i;
        for (i = 0; i < this.peaceTreatyGameData.lCivsData_Defenders.size(); ++i) {
            for (j = 0; j < this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.size(); ++j) {
                if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.get((int)j).intValue()).isTaken >= 0) continue;
                this.makeDemand_Province(this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).lProvincesLost.get(j), this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).iCivID, this.peaceTreatyGameData.lCivsData_Defenders.get((int)i).iCivID, true);
            }
        }
        for (i = 0; i < this.peaceTreatyGameData.lCivsData_Aggressors.size(); ++i) {
            for (j = 0; j < this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i).lProvincesLost.size(); ++j) {
                if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i).lProvincesLost.get((int)j).intValue()).isTaken >= 0) continue;
                this.makeDemand_Province(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i).lProvincesLost.get(j), this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i).iCivID, this.peaceTreatyGameData.lCivsData_Aggressors.get((int)i).iCivID, true);
            }
        }
        if (!CFG.game.getCiv(iFromCivID).getControlledByPlayer()) {
            ArrayList<Integer> provinces;
            int j2;
            boolean bContinue;
            int i2;
            String sOwners;
            FileHandle file;
            Enumeration<String> keyVals;
            String foundID;
            int foundVassal;
            int l2;
            float denominator;
            float numerator;
            float sTotal;
            float mediatedMapSize;
            float numDistance;
            int numOfConnections_Neutral;
            int numOfConnections_Enemies;
            int numOfConnections_PT;
            int numOfConnections_Own;
            int l3;
            int k3;
            boolean updateData = false;
            for (k3 = 0; k3 < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k3) {
                if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getControlledByPlayer()) continue;
                for (l3 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.size() - 1; l3 >= 0; --l3) {
                    numOfConnections_Own = 0;
                    numOfConnections_PT = 0;
                    numOfConnections_Enemies = 0;
                    numOfConnections_Neutral = 0;
                    for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvincesSize(); ++m) {
                        if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getTrueOwnerOfProvince() == this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID) {
                            ++numOfConnections_Own;
                            continue;
                        }
                        if (this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).getNeighboringProvinces((int)m)).iCivID == this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID) {
                            ++numOfConnections_PT;
                            continue;
                        }
                        if (CFG.game.getCivsAtWar(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID, Math.abs(this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).getNeighboringProvinces((int)m)).iCivID))) {
                            ++numOfConnections_Enemies;
                            continue;
                        }
                        if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getWasteland() >= 0 || CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getSeaProvince()) continue;
                        ++numOfConnections_Neutral;
                    }
                    numDistance = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getCapitalProvinceID(), this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3));
                    mediatedMapSize = (float)CFG.map.getMapBG().getMaxDistance() / (100.0f * (float)CFG.game.countLandProvinces_NotWasteland() / (float)CFG.game.getProvincesSize());
                    sTotal = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvincesSize();
                    if (sTotal > 0.0f) {
                        float nNotOwned = numOfConnections_Neutral + numOfConnections_Enemies;
                        float oOwned = numOfConnections_PT + numOfConnections_Own;
                        numerator = sTotal - nNotOwned + oOwned + (float)(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringSeaProvincesSize() * 3);
                        numerator += numDistance / mediatedMapSize;
                        denominator = sTotal - nNotOwned * 1.65f + (float)numOfConnections_Neutral;
                    } else {
                        numerator = numDistance < 150.0f ? 1.0f : 0.0f;
                        denominator = 1.0f;
                    }
                    if (numerator / denominator <= 0.45f) {
                        if (Math.abs(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).iCivID) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getTrueOwnerOfProvince()) {
                            int optimal = -1;
                            for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvincesSize(); ++m) {
                                if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID == CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID() || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID()) < 0 && CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenderID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID()) < 0) continue;
                                optimal = CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID();
                                break;
                            }
                            if (optimal > -1) {
                                int i3 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3);
                                this.drawProvinceOwners.get((int)i3).iCivID = optimal;
                                this.drawProvinceOwners.get((int)i3).isTaken = optimal;
                                this.drawProvinceOwners.get((int)i3).isToTake = false;
                                this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.remove(l3);
                                for (l2 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; l2 >= 0; --l2) {
                                    if (optimal != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).iCivID) continue;
                                    this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).lDemands.add(i3);
                                }
                                for (l2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; l2 >= 0; --l2) {
                                    if (optimal != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).iCivID) continue;
                                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).lDemands.add(i3);
                                }
                                updateData = true;
                                Gdx.app.log("AoC2.5", "Corrected Peace Treaty loneprovince");
                                continue;
                            }
                        }
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).isTaken = -1;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).iCivID = CFG.game.getProvince(k3).getCivID() * -1;
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(k3).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3));
                        updateData = true;
                        continue;
                    }
                    if (!CFG.AI_VASSALS || !(numerator / denominator <= 0.5f) && !(10.0f * (numDistance / mediatedMapSize) > 30.0f) || CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).saveProvinceData.oProvinceCore.getHaveACore(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).iCivID)) continue;
                    int civID = k3;
                    if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getIsPupet() && (CFG.SPECTATOR_MODE || !CFG.game.getCiv(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getPuppetOfCivID()).getControlledByPlayer())) {
                        for (int k22 = 0; k22 < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k22) {
                            if (this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k22).iCivID != CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getPuppetOfCivID()) continue;
                            civID = k22;
                            break;
                        }
                    }
                    Gdx.app.log("AoC2.5", "AI Peace Vassalization");
                    float found = -1.0f;
                    foundVassal = -1;
                    try {
                        for (int i4 = 0; i4 < CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getPuppetOfCivID()).civGameData.iVassalsSize; ++i4) {
                            int iVassal = CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).iCivID).getPuppetOfCivID()).civGameData.lVassals.get((int)i4).iCivID;
                            float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(iVassal).getCivID(), this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)) / mediatedMapSize);
                            if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                            found = dist;
                            foundVassal = iVassal;
                        }
                    }
                    catch (IndexOutOfBoundsException i4) {
                        // empty catch block
                    }
                    foundID = "";
                    keyVals = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lReleasableVassals_PT.keys();
                    while (keyVals.hasMoreElements()) {
                        String key = keyVals.nextElement();
                        for (Integer provinceID : this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lReleasableVassals_PT.get(key)) {
                            float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(provinceID, this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3)) / mediatedMapSize);
                            if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                            found = dist;
                            foundID = key;
                        }
                    }
                    if (found > 0.0f) {
                        Gdx.app.log("AoC2.5", "AI Peace Vassal Annex");
                        if (foundID.length() > 0) {
                            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lReleasableVassals_PT.get(foundID).add(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3));
                            continue;
                        }
                        if (foundVassal <= 0) continue;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get((int)l3).intValue()).iCivID = foundVassal;
                        continue;
                    }
                    Gdx.app.log("AoC2.5", "AI Peace Vassal Create");
                    ArrayList<String> lCivsTags = new ArrayList<String>();
                    try {
                        file = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path() + "suggested_owners/" + this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3));
                        sOwners = file.readString();
                        String[] sRes = sOwners.split(";");
                        for (i2 = 0; i2 < sRes.length; i2 += 2) {
                            bContinue = false;
                            for (j2 = 0; j2 < CFG.game.getCivsSize(); ++j2) {
                                if (!CFG.game.getCiv(j2).getCivTag().equals(sRes[i2])) continue;
                                bContinue = true;
                                break;
                            }
                            if (bContinue) continue;
                            lCivsTags.add(sRes[i2]);
                        }
                        sRes = null;
                        sOwners = null;
                        file = null;
                    }
                    catch (GdxRuntimeException file2) {
                        // empty catch block
                    }
                    try {
                        if (lCivsTags.size() < 1) {
                            file = Gdx.files.internal("game/civilizations/Age_of_Civilizations");
                            sOwners = file.readString();
                            String[] sRes = sOwners.split(";");
                            for (i2 = 0; i2 < sRes.length; ++i2) {
                                bContinue = false;
                                for (j2 = 0; j2 < CFG.game.getCivsSize(); ++j2) {
                                    if (!CFG.game.getCiv(j2).getCivTag().equals(sRes[i2])) continue;
                                    bContinue = true;
                                    break;
                                }
                                if (bContinue) continue;
                                lCivsTags.add(sRes[i2]);
                            }
                            sRes = null;
                            sOwners = null;
                            file = null;
                        }
                    }
                    catch (GdxRuntimeException e) {
                        CFG.exceptionStack(e);
                    }
                    provinces = new ArrayList();
                    provinces.add(this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k3).lDemands.get(l3));
                    if (lCivsTags.size() > 0) {
                        this.peaceTreatyGameData.lCivsDemands_Defenders.get(k3).addReleasableVassal_PT((String)lCivsTags.get((int)(Math.random() * (double)lCivsTags.size())), provinces);
                        continue;
                    }
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get(k3).addReleasableVassal_PT("ran", provinces);
                }
            }
            for (k3 = 0; k3 < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k3) {
                if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getControlledByPlayer()) continue;
                for (l3 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.size() - 1; l3 >= 0; --l3) {
                    numOfConnections_Own = 0;
                    numOfConnections_PT = 0;
                    numOfConnections_Enemies = 0;
                    numOfConnections_Neutral = 0;
                    for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvincesSize(); ++m) {
                        if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getTrueOwnerOfProvince() == this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID) {
                            ++numOfConnections_Own;
                            continue;
                        }
                        if (this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).getNeighboringProvinces((int)m)).iCivID == this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID) {
                            ++numOfConnections_PT;
                            continue;
                        }
                        if (CFG.game.getCivsAtWar(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID, Math.abs(this.drawProvinceOwners.get((int)CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).getNeighboringProvinces((int)m)).iCivID))) {
                            ++numOfConnections_Enemies;
                            continue;
                        }
                        if (CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getWasteland() >= 0 || CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getSeaProvince()) continue;
                        ++numOfConnections_Neutral;
                    }
                    numDistance = CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getCapitalProvinceID(), this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3));
                    mediatedMapSize = (float)CFG.map.getMapBG().getMaxDistance() / (100.0f * (float)CFG.game.countLandProvinces_NotWasteland() / (float)CFG.game.getProvincesSize());
                    sTotal = CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvincesSize();
                    if (sTotal > 0.0f) {
                        float nNotOwned = numOfConnections_Neutral + numOfConnections_Enemies;
                        float oOwned = numOfConnections_PT + numOfConnections_Own;
                        numerator = sTotal - nNotOwned + oOwned + (float)(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringSeaProvincesSize() * 3);
                        numerator += numDistance / mediatedMapSize;
                        denominator = sTotal - nNotOwned * 1.65f + (float)numOfConnections_Neutral;
                    } else {
                        numerator = numDistance < 150.0f ? 1.0f : 0.0f;
                        denominator = 1.0f;
                    }
                    if (numerator / denominator <= 0.45f) {
                        if (Math.abs(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).iCivID) == CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getTrueOwnerOfProvince()) {
                            int optimal = -1;
                            for (int m = 0; m < CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvincesSize(); ++m) {
                                if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID == CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID() || CFG.game.getWar(this.peaceTreatyGameData.iWarID).getAggressorID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID()) < 0 && CFG.game.getWar(this.peaceTreatyGameData.iWarID).getDefenderID_ByCivID(CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID()) < 0) continue;
                                optimal = CFG.game.getProvince(CFG.game.getProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)).getNeighboringProvinces(m)).getCivID();
                                break;
                            }
                            if (optimal > -1) {
                                int i5 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3);
                                this.drawProvinceOwners.get((int)i5).iCivID = optimal;
                                this.drawProvinceOwners.get((int)i5).isTaken = optimal;
                                this.drawProvinceOwners.get((int)i5).isToTake = false;
                                this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.remove(l3);
                                for (l2 = this.peaceTreatyGameData.lCivsDemands_Defenders.size() - 1; l2 >= 0; --l2) {
                                    if (optimal != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).iCivID) continue;
                                    this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)l2).lDemands.add(i5);
                                    break;
                                }
                                for (l2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.size() - 1; l2 >= 0; --l2) {
                                    if (optimal != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).iCivID) continue;
                                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)l2).lDemands.add(i5);
                                    break;
                                }
                                Gdx.app.log("AoC2.5", "Corrected Peace Treaty loneprovince");
                                updateData = true;
                                continue;
                            }
                        }
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).isTaken = -1;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).iCivID = CFG.game.getProvince(k3).getCivID() * -1;
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k3).removeDemandOnProvince(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3));
                        updateData = true;
                        continue;
                    }
                    if (!CFG.AI_VASSALS || !(numerator / denominator <= 0.5f) && !(10.0f * (numDistance / mediatedMapSize) > 30.0f) || CFG.game.getProvince((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).saveProvinceData.oProvinceCore.getHaveACore(this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).iCivID)) continue;
                    int civID = k3;
                    if (CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getIsPupet() && (CFG.SPECTATOR_MODE || !CFG.game.getCiv(CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getPuppetOfCivID()).getControlledByPlayer())) {
                        for (int k23 = 0; k23 < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k23) {
                            if (this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k23).iCivID != CFG.game.getCiv(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getPuppetOfCivID()) continue;
                            civID = k23;
                            break;
                        }
                    }
                    Gdx.app.log("AoC2.5", "AI Peace Vassalization");
                    float found = -1.0f;
                    foundVassal = -1;
                    try {
                        for (int i6 = 0; i6 < CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getPuppetOfCivID()).civGameData.iVassalsSize; ++i6) {
                            int iVassal = CFG.game.getCiv((int)CFG.game.getCiv((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).iCivID).getPuppetOfCivID()).civGameData.lVassals.get((int)i6).iCivID;
                            float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(CFG.game.getCiv(iVassal).getCapitalProvinceID(), this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)) / mediatedMapSize);
                            if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                            found = dist;
                            foundVassal = iVassal;
                        }
                    }
                    catch (IndexOutOfBoundsException i6) {
                        // empty catch block
                    }
                    foundID = "";
                    keyVals = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lReleasableVassals_PT.keys();
                    while (keyVals.hasMoreElements()) {
                        String key = keyVals.nextElement();
                        for (Integer provinceID : this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lReleasableVassals_PT.get(key)) {
                            float dist = 10.0f * (CFG.game_NextTurnUpdate.getDistanceFromCapital(provinceID, this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3)) / mediatedMapSize);
                            if (!(dist <= 30.0f) || !(found < 0.0f) && !(dist < found)) continue;
                            found = dist;
                            foundID = key;
                        }
                    }
                    if (found > -1.0f) {
                        Gdx.app.log("AoC2.5", "AI Peace Vassal Annex");
                        if (foundID.length() > 0) {
                            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lReleasableVassals_PT.get(foundID).add(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3));
                            continue;
                        }
                        if (foundVassal <= 0) continue;
                        this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get((int)l3).intValue()).iCivID = foundVassal;
                        continue;
                    }
                    Gdx.app.log("AoC2.5", "AI Peace Vassal Create");
                    ArrayList<String> lCivsTags = new ArrayList<String>();
                    try {
                        file = Gdx.files.internal("map/" + CFG.map.getFile_ActiveMap_Path() + "suggested_owners/" + this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3));
                        sOwners = file.readString();
                        String[] sRes = sOwners.split(";");
                        for (i2 = 0; i2 < sRes.length; i2 += 2) {
                            bContinue = false;
                            for (j2 = 0; j2 < CFG.game.getCivsSize(); ++j2) {
                                if (!CFG.game.getCiv(j2).getCivTag().equals(sRes[i2])) continue;
                                bContinue = true;
                                break;
                            }
                            if (bContinue) continue;
                            lCivsTags.add(sRes[i2]);
                        }
                        sRes = null;
                        sOwners = null;
                        file = null;
                    }
                    catch (GdxRuntimeException file3) {
                        // empty catch block
                    }
                    try {
                        if (lCivsTags.size() < 1) {
                            file = Gdx.files.internal("game/civilizations/Age_of_Civilizations");
                            sOwners = file.readString();
                            String[] sRes = sOwners.split(";");
                            for (i2 = 0; i2 < sRes.length; ++i2) {
                                bContinue = false;
                                for (j2 = 0; j2 < CFG.game.getCivsSize(); ++j2) {
                                    if (!CFG.game.getCiv(j2).getCivTag().equals(sRes[i2])) continue;
                                    bContinue = true;
                                    break;
                                }
                                if (bContinue) continue;
                                lCivsTags.add(sRes[i2]);
                            }
                            sRes = null;
                            sOwners = null;
                            file = null;
                        }
                    }
                    catch (GdxRuntimeException e) {
                        CFG.exceptionStack(e);
                    }
                    provinces = new ArrayList<Integer>();
                    provinces.add(this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k3).lDemands.get(l3));
                    if (lCivsTags.size() > 0) {
                        this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k3).addReleasableVassal_PT((String)lCivsTags.get((int)(Math.random() * (double)lCivsTags.size())), provinces);
                        continue;
                    }
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get(k3).addReleasableVassal_PT("ran", provinces);
                }
            }
            if (updateData) {
                for (k3 = 0; k3 < this.peaceTreatyGameData.lCivsData_Defenders.size(); ++k3) {
                    for (l3 = 0; l3 < this.peaceTreatyGameData.lCivsData_Defenders.get((int)k3).lProvincesLost.size(); ++l3) {
                        if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Defenders.get((int)k3).lProvincesLost.get((int)l3).intValue()).isTaken >= 0) continue;
                        this.makeDemand_Province(this.peaceTreatyGameData.lCivsData_Defenders.get((int)k3).lProvincesLost.get(l3), this.peaceTreatyGameData.lCivsData_Defenders.get((int)k3).iCivID, this.peaceTreatyGameData.lCivsData_Defenders.get((int)k3).iCivID, true);
                    }
                }
                for (k3 = 0; k3 < this.peaceTreatyGameData.lCivsData_Aggressors.size(); ++k3) {
                    for (l3 = 0; l3 < this.peaceTreatyGameData.lCivsData_Aggressors.get((int)k3).lProvincesLost.size(); ++l3) {
                        if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsData_Aggressors.get((int)k3).lProvincesLost.get((int)l3).intValue()).isTaken >= 0) continue;
                        this.makeDemand_Province(this.peaceTreatyGameData.lCivsData_Aggressors.get((int)k3).lProvincesLost.get(l3), this.peaceTreatyGameData.lCivsData_Aggressors.get((int)k3).iCivID, this.peaceTreatyGameData.lCivsData_Aggressors.get((int)k3).iCivID, true);
                    }
                }
                for (int i7 = 0; i7 < 11 && this.purifyTreaty(iFromCivID); ++i7) {
                }
            }
        }
        for (k = 0; k < this.peaceTreatyGameData.lCivsDemands_Defenders.size(); ++k) {
            for (l = 0; l < this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.size(); ++l) {
                for (k2 = this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)l).lProvinces.size() - 1; k2 >= 0; --k2) {
                    if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)l).lProvinces.get((int)k2).intValue()).iCivID == this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)l).iCivID) continue;
                    this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).lReleasableCivs.get((int)l).lProvinces.remove(k2);
                }
            }
            if (iFromCivID != this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).iCivID) continue;
            this.peaceTreatyGameData.lCivsDemands_Defenders.get((int)k).peaceTreatyAccepted = true;
        }
        for (k = 0; k < this.peaceTreatyGameData.lCivsDemands_Aggressors.size(); ++k) {
            for (l = 0; l < this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.size(); ++l) {
                for (k2 = this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)l).lProvinces.size() - 1; k2 >= 0; --k2) {
                    if (this.drawProvinceOwners.get((int)this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)l).lProvinces.get((int)k2).intValue()).iCivID == this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)l).iCivID) continue;
                    this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).lReleasableCivs.get((int)l).lProvinces.remove(k2);
                }
            }
            if (iFromCivID != this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).iCivID) continue;
            this.peaceTreatyGameData.lCivsDemands_Aggressors.get((int)k).peaceTreatyAccepted = true;
        }
    }

    protected static int getProposal_Positive(boolean scoreCountDefenders) {
        boolean out = false;
        return 0;
    }

    protected static int getProposal_Negative(boolean scoreCountDefenders) {
        boolean out = false;
        return 0;
    }
}

