/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.Game_Calendar;
import java.io.Serializable;

public class Decision_GameData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String sName = "";
    private String sDesc = "";
    private int Year = -9999;
    private int Month = 1;
    private int Day = 1;
    private int progress = 0;
    private int turnLength = 10;
    private float goldCost = 0.0f;
    private float diploCost = 0.0f;
    private boolean inProgress = false;
    private boolean repeatable = false;
    private boolean costEveryTurn = false;
    protected float fModifier_UpperClass = 0.0f;
    protected float fModifier_MiddleClass = 0.0f;
    protected float fModifier_LowerClass = 0.0f;
    protected float fModifier_PopGrowth = 0.0f;
    protected float fModifier_EconomyGrowth = 0.0f;
    protected float fModifier_IncomeTaxation = 0.0f;
    protected float fModifier_IncomeProduction = 0.0f;
    protected float fModifier_Administration = 0.0f;
    protected float fModifier_Research = 0.0f;
    protected float fModifier_MilitaryUpkeep = 0.0f;
    protected float fModifier_AttackBonus = 0.0f;
    protected float fModifier_DefenseBonus = 0.0f;
    protected float fModifier_MovementPoints = 0.0f;

    Decision_GameData() {
    }

    protected final String getName() {
        return CFG.langManager.get(this.sName);
    }

    protected final void setName(String sName) {
        this.sName = sName;
    }

    protected final String getDesc() {
        return CFG.langManager.get(this.sDesc);
    }

    protected final void setDesc(String sDesc) {
        this.sDesc = sDesc;
    }

    protected final int getTurnLength() {
        return this.turnLength;
    }

    protected final void setTurnLength(int turnLength) {
        this.turnLength = Math.max(1, turnLength);
    }

    protected final float getGoldCost() {
        return this.goldCost;
    }

    protected final void setGoldCost(float goldCost) {
        this.goldCost = goldCost;
    }

    protected final float getDiploCost() {
        return this.diploCost;
    }

    protected final void setDiploCost(float diploCost) {
        this.diploCost = diploCost;
    }

    protected final boolean isCostEveryTurn() {
        return this.costEveryTurn;
    }

    protected final void setCostEveryTurn(boolean costEveryTurn) {
        this.costEveryTurn = costEveryTurn;
    }

    protected final int getMonth() {
        return this.Month;
    }

    protected final void setMonth(int month) {
        this.Month = month;
    }

    protected final int getYear() {
        return this.Year;
    }

    protected final void setYear(int year) {
        this.Year = year;
    }

    protected final int getDay() {
        return this.Day;
    }

    protected final void setDay(int day) {
        this.Day = day;
    }

    protected final int getTurnsProgress() {
        return this.progress;
    }

    protected final void setTurnsProgress(int progress) {
        this.progress = Math.max(0, Math.min(this.turnLength, progress));
        if (this.progress >= this.turnLength) {
            this.inProgress = true;
        }
    }

    protected final boolean getInProgress() {
        return this.inProgress;
    }

    protected final void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    protected final boolean isRepeatable() {
        return this.repeatable;
    }

    protected final void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    protected final boolean canEnactDecision(int nCivID) {
        if (this.inProgress) {
            return false;
        }
        if ((float)CFG.game.getCiv(nCivID).getMoney() < this.goldCost) {
            return false;
        }
        if ((float)CFG.game.getCiv(nCivID).getDiplomacyPoints() < this.diploCost) {
            return false;
        }
        if (Game_Calendar.currentYear < this.Year) {
            return false;
        }
        if (Game_Calendar.currentYear == this.Year && Game_Calendar.currentMonth < this.Month) {
            return false;
        }
        return Game_Calendar.currentYear != this.Year || Game_Calendar.currentMonth != this.Month || Game_Calendar.currentDay >= this.Day;
    }

    protected Decision_GameData copy() {
        Decision_GameData d = new Decision_GameData();
        d.sName = this.sName;
        d.sDesc = this.sDesc;
        d.Year = this.Year;
        d.Month = this.Month;
        d.Day = this.Day;
        d.progress = this.progress;
        d.turnLength = this.turnLength;
        d.goldCost = this.goldCost;
        d.diploCost = this.diploCost;
        d.inProgress = this.inProgress;
        d.repeatable = this.repeatable;
        d.costEveryTurn = this.costEveryTurn;
        d.fModifier_UpperClass = this.fModifier_UpperClass;
        d.fModifier_MiddleClass = this.fModifier_MiddleClass;
        d.fModifier_LowerClass = this.fModifier_LowerClass;
        d.fModifier_PopGrowth = this.fModifier_PopGrowth;
        d.fModifier_EconomyGrowth = this.fModifier_EconomyGrowth;
        d.fModifier_IncomeTaxation = this.fModifier_IncomeTaxation;
        d.fModifier_IncomeProduction = this.fModifier_IncomeProduction;
        d.fModifier_Administration = this.fModifier_Administration;
        d.fModifier_Research = this.fModifier_Research;
        d.fModifier_MilitaryUpkeep = this.fModifier_MilitaryUpkeep;
        d.fModifier_AttackBonus = this.fModifier_AttackBonus;
        d.fModifier_DefenseBonus = this.fModifier_DefenseBonus;
        d.fModifier_MovementPoints = this.fModifier_MovementPoints;
        return d;
    }
}

