/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.geom.Path2D;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.d3d.D3DContext;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.BufferedRenderPipe;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.SpanIterator;

class D3DRenderer
extends BufferedRenderPipe {
    D3DRenderer(RenderQueue renderQueue) {
        super(renderQueue);
    }

    @Override
    protected void validateContext(SunGraphics2D sunGraphics2D) {
        D3DSurfaceData d3DSurfaceData;
        int n = sunGraphics2D.paint.getTransparency() == 1 ? 1 : 0;
        try {
            d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
        D3DContext.validateContext(d3DSurfaceData, d3DSurfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, null, sunGraphics2D.paint, sunGraphics2D, n);
    }

    @Override
    protected void validateContextAA(SunGraphics2D sunGraphics2D) {
        D3DSurfaceData d3DSurfaceData;
        int n = 0;
        try {
            d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
        }
        D3DContext.validateContext(d3DSurfaceData, d3DSurfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, null, sunGraphics2D.paint, sunGraphics2D, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.rq.lock();
        try {
            D3DSurfaceData d3DSurfaceData;
            int n7 = sunGraphics2D.surfaceData.getTransparency() == 1 ? 1 : 0;
            try {
                d3DSurfaceData = (D3DSurfaceData)sunGraphics2D.surfaceData;
            }
            catch (ClassCastException classCastException) {
                throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
            }
            D3DContext.validateContext(d3DSurfaceData, d3DSurfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, null, null, null, n7);
            this.rq.ensureCapacity(28);
            this.buf.putInt(30);
            this.buf.putInt(n).putInt(n2).putInt(n3).putInt(n4);
            this.buf.putInt(n5).putInt(n6);
        }
        finally {
            this.rq.unlock();
        }
    }

    @Override
    protected native void drawPoly(int[] var1, int[] var2, int var3, boolean var4, int var5, int var6);

    D3DRenderer traceWrap() {
        return new Tracer(this);
    }

    private class Tracer
    extends D3DRenderer {
        private D3DRenderer d3dr;

        Tracer(D3DRenderer d3DRenderer2) {
            super(d3DRenderer2.rq);
            this.d3dr = d3DRenderer2;
        }

        @Override
        public ParallelogramPipe getAAParallelogramPipe() {
            final ParallelogramPipe parallelogramPipe = this.d3dr.getAAParallelogramPipe();
            return new ParallelogramPipe(){

                @Override
                public void fillParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
                    GraphicsPrimitive.tracePrimitive("D3DFillAAParallelogram");
                    parallelogramPipe.fillParallelogram(sunGraphics2D, d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
                }

                @Override
                public void drawParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
                    GraphicsPrimitive.tracePrimitive("D3DDrawAAParallelogram");
                    parallelogramPipe.drawParallelogram(sunGraphics2D, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
                }
            };
        }

        @Override
        protected void validateContext(SunGraphics2D sunGraphics2D) {
            this.d3dr.validateContext(sunGraphics2D);
        }

        @Override
        public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("D3DDrawLine");
            this.d3dr.drawLine(sunGraphics2D, n, n2, n3, n4);
        }

        @Override
        public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("D3DDrawRect");
            this.d3dr.drawRect(sunGraphics2D, n, n2, n3, n4);
        }

        @Override
        protected void drawPoly(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n, boolean bl) {
            GraphicsPrimitive.tracePrimitive("D3DDrawPoly");
            this.d3dr.drawPoly(sunGraphics2D, nArray, nArray2, n, bl);
        }

        @Override
        public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("D3DFillRect");
            this.d3dr.fillRect(sunGraphics2D, n, n2, n3, n4);
        }

        @Override
        protected void drawPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("D3DDrawPath");
            this.d3dr.drawPath(sunGraphics2D, float_, n, n2);
        }

        @Override
        protected void fillPath(SunGraphics2D sunGraphics2D, Path2D.Float float_, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("D3DFillPath");
            this.d3dr.fillPath(sunGraphics2D, float_, n, n2);
        }

        @Override
        protected void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator, int n, int n2) {
            GraphicsPrimitive.tracePrimitive("D3DFillSpans");
            this.d3dr.fillSpans(sunGraphics2D, spanIterator, n, n2);
        }

        @Override
        public void fillParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
            GraphicsPrimitive.tracePrimitive("D3DFillParallelogram");
            this.d3dr.fillParallelogram(sunGraphics2D, d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
        }

        @Override
        public void drawParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
            GraphicsPrimitive.tracePrimitive("D3DDrawParallelogram");
            this.d3dr.drawParallelogram(sunGraphics2D, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        }

        @Override
        public void copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("D3DCopyArea");
            this.d3dr.copyArea(sunGraphics2D, n, n2, n3, n4, n5, n6);
        }
    }
}

