/*
 * Decompiled with CFR 0.152.
 */
package age.of.civilizations2.jakowski.lukasz;

import age.of.civilizations2.jakowski.lukasz.CFG;
import age.of.civilizations2.jakowski.lukasz.ColorSerializer;
import age.of.civilizations2.jakowski.lukasz.Color_GameData;
import age.of.civilizations2.jakowski.lukasz.Image;
import age.of.civilizations2.jakowski.lukasz.Terrain_GameData3;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;

class TerrainTypesManager {
    private List<String> lNames;
    private List<String> lTerrainTags;
    private List<Color> lColors;
    private List<Image> lTerrainIcons;
    private List<Float> lDefense;
    private List<Float> lMilitaryUpkeep;
    private List<Float> lPopulationGrowth;
    private List<Float> lEconomyGrowth;
    private List<Float> lBuildCost;
    private List<Float> lMovementCost;
    private List<Float> lBaseDevelopment;
    private List<Integer> lBaseProvinceValue;
    private int iTerrainTypesSize;

    protected TerrainTypesManager() {
        this.loadTerrainTypes();
    }

    protected final void loadTerrainTypes() {
        block10: {
            if (this.lTerrainIcons != null) {
                for (Image img : this.lTerrainIcons) {
                    img.getTexture().dispose();
                }
                this.lTerrainIcons.clear();
            }
            this.lNames = new ArrayList<String>();
            this.lTerrainTags = new ArrayList<String>();
            this.lTerrainIcons = new ArrayList<Image>();
            this.lColors = new ArrayList<Color>();
            this.lDefense = new ArrayList<Float>();
            this.lMilitaryUpkeep = new ArrayList<Float>();
            this.lPopulationGrowth = new ArrayList<Float>();
            this.lEconomyGrowth = new ArrayList<Float>();
            this.lBuildCost = new ArrayList<Float>();
            this.lMovementCost = new ArrayList<Float>();
            this.lBaseDevelopment = new ArrayList<Float>();
            this.lBaseProvinceValue = new ArrayList<Integer>();
            try {
                if (!this.hasJsonTerrainFiles()) {
                    Gdx.app.log("AoC", "\u68c0\u6d4b\u5230\u65e7\u6570\u636e\u683c\u5f0f\uff0c\u5f00\u59cb\u81ea\u52a8\u8fc1\u79fb...");
                    this.migrateLegacyTerrainData();
                }
                FileHandle listFile = CFG.eqFileRead("game/terrain_types/Age_of_Civilizations");
                String[] terrainTags = listFile.readString("UTF-8").split(";");
                this.iTerrainTypesSize = terrainTags.length;
                Gdx.app.log("AoC", "Config Terrain Size: " + this.iTerrainTypesSize);
                this.addSea();
                Json json = new Json();
                json.setSerializer(Color_GameData.class, new ColorSerializer());
                for (int i = 0; i < this.iTerrainTypesSize; ++i) {
                    String tag = terrainTags[i];
                    FileHandle fileData = CFG.eqFileRead("game/terrain_types/" + tag + ".json");
                    try {
                        Terrain_GameData3 tempData = json.fromJson(Terrain_GameData3.class, fileData.readString("UTF-8"));
                        this.lNames.add(CFG.langManager.get(tempData.getName()));
                        this.lTerrainTags.add(tag);
                        this.lColors.add(new Color(tempData.getColor().getR(), tempData.getColor().getG(), tempData.getColor().getB(), 0.55f));
                        this.lDefense.add(Float.valueOf(tempData.getDefensiveModifier()));
                        this.lMilitaryUpkeep.add(Float.valueOf(tempData.getMilitaryUpkeepModifier()));
                        this.lPopulationGrowth.add(Float.valueOf(tempData.getPopulationGrowthModifier()));
                        this.lEconomyGrowth.add(Float.valueOf(tempData.getEconomyGrowthModifier()));
                        this.lBuildCost.add(Float.valueOf(tempData.getBuildCostModifier()));
                        this.lMovementCost.add(Float.valueOf(tempData.getMovementCost()));
                        this.lBaseDevelopment.add(Float.valueOf(tempData.getBaseDevelopmentLevel()));
                        this.lBaseProvinceValue.add(tempData.getBaseProvinceValue());
                        try {
                            this.lTerrainIcons.add(new Image(new Texture(Gdx.files.internal("UI/" + CFG.getRescouresPath() + "terrain/" + tempData.getIconName() + ".png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear));
                        }
                        catch (GdxRuntimeException var8) {
                            this.lTerrainIcons.add(new Image(new Texture(Gdx.files.internal("UI/" + CFG.getRescouresPath() + "terrain/notfound.png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear));
                        }
                        Gdx.app.log("AoC", "Success Load Terrain: " + tempData.getName());
                        continue;
                    }
                    catch (Exception e) {
                        Gdx.app.error("AoC", "Failed Load Terrain: " + tag, e);
                    }
                }
            }
            catch (GdxRuntimeException e) {
                if (!CFG.LOGS) break block10;
                CFG.exceptionStack(e);
            }
        }
        this.iTerrainTypesSize = this.lNames.size();
        Gdx.app.log("AoC", "Final Terrain Size: " + this.iTerrainTypesSize);
    }

    private boolean hasJsonTerrainFiles() {
        FileHandle dir = CFG.eqFileRead("game/terrain_types");
        for (FileHandle file : dir.list()) {
            if (!file.extension().equals("json")) continue;
            return true;
        }
        return false;
    }

    protected void migrateLegacyTerrainData() {
        try {
            FileHandle listFile = CFG.eqFileRead("game/terrain_types/Age_of_Civilizations");
            String[] legacyTags = listFile.readString("UTF-8").split(";");
            Json json = new Json();
            json.setOutputType(JsonWriter.OutputType.json);
            json.setSerializer(Color_GameData.class, new ColorSerializer());
            for (String tag : legacyTags) {
                FileHandle legacyFile = CFG.eqFileRead("game/terrain_types/" + tag);
                FileHandle jsonFile = Gdx.files.local("game/terrain_types/" + tag + ".json");
                if (jsonFile.exists()) continue;
                try (InputStream is = legacyFile.read();
                     ObjectInputStream ois = new ObjectInputStream(is);){
                    Terrain_GameData3 data = (Terrain_GameData3)ois.readObject();
                    jsonFile.writeString(json.prettyPrint(data), false, "UTF-8");
                    if (legacyFile.type() == Files.FileType.Internal) continue;
                    FileHandle backupDir = Gdx.files.local("game/terrain_types/backup");
                    if (!backupDir.exists()) {
                        backupDir.mkdirs();
                    }
                    legacyFile.moveTo(backupDir.child(tag));
                }
                catch (Exception e) {
                    Gdx.app.error("Migration", "\u8fc1\u79fb\u5931\u8d25: " + tag, e);
                }
            }
        }
        catch (Exception e) {
            Gdx.app.error("Migration", "\u8fc1\u79fb\u4e25\u91cd\u9519\u8bef", e);
        }
    }

    private void recoverCorruptedFile(FileHandle legacyFile, String tag) {
        try {
            FileHandle corruptDir = Gdx.files.local("game/terrain_types/corrupted");
            if (!corruptDir.exists()) {
                corruptDir.mkdirs();
            }
            legacyFile.moveTo(corruptDir.child(tag + ".corrupted"));
        }
        catch (Exception e) {
            Gdx.app.error("Migration", "\u65e0\u6cd5\u79fb\u52a8\u635f\u574f\u6587\u4ef6: " + tag, e);
        }
    }

    private void addSea() {
        this.lNames.add(CFG.langManager.get("Sea"));
        this.lTerrainTags.add("");
        this.lColors.add(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.lDefense.add(Float.valueOf(0.0f));
        this.lMilitaryUpkeep.add(Float.valueOf(0.08f));
        this.lPopulationGrowth.add(Float.valueOf(0.0f));
        this.lEconomyGrowth.add(Float.valueOf(0.0f));
        this.lBuildCost.add(Float.valueOf(0.0f));
        this.lMovementCost.add(Float.valueOf(0.0f));
        this.lBaseDevelopment.add(Float.valueOf(0.0f));
        this.lBaseProvinceValue.add(0);
        try {
            this.lTerrainIcons.add(new Image(new Texture(Gdx.files.internal("UI/" + CFG.getRescouresPath() + "terrain/sea.png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear));
        }
        catch (GdxRuntimeException var2) {
            this.lTerrainIcons.add(new Image(new Texture(Gdx.files.internal("UI/" + CFG.getRescouresPath() + "terrain/notfound.png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear));
        }
    }

    protected final int getTerrainTypeID(String sTag) {
        for (int i = 1; i < this.iTerrainTypesSize; ++i) {
            if (!this.getTag(i).equals(sTag)) continue;
            return i;
        }
        return 1;
    }

    protected final void saveTerrainData() {
        Json json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        json.setSerializer(Color_GameData.class, new ColorSerializer());
        try {
            FileHandle dataFile = Gdx.files.local("game/terrain_types/" + CFG.EDITOR_ACTIVE_GAMEDATA_TAG + ".json");
            String jsonData = json.prettyPrint(CFG.editorTerrain_Data2);
            dataFile.writeString(jsonData, false, "UTF-8");
            this.updateTerrainListFile(CFG.EDITOR_ACTIVE_GAMEDATA_TAG);
        }
        catch (Exception e) {
            Gdx.app.error("AoC", "\u5730\u5f62\u4fdd\u5b58\u5931\u8d25", e);
        }
    }

    private void updateTerrainListFile(String newTag) {
        try {
            String currentTags;
            FileHandle listFile = Gdx.files.local("game/terrain_types/Age_of_Civilizations");
            String string = currentTags = listFile.exists() ? listFile.readString("UTF-8") : "";
            if (!currentTags.contains(newTag)) {
                listFile.writeString(currentTags + newTag + ";", false, "UTF-8");
            }
        }
        catch (Exception e) {
            Gdx.app.error("AoC", "\u66f4\u65b0\u5730\u5f62\u5217\u8868\u5931\u8d25", e);
        }
    }

    protected final String getName(int i) {
        try {
            return this.lNames.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return CFG.langManager.get("NotFound");
        }
    }

    protected final String getTag(int i) {
        try {
            return this.lTerrainTags.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    protected final Color getColor(int i) {
        try {
            return this.lColors.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    protected final Image getIcon(int i) {
        try {
            return this.lTerrainIcons.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return new Image(new Texture(Gdx.files.internal("UI/" + CFG.getRescouresPath() + "terrain/notfound.png"), Pixmap.Format.RGBA8888, true), Texture.TextureFilter.Linear);
        }
    }

    protected final int getTerrainsSize() {
        return this.iTerrainTypesSize;
    }

    protected final float getDefense(int i) {
        try {
            return this.lDefense.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final float getMilitaryUpkeep(int i) {
        try {
            return this.lMilitaryUpkeep.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final float getPopulationGrowth(int i) {
        try {
            return this.lPopulationGrowth.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final float getEconomyGrowth(int i) {
        try {
            return this.lEconomyGrowth.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final float getBuildCost(int i) {
        try {
            return this.lBuildCost.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final float getMovementCost(int i) {
        try {
            return this.lMovementCost.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final float getBaseDevelopmentModifier(int i) {
        try {
            return this.lBaseDevelopment.get(i).floatValue();
        }
        catch (IndexOutOfBoundsException e) {
            return 0.0f;
        }
    }

    protected final int getBaseProvinceValue(int i) {
        try {
            return this.lBaseProvinceValue.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    private static class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass desc = super.readClassDescriptor();
            if (desc.getName().equals("age.of.civilizations2.jakowski.lukasz.Terrain_GameData3")) {
                return ObjectStreamClass.lookup(Terrain_GameData3.class);
            }
            return desc;
        }
    }
}

